/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.client.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.linkis.cs.client.ContextClient;
import org.apache.linkis.cs.client.builder.ContextClientFactory;
import org.apache.linkis.cs.client.service.CSWorkService;
import org.apache.linkis.cs.client.utils.SerializeHelper;
import org.apache.linkis.cs.common.entity.enumeration.WorkType;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.common.utils.CSCommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSWorkServiceImpl
implements CSWorkService {
    private static final Logger logger = LoggerFactory.getLogger(CSWorkServiceImpl.class);
    private static CSWorkService csWorkService = null;

    private CSWorkServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CSWorkService getInstance() {
        if (null != csWorkService) return csWorkService;
        Class<CSWorkServiceImpl> clazz = CSWorkServiceImpl.class;
        synchronized (CSWorkServiceImpl.class) {
            if (null != csWorkService) return csWorkService;
            csWorkService = new CSWorkServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return csWorkService;
        }
    }

    @Override
    public void initContextServiceInfo(String contextIDStr, WorkType workType) throws CSErrorException {
        ArrayList<WorkType> typeList = new ArrayList<WorkType>();
        typeList.add(workType);
        this.initContextServiceInfo(contextIDStr, typeList);
    }

    @Override
    public void initContextServiceInfo(String contextIDStr, List<WorkType> workTypes) throws CSErrorException {
        try {
            ContextClient contextClient = ContextClientFactory.getOrCreateContextClient();
            ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
            for (WorkType type : workTypes) {
                contextClient.removeAllValueByKeyPrefix(contextID, this.getWorkTypePrefix(type));
            }
            logger.info("contextID: {} initContextServiceInfo", (Object)contextID.getContextId());
        }
        catch (Exception e) {
            logger.error("InitContextInfo error. contextIDStr : {}, workTypes : {}" + contextIDStr, (Object)CSCommonUtils.gson.toJson(workTypes));
            throw new CSErrorException(70112, "InitContextInfo error. contextIDStr : " + contextIDStr + ", workTypes : " + CSCommonUtils.gson.toJson(workTypes), (Throwable)e);
        }
    }

    private String getWorkTypePrefix(WorkType workType) {
        String prefix = null;
        switch (workType) {
            case WORKSPACE: {
                prefix = "workspace.";
                break;
            }
            case PROJECT: {
                prefix = "project.";
                break;
            }
            case FLOW: {
                prefix = "flow.";
                break;
            }
            case NODE: {
                prefix = "node.";
                break;
            }
            default: {
                logger.error("Invalid workType : {}", (Object)workType);
            }
        }
        return prefix;
    }
}

