/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.http.MediaType;
import org.springframework.util.MimeType;
import springfox.documentation.service.Representation;

public class ContentSpecification {
    private final Map<MediaType, Representation> representations = new TreeMap<MediaType, Representation>(MimeType::compareTo);
    private final boolean requestBody;

    public ContentSpecification(boolean requestBody, Set<Representation> representations) {
        this.requestBody = requestBody;
        this.representations.putAll(representations.stream().collect(Collectors.toMap(Representation::getMediaType, m -> m)));
    }

    public Set<Representation> getRepresentations() {
        TreeSet<Representation> representations = new TreeSet<Representation>(Comparator.comparing(Representation::getMediaType));
        representations.addAll(this.representations.values());
        return representations;
    }

    public Optional<Representation> representationFor(MediaType mediaType) {
        return Optional.ofNullable(this.representations.get(mediaType));
    }

    public boolean isRequestBody() {
        return this.requestBody;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentSpecification that = (ContentSpecification)o;
        return this.representations.equals(that.representations) && this.requestBody == that.requestBody;
    }

    public int hashCode() {
        return Objects.hash(this.representations, this.requestBody);
    }

    public String toString() {
        return new StringJoiner(", ", ContentSpecification.class.getSimpleName() + "[", "]").add("mediaTypes=" + this.representations).add("requestBody=" + this.requestBody).toString();
    }
}

