/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.datacalc.service.strategy;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.engineplugin.spark.datacalc.service.strategy.DataSourceStrategy;

public class OracleStrategy
extends DataSourceStrategy {
    @Override
    public String getJdbcUrl(String address, Map<String, String> paramsJson, String paramsStr) {
        String serviceName = paramsJson.getOrDefault("serviceName", "");
        String server = paramsJson.getOrDefault("server", "");
        String instanceName = paramsJson.getOrDefault("instance", "");
        String sid = paramsJson.getOrDefault("sid", "");
        StringBuilder builder = new StringBuilder("jdbc:oracle:thin:@");
        if (StringUtils.isNotBlank((CharSequence)sid)) {
            builder.append(address);
            builder.append(":").append(sid);
        } else {
            builder.append("//").append(address).append("/").append(serviceName);
            if (StringUtils.isNotBlank((CharSequence)server)) {
                builder.append(":").append(server);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)instanceName)) {
            builder.append("/").append(instanceName);
        }
        if (!paramsStr.isEmpty()) {
            builder.append(this.getConnectParams(paramsStr));
        }
        return builder.toString();
    }

    @Override
    public String defaultDriver() {
        return "oracle.jdbc.driver.OracleDriver";
    }

    @Override
    public String defaultPort() {
        return "1521";
    }
}

