/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.datacalc.sink;

import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.apache.linkis.engineplugin.spark.datacalc.model.SinkConfig;

public class FileSinkConfig
extends SinkConfig {
    @NotBlank
    @Pattern(regexp="^(((file|hdfs)://)|/).*", message="Invalid path URI, please set the following allowed schemas: 'file://' or 'hdfs://'(default).")
    private @NotBlank @Pattern(regexp="^(((file|hdfs)://)|/).*", message="Invalid path URI, please set the following allowed schemas: 'file://' or 'hdfs://'(default).") String path;
    @NotBlank
    private String serializer = "parquet";
    private List<String> partitionBy = new ArrayList<String>();
    @NotBlank
    @Pattern(regexp="^(overwrite|append|ignore|error|errorifexists)$", message="Unknown save mode: {saveMode}. Accepted save modes are 'overwrite', 'append', 'ignore', 'error', 'errorifexists'.")
    private @NotBlank @Pattern(regexp="^(overwrite|append|ignore|error|errorifexists)$", message="Unknown save mode: {saveMode}. Accepted save modes are 'overwrite', 'append', 'ignore', 'error', 'errorifexists'.") String saveMode = "overwrite";

    public String getPath() {
        if (this.path.startsWith("/")) {
            return "hdfs://" + this.path;
        }
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getSerializer() {
        return this.serializer;
    }

    public void setSerializer(String serializer) {
        this.serializer = serializer;
    }

    public List<String> getPartitionBy() {
        return this.partitionBy;
    }

    public void setPartitionBy(List<String> partitionBy) {
        this.partitionBy = partitionBy;
    }

    public String getSaveMode() {
        return this.saveMode;
    }

    public void setSaveMode(String saveMode) {
        this.saveMode = saveMode;
    }
}

