/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.imexport;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineplugin.spark.config.SparkConfiguration$;
import org.apache.linkis.engineplugin.spark.imexport.CsvRelation$;
import org.apache.linkis.engineplugin.spark.imexport.util.BackGroundServiceUtils$;
import org.apache.linkis.engineplugin.spark.imexport.util.ImExportUtils$;
import org.apache.linkis.hadoop.common.conf.HadoopConf$;
import org.apache.linkis.hadoop.common.utils.HDFSUtils$;
import org.apache.linkis.storage.excel.XlsUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class LoadData$ {
    public static LoadData$ MODULE$;
    private final DefaultFormats$ formats;

    static {
        new LoadData$();
    }

    public DefaultFormats$ formats() {
        return this.formats;
    }

    public void loadDataToTable(SparkSession spark, String source, String destination) {
        this.create_table_from_a_file(spark, JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(source), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()), JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(destination), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
    }

    public void loadDataToTableByFile(SparkSession spark, String destinationPath, String source) {
        String destination = BackGroundServiceUtils$.MODULE$.exchangeExecutionCode(destinationPath);
        this.create_table_from_a_file(spark, JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(source), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()), JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(destination), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
    }

    public void create_table_from_a_file(SparkSession spark, JsonAST.JValue src, JsonAST.JValue dest) {
        Map source = (Map)package$.MODULE$.jvalue2extractable(src).extract((Formats)this.formats(), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Any()})));
        Map destination = (Map)package$.MODULE$.jvalue2extractable(dest).extract((Formats)this.formats(), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Any()})));
        String path = (String)this.getMapValue((Map<String, Object>)source, "path", this.getMapValue$default$3());
        String pathType = this.getMapValue((Map<String, Object>)source, "pathType", "share");
        boolean hasHeader = BoxesRunTime.unboxToBoolean((Object)this.getMapValue((Map<String, Object>)source, "hasHeader", BoxesRunTime.boxToBoolean((boolean)false)));
        String sheetName = this.getMapValue((Map<String, Object>)source, "sheet", "Sheet1");
        String dateFormat = this.getMapValue((Map<String, Object>)source, "dateFormat", "yyyy-MM-dd");
        String suffix = path.substring(path.lastIndexOf("."));
        java.util.List sheetNames = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sheetName.split(","))).toBuffer()).asJava();
        FileSystem fs = null;
        String database = (String)this.getMapValue((Map<String, Object>)destination, "database", this.getMapValue$default$3());
        String tableName = (String)this.getMapValue((Map<String, Object>)destination, "tableName", this.getMapValue$default$3());
        boolean importData = BoxesRunTime.unboxToBoolean((Object)this.getMapValue((Map<String, Object>)destination, "importData", BoxesRunTime.boxToBoolean((boolean)true)));
        boolean isPartition = BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)MODULE$.getMapValue((Map<String, Object>)destination, "isPartition", BoxesRunTime.boxToBoolean((boolean)true))), (Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LoadData$.$anonfun$create_table_from_a_file$2(destination, x0$1))));
        boolean isOverwrite = BoxesRunTime.unboxToBoolean((Object)this.getMapValue((Map<String, Object>)destination, "isOverwrite", BoxesRunTime.boxToBoolean((boolean)false)));
        String partition = this.getMapValue((Map<String, Object>)destination, "partition", "ds");
        String partitionValue = this.getMapValue((Map<String, Object>)destination, "partitionValue", "1993-01-02");
        List columns = (List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(dest).$bslash("columns")).extract((Formats)this.formats(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Any()})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        List dateFormats = (List)((List)columns.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.get((Object)"dateFormat").get().toString(), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)f -> {
            if (f.isEmpty()) {
                return "yyyy-MM-dd";
            }
            return f;
        }, List$.MODULE$.canBuildFrom());
        BooleanRef isFirst = BooleanRef.create((boolean)true);
        StringBuilder dateFormatsJson = new StringBuilder();
        dateFormats.foreach((Function1 & Serializable & scala.Serializable)f -> {
            StringBuilder stringBuilder;
            if (isFirst$1.elem) {
                isFirst$1.elem = false;
                stringBuilder = BoxedUnit.UNIT;
            } else {
                stringBuilder = dateFormatsJson.append(";");
            }
            return dateFormatsJson.append(f);
        });
        String indexesStr = String.join((CharSequence)",", (Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)columns.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getOrElse((Object)"index", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0).toString(), List$.MODULE$.canBuildFrom())).asJava());
        if ("hdfs".equalsIgnoreCase(pathType)) {
            if (".xls".equalsIgnoreCase(suffix)) {
                Configuration config = HDFSUtils$.MODULE$.getConfiguration((String)HadoopConf$.MODULE$.HADOOP_ROOT_USER().getValue());
                config.setBoolean("fs.hdfs.impl.disable.cache", true);
                fs = HDFSUtils$.MODULE$.getHDFSUserFileSystem(System.getProperty("user.name"), null, config);
                path = XlsUtils.excelToCsv((InputStream)fs.open(new Path(path)), (FileSystem)fs, (Boolean)Predef$.MODULE$.boolean2Boolean(hasHeader), (java.util.List)sheetNames);
                hasHeader = false;
            } else {
                path = BoxesRunTime.unboxToBoolean((Object)SparkConfiguration$.MODULE$.IS_VIEWFS_ENV().getValue()) ? path : new java.lang.StringBuilder(7).append("hdfs://").append(path).toString();
            }
        } else if (".xlsx".equalsIgnoreCase(suffix)) {
            path = new java.lang.StringBuilder(7).append("file://").append(path).toString();
        } else if (".xls".equalsIgnoreCase(suffix)) {
            Configuration config = HDFSUtils$.MODULE$.getConfiguration((String)HadoopConf$.MODULE$.HADOOP_ROOT_USER().getValue());
            config.setBoolean("fs.hdfs.impl.disable.cache", true);
            fs = HDFSUtils$.MODULE$.getHDFSUserFileSystem(System.getProperty("user.name"), null, config);
            path = XlsUtils.excelToCsv((InputStream)new FileInputStream(path), (FileSystem)fs, (Boolean)Predef$.MODULE$.boolean2Boolean(hasHeader), (java.util.List)sheetNames);
            hasHeader = false;
        } else {
            Configuration config = HDFSUtils$.MODULE$.getConfiguration((String)HadoopConf$.MODULE$.HADOOP_ROOT_USER().getValue());
            config.setBoolean("fs.hdfs.impl.disable.cache", true);
            fs = HDFSUtils$.MODULE$.getHDFSUserFileSystem(System.getProperty("user.name"), null, config);
            path = this.copyFileToHdfs(path, fs);
        }
        Dataset df = ".xlsx".equalsIgnoreCase(suffix) ? spark.read().format("com.webank.wedatasphere.spark.excel").option("useHeader", hasHeader).option("maxRowsInMemory", 100L).option("sheetName", sheetName).option("indexes", indexesStr).option("dateFormats", dateFormatsJson.toString()).schema(new StructType(this.getFields((List<Map<String, Object>>)columns))).load(path) : CsvRelation$.MODULE$.csvToDF(spark, new StructType(this.getFields((List<Map<String, Object>>)columns)), hasHeader, path, (Map<String, Object>)source, (List<Map<String, Object>>)columns);
        df.createOrReplaceTempView("tempTable");
        try {
            try {
                if (importData) {
                    if (isPartition) {
                        if (isOverwrite) {
                            spark.sql(new java.lang.StringBuilder(64).append("INSERT OVERWRITE TABLE  ").append(database).append(".").append(tableName).append(" partition(").append(partition).append("='").append(partitionValue).append("') select * from tempTable").toString());
                        } else {
                            spark.sql(new java.lang.StringBuilder(53).append("INSERT INTO  ").append(database).append(".").append(tableName).append(" partition(").append(partition).append("='").append(partitionValue).append("') select * from tempTable").toString());
                        }
                    } else if (isOverwrite) {
                        spark.sql(new java.lang.StringBuilder(49).append("INSERT OVERWRITE TABLE  ").append(database).append(".").append(tableName).append(" select * from tempTable").toString());
                    } else {
                        spark.sql(new java.lang.StringBuilder(39).append("INSERT INTO   ").append(database).append(".").append(tableName).append(" select * from tempTable").toString());
                    }
                } else {
                    Object object = spark.catalog().tableExists(database, tableName) ? spark.sql(new java.lang.StringBuilder(22).append("drop table if exists ").append(database).append(".").append(tableName).toString()) : BoxedUnit.UNIT;
                    if (isPartition) {
                        String columnSql = this.getColumnSql((List<Map<String, Object>>)columns);
                        String sql = new java.lang.StringBuilder(97).append("create table ").append(database).append(".").append(tableName).append("(").append(columnSql).append(") PARTITIONED BY (`").append(partition).append("` string) stored as orc tblproperties ('orc.compress'='SNAPPY')").toString();
                        spark.sql(sql);
                        spark.sql(new java.lang.StringBuilder(64).append("INSERT OVERWRITE TABLE  ").append(database).append(".").append(tableName).append(" partition(").append(partition).append("='").append(partitionValue).append("') select * from tempTable").toString());
                    } else {
                        String columnSql = this.getColumnSql((List<Map<String, Object>>)columns);
                        String sql = new java.lang.StringBuilder(70).append("create table ").append(database).append(".").append(tableName).append("(").append(columnSql).append(") stored as orc tblproperties ('orc.compress'='SNAPPY')").toString();
                        spark.sql(sql);
                        spark.sql(new java.lang.StringBuilder(49).append("INSERT OVERWRITE TABLE  ").append(database).append(".").append(tableName).append(" select * from tempTable").toString());
                    }
                }
            }
            catch (Throwable t) {
                Object object = !importData ? ImExportUtils$.MODULE$.tryAndIngoreError((Function0 & Serializable & scala.Serializable)() -> spark.sql(new java.lang.StringBuilder(12).append("drop table ").append(database).append(".").append(tableName).toString())) : BoxedUnit.UNIT;
                throw t;
            }
        }
        finally {
            if (fs != null) {
                fs.delete(new Path(path), true);
            }
        }
    }

    public String copyFileToHdfs(String path, FileSystem fs) {
        File file = new File(path);
        if (file.isDirectory()) {
            throw new Exception("Import must be a file, not a directory(\u5bfc\u5165\u7684\u5fc5\u987b\u662f\u6587\u4ef6\uff0c\u4e0d\u80fd\u662f\u76ee\u5f55)");
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        String hdfsPath = new java.lang.StringBuilder(6).append("/tmp/").append(System.getProperty("user.name")).append("/").append(System.currentTimeMillis()).append(file.getName()).toString();
        FSDataOutputStream out = fs.create(new Path(hdfsPath), true);
        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)4096);
        out.hsync();
        IOUtils.closeStream((Closeable)in);
        IOUtils.closeStream((Closeable)out);
        return hdfsPath;
    }

    public <T> T getNodeValue(JsonAST.JValue json, String node, T t, Manifest<T> m) {
        JsonAST.JValue jValue = package$.MODULE$.jvalue2monadic(json).$bslash(node);
        JsonAST.JNothing$ jNothing$ = package$.MODULE$.JNothing();
        JsonAST.JValue jValue2 = jValue;
        if (!(jNothing$ != null ? !jNothing$.equals(jValue2) : jValue2 != null)) {
            return t;
        }
        if (jValue != null) {
            Object object;
            JsonAST.JValue jValue3 = jValue;
            if ("JString()".equals(jValue3.toString())) {
                return t;
            }
            try {
                object = package$.MODULE$.jvalue2extractable(jValue3).extract((Formats)this.formats(), m);
            }
            catch (Throwable t2) {
                object = t;
            }
            return object;
        }
        throw new MatchError((Object)jValue);
    }

    public <T> T getNodeValue$default$3() {
        return null;
    }

    public <T> T getMapValue(Map<String, Object> map, String key, T t) {
        Object value = map.get((Object)key).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3).getOrElse((Function0 & Serializable & scala.Serializable)() -> t);
        if (StringUtils.isEmpty((CharSequence)value.toString())) {
            return t;
        }
        return (T)value;
    }

    public <T> T getMapValue$default$3() {
        return null;
    }

    public String getColumnSql(List<Map<String, Object>> columns) {
        StringBuilder sql = new StringBuilder();
        columns.foreach((Function1 & Serializable & scala.Serializable)column -> {
            if (column.apply((Object)"name") == null) {
                throw new IllegalArgumentException("When create a table, the field name must be defined(\u5efa\u7acb\u65b0\u8868\u65f6\uff0c\u5b57\u6bb5\u540d\u5fc5\u987b\u5b9a\u4e49)");
            }
            String name = (String)column.apply((Object)"name");
            sql.append("`").append(name).append("` ");
            String dataType = ((String)column.getOrElse((Object)"type", (Function0 & Serializable & scala.Serializable)() -> "string")).toLowerCase(Locale.getDefault());
            sql.append(dataType);
            String string = dataType;
            if ("char".equals(string) ? true : "varchar".equals(string)) {
                int length = new StringOps(Predef$.MODULE$.augmentString(column.getOrElse((Object)"length", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 20).toString())).toInt();
                sql.append(new java.lang.StringBuilder(2).append("(").append(length).append(")").toString());
            } else if ("decimal".equals(string)) {
                int precision = new StringOps(Predef$.MODULE$.augmentString(column.getOrElse((Object)"precision", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 20).toString())).toInt();
                int scale = new StringOps(Predef$.MODULE$.augmentString(column.getOrElse((Object)"scale", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 4).toString())).toInt();
                sql.append(new java.lang.StringBuilder(3).append("(").append(precision).append(",").append(scale).append(")").toString());
            }
            String comment = column.getOrElse((Object)"comment", (Function0 & Serializable & scala.Serializable)() -> "").toString();
            Object object = StringUtils.isNotEmpty((CharSequence)comment) ? sql.append(" comment ").append(new java.lang.StringBuilder(3).append("'").append(comment).append("' ").toString()) : BoxedUnit.UNIT;
            return sql.append(",");
        });
        return sql.toString().substring(0, sql.length() - 1);
    }

    public StructField[] getFields(List<Map<String, Object>> columns) {
        return (StructField[])((TraversableOnce)columns.map((Function1 & Serializable & scala.Serializable)column -> {
            if (column.apply((Object)"name") == null) {
                throw new IllegalArgumentException("When create a table, the field name must be defined(\u5efa\u7acb\u65b0\u8868\u65f6\uff0c\u5b57\u6bb5\u540d\u5fc5\u987b\u5b9a\u4e49)");
            }
            String name = (String)column.apply((Object)"name");
            String dataType = (String)column.getOrElse((Object)"type", (Function0 & Serializable & scala.Serializable)() -> "string");
            int precision = BoxesRunTime.unboxToInt((Object)Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(column.getOrElse((Object)"precision", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 20).toString())).toInt(), (Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)LoadData$.$anonfun$getFields$5(x0$1))));
            int scale = BoxesRunTime.unboxToInt((Object)Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(column.getOrElse((Object)"scale", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 4).toString())).toInt(), (Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)LoadData$.$anonfun$getFields$8(x0$2))));
            return new StructField(name, MODULE$.toDataType(dataType.toLowerCase(Locale.getDefault()), precision, scale), true, StructField$.MODULE$.apply$default$4());
        }, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StructField.class));
    }

    public DataType toDataType(String dataType, int precision, int scale) {
        String string = dataType;
        if ("void".equals(string) ? true : "null".equals(string)) {
            return NullType$.MODULE$;
        }
        if ("string".equals(string) ? true : ("char".equals(string) ? true : "varchar".equals(string))) {
            return StringType$.MODULE$;
        }
        if ("boolean".equals(string)) {
            return BooleanType$.MODULE$;
        }
        if ("short".equals(string)) {
            return ShortType$.MODULE$;
        }
        if ("int".equals(string) ? true : ("tinyint".equals(string) ? true : ("integer".equals(string) ? true : "smallint".equals(string)))) {
            return IntegerType$.MODULE$;
        }
        if ("long".equals(string) ? true : "bigint".equals(string)) {
            return LongType$.MODULE$;
        }
        if ("float".equals(string)) {
            return FloatType$.MODULE$;
        }
        if ("double".equals(string)) {
            return DoubleType$.MODULE$;
        }
        if ("date".equals(string)) {
            return DateType$.MODULE$;
        }
        if ("timestamp".equals(string)) {
            return TimestampType$.MODULE$;
        }
        if ("binary".equals(string)) {
            return BinaryType$.MODULE$;
        }
        if ("decimal".equals(string)) {
            return new DecimalType(precision, scale);
        }
        throw new IllegalArgumentException(new java.lang.StringBuilder(18).append("unknown dataType ").append(dataType).append(".").toString());
    }

    public static final /* synthetic */ boolean $anonfun$create_table_from_a_file$2(Map destination$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            BigInt flag = MODULE$.getMapValue((Map<String, Object>)destination$1, "isPartition", BigInt$.MODULE$.int2bigInt(0));
            return BoxesRunTime.equalsNumObject((Number)flag, (Object)BoxesRunTime.boxToInteger((int)1));
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ int $anonfun$getFields$5(Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            return 20;
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ int $anonfun$getFields$8(Throwable x0$2) {
        Throwable throwable = x0$2;
        if (throwable instanceof Exception) {
            return 4;
        }
        throw new MatchError((Object)throwable);
    }

    private LoadData$() {
        MODULE$ = this;
        this.formats = DefaultFormats$.MODULE$;
    }
}

