/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.entity.command.CmdTemplate;
import org.apache.linkis.cli.application.entity.command.Params;
import org.apache.linkis.cli.application.entity.context.CliCtx;
import org.apache.linkis.cli.application.exception.LinkisClientRuntimeException;
import org.apache.linkis.cli.application.exception.PropsException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.command.CliCmdType;
import org.apache.linkis.cli.application.interactor.command.CmdTemplateFactory;
import org.apache.linkis.cli.application.interactor.command.fitter.SingleTplFitter;
import org.apache.linkis.cli.application.interactor.command.parser.AbstarctParser;
import org.apache.linkis.cli.application.interactor.command.parser.SingleCmdParser;
import org.apache.linkis.cli.application.interactor.command.parser.result.ParseResult;
import org.apache.linkis.cli.application.interactor.context.CliCtxImpl;
import org.apache.linkis.cli.application.interactor.properties.ClientProperties;
import org.apache.linkis.cli.application.interactor.properties.PropertiesLoader;
import org.apache.linkis.cli.application.interactor.properties.PropsFilesScanner;
import org.apache.linkis.cli.application.interactor.properties.reader.PropertiesReader;
import org.apache.linkis.cli.application.interactor.properties.reader.PropsFileReader;
import org.apache.linkis.cli.application.interactor.validate.ParsedTplValidator;
import org.apache.linkis.cli.application.interactor.var.VarAccessImpl;
import org.apache.linkis.cli.application.utils.CliUtils;
import org.apache.linkis.cli.application.utils.LoggerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CtxBuilder {
    private static Logger logger = LoggerFactory.getLogger(CtxBuilder.class);

    public static CliCtx buildCtx(String[] args) throws LinkisClientRuntimeException {
        ClientProperties[] loaderResult;
        CmdTemplate template = CmdTemplateFactory.getTemplateCopy(CliCmdType.UNIVERSAL);
        AbstarctParser parser = new SingleCmdParser().setMapper(null).setTemplate(template).setFitter(new SingleTplFitter());
        ParseResult result = parser.parse(args);
        ParsedTplValidator parsedTplValidator = new ParsedTplValidator();
        parsedTplValidator.doValidation(result.getParsedTemplate());
        Params params = result.getParams();
        logger.debug("==========params============\n" + CliUtils.GSON.toJson((Object)params));
        HashMap<String, ClientProperties> propertiesMap = new HashMap<String, ClientProperties>();
        LoggerManager.getInformationLogger().info("LogFile path: " + System.getProperty("log.path") + "/" + System.getProperty("log.file"));
        String configPath = System.getProperty("conf.root");
        String defaultConfFileName = System.getProperty("conf.file", "linkis-cli.properties");
        if (StringUtils.isBlank((CharSequence)configPath)) {
            throw new PropsException("PRP0007", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.PropsLoaderErr, "configuration root path specified by env variable: conf.root is empty.");
        }
        List<PropertiesReader> readersList = new PropsFilesScanner().getPropsReaders(configPath);
        String userConfPath = null;
        if (params.containsParam("wds.linkis.client.common.user.conf")) {
            userConfPath = (String)params.getParamItemMap().get("wds.linkis.client.common.user.conf").getValue();
        }
        if (StringUtils.isNotBlank(userConfPath)) {
            PropertiesReader reader = new PropsFileReader().setPropsId("wds.linkis.client.common.user.conf").setPropsPath(userConfPath);
            readersList.add(reader);
        } else {
            LoggerManager.getInformationLogger().info("User does not provide usr-configuration file. Will use default config");
        }
        PropertiesLoader loader = new PropertiesLoader().addPropertiesReaders(readersList.toArray(new PropertiesReader[readersList.size()]));
        for (ClientProperties clientProperties : loaderResult = loader.loadProperties()) {
            if (StringUtils.equals((CharSequence)clientProperties.getPropsId(), (CharSequence)"wds.linkis.client.common.user.conf")) {
                for (Map.Entry prop : clientProperties.entrySet()) {
                    if (!StringUtils.startsWith((CharSequence)((String)prop.getKey()), (CharSequence)"wds.linkis.client.noncustomizable")) continue;
                    throw new PropsException("PRP0007", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.PropsLoaderErr, "User cannot specify non-customizable configuration: " + prop.getKey());
                }
            }
            propertiesMap.put(clientProperties.getPropsId(), clientProperties);
        }
        VarAccessImpl varAccess = new VarAccessImpl().setCmdParams(params).setUserConf((ClientProperties)propertiesMap.get("wds.linkis.client.common.user.conf")).setDefaultConf((ClientProperties)propertiesMap.get(defaultConfFileName)).init();
        logger.info("==========std_var============\n" + CliUtils.GSON.toJson((Object)varAccess));
        Properties props = new Properties();
        try {
            Throwable throwable = null;
            try (InputStream inputStream = CtxBuilder.class.getClassLoader().getResourceAsStream("version.properties");
                 InputStreamReader reader = new InputStreamReader(inputStream);
                 BufferedReader bufferedReader = new BufferedReader(reader);){
                props.load(bufferedReader);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (Exception e) {
            logger.warn("Failed to load version info", (Throwable)e);
        }
        String verion = props.getProperty("cli.version");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("cli.version", verion);
        return new CliCtxImpl(params.getCmdType(), template, varAccess, hashMap);
    }
}

