/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.present;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.entity.present.Model;
import org.apache.linkis.cli.application.entity.present.Presenter;
import org.apache.linkis.cli.application.exception.PresenterException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.job.common.ResultSet;
import org.apache.linkis.cli.application.observer.event.LinkisClientEvent;
import org.apache.linkis.cli.application.observer.listener.LinkisClientListener;
import org.apache.linkis.cli.application.present.file.ResultFileWriter;
import org.apache.linkis.cli.application.present.model.LinkisResultModel;
import org.apache.linkis.cli.application.utils.CliUtils;
import org.apache.linkis.cli.application.utils.LoggerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultPresenter
implements Presenter,
LinkisClientListener {
    private static Logger logger = LoggerFactory.getLogger(ResultPresenter.class);
    private Boolean writeToFile = false;
    private String filePath = "";

    public ResultPresenter() {
    }

    public ResultPresenter(Boolean writeToFile, String filePath) {
        this.writeToFile = writeToFile;
        this.filePath = filePath;
    }

    @Override
    public void update(LinkisClientEvent event, Object msg) {
        LinkisResultModel model = new LinkisResultModel();
        model.buildModel(msg);
        this.present(model);
    }

    @Override
    public void present(Model model) {
        if (!(model instanceof LinkisResultModel)) {
            throw new PresenterException("PST0001", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.PresenterErr, "Input model for \"LinkisResultPresenter\" is not instance of \"LinkisResultModel\"");
        }
        LinkisResultModel resultModel = (LinkisResultModel)model;
        LoggerManager.getPlaintTextLogger().info(this.formatResultIndicator(resultModel));
        if (!resultModel.getJobStatus().isJobSuccess()) {
            LoggerManager.getInformationLogger().info("JobStatus is not 'success'. Will not retrieve result-set.");
            return;
        }
        String msg = "";
        msg = resultModel.hasResult() ? "Retrieving result-set, may take time if result-set is large, please do not exit program." : "Your job has no result.";
        LoggerManager.getInformationLogger().info(msg);
        int preIdx = -1;
        StringBuilder resultSb = new StringBuilder();
        while (!resultModel.resultFinReceived()) {
            preIdx = this.presentOneIteration(resultModel, preIdx, resultSb);
            CliUtils.doSleepQuietly(500L);
        }
        this.presentOneIteration(resultModel, preIdx, resultSb);
        if (this.writeToFile.booleanValue()) {
            LoggerManager.getInformationLogger().info("ResultSet has been successfully written to path: " + this.filePath);
        }
    }

    protected int presentOneIteration(LinkisResultModel resultModel, int preIdx, StringBuilder resultSb) {
        List<ResultSet> resultSets = resultModel.consumeResultContent();
        if (resultSets != null && !resultSets.isEmpty()) {
            for (ResultSet c : resultSets) {
                boolean flag;
                int idxResultset = c.getResultsetIdx();
                if (idxResultset - preIdx != 0 && idxResultset - preIdx != 1) {
                    throw new PresenterException("PST0002", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.PresenterErr, "Linkis resultsets are visited in descending order or are not visited one-by-one");
                }
                boolean bl = flag = idxResultset > preIdx;
                if (idxResultset - preIdx == 1) {
                    resultSb.setLength(0);
                    resultSb.append(MessageFormat.format("============ RESULT SET {0} ============", idxResultset + 1)).append(System.lineSeparator());
                    if (c.getResultMeta() != null) {
                        resultSb.append("----------- META DATA ------------").append(System.lineSeparator());
                        resultSb.append(this.formatResultMeta(c.getResultMeta()));
                        resultSb.append("------------ END OF META DATA ------------").append(System.lineSeparator());
                    }
                }
                preIdx = idxResultset;
                String contentStr = this.formatResultContent(c.getResultMeta(), c.getContent());
                if (contentStr != null) {
                    resultSb.append(contentStr);
                }
                if (resultSb.length() == 0) continue;
                if (this.writeToFile.booleanValue()) {
                    String resultFileName = resultModel.getUser() + "-task-" + resultModel.getJobID() + "-result-" + String.valueOf(idxResultset + 1) + ".txt";
                    ResultFileWriter.writeToFile(this.filePath, resultFileName, resultSb.toString(), flag);
                } else {
                    LoggerManager.getPlaintTextLogger().info(resultSb.toString());
                }
                resultSb.setLength(0);
            }
        }
        return preIdx;
    }

    protected String formatResultMeta(List<LinkedHashMap<String, String>> metaData) {
        StringBuilder outputBuilder = new StringBuilder();
        if (metaData == null || metaData.size() == 0) {
            return null;
        }
        ArrayList<String> titles = new ArrayList<String>();
        for (LinkedHashMap<String, String> mapElement : metaData) {
            if (mapElement == null || mapElement.size() == 0) continue;
            Set<Map.Entry<String, String>> entrySet = mapElement.entrySet();
            if (entrySet == null) break;
            for (Map.Entry<String, String> entry : entrySet) {
                String key = entry.getKey();
                if (key == null || titles.contains(key)) continue;
                titles.add(key);
                outputBuilder.append(key).append("\t");
            }
        }
        outputBuilder.append(System.lineSeparator());
        for (LinkedHashMap<String, String> mapElement : metaData) {
            if (mapElement == null || mapElement.size() == 0) continue;
            for (String title : titles) {
                String candidate = mapElement.containsKey(title) ? mapElement.get(title) : "NULL";
                outputBuilder.append(candidate).append("\t");
            }
            outputBuilder.append(System.lineSeparator());
        }
        return outputBuilder.toString();
    }

    protected String formatResultContent(List<LinkedHashMap<String, String>> metaData, List<List<String>> contentData) {
        StringBuilder outputBuilder = new StringBuilder();
        if (contentData == null || contentData.size() == 0) {
            return null;
        }
        int listLen = contentData.size();
        for (int i = 0; i < listLen; ++i) {
            List<String> listElement = contentData.get(i);
            if (listElement == null || listElement.size() == 0) continue;
            for (String element : listElement) {
                outputBuilder.append(element).append("\t");
            }
            if (i >= listLen - 1) continue;
            outputBuilder.append(System.lineSeparator());
        }
        return outputBuilder.toString();
    }

    protected String formatResultIndicator(LinkisResultModel model) {
        StringBuilder infoBuilder = new StringBuilder();
        String extraMsgStr = "";
        if (model.getExtraMessage() != null) {
            extraMsgStr = model.getExtraMessage();
        }
        if (model.getJobStatus().isJobSuccess()) {
            LoggerManager.getInformationLogger().info("Job execute successfully! Will try get execute result");
            infoBuilder.append("============Result:================").append(System.lineSeparator()).append("TaskId:").append(model.getJobID()).append(System.lineSeparator()).append("ExecId: ").append(model.getExecID()).append(System.lineSeparator()).append("User:").append(model.getUser()).append(System.lineSeparator()).append("Current job status:").append(model.getJobStatus()).append(System.lineSeparator()).append("extraMsg: ").append(extraMsgStr).append(System.lineSeparator()).append("result: ").append(extraMsgStr).append(System.lineSeparator());
        } else if (model.getJobStatus().isJobFinishedState()) {
            LoggerManager.getInformationLogger().info("Job failed! Will not try get execute result.");
            infoBuilder.append("============Result:================").append(System.lineSeparator()).append("TaskId:").append(model.getJobID()).append(System.lineSeparator()).append("ExecId: ").append(model.getExecID()).append(System.lineSeparator()).append("User:").append(model.getUser()).append(System.lineSeparator()).append("Current job status:").append(model.getJobStatus()).append(System.lineSeparator()).append("extraMsg: ").append(extraMsgStr).append(System.lineSeparator());
            if (model.getErrCode() != null) {
                infoBuilder.append("errCode: ").append(model.getErrCode()).append(System.lineSeparator());
            }
            if (StringUtils.isNotBlank((CharSequence)model.getErrDesc())) {
                infoBuilder.append("errDesc: ").append(model.getErrDesc()).append(System.lineSeparator());
            }
        } else {
            throw new PresenterException("PST0011", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.PresenterErr, "Job is not completed but triggered ResultPresenter");
        }
        return infoBuilder.toString();
    }
}

