/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.entity.var.VarAccess;
import org.apache.linkis.cli.application.exception.BuilderException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.utils.LoggerManager;

public class CliUtils {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getSubmitUser(VarAccess stdVarAccess, String osUser, Set<String> adminSet) {
        String enableSpecifyUserStr = stdVarAccess.getVar(String.class, "wds.linkis.client.noncustomizable.enable.user.specification");
        Boolean enableSpecifyUser = Boolean.parseBoolean(enableSpecifyUserStr) || adminSet.contains(osUser);
        String authenticationStrategy = stdVarAccess.getVarOrDefault(String.class, "wds.linkis.client.common.authStrategy", "static");
        if (StringUtils.equalsIgnoreCase((CharSequence)authenticationStrategy, (CharSequence)"token")) {
            String submitUsr;
            if (enableSpecifyUser.booleanValue()) {
                if (stdVarAccess.hasVar("wds.linkis.client.common.submitUser")) {
                    submitUsr = stdVarAccess.getVar(String.class, "wds.linkis.client.common.submitUser");
                    if (adminSet.contains(osUser)) return submitUsr;
                    if (!adminSet.contains(submitUsr)) return submitUsr;
                    throw new BuilderException("BLD0010", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.BuilderBuildErr, "Cannot specify admin-user as submit-user");
                }
                submitUsr = osUser;
                LoggerManager.getInformationLogger().info("user does not specify submit-user, will use current Linux user \"" + osUser + "\" by default.");
                return submitUsr;
            } else {
                if (stdVarAccess.hasVar("wds.linkis.client.common.submitUser")) {
                    submitUsr = stdVarAccess.getVar(String.class, "wds.linkis.client.common.submitUser");
                    if (StringUtils.equals((CharSequence)submitUsr, (CharSequence)osUser)) return submitUsr;
                    throw new BuilderException("BLD0010", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.BuilderBuildErr, "Cannot specify submit-user when user-specification switch is off");
                }
                submitUsr = osUser;
                LoggerManager.getInformationLogger().info("user does not specify submit-user, will use current Linux user \"" + osUser + "\" by default.");
            }
            return submitUsr;
        } else {
            if (!StringUtils.equalsIgnoreCase((CharSequence)authenticationStrategy, (CharSequence)"static")) throw new BuilderException("BLD0011", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.BuilderBuildErr, "Authentication strategy '" + authenticationStrategy + "' is not supported");
            String authKey = stdVarAccess.getVar(String.class, "wds.linkis.client.common.tokenKey");
            String submitUsrInput = stdVarAccess.getVarOrDefault(String.class, "wds.linkis.client.common.submitUser", authKey);
            if (!StringUtils.equalsIgnoreCase((CharSequence)submitUsrInput, (CharSequence)authKey)) throw new BuilderException("BLD0011", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.BuilderBuildErr, "Submit-User should be the same as Auth-Key under Static-Authentication-Strategy '");
            return authKey;
        }
    }

    public static String getProxyUser(VarAccess stdVarAccess, String submitUsr, Set<String> adminSet) {
        String proxyUsr;
        String enableSpecifyPRoxyUserStr = stdVarAccess.getVar(String.class, "wds.linkis.client.noncustomizable.enable.proxy.user");
        Boolean enableSpecifyProxyUser = Boolean.parseBoolean(enableSpecifyPRoxyUserStr) || adminSet.contains(submitUsr);
        if (enableSpecifyProxyUser.booleanValue()) {
            if (stdVarAccess.hasVar("wds.linkis.client.common.proxyUser")) {
                proxyUsr = stdVarAccess.getVar(String.class, "wds.linkis.client.common.proxyUser");
                if (!adminSet.contains(submitUsr) && adminSet.contains(proxyUsr)) {
                    throw new BuilderException("BLD0010", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.BuilderBuildErr, "Cannot specify admin-user as proxy-user");
                }
            } else {
                proxyUsr = submitUsr;
                LoggerManager.getInformationLogger().info("user does not specify proxy-user, will use current submit-user \"" + submitUsr + "\" by default.");
            }
        } else if (stdVarAccess.hasVar("wds.linkis.client.common.proxyUser")) {
            proxyUsr = stdVarAccess.getVar(String.class, "wds.linkis.client.common.proxyUser");
            if (!StringUtils.equals((CharSequence)proxyUsr, (CharSequence)submitUsr)) {
                throw new BuilderException("BLD0010", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.BuilderBuildErr, "Cannot specify proxy-user when proxy-user-specification switch is off");
            }
        } else {
            proxyUsr = submitUsr;
            LoggerManager.getInformationLogger().info("user does not specify proxy-user, will use current submit-user \"" + proxyUsr + "\" by default.");
        }
        return proxyUsr;
    }

    /*
     * Exception decompiling
     */
    public static String readFile(String path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> T castStringToAny(Class<T> clazz, String val) {
        if (StringUtils.isBlank((CharSequence)val)) {
            return null;
        }
        T ret = null;
        if (clazz == Object.class) {
            ret = clazz.cast(val);
        } else if (clazz == String.class) {
            ret = clazz.cast(val);
        } else if (clazz == Integer.class) {
            ret = clazz.cast(Integer.parseInt(val));
        } else if (clazz == Double.class) {
            ret = clazz.cast(Double.parseDouble(val));
        } else if (clazz == Float.class) {
            ret = clazz.cast(Float.valueOf(Float.parseFloat(val)));
        } else if (clazz == Long.class) {
            ret = clazz.cast(Long.parseLong(val));
        } else if (clazz == Boolean.class) {
            ret = clazz.cast(Boolean.parseBoolean(val));
        }
        return ret;
    }

    public static Map<String, String> parseKVStringToMap(String kvStr, String separator) {
        String[] args;
        if (StringUtils.isBlank((CharSequence)separator)) {
            separator = ",";
        }
        if (StringUtils.isBlank((CharSequence)kvStr)) {
            return null;
        }
        HashMap<String, String> argsProps = new HashMap<String, String>();
        for (String arg : args = StringUtils.splitByWholeSeparator((String)kvStr, (String)separator)) {
            int index = arg.indexOf("=");
            if (index == -1) continue;
            argsProps.put(arg.substring(0, index).trim(), arg.substring(index + 1).trim());
        }
        return argsProps;
    }

    public static boolean isValidExecId(String execId) {
        boolean ret = false;
        if (StringUtils.isNotBlank((CharSequence)execId)) {
            ret = true;
        }
        return ret;
    }

    public static String progressInPercentage(float progress) {
        return String.valueOf(progress * 100.0f) + "%";
    }

    public static void doSleepQuietly(Long sleepMills) {
        try {
            Thread.sleep(sleepMills);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

