/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.execution.impl;

import org.apache.linkis.common.listener.Event;
import org.apache.linkis.orchestrator.execution.AbstractExecution;
import org.apache.linkis.orchestrator.execution.ExecTaskRunner;
import org.apache.linkis.orchestrator.execution.TaskConsumer;
import org.apache.linkis.orchestrator.execution.TaskManager;
import org.apache.linkis.orchestrator.execution.TaskScheduler;
import org.apache.linkis.orchestrator.listener.OrchestratorSyncEvent;
import org.apache.linkis.orchestrator.listener.execution.ExecutionTaskCompletedEvent;
import org.apache.linkis.orchestrator.listener.execution.ExecutionTaskCompletedListener;
import org.apache.linkis.orchestrator.listener.task.KillRootExecTaskEvent;
import org.apache.linkis.orchestrator.listener.task.OrchestrationKillListener;
import org.apache.linkis.orchestrator.plans.physical.ExecTask;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001e4A\u0001D\u0007\u00015!AA\u0006\u0001BC\u0002\u0013\u0005S\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u0003/\u0011!\u0011\u0004A!b\u0001\n\u0003\u001a\u0004\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0011a\u0002!Q1A\u0005BeB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\u0006}\u0001!\ta\u0010\u0005\u0006\u000b\u0002!\tE\u0012\u0005\u0006'\u0002!\t\u0005\u0016\u0005\u0006W\u0002!\t\u0005\u001c\u0005\u0006e\u0002!\te\u001d\u0002\u000e\u000bb,7-\u001e;j_:LU\u000e\u001d7\u000b\u00059y\u0011\u0001B5na2T!\u0001E\t\u0002\u0013\u0015DXmY;uS>t'B\u0001\n\u0014\u00031y'o\u00195fgR\u0014\u0018\r^8s\u0015\t!R#\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003-]\ta!\u00199bG\",'\"\u0001\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001YrD\n\t\u00039ui\u0011aD\u0005\u0003==\u0011\u0011#\u00112tiJ\f7\r^#yK\u000e,H/[8o!\t\u0001C%D\u0001\"\u0015\t\u0001\"E\u0003\u0002$#\u0005AA.[:uK:,'/\u0003\u0002&C\tqR\t_3dkRLwN\u001c+bg.\u001cu.\u001c9mKR,G\rT5ti\u0016tWM\u001d\t\u0003O)j\u0011\u0001\u000b\u0006\u0003S\t\nA\u0001^1tW&\u00111\u0006\u000b\u0002\u001a\u001fJ\u001c\u0007.Z:ue\u0006$\u0018n\u001c8LS2dG*[:uK:,'/A\u0007uCN\\7k\u00195fIVdWM]\u000b\u0002]A\u0011AdL\u0005\u0003a=\u0011Q\u0002V1tWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018A\u0004;bg.\u001c6\r[3ek2,'\u000fI\u0001\fi\u0006\u001c8.T1oC\u001e,'/F\u00015!\taR'\u0003\u00027\u001f\tYA+Y:l\u001b\u0006t\u0017mZ3s\u00031!\u0018m]6NC:\fw-\u001a:!\u00031!\u0018m]6D_:\u001cX/\\3s+\u0005Q\u0004C\u0001\u000f<\u0013\tatB\u0001\u0007UCN\\7i\u001c8tk6,'/A\u0007uCN\\7i\u001c8tk6,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0001\u00135\t\u0012\t\u0003\u0003\u0002i\u0011!\u0004\u0005\u0006Y\u001d\u0001\rA\f\u0005\u0006e\u001d\u0001\r\u0001\u000e\u0005\u0006q\u001d\u0001\rAO\u0001\f_:\u001c\u0016P\\2Fm\u0016tG\u000f\u0006\u0002H\u001bB\u0011\u0001jS\u0007\u0002\u0013*\t!*A\u0003tG\u0006d\u0017-\u0003\u0002M\u0013\n!QK\\5u\u0011\u0015q\u0005\u00021\u0001P\u0003\u0015)g/\u001a8u!\t\u0001\u0016+D\u0001#\u0013\t\u0011&EA\u000bPe\u000eDWm\u001d;sCR|'oU=oG\u00163XM\u001c;\u0002\u0019=tWI^3oi\u0016\u0013(o\u001c:\u0015\u0007\u001d+V\fC\u0003O\u0013\u0001\u0007a\u000b\u0005\u0002X76\t\u0001L\u0003\u0002$3*\u0011!lE\u0001\u0007G>lWn\u001c8\n\u0005qC&!B#wK:$\b\"\u00020\n\u0001\u0004y\u0016!\u0001;\u0011\u0005\u0001DgBA1g\u001d\t\u0011W-D\u0001d\u0015\t!\u0017$\u0001\u0004=e>|GOP\u0005\u0002\u0015&\u0011q-S\u0001\ba\u0006\u001c7.Y4f\u0013\tI'NA\u0005UQJ|w/\u00192mK*\u0011q-S\u0001\u001e_:,\u00050Z2vi&|g\u000eV1tW\u000e{W\u000e\u001d7fi\u0016$WI^3oiR\u0011q)\u001c\u0005\u0006]*\u0001\ra\\\u0001\u001cKb,7-\u001e;j_:$\u0016m]6D_6\u0004H.\u001a;fI\u00163XM\u001c;\u0011\u0005\u0001\u0002\u0018BA9\"\u0005m)\u00050Z2vi&|g\u000eV1tW\u000e{W\u000e\u001d7fi\u0016$WI^3oi\u00069rN\\&jY2\u0014vn\u001c;Fq\u0016\u001cG+Y:l\u000bZ,g\u000e\u001e\u000b\u0003\u000fRDQ!^\u0006A\u0002Y\fQc[5mYJ{w\u000e^#yK\u000e$\u0016m]6Fm\u0016tG\u000f\u0005\u0002(o&\u0011\u0001\u0010\u000b\u0002\u0016\u0017&dGNU8pi\u0016CXm\u0019+bg.,e/\u001a8u\u0001")
public class ExecutionImpl
extends AbstractExecution
implements ExecutionTaskCompletedListener,
OrchestrationKillListener {
    private final TaskScheduler taskScheduler;
    private final TaskManager taskManager;
    private final TaskConsumer taskConsumer;

    @Override
    public TaskScheduler taskScheduler() {
        return this.taskScheduler;
    }

    @Override
    public TaskManager taskManager() {
        return this.taskManager;
    }

    @Override
    public TaskConsumer taskConsumer() {
        return this.taskConsumer;
    }

    @Override
    public void onSyncEvent(OrchestratorSyncEvent event) {
        OrchestratorSyncEvent orchestratorSyncEvent = event;
        if (orchestratorSyncEvent instanceof ExecutionTaskCompletedEvent) {
            ExecutionTaskCompletedEvent executionTaskCompletedEvent = (ExecutionTaskCompletedEvent)orchestratorSyncEvent;
            this.onExecutionTaskCompletedEvent(executionTaskCompletedEvent);
            return;
        }
        if (orchestratorSyncEvent instanceof KillRootExecTaskEvent) {
            KillRootExecTaskEvent killRootExecTaskEvent = (KillRootExecTaskEvent)orchestratorSyncEvent;
            this.onKillRootExecTaskEvent(killRootExecTaskEvent);
            return;
        }
    }

    public void onEventError(Event event, Throwable t) {
    }

    @Override
    public void onExecutionTaskCompletedEvent(ExecutionTaskCompletedEvent executionTaskCompletedEvent) {
        executionTaskCompletedEvent.executionTask().markCompleted(executionTaskCompletedEvent.taskResponse());
    }

    @Override
    public void onKillRootExecTaskEvent(KillRootExecTaskEvent killRootExecTaskEvent) {
        ExecTask execTask = killRootExecTaskEvent.execTask();
        this.logger().info(new StringBuilder(30).append("receive killRootExecTaskEvent ").append(execTask.getIDInfo()).toString());
        ExecTaskRunner[] runners = this.taskManager().getRunningTask(execTask);
        if (runners != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])runners)).nonEmpty()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])runners)).foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
                ExecutionImpl.$anonfun$onKillRootExecTaskEvent$1(this, x$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        this.logger().info(new StringBuilder(56).append(execTask.getIDInfo()).append(" running task is null, now to mark ExecutionTask Failed ").toString());
        execTask.getPhysicalContext().markFailed("Execution Task is cancelled", null);
    }

    public static final /* synthetic */ void $anonfun$onKillRootExecTaskEvent$1(ExecutionImpl $this, ExecTaskRunner x$1) {
        $this.taskScheduler().cancelTask(x$1, true);
    }

    public ExecutionImpl(TaskScheduler taskScheduler, TaskManager taskManager, TaskConsumer taskConsumer) {
        this.taskScheduler = taskScheduler;
        this.taskManager = taskManager;
        this.taskConsumer = taskConsumer;
    }
}

