/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ResponseHeaderData;
import org.apache.kafka.common.network.ByteBufferSend;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.RecordsReadable;
import org.apache.kafka.common.protocol.RecordsWritable;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MultiRecordsSend;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.ResponseHeader;

public class FetchResponse<T extends BaseRecords>
extends AbstractResponse {
    public static final long INVALID_HIGHWATERMARK = -1L;
    public static final long INVALID_LAST_STABLE_OFFSET = -1L;
    public static final long INVALID_LOG_START_OFFSET = -1L;
    public static final int INVALID_PREFERRED_REPLICA_ID = -1;
    private final FetchResponseData data;
    private final LinkedHashMap<TopicPartition, PartitionData<T>> responseDataMap;

    public FetchResponseData data() {
        return this.data;
    }

    public FetchResponse(Errors error, LinkedHashMap<TopicPartition, PartitionData<T>> responseData, int throttleTimeMs, int sessionId) {
        this.data = FetchResponse.toMessage(throttleTimeMs, error, responseData.entrySet().iterator(), sessionId);
        this.responseDataMap = responseData;
    }

    public FetchResponse(FetchResponseData fetchResponseData) {
        this.data = fetchResponseData;
        this.responseDataMap = FetchResponse.toResponseDataMap(fetchResponseData);
    }

    @Override
    public Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    @Override
    public Send toSend(String dest, ResponseHeader responseHeader, short apiVersion) {
        ArrayDeque<Send> sends = new ArrayDeque<Send>();
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int totalRecordSize = this.data.responses().stream().flatMap(fetchableTopicResponse -> fetchableTopicResponse.partitionResponses().stream()).mapToInt(fetchablePartitionResponse -> fetchablePartitionResponse.recordSet().sizeInBytes()).sum();
        int totalMessageSize = this.data.size(cache, apiVersion);
        RecordsWritable writer = new RecordsWritable(dest, totalMessageSize - totalRecordSize, sends::add);
        this.data.write(writer, cache, apiVersion);
        writer.flush();
        ResponseHeaderData responseHeaderData = responseHeader.data();
        int headerSize = responseHeaderData.size(cache, responseHeader.headerVersion());
        int bodySize = Math.toIntExact(sends.stream().mapToLong(Send::size).sum());
        ByteBuffer buffer = ByteBuffer.allocate(headerSize + 4);
        ByteBufferAccessor headerWriter = new ByteBufferAccessor(buffer);
        buffer.putInt(headerSize + bodySize);
        responseHeaderData.write(headerWriter, cache, responseHeader.headerVersion());
        buffer.rewind();
        sends.addFirst(new ByteBufferSend(dest, buffer));
        return new MultiRecordsSend(dest, sends);
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    public LinkedHashMap<TopicPartition, PartitionData<T>> responseData() {
        return this.responseDataMap;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public int sessionId() {
        return this.data.sessionId();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.responseDataMap.values().forEach(response -> this.updateErrorCounts(errorCounts, response.error()));
        return errorCounts;
    }

    public static FetchResponse<MemoryRecords> parse(ByteBuffer buffer, short version) {
        FetchResponseData fetchResponseData = new FetchResponseData();
        RecordsReadable reader = new RecordsReadable(buffer);
        fetchResponseData.read(reader, version);
        return new FetchResponse<MemoryRecords>(fetchResponseData);
    }

    private static <T extends BaseRecords> LinkedHashMap<TopicPartition, PartitionData<T>> toResponseDataMap(FetchResponseData message) {
        LinkedHashMap responseMap = new LinkedHashMap();
        message.responses().forEach(topicResponse -> topicResponse.partitionResponses().forEach(partitionResponse -> {
            TopicPartition tp = new TopicPartition(topicResponse.topic(), partitionResponse.partition());
            PartitionData partitionData = new PartitionData((FetchResponseData.FetchablePartitionResponse)partitionResponse);
            responseMap.put(tp, partitionData);
        }));
        return responseMap;
    }

    private static <T extends BaseRecords> FetchResponseData toMessage(int throttleTimeMs, Errors error, Iterator<Map.Entry<TopicPartition, PartitionData<T>>> partIterator, int sessionId) {
        FetchResponseData message = new FetchResponseData();
        message.setThrottleTimeMs(throttleTimeMs);
        message.setErrorCode(error.code());
        message.setSessionId(sessionId);
        ArrayList<FetchResponseData.FetchableTopicResponse> topicResponseList = new ArrayList<FetchResponseData.FetchableTopicResponse>();
        List<FetchRequest.TopicAndPartitionData<FetchRequest.TopicAndPartitionData>> topicsData = FetchRequest.TopicAndPartitionData.batchByTopic(partIterator);
        topicsData.forEach(partitionDataTopicAndPartitionData -> {
            ArrayList<FetchResponseData.FetchablePartitionResponse> partitionResponses = new ArrayList<FetchResponseData.FetchablePartitionResponse>();
            partitionDataTopicAndPartitionData.partitions.forEach((partitionId, partitionData) -> {
                ((PartitionData)partitionData).partitionResponse.setPartition((int)partitionId);
                partitionResponses.add(((PartitionData)partitionData).partitionResponse);
            });
            topicResponseList.add(new FetchResponseData.FetchableTopicResponse().setTopic(partitionDataTopicAndPartitionData.topic).setPartitionResponses(partitionResponses));
        });
        message.setResponses(topicResponseList);
        return message;
    }

    public static <T extends BaseRecords> int sizeOf(short version, Iterator<Map.Entry<TopicPartition, PartitionData<T>>> partIterator) {
        FetchResponseData data = FetchResponse.toMessage(0, Errors.NONE, partIterator, 0);
        ObjectSerializationCache cache = new ObjectSerializationCache();
        return 4 + data.size(cache, version);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 8;
    }

    public static final class PartitionData<T extends BaseRecords> {
        private final FetchResponseData.FetchablePartitionResponse partitionResponse;
        private final Optional<Integer> preferredReplica;
        private final List<AbortedTransaction> abortedTransactions;
        private final Errors error;

        private PartitionData(FetchResponseData.FetchablePartitionResponse partitionResponse) {
            this.partitionResponse = partitionResponse;
            this.preferredReplica = Optional.of(partitionResponse.preferredReadReplica()).filter(replicaId -> replicaId != -1);
            this.abortedTransactions = partitionResponse.abortedTransactions() == null ? null : partitionResponse.abortedTransactions().stream().map(AbortedTransaction::fromMessage).collect(Collectors.toList());
            this.error = Errors.forCode(partitionResponse.errorCode());
        }

        public PartitionData(Errors error, long highWatermark, long lastStableOffset, long logStartOffset, Optional<Integer> preferredReadReplica, List<AbortedTransaction> abortedTransactions, Optional<FetchResponseData.EpochEndOffset> divergingEpoch, T records) {
            this.preferredReplica = preferredReadReplica;
            this.abortedTransactions = abortedTransactions;
            this.error = error;
            FetchResponseData.FetchablePartitionResponse partitionResponse = new FetchResponseData.FetchablePartitionResponse();
            partitionResponse.setErrorCode(error.code()).setHighWatermark(highWatermark).setLastStableOffset(lastStableOffset).setLogStartOffset(logStartOffset);
            if (abortedTransactions != null) {
                partitionResponse.setAbortedTransactions(abortedTransactions.stream().map(aborted -> new FetchResponseData.AbortedTransaction().setProducerId(aborted.producerId).setFirstOffset(aborted.firstOffset)).collect(Collectors.toList()));
            } else {
                partitionResponse.setAbortedTransactions(null);
            }
            partitionResponse.setPreferredReadReplica(preferredReadReplica.orElse(-1));
            partitionResponse.setRecordSet((BaseRecords)records);
            divergingEpoch.ifPresent(partitionResponse::setDivergingEpoch);
            this.partitionResponse = partitionResponse;
        }

        public PartitionData(Errors error, long highWatermark, long lastStableOffset, long logStartOffset, Optional<Integer> preferredReadReplica, List<AbortedTransaction> abortedTransactions, T records) {
            this(error, highWatermark, lastStableOffset, logStartOffset, preferredReadReplica, abortedTransactions, Optional.empty(), records);
        }

        public PartitionData(Errors error, long highWatermark, long lastStableOffset, long logStartOffset, List<AbortedTransaction> abortedTransactions, T records) {
            this(error, highWatermark, lastStableOffset, logStartOffset, Optional.empty(), abortedTransactions, records);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionData that = (PartitionData)o;
            return this.partitionResponse.equals(that.partitionResponse);
        }

        public int hashCode() {
            return this.partitionResponse.hashCode();
        }

        public String toString() {
            return "(error=" + (Object)((Object)this.error()) + ", highWaterMark=" + this.highWatermark() + ", lastStableOffset = " + this.lastStableOffset() + ", logStartOffset = " + this.logStartOffset() + ", preferredReadReplica = " + this.preferredReadReplica().map(Object::toString).orElse("absent") + ", abortedTransactions = " + this.abortedTransactions() + ", divergingEpoch =" + this.divergingEpoch() + ", recordsSizeInBytes=" + this.records().sizeInBytes() + ")";
        }

        public Errors error() {
            return this.error;
        }

        public long highWatermark() {
            return this.partitionResponse.highWatermark();
        }

        public long lastStableOffset() {
            return this.partitionResponse.lastStableOffset();
        }

        public long logStartOffset() {
            return this.partitionResponse.logStartOffset();
        }

        public Optional<Integer> preferredReadReplica() {
            return this.preferredReplica;
        }

        public List<AbortedTransaction> abortedTransactions() {
            return this.abortedTransactions;
        }

        public Optional<FetchResponseData.EpochEndOffset> divergingEpoch() {
            FetchResponseData.EpochEndOffset epochEndOffset = this.partitionResponse.divergingEpoch();
            if (epochEndOffset.epoch() < 0) {
                return Optional.empty();
            }
            return Optional.of(epochEndOffset);
        }

        public T records() {
            return (T)this.partitionResponse.recordSet();
        }
    }

    public static final class AbortedTransaction {
        public final long producerId;
        public final long firstOffset;

        public AbortedTransaction(long producerId, long firstOffset) {
            this.producerId = producerId;
            this.firstOffset = firstOffset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbortedTransaction that = (AbortedTransaction)o;
            return this.producerId == that.producerId && this.firstOffset == that.firstOffset;
        }

        public int hashCode() {
            int result = Long.hashCode(this.producerId);
            result = 31 * result + Long.hashCode(this.firstOffset);
            return result;
        }

        public String toString() {
            return "(producerId=" + this.producerId + ", firstOffset=" + this.firstOffset + ")";
        }

        static AbortedTransaction fromMessage(FetchResponseData.AbortedTransaction abortedTransaction) {
            return new AbortedTransaction(abortedTransaction.producerId(), abortedTransaction.firstOffset());
        }
    }
}

