/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.execution.ruler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cs.common.entity.enumeration.ContextType;
import org.apache.linkis.cs.common.entity.object.CSFlowInfos;
import org.apache.linkis.cs.common.entity.source.CommonContextKey;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.entity.source.ContextKeyValue;
import org.apache.linkis.cs.condition.impl.NearestCondition;
import org.apache.linkis.cs.contextcache.ContextCacheService;
import org.apache.linkis.cs.execution.matcher.ContextSearchMatcher;
import org.apache.linkis.cs.execution.ruler.AbstractContextSearchRuler;
import org.apache.linkis.cs.execution.ruler.CommonListContextSearchRuler;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NearestContextSearchRuler
extends AbstractContextSearchRuler {
    private static Logger logger = LoggerFactory.getLogger(NearestContextSearchRuler.class);
    static int LARGE_INT = 100000;
    static int SMALL_INT = -100000;
    static String DOT = ".";
    ContextCacheService contextCacheService;
    ContextID contextID;
    NearestCondition nearestCondition;
    CommonListContextSearchRuler commonListContextSearchRuler;

    public NearestContextSearchRuler(ContextSearchMatcher matcher, ContextCacheService contextCacheService, ContextID contextID, NearestCondition condition) {
        super(matcher);
        this.contextCacheService = contextCacheService;
        this.contextID = contextID;
        this.nearestCondition = condition;
        this.commonListContextSearchRuler = new CommonListContextSearchRuler(matcher);
    }

    @Override
    public List<ContextKeyValue> rule(List<ContextKeyValue> contextKeyValues) {
        contextKeyValues = this.commonListContextSearchRuler.rule(contextKeyValues);
        List<Object> filtered = Lists.newArrayList();
        CommonContextKey flowInfosKey = new CommonContextKey();
        flowInfosKey.setContextType(ContextType.OBJECT);
        flowInfosKey.setKey("flow.infos");
        ContextKeyValue flowInfos = this.contextCacheService.get(this.contextID, (ContextKey)flowInfosKey);
        if (null != flowInfos && flowInfos.getContextValue().getValue() instanceof CSFlowInfos) {
            CSFlowInfos csFlowInfos = (CSFlowInfos)flowInfos.getContextValue().getValue();
            logger.info("Calculate nearest nodes based on flow info: \n" + BDPJettyServerHelper.gson().toJson((Object)csFlowInfos));
            final List edges = (List)csFlowInfos.getInfos().get("edges");
            final Map idNodeName = (Map)csFlowInfos.getInfos().get("id_nodeName");
            String[] fullNodeName = StringUtils.split((String)this.nearestCondition.getCurrentNode(), (String)DOT);
            final String currentNodeName = fullNodeName[fullNodeName.length - 1];
            final ArrayList notUpstream = Lists.newArrayList();
            contextKeyValues.sort(new Comparator<ContextKeyValue>(){

                @Override
                public int compare(ContextKeyValue o1, ContextKeyValue o2) {
                    return this.distance(o1) - this.distance(o2);
                }

                private int distance(ContextKeyValue contextKeyValue) {
                    String nodeNameToCalc = StringUtils.substringBetween((String)contextKeyValue.getContextKey().getKey(), (String)"node.", (String)DOT);
                    if (StringUtils.isBlank((CharSequence)nodeNameToCalc)) {
                        return LARGE_INT;
                    }
                    if (nodeNameToCalc.equals(currentNodeName)) {
                        return 0;
                    }
                    int upDistance = this.upstreamDistance(nodeNameToCalc);
                    if (NearestContextSearchRuler.this.nearestCondition.getUpstreamOnly().booleanValue()) {
                        if (upDistance >= LARGE_INT) {
                            notUpstream.add(contextKeyValue);
                        }
                        return upDistance;
                    }
                    int downDistance = this.downstreamDistance(nodeNameToCalc);
                    return Integer.min(upDistance, downDistance);
                }

                private int upstreamDistance(String nodeNameToCalc) {
                    int minDistance = LARGE_INT;
                    for (Map edge : edges) {
                        if (!this.getNodeName((String)edge.get("source")).equals(nodeNameToCalc)) continue;
                        if (this.getNodeName((String)edge.get("target")).equals(currentNodeName)) {
                            return 1;
                        }
                        minDistance = Integer.min(minDistance, this.upstreamDistance(this.getNodeName((String)edge.get("target"))) + 1);
                    }
                    return minDistance;
                }

                private int downstreamDistance(String nodeNameToCalc) {
                    int minDistance = LARGE_INT;
                    for (Map edge : edges) {
                        if (!this.getNodeName((String)edge.get("target")).equals(nodeNameToCalc)) continue;
                        if (this.getNodeName((String)edge.get("source")).equals(currentNodeName)) {
                            return 1;
                        }
                        minDistance = this.downstreamDistance(this.getNodeName((String)edge.get("source"))) + 1;
                    }
                    return minDistance;
                }

                private String getNodeName(String nodeId) {
                    if (StringUtils.isBlank((CharSequence)nodeId) || null == idNodeName) {
                        return "";
                    }
                    return (String)idNodeName.get(nodeId);
                }
            });
            if (this.nearestCondition.getUpstreamOnly().booleanValue()) {
                contextKeyValues.removeAll(notUpstream);
            }
            int endIndex = this.nearestCondition.getNumber() < contextKeyValues.size() ? this.nearestCondition.getNumber().intValue() : contextKeyValues.size();
            filtered = contextKeyValues.subList(0, endIndex);
            logger.info("Finished to NearestContextSearchRuler nearest nodes based on flow info: \n, filtered size {}" + BDPJettyServerHelper.gson().toJson((Object)csFlowInfos), (Object)filtered.size());
        }
        return filtered;
    }
}

