/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.highavailable.proxy;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.HAContextID;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.highavailable.AbstractContextHAManager;
import org.apache.linkis.cs.highavailable.exception.CSErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

public class MethodInterceptorImpl
implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(MethodInterceptorImpl.class);
    private AbstractContextHAManager contextHAManager;
    private Object object;
    private static final String CONTEXTID = "contextid";
    private static final String GETCONTEXTID = "getcontextid";

    public MethodInterceptorImpl(AbstractContextHAManager contextHAManager, Object object) {
        this.contextHAManager = contextHAManager;
        this.object = object;
    }

    public Object intercept(Object interceptObject, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        Object oriResult;
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof ContextID)) continue;
            ContextID contextID = (ContextID)args[i];
            args[i] = this.convertContextIDBeforeInvoke(contextID);
        }
        if (method.getName().toLowerCase().contains(CONTEXTID)) {
            for (int j = 0; j < args.length; ++j) {
                if (!(args[j] instanceof String)) continue;
                String contextIdStr = (String)args[j];
                if (!StringUtils.isNotBlank((CharSequence)contextIdStr) || StringUtils.isNumeric((CharSequence)contextIdStr)) break;
                if (this.contextHAManager.getContextHAChecker().isHAIDValid(contextIdStr)) {
                    Object contextID;
                    args[j] = contextID = this.contextHAManager.getContextHAChecker().parseHAIDFromKey(contextIdStr).getContextId();
                    break;
                }
                logger.error("Invalid HAID : " + contextIdStr + " in method : " + method.getName());
                throw new CSErrorException(CSErrorCode.INVALID_HAID, "Invalid HAID : " + contextIdStr + " in method : " + method.getName());
            }
        }
        if (null != (oriResult = method.invoke(this.object, args))) {
            HAContextID haContextID;
            if (oriResult instanceof List) {
                List objList = (List)oriResult;
                for (Object oneParameter : objList) {
                    HAContextID haContextID2;
                    if (null == objList || !(oneParameter instanceof HAContextID) || !StringUtils.isNumeric((CharSequence)(haContextID2 = (HAContextID)oneParameter).getContextId())) continue;
                    String haId = this.contextHAManager.getContextHAChecker().convertHAIDToHAKey(haContextID2);
                    haContextID2.setContextId(haId);
                }
            } else if (oriResult instanceof HAContextID && StringUtils.isNumeric((CharSequence)(haContextID = (HAContextID)oriResult).getContextId())) {
                String haId = this.contextHAManager.getContextHAChecker().convertHAIDToHAKey(haContextID);
                haContextID.setContextId(haId);
            }
        }
        return oriResult;
    }

    private ContextID convertContextIDBeforeInvoke(ContextID contextID) throws CSErrorException {
        if (null == contextID) {
            return null;
        }
        if (StringUtils.isNumeric((CharSequence)contextID.getContextId())) {
            if (contextID instanceof HAContextID) {
                logger.error("ContextId of HAContextID instance cannot be numberic. contextId : {} ", (Object)contextID.getContextId());
                throw new CSErrorException(CSErrorCode.INVALID_CONTEXTID, "ContextId of HAContextID instance cannot be numberic. contextId : " + contextID.getContextId());
            }
        } else if (contextID instanceof HAContextID) {
            if (null == contextID.getContextId()) {
                return this.contextHAManager.convertProxyHAID((HAContextID)contextID);
            }
            if (this.contextHAManager.getContextHAChecker().isHAIDValid(contextID.getContextId())) {
                return this.contextHAManager.convertProxyHAID((HAContextID)contextID);
            }
            logger.error("Invalid haContextId. contextId : {} ", (Object)contextID.getContextId());
            throw new CSErrorException(CSErrorCode.INVALID_HAID, "Invalid haContextId. contextId : " + contextID.getContextId());
        }
        return contextID;
    }

    private void convertGetContextIDAfterInvoke(Object object) throws CSErrorException {
        if (null == object) {
            return;
        }
        for (Method innerMethod : object.getClass().getMethods()) {
            this.convertGetContextIDAfterInvokeMethod(innerMethod, object);
        }
    }

    private void convertGetContextIDAfterInvokeMethod(Method method, Object methodObject) throws CSErrorException {
        if (method.getName().toLowerCase().contains(GETCONTEXTID)) {
            Object result = null;
            try {
                result = method.invoke(methodObject, new Object[0]);
            }
            catch (Exception e) {
                logger.warn("Invoke method : {} error. ", (Object)method.getName(), (Object)e);
            }
            if (HAContextID.class.isInstance(result)) {
                HAContextID haContextID = (HAContextID)result;
                if (StringUtils.isNumeric((CharSequence)haContextID.getContextId()) && StringUtils.isNotBlank((CharSequence)haContextID.getInstance()) && StringUtils.isNotBlank((CharSequence)haContextID.getBackupInstance())) {
                    String haid = this.contextHAManager.getContextHAChecker().convertHAIDToHAKey(haContextID);
                    haContextID.setContextId(haid);
                } else {
                    logger.error("GetContextID method : " + method.getName() + " returns invalid haContextID : " + result);
                    throw new CSErrorException(CSErrorCode.INVALID_HAID, "GetContextID method : " + method.getName() + " returns invalid haContextID : " + result);
                }
            }
        }
    }
}

