/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.optimize.cost;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.linkis.cs.common.entity.enumeration.ContextScope;
import org.apache.linkis.cs.common.entity.enumeration.ContextType;
import org.apache.linkis.cs.condition.AtomicCondition;
import org.apache.linkis.cs.condition.Condition;
import org.apache.linkis.cs.condition.impl.ContainsCondition;
import org.apache.linkis.cs.condition.impl.ContextValueTypeCondition;
import org.apache.linkis.cs.condition.impl.RegexCondition;

public class ConditionCostCalculator {
    static Map<Class, Double> initialCost = Maps.newHashMap();

    public Double calculate(Condition condition) {
        if (condition instanceof AtomicCondition) {
            return initialCost.get(condition.getClass());
        }
        return 0.0;
    }

    static {
        initialCost.put(RegexCondition.class, 100.0);
        initialCost.put(ContainsCondition.class, 10.0);
        initialCost.put(ContextScope.class, 10.0);
        initialCost.put(ContextType.class, 1.0);
        initialCost.put(ContextValueTypeCondition.class, 1.0);
    }
}

