/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.persistence.persistence.impl;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.linkis.cs.common.entity.listener.CommonContextIDListenerDomain;
import org.apache.linkis.cs.common.entity.listener.ContextIDListenerDomain;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.persistence.dao.ContextIDListenerMapper;
import org.apache.linkis.cs.persistence.entity.PersistenceContextIDListener;
import org.apache.linkis.cs.persistence.persistence.ContextIDListenerPersistence;
import org.apache.linkis.cs.persistence.persistence.ContextIDPersistence;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContextIDListenerPersistenceImpl
implements ContextIDListenerPersistence {
    @Autowired
    private ContextIDListenerMapper contextIDListenerMapper;
    @Autowired
    private ContextIDPersistence contextIDPersistence;

    @Override
    public void create(ContextID contextID, ContextIDListenerDomain contextIDListenerDomain) throws CSErrorException {
        PersistenceContextIDListener listener = new PersistenceContextIDListener();
        listener.setContextId(contextID.getContextId());
        listener.setSource(contextIDListenerDomain.getSource());
        this.contextIDListenerMapper.createIDListener(listener);
    }

    @Override
    public void remove(ContextIDListenerDomain contextIDListenerDomain) throws CSErrorException {
        PersistenceContextIDListener listener = new PersistenceContextIDListener();
        listener.setContextId(contextIDListenerDomain.getContextID().getContextId());
        listener.setSource(contextIDListenerDomain.getSource());
        this.contextIDListenerMapper.remove(listener);
    }

    @Override
    public void removeAll(ContextID contextID) throws CSErrorException {
        this.contextIDListenerMapper.removeAll(contextID);
    }

    @Override
    public List<ContextIDListenerDomain> getAll(ContextID contextID) throws CSErrorException {
        ContextID complete = this.contextIDPersistence.getContextID(contextID.getContextId());
        List<PersistenceContextIDListener> listeners = this.contextIDListenerMapper.getAll(contextID);
        List<ContextIDListenerDomain> domains = listeners.stream().map(l -> this.pDomainToCommon((PersistenceContextIDListener)l, complete)).collect(Collectors.toList());
        return domains;
    }

    public ContextIDListenerDomain pDomainToCommon(PersistenceContextIDListener listener, ContextID contextID) {
        CommonContextIDListenerDomain domain = new CommonContextIDListenerDomain();
        domain.setContextID(contextID);
        domain.setSource(listener.getSource());
        return domain;
    }

    @Override
    public ContextIDListenerDomain getBy(ContextIDListenerDomain contextIDListenerDomain) throws CSErrorException {
        return contextIDListenerDomain;
    }
}

