/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.ecm;

import java.io.Serializable;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.exception.LinkisRetryException;
import org.apache.linkis.common.log.LogUtils$;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf$;
import org.apache.linkis.manager.common.entity.node.EngineNode;
import org.apache.linkis.manager.common.protocol.engine.EngineAskAsyncResponse;
import org.apache.linkis.manager.common.protocol.engine.EngineAskRequest;
import org.apache.linkis.manager.common.protocol.engine.EngineAsyncResponse;
import org.apache.linkis.manager.common.protocol.engine.EngineCreateError;
import org.apache.linkis.manager.common.protocol.engine.EngineCreateSuccess;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.orchestrator.computation.physical.CodeLogicalUnitExecTask;
import org.apache.linkis.orchestrator.ecm.AbstractEngineConnManager;
import org.apache.linkis.orchestrator.ecm.cache.EngineAsyncResponseCache;
import org.apache.linkis.orchestrator.ecm.cache.EngineAsyncResponseCache$;
import org.apache.linkis.orchestrator.ecm.conf.ECMPluginConf$;
import org.apache.linkis.orchestrator.ecm.entity.DefaultMark;
import org.apache.linkis.orchestrator.ecm.entity.Mark;
import org.apache.linkis.orchestrator.ecm.entity.MarkReq;
import org.apache.linkis.orchestrator.ecm.entity.Policy;
import org.apache.linkis.orchestrator.ecm.exception.ECMPluginErrorException;
import org.apache.linkis.orchestrator.ecm.service.EngineConnExecutor;
import org.apache.linkis.orchestrator.ecm.service.impl.ComputationConcurrentEngineConnExecutor;
import org.apache.linkis.orchestrator.ecm.service.impl.ComputationEngineConnExecutor;
import org.apache.linkis.orchestrator.listener.task.TaskLogEvent;
import org.apache.linkis.orchestrator.plans.physical.ExecTask;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.Sender$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001B\u0007\u000f\u0001eAQA\n\u0001\u0005\u0002\u001dBq!\u000b\u0001C\u0002\u0013%!\u0006\u0003\u00048\u0001\u0001\u0006Ia\u000b\u0005\bq\u0001\u0011\r\u0011\"\u0003:\u0011\u0019\u0001\u0005\u0001)A\u0005u!)\u0011\t\u0001C!\u0005\")\u0011\n\u0001C!\u0015\")1\u000b\u0001C!)\")a\u000b\u0001C\t/\")Q\r\u0001C)M\"9\u0011Q\u0002\u0001\u0005\n\u0005=\u0001bBA\u001a\u0001\u0011%\u0011Q\u0007\u0002\u001d\u0007>l\u0007/\u001e;bi&|g.\u00128hS:,7i\u001c8o\u001b\u0006t\u0017mZ3s\u0015\ty\u0001#A\u0002fG6T!!\u0005\n\u0002\u0019=\u00148\r[3tiJ\fGo\u001c:\u000b\u0005M!\u0012A\u00027j].L7O\u0003\u0002\u0016-\u00051\u0011\r]1dQ\u0016T\u0011aF\u0001\u0004_J<7\u0001A\n\u0004\u0001iq\u0002CA\u000e\u001d\u001b\u0005q\u0011BA\u000f\u000f\u0005e\t%m\u001d;sC\u000e$XI\\4j]\u0016\u001cuN\u001c8NC:\fw-\u001a:\u0011\u0005}!S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013!B;uS2\u001c(BA\u0012\u0013\u0003\u0019\u0019w.\\7p]&\u0011Q\u0005\t\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0006\u0005\u0002\u001c\u0001\u0005I\u0011\u000eZ\"sK\u0006$xN]\u000b\u0002WA\u0011A&N\u0007\u0002[)\u0011afL\u0001\u0007CR|W.[2\u000b\u0005A\n\u0014AC2p]\u000e,(O]3oi*\u0011!gM\u0001\u0005kRLGNC\u00015\u0003\u0011Q\u0017M^1\n\u0005Yj#!D!u_6L7-\u00138uK\u001e,'/\u0001\u0006jI\u000e\u0013X-\u0019;pe\u0002\n\u0001bY1dQ\u0016l\u0015\r]\u000b\u0002uA\u00111HP\u0007\u0002y)\u0011QHD\u0001\u0006G\u0006\u001c\u0007.Z\u0005\u0003\u007fq\u0012\u0001$\u00128hS:,\u0017i]=oGJ+7\u000f]8og\u0016\u001c\u0015m\u00195f\u0003%\u0019\u0017m\u00195f\u001b\u0006\u0004\b%A\u0005hKR\u0004v\u000e\\5dsR\t1\t\u0005\u0002E\u000f6\tQI\u0003\u0002G\u001d\u00051QM\u001c;jifL!\u0001S#\u0003\rA{G.[2z\u0003%\t\u0007\u000f\u001d7z\u001b\u0006\u00148\u000e\u0006\u0002L\u001dB\u0011A\tT\u0005\u0003\u001b\u0016\u0013A!T1sW\")qj\u0002a\u0001!\u00069Q.\u0019:l%\u0016\f\bC\u0001#R\u0013\t\u0011VIA\u0004NCJ\\'+Z9\u0002\u0015\r\u0014X-\u0019;f\u001b\u0006\u00148\u000e\u0006\u0002L+\")q\n\u0003a\u0001!\u0006Qa.\u001a=u\u001b\u0006\u00148.\u00133\u0015\u0003a\u0003\"!\u00172\u000f\u0005i\u0003\u0007CA._\u001b\u0005a&BA/\u0019\u0003\u0019a$o\\8u})\tq,A\u0003tG\u0006d\u0017-\u0003\u0002b=\u00061\u0001K]3eK\u001aL!a\u00193\u0003\rM#(/\u001b8h\u0015\t\tg,A\u000bbg.,enZ5oK\u000e{gN\\#yK\u000e,Ho\u001c:\u0015\t\u001dl'\u0010 \t\u0003Q.l\u0011!\u001b\u0006\u0003U:\tqa]3sm&\u001cW-\u0003\u0002mS\n\u0011RI\\4j]\u0016\u001cuN\u001c8Fq\u0016\u001cW\u000f^8s\u0011\u0015q'\u00021\u0001p\u0003A)gnZ5oK\u0006\u001b8NU3rk\u0016\u001cH\u000f\u0005\u0002qq6\t\u0011O\u0003\u0002sg\u00061QM\\4j]\u0016T!\u0001^;\u0002\u0011A\u0014x\u000e^8d_2T!a\t<\u000b\u0005]\u0014\u0012aB7b]\u0006<WM]\u0005\u0003sF\u0014\u0001#\u00128hS:,\u0017i]6SKF,Xm\u001d;\t\u000bmT\u0001\u0019A&\u0002\t5\f'o\u001b\u0005\u0006{*\u0001\rA`\u0001\tKb,7\rV1tWB\u0019q0!\u0003\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\t\u0001\u0002\u001d5zg&\u001c\u0017\r\u001c\u0006\u0004\u0003\u000f\u0001\u0012aC2p[B,H/\u0019;j_:LA!a\u0003\u0002\u0002\t92i\u001c3f\u0019><\u0017nY1m+:LG/\u0012=fGR\u000b7o[\u0001\u0018O\u0016$XI\\4j]\u0016tu\u000eZ3Bg.l\u0015M\\1hKJ$\u0002\"!\u0005\u0002.\u0005=\u0012\u0011\u0007\t\t\u0003'\t)\"!\u0007\u0002(5\ta,C\u0002\u0002\u0018y\u0013a\u0001V;qY\u0016\u0014\u0004\u0003BA\u000e\u0003Gi!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0005]>$WM\u0003\u0002Gk&!\u0011QEA\u000f\u0005))enZ5oK:{G-\u001a\t\u0005\u0003'\tI#C\u0002\u0002,y\u0013qAQ8pY\u0016\fg\u000eC\u0003o\u0017\u0001\u0007q\u000eC\u0003|\u0017\u0001\u00071\nC\u0003~\u0017\u0001\u0007a0\u0001\thKRl\u0015M\\1hKJ\u001cVM\u001c3feR\u0011\u0011q\u0007\t\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011Q\b\n\u0002\u0007I\u00048-\u0003\u0003\u0002B\u0005m\"AB*f]\u0012,'\u000f")
public class ComputationEngineConnManager
extends AbstractEngineConnManager {
    private final AtomicInteger idCreator = new AtomicInteger();
    private final EngineAsyncResponseCache cacheMap = EngineAsyncResponseCache$.MODULE$.getCache();

    private AtomicInteger idCreator() {
        return this.idCreator;
    }

    private EngineAsyncResponseCache cacheMap() {
        return this.cacheMap;
    }

    @Override
    public Policy getPolicy() {
        return Policy.Process;
    }

    @Override
    public Mark applyMark(MarkReq markReq) {
        if (markReq == null) {
            return null;
        }
        return this.createMark(markReq);
    }

    @Override
    public Mark createMark(MarkReq markReq) {
        DefaultMark mark = new DefaultMark(this.nextMarkId(), markReq);
        this.addMark(mark, new ArrayList<ServiceInstance>());
        return mark;
    }

    public String nextMarkId() {
        return new StringBuilder(5).append("mark_").append(this.idCreator().getAndIncrement()).toString();
    }

    @Override
    public EngineConnExecutor askEngineConnExecutor(EngineAskRequest engineAskRequest, Mark mark, CodeLogicalUnitExecTask execTask) {
        engineAskRequest.setTimeOut(this.getEngineConnApplyTime());
        int count = this.getEngineConnApplyAttempts() + 1;
        LinkisRetryException retryException = null;
        while (count >= 1) {
            Object object;
            --count;
            long start = System.currentTimeMillis();
            try {
                Tuple2<EngineNode, Object> tuple2 = this.getEngineNodeAskManager(engineAskRequest, mark, execTask);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                EngineNode engineNode = (EngineNode)tuple2._1();
                boolean reuse = tuple2._2$mcZ$sp();
                Tuple2 tuple22 = new Tuple2((Object)engineNode, (Object)BoxesRunTime.boxToBoolean((boolean)reuse));
                EngineNode engineNode2 = (EngineNode)tuple22._1();
                boolean reuse2 = tuple22._2$mcZ$sp();
                if (engineNode2 != null) {
                    ComputationEngineConnExecutor engineConnExecutor;
                    ComputationEngineConnExecutor computationEngineConnExecutor = engineConnExecutor = engineAskRequest.getLabels() != null && engineAskRequest.getLabels().containsKey("concurrentEngineConn") ? new ComputationConcurrentEngineConnExecutor(engineNode2, this.getParallelism()) : new ComputationEngineConnExecutor(engineNode2);
                    if (engineNode2.getLabels() != null) {
                        engineConnExecutor.setLabels((Label[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(engineNode2.getLabels()).asScala()).toList().toArray(ClassTag$.MODULE$.apply(Label.class)));
                    }
                    engineConnExecutor.setReuse(reuse2);
                    return engineConnExecutor;
                }
                object = BoxedUnit.UNIT;
            }
            catch (LinkisRetryException t) {
                String taken = ByteTimeUtils.msDurationToString((long)(System.currentTimeMillis() - start));
                this.logger().warn(new StringBuilder(46).append(mark.getMarkId()).append(" Failed to askEngineAskRequest time taken (").append(taken).append("), ").append(t.getMessage()).toString());
                retryException = t;
                Thread.sleep(5000L);
                if (retryException.getDesc().contains("origin cluster retry")) {
                    object = engineAskRequest.getProperties().put("originClusterRetry", "true");
                    continue;
                }
                object = engineAskRequest.getProperties().put("targetClusterRetry", "true");
            }
            catch (Throwable t) {
                String taken = ByteTimeUtils.msDurationToString((long)(System.currentTimeMillis() - start));
                this.logger().warn(new StringBuilder(44).append(mark.getMarkId()).append(" Failed to askEngineAskRequest time taken (").append(taken).append(")").toString());
                throw t;
            }
        }
        if (retryException != null) {
            throw retryException;
        }
        throw new ECMPluginErrorException(ECMPluginConf$.MODULE$.ECM_ERROR_CODE(), new StringBuilder(44).append(mark.getMarkId()).append(" Failed to ask engineAskRequest ").append(engineAskRequest).append(" by retry ").append(this.getEngineConnApplyAttempts() - count).append("  ").toString());
    }

    private Tuple2<EngineNode, Object> getEngineNodeAskManager(EngineAskRequest engineAskRequest, Mark mark, CodeLogicalUnitExecTask execTask) {
        Object response = Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> this.getManagerSender().ask((Object)engineAskRequest), (Function1 & Serializable & scala.Serializable)t -> {
            String baseMsg = new StringBuilder(51).append("mark ").append(mark.getMarkId()).append("  failed to ask linkis Manager Can be retried ").toString();
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)t);
            if (throwable instanceof SocketTimeoutException) {
                SocketTimeoutException socketTimeoutException = (SocketTimeoutException)throwable;
                String msg = new StringBuilder(0).append(baseMsg).append(ExceptionUtils.getMessage((Throwable)socketTimeoutException)).toString();
                throw new LinkisRetryException(ECMPluginConf$.MODULE$.ECM_ENGNE_CREATION_ERROR_CODE(), msg);
            }
            if (throwable instanceof SocketException) {
                SocketException socketException = (SocketException)throwable;
                String msg = new StringBuilder(0).append(baseMsg).append(ExceptionUtils.getMessage((Throwable)socketException)).toString();
                throw new LinkisRetryException(ECMPluginConf$.MODULE$.ECM_ENGNE_CREATION_ERROR_CODE(), msg);
            }
            throw t;
        });
        Object object = response;
        if (object instanceof EngineCreateError) {
            EngineCreateError engineCreateError = (EngineCreateError)object;
            String id = engineCreateError.id();
            String exception = engineCreateError.exception();
            boolean retry = engineCreateError.retry();
            if (retry) {
                throw new LinkisRetryException(ECMPluginConf$.MODULE$.ECM_ENGNE_CREATION_ERROR_CODE(), new StringBuilder(33).append(id).append(" Failed  to async get EngineNode ").append(exception).toString());
            }
            throw new ECMPluginErrorException(ECMPluginConf$.MODULE$.ECM_ENGNE_CREATION_ERROR_CODE(), new StringBuilder(33).append(id).append(" Failed  to async get EngineNode ").append(exception).toString());
        }
        if (object instanceof EngineNode) {
            EngineNode engineNode = (EngineNode)object;
            this.logger().debug(new StringBuilder(34).append("Succeed to reuse engineNode ").append(engineNode).append(" mark ").append(mark.getMarkId()).toString());
            return new Tuple2((Object)engineNode, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        if (object instanceof EngineAskAsyncResponse) {
            EngineAskAsyncResponse engineAskAsyncResponse = (EngineAskAsyncResponse)object;
            String id = engineAskAsyncResponse.id();
            ServiceInstance serviceInstance = engineAskAsyncResponse.managerInstance();
            this.logger().info("{} received EngineAskAsyncResponse id: {} serviceInstance: {}", new Object[]{mark.getMarkId(), id, serviceInstance});
            execTask.getPhysicalContext().pushLog(new TaskLogEvent((ExecTask)execTask, LogUtils$.MODULE$.generateInfo(new StringBuilder(22).append("Request LinkisManager:").append(response).toString())));
            EngineAsyncResponse engineAsyncResponse = this.cacheMap().getAndRemove(id, (Duration)Duration$.MODULE$.apply(engineAskRequest.getTimeOut() + 100000L, TimeUnit.MILLISECONDS));
            if (engineAsyncResponse instanceof EngineCreateSuccess) {
                EngineCreateSuccess engineCreateSuccess = (EngineCreateSuccess)engineAsyncResponse;
                String id2 = engineCreateSuccess.id();
                EngineNode engineNode = engineCreateSuccess.engineNode();
                boolean reuse = engineCreateSuccess.isReuse();
                this.logger().info("{} async id: {} success to async get create EngineNode {}", new Object[]{mark.getMarkId(), id2, engineNode});
                return new Tuple2((Object)engineNode, (Object)BoxesRunTime.boxToBoolean((boolean)reuse));
            }
            if (engineAsyncResponse instanceof EngineCreateError) {
                EngineCreateError engineCreateError = (EngineCreateError)engineAsyncResponse;
                String id3 = engineCreateError.id();
                String exception = engineCreateError.exception();
                boolean retry = engineCreateError.retry();
                this.logger().debug("{} async id: {} Failed  to async get EngineNode, {}", (Object[])new String[]{mark.getMarkId(), id3, exception});
                if (retry) {
                    throw new LinkisRetryException(ECMPluginConf$.MODULE$.ECM_ENGNE_CREATION_ERROR_CODE(), new StringBuilder(33).append(id3).append(" Failed  to async get EngineNode ").append(exception).toString());
                }
                throw new ECMPluginErrorException(ECMPluginConf$.MODULE$.ECM_ENGNE_CREATION_ERROR_CODE(), new StringBuilder(33).append(id3).append(" Failed  to async get EngineNode ").append(exception).toString());
            }
            throw new MatchError((Object)engineAsyncResponse);
        }
        this.logger().info("{} Failed to ask engineAskRequest {}, response is not engineNode", (Object)mark.getMarkId(), (Object)engineAskRequest);
        return new Tuple2(null, (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    private Sender getManagerSender() {
        return Sender$.MODULE$.getSender((String)GovernanceCommonConf$.MODULE$.MANAGER_SERVICE_NAME().getValue());
    }
}

