/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.udf.api;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.Consts;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.apache.linkis.udf.entity.PythonModuleInfo;
import org.apache.linkis.udf.entity.UDFInfo;
import org.apache.linkis.udf.entity.UDFTree;
import org.apache.linkis.udf.excepiton.UDFException;
import org.apache.linkis.udf.service.PythonModuleInfoService;
import org.apache.linkis.udf.service.UDFService;
import org.apache.linkis.udf.service.UDFTreeService;
import org.apache.linkis.udf.utils.ConstantVar;
import org.apache.linkis.udf.utils.UdfConfiguration;
import org.apache.linkis.udf.vo.DownloadVo;
import org.apache.linkis.udf.vo.UDFAddVo;
import org.apache.linkis.udf.vo.UDFInfoVo;
import org.apache.linkis.udf.vo.UDFUpdateVo;
import org.apache.linkis.udf.vo.UDFVersionVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"UDF management"})
@RestController
@RequestMapping(path={"udf"})
public class UDFRestfulApi {
    private static final Logger logger = LoggerFactory.getLogger(UDFRestfulApi.class);
    private static final Set<String> specialTypes = Sets.newHashSet((Object[])ConstantVar.specialTypes);
    @Autowired
    private UDFService udfService;
    @Autowired
    private UDFTreeService udfTreeService;
    @Autowired
    private PythonModuleInfoService pythonModuleInfoService;
    ObjectMapper mapper = new ObjectMapper();

    @ApiOperation(value="allUDF", notes="all UDF", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="jsonString", required=true, dataType="String", value="json string")})
    @RequestMapping(path={"all"}, method={RequestMethod.POST})
    public Message allUDF(HttpServletRequest req, String jsonString) {
        Message message = null;
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"get all udfs ");
            if (!StringUtils.isEmpty((Object)jsonString)) {
                Map json = (Map)this.mapper.reader(Map.class).readValue(jsonString);
                String type = json.getOrDefault("type", "self");
                Long treeId = json.getOrDefault("treeId", -1).longValue();
                String category = json.getOrDefault("category", "all");
                ArrayList allInfo = Lists.newArrayList();
                UDFTree udfTree = this.udfTreeService.getTreeById(treeId, userName, type, category);
                this.fetchUdfInfoRecursively(allInfo, udfTree, userName);
                udfTree.setUdfInfos((List)allInfo);
                udfTree.setChildrens((List)Lists.newArrayList());
                message = Message.ok();
                message.data("udfTree", (Object)udfTree);
            } else {
                List<UDFInfoVo> allInfo = this.udfService.getAllUDFSByUserName(userName);
                UDFTree udfTree = new UDFTree();
                udfTree.setUdfInfos(allInfo);
                udfTree.setChildrens((List)Lists.newArrayList());
                message = Message.ok();
                message.data("udfTree", (Object)udfTree);
            }
        }
        catch (Throwable e) {
            logger.error("Failed to list Tree: ", e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    private void fetchUdfInfoRecursively(List<UDFInfoVo> allInfo, UDFTree udfTree, String realUser) throws Throwable {
        if (CollectionUtils.isNotEmpty((Collection)udfTree.getUdfInfos())) {
            for (UDFInfoVo udfInfo : udfTree.getUdfInfos()) {
                if (!udfInfo.getLoad().booleanValue()) continue;
                allInfo.add(udfInfo);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)udfTree.getChildrens())) {
            for (UDFTree childTree : udfTree.getChildrens()) {
                UDFTree childTreeDetail = null;
                childTreeDetail = specialTypes.contains(childTree.getUserName()) ? this.udfTreeService.getTreeById(childTree.getId(), realUser, childTree.getUserName(), childTree.getCategory()) : this.udfTreeService.getTreeById(childTree.getId(), realUser, "self", childTree.getCategory());
                this.fetchUdfInfoRecursively(allInfo, childTreeDetail, realUser);
            }
        }
    }

    @ApiOperation(value="listUDF", notes="list UDF", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="category", required=true, dataType="String", value="category"), @ApiImplicitParam(name="treeId", required=true, dataType="String", value="tree id"), @ApiImplicitParam(name="type", dataType="String", value="Type", required=true, example="expire, self, share")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"list"}, method={RequestMethod.POST})
    public Message listUDF(HttpServletRequest req, @RequestBody Map<String, Object> json) {
        Message message = null;
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"list udfs ");
            String type = (String)json.getOrDefault("type", "self");
            Long treeId = ((Integer)json.getOrDefault("treeId", -1)).longValue();
            String category = (String)json.getOrDefault("category", "all");
            UDFTree udfTree = this.udfTreeService.getTreeById(treeId, userName, type, category);
            message = Message.ok();
            message.data("udfTree", (Object)udfTree);
        }
        catch (Exception e) {
            logger.error("Failed to list Tree: ", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    @ApiOperation(value="addUDF", notes="add UDF", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="createUser", dataType="String", value="create user", example="all"), @ApiImplicitParam(name="udfName", dataType="String", value="udf name"), @ApiImplicitParam(name="udfType", dataType="Integer", value="udf type"), @ApiImplicitParam(name="isExpire", dataType="Boolean", value="is expire"), @ApiImplicitParam(name="isShared", dataType="Boolean", value="is shared"), @ApiImplicitParam(name="treeId", dataType="Long", value="tree id"), @ApiImplicitParam(name="sys", dataType="String", value="sys"), @ApiImplicitParam(name="clusterName", dataType="String", value="cluster name"), @ApiImplicitParam(name="createTime", dataType="Date", value="create time"), @ApiImplicitParam(name="updateTime", dataType="Date", value="update time"), @ApiImplicitParam(name="path", dataType="String", value="path", example="file:///mnt/bdap/hadoop/test1012_01.jar"), @ApiImplicitParam(name="registerFormat", dataType="String", value="register format", example="create temporary function binbin as \\\"binbin\\\""), @ApiImplicitParam(name="useFormat", dataType="String", value="use format"), @ApiImplicitParam(name="description", dataType="String", value="description"), @ApiImplicitParam(name="directory", dataType="String", value="directory"), @ApiImplicitParam(name="isLoad", dataType="Boolean", value="is load")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"add"}, method={RequestMethod.POST})
    public Message addUDF(HttpServletRequest req, @RequestBody JsonNode json) {
        Message message = null;
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"add udf ");
            UDFAddVo udfvo = (UDFAddVo)this.mapper.treeToValue((TreeNode)json.get("udfAddVo"), UDFAddVo.class);
            udfvo.setCreateUser(userName);
            udfvo.setCreateTime(new Date());
            udfvo.setUpdateTime(new Date());
            message = Message.ok().data("udfId", (Object)this.udfService.addUDF(udfvo, userName));
        }
        catch (Exception e) {
            logger.error("Failed to add UDF: ", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    @ApiOperation(value="updateUDF", notes="update UDF", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", example="51", required=true, dataType="Long", value="id"), @ApiImplicitParam(name="udfName", required=true, dataType="String", value="udf name", example="test2022_2"), @ApiImplicitParam(name="udfType", required=true, dataType="Integer", value="udf type"), @ApiImplicitParam(name="path", required=true, dataType="String", value="path", example="file:///mnt/bdap/hadoop/test.py"), @ApiImplicitParam(name="registerFormat", required=true, dataType="String", value="register format", example="udf.register(\\\"test2022_2\\\",udf22)"), @ApiImplicitParam(name="useFormat", required=true, dataType="String", value="use format", example="int test2022_2(int)"), @ApiImplicitParam(name="directory", required=true, dataType="String", value="directory"), @ApiImplicitParam(name="isLoad", dataType="Boolean", value="is load")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"update"}, method={RequestMethod.POST})
    public Message updateUDF(HttpServletRequest req, @RequestBody JsonNode json) {
        Message message = null;
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"update udf ");
            UDFUpdateVo udfUpdateVo = (UDFUpdateVo)this.mapper.treeToValue((TreeNode)json.get("udfUpdateVo"), UDFUpdateVo.class);
            this.udfService.updateUDF(udfUpdateVo, userName);
            message = Message.ok();
        }
        catch (Exception e) {
            logger.error("Failed to update UDF: ", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    @ApiOperation(value="deleteUDF", notes="delete UDF", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", required=true, dataType="Long", value="id", example="8")})
    @RequestMapping(path={"delete/{id}"}, method={RequestMethod.POST})
    public Message deleteUDF(HttpServletRequest req, @PathVariable(value="id") Long id) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("delete udf " + id));
        Message message = null;
        try {
            this.verifyOperationUser(userName, id);
            this.udfService.deleteUDF(id, userName);
            message = Message.ok();
        }
        catch (Exception e) {
            logger.error("Failed to delete UDF: ", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    @ApiOperation(value="isLoad", notes="is load", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="udfId", required=true, dataType="Long", value="udf id"), @ApiImplicitParam(name="isLoad", required=true, dataType="Boolean", value="is load")})
    @RequestMapping(path={"isload"}, method={RequestMethod.GET})
    public Message isLoad(HttpServletRequest req, @RequestParam(value="udfId") Long udfId, @RequestParam(value="isLoad") Boolean isLoad) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"isload ");
        Message message = null;
        try {
            if (isLoad.booleanValue()) {
                this.udfService.addLoadInfo(udfId, userName);
            } else {
                this.udfService.deleteLoadInfo(udfId, userName);
            }
            message = Message.ok();
        }
        catch (Exception e) {
            logger.error("Failed to isLoad UDF: ", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    @ApiOperation(value="AddTree", notes="Add_Tree", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", dataType="Long", value="id"), @ApiImplicitParam(name="parent", dataType="Long", value="parent"), @ApiImplicitParam(name="name", dataType="String", value="name"), @ApiImplicitParam(name="userName", dataType="String", value="user name"), @ApiImplicitParam(name="description", dataType="String", value="description"), @ApiImplicitParam(name="createTime", dataType="String", value="create time"), @ApiImplicitParam(name="updateTime", dataType="String", value="update time"), @ApiImplicitParam(name="clusterName", dataType="String", value="cluster name"), @ApiImplicitParam(name="category", dataType="String", value="category"), @ApiImplicitParam(name="udfInfos", dataType="List<UDFInfoVo>", value="udf infos"), @ApiImplicitParam(name="childrens", dataType="List<UDFTree>", value="childrens")})
    @ApiOperationSupport(ignoreParameters={"udfTree"})
    @RequestMapping(path={"/tree/add"}, method={RequestMethod.POST})
    public Message addTree(HttpServletRequest req, @RequestBody UDFTree udfTree) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("add udf tree " + udfTree.getName()));
        Message message = null;
        try {
            udfTree.setCreateTime(new Date());
            udfTree.setUpdateTime(new Date());
            udfTree.setUserName(userName);
            udfTree = this.udfTreeService.addTree(udfTree, userName);
            message = Message.ok();
            message.data("udfTree", (Object)udfTree);
        }
        catch (Exception e) {
            logger.error("Failed to add Tree: ", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    @ApiOperation(value="updateTree", notes="update tree", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", dataType="Long", value="id"), @ApiImplicitParam(name="parent", dataType="Long", value="parent"), @ApiImplicitParam(name="name", dataType="String", value="name"), @ApiImplicitParam(name="userName", dataType="String", value="user name"), @ApiImplicitParam(name="description", dataType="String", value="description"), @ApiImplicitParam(name="createTime", dataType="String", value="create time"), @ApiImplicitParam(name="updateTime", dataType="String", value="update time"), @ApiImplicitParam(name="clusterName", dataType="String", value="cluster name"), @ApiImplicitParam(name="category", dataType="String", value="category"), @ApiImplicitParam(name="udfInfos", dataType="List<UDFInfoVo>", value="udf infos"), @ApiImplicitParam(name="childrens", dataType="List<UDFTree>", value="childrens")})
    @ApiOperationSupport(ignoreParameters={"udfTree"})
    @RequestMapping(path={"/tree/update"}, method={RequestMethod.POST})
    public Message updateTree(HttpServletRequest req, @RequestBody UDFTree udfTree) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("update udf tree " + udfTree.getName()));
        Message message = null;
        try {
            udfTree.setUpdateTime(new Date());
            udfTree.setUserName(userName);
            udfTree = this.udfTreeService.updateTree(udfTree, userName);
            message = Message.ok();
            message.data("udfTree", (Object)udfTree);
        }
        catch (Exception e) {
            logger.error("Failed to update Tree: ", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    @ApiOperation(value="deleteTree", notes="delete tree", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", required=true, dataType="Long", value="id")})
    @RequestMapping(path={"/tree/delete/{id}"}, method={RequestMethod.GET})
    public Message deleteTree(HttpServletRequest req, @PathVariable(value="id") Long id) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("delete udf tree " + id));
        Message message = null;
        try {
            this.udfTreeService.deleteTree(id, userName);
            message = Message.ok();
        }
        catch (Exception e) {
            logger.error("Failed to delete Tree: ", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    @ApiOperation(value="authenticate", notes="authenticate", response=Message.class)
    @RequestMapping(path={"/authenticate"}, method={RequestMethod.POST})
    public Message Authenticate(HttpServletRequest req) {
        Message message = null;
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"Authenticate");
            if (StringUtils.isEmpty((Object)userName)) {
                throw new UDFException("UserName is Empty!");
            }
            Boolean boo = this.udfService.isUDFManager(userName);
            message = Message.ok();
            message.data("isUDFManager", (Object)boo);
        }
        catch (Exception e) {
            logger.error("Failed to authenticate identification: ", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    @ApiOperation(value="setExpire", notes="set expire", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="udfId", dataType="Long", value="udf id")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/setExpire"}, method={RequestMethod.POST})
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.DEFAULT, rollbackFor={Throwable.class})
    public Message setExpire(HttpServletRequest req, @RequestBody JsonNode json) {
        Message message = null;
        try {
            Long udfId = json.get("udfId").longValue();
            if (StringUtils.isEmpty((Object)udfId)) {
                throw new UDFException("udfId is Empty!");
            }
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("set expire udf " + udfId));
            if (StringUtils.isEmpty((Object)userName)) {
                throw new UDFException("UserName is Empty!");
            }
            this.verifyOperationUser(userName, udfId);
            this.udfService.setUdfExpire(udfId, userName);
            message = Message.ok();
        }
        catch (Exception e) {
            logger.error("Failed to setExpire: ", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    @ApiOperation(value="shareUDF", notes="share uDF", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="udfInfo", required=true, dataType="UDFInfo", value="udf info"), @ApiImplicitParam(name="id", required=true, dataType="Long", value="id", example="51"), @ApiImplicitParam(name="sharedUsers", required=true, dataType="List", value="shared users")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/shareUDF"}, method={RequestMethod.POST})
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.DEFAULT, rollbackFor={Throwable.class})
    public Message shareUDF(HttpServletRequest req, @RequestBody JsonNode json) throws Throwable {
        Message message = null;
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"shareUDF");
            if (StringUtils.isEmpty((Object)userName)) {
                throw new UDFException("UserName is Empty!");
            }
            if (!this.udfService.isUDFManager(userName).booleanValue()) {
                throw new UDFException("Only manager can share udf!");
            }
            List userList = (List)this.mapper.treeToValue((TreeNode)json.get("sharedUsers"), List.class);
            if (userList == null) {
                throw new UDFException("userList cat not be null!");
            }
            HashSet<String> sharedUserSet = new HashSet<String>(userList);
            UDFInfo udfInfo = (UDFInfo)this.mapper.treeToValue((TreeNode)json.get("udfInfo"), UDFInfo.class);
            udfInfo = this.verifyOperationUser(userName, udfInfo.getId());
            this.udfService.checkSharedUsers(sharedUserSet, userName, udfInfo.getUdfName());
            HashSet<String> oldsharedUsers = new HashSet<String>(this.udfService.getAllSharedUsersByUdfId(userName, udfInfo.getId()));
            HashSet<String> temp = new HashSet<String>(sharedUserSet);
            temp.retainAll(oldsharedUsers);
            sharedUserSet.removeAll(temp);
            oldsharedUsers.removeAll(temp);
            this.udfService.removeSharedUser(oldsharedUsers, udfInfo.getId());
            this.udfService.addSharedUser(sharedUserSet, udfInfo.getId());
            if (!Boolean.TRUE.equals(udfInfo.getShared())) {
                this.udfService.publishLatestUdf(udfInfo.getId());
            }
            this.udfService.setUDFSharedInfo(true, udfInfo.getId());
            message = Message.ok();
        }
        catch (Exception e) {
            logger.error("Failed to share: ", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    @ApiOperation(value="getSharedUsers", notes="get shared users", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="udfId", example="51", dataType="long", value="udf id")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/getSharedUsers"}, method={RequestMethod.POST})
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.DEFAULT, rollbackFor={Throwable.class})
    public Message getSharedUsers(HttpServletRequest req, @RequestBody JsonNode json) {
        Message message = null;
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"getSharedUsers");
            if (StringUtils.isEmpty((Object)userName)) {
                throw new UDFException("UserName is Empty!");
            }
            long udfId = json.get("udfId").longValue();
            List<String> shareUsers = this.udfService.getAllSharedUsersByUdfId(userName, udfId);
            message = Message.ok();
            message.data("sharedUsers", shareUsers);
        }
        catch (Exception e) {
            logger.error("Failed to setExpire: ", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    @ApiOperation(value="handoverUDF", notes="handover UDF", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="udfId", required=true, dataType="long", value="udf id", example="48"), @ApiImplicitParam(name="handoverUser", required=true, dataType="String", value="handover user", example="w_jg02")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/handover"}, method={RequestMethod.POST})
    public Message handoverUDF(HttpServletRequest req, @RequestBody JsonNode json) {
        Message message = null;
        try {
            long udfId = json.get("udfId").longValue();
            String handoverUser = json.get("handoverUser").textValue();
            if (StringUtils.isEmpty((Object)handoverUser)) {
                throw new UDFException("The handover user can't be null!");
            }
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)String.join((CharSequence)",", "hand over udf", "" + udfId, handoverUser));
            if (StringUtils.isEmpty((Object)userName)) {
                throw new UDFException("username is empty!");
            }
            UDFInfo udfInfo = this.verifyOperationUser(userName, udfId);
            if (this.udfService.isUDFManager(udfInfo.getCreateUser()).booleanValue() && !this.udfService.isUDFManager(handoverUser).booleanValue()) {
                throw new UDFException("Admin users cannot hand over UDFs to regular users.(\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u80fd\u79fb\u4ea4UDF\u7ed9\u666e\u901a\u7528\u6237\uff01)");
            }
            this.udfService.handoverUdf(udfId, handoverUser);
            message = Message.ok();
        }
        catch (Exception e) {
            logger.error("Failed to handover udf: ", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    private UDFInfo verifyOperationUser(String userName, long udfId) throws UDFException {
        UDFInfo udfInfo = this.udfService.getUDFById(udfId, userName);
        if (udfInfo == null) {
            throw new UDFException("can't find udf by this id!");
        }
        if (!udfInfo.getCreateUser().equals(userName)) {
            throw new UDFException("createUser must be consistent with the operation user(\u521b\u5efa\u7528\u6237\u5fc5\u987b\u548c\u64cd\u4f5c\u7528\u6237\u4e00\u81f4)");
        }
        return udfInfo;
    }

    @ApiOperation(value="publishUDF", notes="publish UDF", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="udfId", required=true, dataType="long", value="udf id"), @ApiImplicitParam(name="version", required=true, dataType="String", value="version")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/publish"}, method={RequestMethod.POST})
    public Message publishUDF(HttpServletRequest req, @RequestBody JsonNode json) {
        Message message = null;
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"publishUDF");
            if (StringUtils.isEmpty((Object)userName)) {
                throw new UDFException("username is empty!");
            }
            if (!this.udfService.isUDFManager(userName).booleanValue()) {
                throw new UDFException("only manager can publish udf!");
            }
            long udfId = json.get("udfId").longValue();
            String version = json.get("version").textValue();
            this.verifyOperationUser(userName, udfId);
            this.udfService.publishUdf(udfId, version);
            message = Message.ok();
        }
        catch (Exception e) {
            logger.error("Failed to publish udf: ", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    @ApiOperation(value="rollbackUDF", notes="rollback UDF", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="udfId", required=true, dataType="long", value="udf id", example="51"), @ApiImplicitParam(name="version", required=true, dataType="String", value="version", example="v000002")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/rollback"}, method={RequestMethod.POST})
    public Message rollbackUDF(HttpServletRequest req, @RequestBody JsonNode json) {
        Message message = null;
        try {
            long udfId = json.get("udfId").longValue();
            String version = json.get("version").textValue();
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)MessageFormat.format("rollbackUDF,udfId:{0},version:{1}", udfId, version));
            if (StringUtils.isEmpty((Object)userName)) {
                throw new UDFException("username is empty!");
            }
            this.verifyOperationUser(userName, udfId);
            this.udfService.rollbackUDF(udfId, version, userName);
            message = Message.ok();
        }
        catch (Exception e) {
            logger.error("Failed to rollback udf: ", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    @ApiOperation(value="versionList", notes="version list", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="udfId", required=true, dataType="long", value="udf id")})
    @RequestMapping(path={"/versionList"}, method={RequestMethod.GET})
    public Message versionList(HttpServletRequest req, @RequestParam(value="udfId") long udfId) {
        Message message = null;
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("versionList,udfId:" + udfId));
            if (StringUtils.isEmpty((Object)userName)) {
                throw new UDFException("username is empty!");
            }
            List<UDFVersionVo> versionList = this.udfService.getUdfVersionList(udfId);
            message = Message.ok();
            message.data("versionList", versionList);
        }
        catch (Exception e) {
            logger.error("Failed to get udf versionList: ", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    @ApiOperation(value="managerPages", notes="manager pages", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="udfName", required=false, dataType="String", defaultValue="", value="udf name", example="udfName"), @ApiImplicitParam, @ApiImplicitParam(name="pageSize", required=false, dataType="Integer", value="page size"), @ApiImplicitParam(name="udfType", required=false, dataType="String", value="udf type", defaultValue="0,1,2", example="0,1,2")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"/managerPages"}, method={RequestMethod.POST})
    public Message managerPages(HttpServletRequest req, @RequestBody JsonNode jsonNode) {
        Message message = null;
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"managerPages");
            if (StringUtils.isEmpty((Object)userName)) {
                throw new UDFException("username is empty!");
            }
            String udfName = jsonNode.get("udfName") == null ? null : jsonNode.get("udfName").textValue();
            String udfType = jsonNode.get("udfType").textValue();
            int curPage = jsonNode.get("curPage").intValue();
            int pageSize = jsonNode.get("pageSize").intValue();
            Collection udfTypes = null;
            if (!StringUtils.isEmpty((Object)udfType)) {
                udfTypes = Arrays.stream(udfType.split(",")).map(Integer::parseInt).collect(Collectors.toList());
            }
            PageInfo<UDFAddVo> pageInfo = this.udfService.getManagerPages(udfName, udfTypes, userName, curPage, pageSize);
            message = Message.ok();
            message.data("infoList", (Object)pageInfo.getList());
            message.data("totalPage", (Object)pageInfo.getPages());
            message.data("total", (Object)pageInfo.getTotal());
        }
        catch (Exception e) {
            logger.error("Failed to get udf infoList: ", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    @ApiOperation(value="downloadUdf", notes="download Udf", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="udfId", required=true, dataType="long", value="udf id", example="51"), @ApiImplicitParam(name="version", required=true, dataType="String", value="version", example="v000003")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/downloadUdf"}, method={RequestMethod.POST})
    public Message downloadUdf(HttpServletRequest req, @RequestBody JsonNode json) {
        Message message = null;
        try {
            long udfId = json.get("udfId").longValue();
            String version = json.get("version").textValue();
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)MessageFormat.format("downloadUdf,udfId:{0},version:{1}", udfId, version));
            if (StringUtils.isEmpty((Object)userName)) {
                throw new UDFException("username is empty!");
            }
            String content = this.udfService.downLoadUDF(udfId, version, userName);
            message = Message.ok();
            message.data("content", (Object)content);
        }
        catch (Exception e) {
            logger.error("Failed to download udf: ", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="DownloadToLocal", notes="Download_To_Local", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="udfId", required=true, dataType="long", value="udf id", example="51"), @ApiImplicitParam(name="version", required=true, dataType="String", value="version", example="v000003")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/downloadToLocal"}, method={RequestMethod.POST})
    public void downloadToLocal(HttpServletRequest req, HttpServletResponse response, @RequestBody JsonNode json) throws IOException {
        BufferedOutputStream outputStream;
        BufferedInputStream fis;
        InputStream is;
        PrintWriter writer;
        block7: {
            writer = null;
            is = null;
            fis = null;
            outputStream = null;
            try {
                long udfId = json.get("udfId").longValue();
                String version = json.get("version").textValue();
                String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)MessageFormat.format("downloadUdf,udfId:{0},version:{1}", udfId, version));
                if (StringUtils.isEmpty((Object)userName)) {
                    throw new UDFException("username is empty!");
                }
                DownloadVo downloadVo = this.udfService.downloadToLocal(udfId, version, userName);
                is = downloadVo.getInputStream();
                fis = new BufferedInputStream(is);
                response.reset();
                response.setCharacterEncoding("UTF-8");
                response.addHeader("Content-Disposition", "attachment;filename=" + downloadVo.getFileName());
                outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
                response.setContentType("application/octet-stream");
                byte[] buffer = new byte[1024];
                int hasRead = 0;
                while ((hasRead = fis.read(buffer, 0, 1024)) != -1) {
                    outputStream.write(buffer, 0, hasRead);
                }
                if (outputStream == null) break block7;
            }
            catch (Exception e) {
                block8: {
                    try {
                        logger.error("download failed", (Throwable)e);
                        response.reset();
                        response.setCharacterEncoding(Consts.UTF_8.toString());
                        response.setContentType("text/plain; charset=utf-8");
                        writer = response.getWriter();
                        writer.append("error(\u9519\u8bef):" + e.getMessage());
                        writer.flush();
                        if (outputStream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        if (outputStream != null) {
                            outputStream.flush();
                        }
                        IOUtils.closeQuietly((OutputStream)outputStream);
                        IOUtils.closeQuietly(fis);
                        IOUtils.closeQuietly(is);
                        IOUtils.closeQuietly(writer);
                        throw throwable;
                    }
                    outputStream.flush();
                }
                IOUtils.closeQuietly((OutputStream)outputStream);
                IOUtils.closeQuietly(fis);
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((Writer)writer);
            }
            outputStream.flush();
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        IOUtils.closeQuietly((InputStream)fis);
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((Writer)writer);
    }

    @ApiOperation(value="allUdfUsers", notes="all Udf users", response=Message.class)
    @RequestMapping(path={"/allUdfUsers"}, method={RequestMethod.GET})
    public Message allUdfUsers(HttpServletRequest req, @RequestBody JsonNode json) {
        Message message = null;
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"allUdfUsers ");
            if (StringUtils.isEmpty((Object)userName)) {
                throw new UDFException("username is empty!");
            }
            List<String> udfUsers = this.udfService.allUdfUsers();
            message = Message.ok();
            message.data("udfUsers", udfUsers);
        }
        catch (Exception e) {
            logger.error("Failed to get udf users: ", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    @ApiOperation(value="getUserDirectory", notes="get user directory", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="category", required=true, dataType="String", value="category")})
    @Deprecated
    @RequestMapping(path={"/userDirectory"}, method={RequestMethod.GET})
    public Message getUserDirectory(HttpServletRequest req, @RequestParam(value="category") String category) {
        Message message = null;
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"userDirectory ");
            if (StringUtils.isEmpty((Object)userName)) {
                throw new UDFException("username is empty!");
            }
            List<String> userDirectory = this.udfService.getUserDirectory(userName, category);
            message = Message.ok();
            message.data("userDirectory", userDirectory);
        }
        catch (Exception e) {
            logger.error("Failed to get user directory: ", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    @ApiOperation(value="getUdfList", notes="get user directory", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="nameList", required=true, dataType="String", value="category"), @ApiImplicitParam(name="createUser", required=true, dataType="String", value="category")})
    @RequestMapping(path={"/getUdfByNameList"}, method={RequestMethod.GET})
    public Message getUdfList(HttpServletRequest req, @RequestParam(value="nameList") String nameList, @RequestParam(value="createUser") String createUser) {
        Message message = null;
        try {
            String userName = "hadoop";
            if (StringUtils.isEmpty((Object)userName)) {
                throw new UDFException("username is empty!");
            }
            if (StringUtils.isEmpty((Object)nameList)) {
                throw new UDFException("nameList is empty!");
            }
            if (!UdfConfiguration.nameRegexPattern().matcher(nameList).matches()) {
                throw new UDFException("nameList is invalid!");
            }
            if (StringUtils.isEmpty((Object)createUser)) {
                throw new UDFException("creator is empty!");
            }
            List<String> collect = Arrays.stream(nameList.split(",")).collect(Collectors.toList());
            List<UDFAddVo> udfInfoList = this.udfService.getUdfByNameList(collect, createUser);
            message = Message.ok().data("infoList", udfInfoList);
        }
        catch (Throwable e) {
            logger.error("Failed to get user udfinfo : ", e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    @ApiOperation(value="versionInfo", notes="version list", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="udfName", required=true, dataType="String", value="udf name"), @ApiImplicitParam(name="createUser", required=true, dataType="String", value="create user")})
    @RequestMapping(path={"/versionInfo"}, method={RequestMethod.GET})
    public Message versionInfo(HttpServletRequest req, @RequestParam(value="udfName") String udfName, @RequestParam(value="createUser") String createUser) {
        Message message = null;
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"versionInfo ");
            if (StringUtils.isEmpty((Object)userName)) {
                throw new UDFException("userName is empty!");
            }
            if (StringUtils.isEmpty((Object)udfName)) {
                throw new UDFException("udfName is empty!");
            }
            if (StringUtils.isEmpty((Object)createUser)) {
                throw new UDFException("createUser is empty!");
            }
            if (!UdfConfiguration.nameRegexPattern().matcher(udfName).matches()) {
                throw new UDFException("udfName is invalid!");
            }
            if (!UdfConfiguration.nameRegexPattern().matcher(createUser).matches()) {
                throw new UDFException("createUser is invalid!");
            }
            UDFVersionVo versionList = this.udfService.getUdfVersionInfo(udfName, createUser);
            message = Message.ok().data("versionInfo", (Object)versionList);
        }
        catch (Throwable e) {
            logger.error("Failed to get udf versionInfo: ", e);
            message = Message.error((String)e.getMessage());
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(path={"/python-list"}, method={RequestMethod.GET})
    @ApiOperation(value="\u67e5\u8be2Python\u6a21\u5757\u5217\u8868", notes="\u6839\u636e\u6761\u4ef6\u67e5\u8be2Python\u6a21\u5757\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="Python\u6a21\u5757\u540d\u79f0", required=false, dataType="String"), @ApiImplicitParam(name="engineType", value="\u5f15\u64ce\u7c7b\u578b\uff08all, spark, python\uff09", required=false, dataType="String"), @ApiImplicitParam(name="username", value="\u7528\u6237\u540d", required=false, dataType="String"), @ApiImplicitParam(name="isLoad", value="\u662f\u5426\u52a0\u8f7d\uff080-\u672a\u52a0\u8f7d\uff0c1-\u5df2\u52a0\u8f7d\uff09", required=false, dataType="Integer"), @ApiImplicitParam(name="isExpire", value="\u662f\u5426\u8fc7\u671f\uff080-\u672a\u8fc7\u671f\uff0c1-\u5df2\u8fc7\u671f\uff09", required=false, dataType="Integer"), @ApiImplicitParam(name="pageNow", value="\u9875\u7801", required=false, dataType="Integer"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u5c55\u793a\u6570\u636e\u6761\u6570", required=false, dataType="Integer")})
    public Message pythonList(@RequestParam(value="name", required=false) String name, @RequestParam(value="engineType", required=false) String engineType, @RequestParam(value="username", required=false) String username, @RequestParam(value="isLoad", required=false) Integer isLoad, @RequestParam(value="isExpire", required=false) Integer isExpire, @RequestParam(value="pageNow", required=false) Integer pageNow, @RequestParam(value="pageSize", required=false) Integer pageSize, HttpServletRequest req) {
        String user = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"pythonList");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)name)) {
            name = null;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)engineType)) {
            engineType = null;
        }
        if (pageNow == null) {
            pageNow = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        if (Configuration.isAdmin((String)user)) {
            if (username == null) {
                username = null;
            }
        } else {
            username = user;
        }
        PageHelper.startPage((int)pageNow, (int)pageSize);
        try {
            PythonModuleInfo pythonModuleInfo = new PythonModuleInfo();
            pythonModuleInfo.setName(name);
            pythonModuleInfo.setEngineType(engineType);
            pythonModuleInfo.setCreateUser(username);
            pythonModuleInfo.setIsLoad(isLoad);
            pythonModuleInfo.setIsExpire(isExpire);
            List<PythonModuleInfo> pythonList = this.pythonModuleInfoService.getByConditions(pythonModuleInfo);
            PageInfo pageInfo = new PageInfo(pythonList);
            Message message = Message.ok().data("pythonList", pythonList).data("totalPage", (Object)pageInfo.getTotal());
            return message;
        }
        finally {
            PageHelper.clearPage();
        }
    }

    @RequestMapping(path={"/python-delete"}, method={RequestMethod.GET})
    @ApiOperation(value="\u5220\u9664Python\u6a21\u5757", notes="\u6839\u636e\u6a21\u5757ID\u5220\u9664Python\u6a21\u5757,\u7ba1\u7406\u5458\u53ef\u4ee5\u5220\u9664\u4efb\u4f55\u6a21\u5757\uff0c\u666e\u901a\u7528\u6237\u53ea\u80fd\u5220\u9664\u81ea\u5df1\u521b\u5efa\u7684\u6a21\u5757")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6a21\u5757ID", required=true, dataType="Long"), @ApiImplicitParam(name="isExpire", value="\u6a21\u5757\u662f\u5426\u8fc7\u671f\uff080\uff1a\u672a\u8fc7\u671f\uff0c1\uff1a\u5df2\u8fc7\u671f\uff09", required=true, dataType="int")})
    public Message pythonDelete(@RequestParam(value="id", required=false) Long id, @RequestParam(value="isExpire", required=false) int isExpire, HttpServletRequest req, HttpServletResponse resp) {
        String user = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"pythonDelete");
        if (id == null) {
            return Message.error((String)"Invalid parameters: id is null");
        }
        if (isExpire != 0 && isExpire != 1) {
            return Message.error((String)"Invalid parameters: isExpire must be 0 or 1");
        }
        PythonModuleInfo pythonModuleInfo = new PythonModuleInfo();
        pythonModuleInfo.setId(id);
        PythonModuleInfo moduleInfo = this.pythonModuleInfoService.getByUserAndNameAndId(pythonModuleInfo);
        if (moduleInfo == null) {
            return Message.ok();
        }
        if (!Configuration.isAdmin((String)user) && !moduleInfo.getCreateUser().equals(user)) {
            return Message.error((String)"\u65e0\u6743\u5220\u9664\u4ed6\u4ebaPython\u6a21\u5757");
        }
        moduleInfo.setIsExpire(1);
        moduleInfo.setUpdateUser(user);
        moduleInfo.setUpdateTime(new Date());
        String newName = moduleInfo.getName() + "_" + System.currentTimeMillis();
        String newPath = moduleInfo.getPath() + "_" + System.currentTimeMillis();
        moduleInfo.setPath(newPath);
        moduleInfo.setName(newName);
        this.pythonModuleInfoService.updatePythonModuleInfo(moduleInfo);
        return Message.ok();
    }

    @ApiOperation(value="Python\u7269\u6599\u65b0\u589e/\u66f4\u65b0", notes="\u6839\u636e\u4f20\u5165\u7684Python\u7269\u6599\u4fe1\u606f\u65b0\u589e\u6216\u66f4\u65b0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Python\u7269\u6599\u65b0\u589e/\u66f4\u65b0Request", value="Python\u7269\u6599\u65b0\u589e/\u66f4\u65b0\u8bf7\u6c42\u4f53", required=false, dataType="PythonModuleInfo")})
    @RequestMapping(value={"/python-save"}, method={RequestMethod.POST})
    public Message request(@Nullable @RequestBody PythonModuleInfo pythonModuleInfo, HttpServletRequest httpReq, HttpServletResponse httpResp) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)httpReq, (String)"pythonSave");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)pythonModuleInfo.getName())) {
            return Message.error((String)"\u6a21\u5757\u540d\u79f0\uff1a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)pythonModuleInfo.getPath())) {
            return Message.error((String)"\u6a21\u5757\u7269\u6599\uff1a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)pythonModuleInfo.getEngineType())) {
            return Message.error((String)"\u5f15\u64ce\u7c7b\u578b\uff1a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pythonModuleInfo.getIsLoad() == null) {
            return Message.error((String)"\u662f\u5426\u52a0\u8f7d\uff1a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pythonModuleInfo.getIsExpire() == null) {
            return Message.error((String)"\u662f\u5426\u8fc7\u671f\uff1a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String path = pythonModuleInfo.getPath();
        String fileName = path.substring(path.lastIndexOf("/") + 1, path.lastIndexOf("."));
        if (!pythonModuleInfo.getName().equals(fileName)) {
            return Message.error((String)"\u6a21\u5757\u540d\u79f0\u4e0e\u7269\u6599\u6587\u4ef6\u540d\u79f0\u5fc5\u987b\u4e00\u6837");
        }
        if (pythonModuleInfo.getId() == null) {
            Integer newExpire = pythonModuleInfo.getIsExpire();
            pythonModuleInfo.setCreateUser(userName);
            pythonModuleInfo.setIsExpire(0);
            PythonModuleInfo moduleInfo = this.pythonModuleInfoService.getByUserAndNameAndId(pythonModuleInfo);
            if (moduleInfo != null) {
                return Message.error((String)("\u6a21\u5757" + moduleInfo.getName() + "\u5df2\u5b58\u5728"));
            }
            pythonModuleInfo.setCreateTime(new Date());
            pythonModuleInfo.setUpdateTime(new Date());
            pythonModuleInfo.setIsExpire(newExpire);
            pythonModuleInfo.setUpdateUser(userName);
            this.pythonModuleInfoService.insertPythonModuleInfo(pythonModuleInfo);
            return Message.ok().data("id", (Object)pythonModuleInfo.getId());
        }
        PythonModuleInfo pythonModuleTmp = new PythonModuleInfo();
        pythonModuleTmp.setId(pythonModuleInfo.getId());
        PythonModuleInfo moduleInfo = this.pythonModuleInfoService.getByUserAndNameAndId(pythonModuleTmp);
        if (moduleInfo == null) {
            return Message.error((String)"\u672a\u627e\u5230\u8be5Python\u6a21\u5757");
        }
        if (!Configuration.isAdmin((String)userName) && !userName.equals(moduleInfo.getCreateUser())) {
            return Message.error((String)"\u65e0\u6743\u7f16\u8f91\u4ed6\u4ebaPython\u6a21\u5757");
        }
        if (moduleInfo.getIsExpire() != 0) {
            return Message.error((String)"\u5f53\u524d\u6a21\u5757\u5df2\u8fc7\u671f\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c");
        }
        if (pythonModuleInfo.getIsExpire() == 1) {
            String newName = moduleInfo.getName() + "_" + System.currentTimeMillis();
            String newPath = moduleInfo.getPath() + "_" + System.currentTimeMillis();
            pythonModuleInfo.setPath(newPath);
            pythonModuleInfo.setName(newName);
        }
        pythonModuleInfo.setUpdateUser(userName);
        pythonModuleInfo.setUpdateTime(new Date());
        this.pythonModuleInfoService.updatePythonModuleInfo(pythonModuleInfo);
        return Message.ok();
    }

    @RequestMapping(path={"/python-file-exist"}, method={RequestMethod.GET})
    @ApiOperation(value="\u67e5\u8be2Python\u6587\u4ef6\u662f\u5426\u5b58\u5728", notes="\u6839\u636e\u7528\u6237\u540d\u548c\u6587\u4ef6\u540d\u67e5\u8be2Python\u6a21\u5757\u4fe1\u606f\uff0c\u5982\u679c\u5b58\u5728\u5219\u8fd4\u56detrue\uff0c\u5426\u5219\u8fd4\u56defalse")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileName", value="Python\u6587\u4ef6\u540d", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header")})
    public Message pythonFileExist(@RequestParam(value="fileName", required=false) String fileName, HttpServletRequest req) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"pythonFileExist");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)fileName)) {
            return Message.error((String)"\u53c2\u6570fileName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String fileNameWithoutExtension = fileName.substring(0, fileName.lastIndexOf("."));
        if (!fileNameWithoutExtension.matches("^[a-zA-Z][a-zA-Z0-9_]{0,49}$")) {
            return Message.error((String)"\u53ea\u652f\u6301\u6570\u5b57\u5b57\u6bcd\u4e0b\u5212\u7ebf\uff0c\u4e14\u4ee5\u5b57\u6bcd\u5f00\u5934\uff0c\u957f\u5ea6\u6700\u592750");
        }
        PythonModuleInfo pythonModuleInfo = new PythonModuleInfo();
        pythonModuleInfo.setName(fileNameWithoutExtension);
        pythonModuleInfo.setCreateUser(userName);
        PythonModuleInfo moduleInfo = this.pythonModuleInfoService.getByUserAndNameAndId(pythonModuleInfo);
        if (moduleInfo == null) {
            return Message.ok().data("result", (Object)true);
        }
        return Message.error((String)("\u6a21\u5757" + fileName + "\u5df2\u5b58\u5728\uff0c\u5982\u9700\u91cd\u65b0\u4e0a\u4f20\u8bf7\u5148\u5220\u9664\u65e7\u7684\u6a21\u5757"));
    }
}

