/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.datacalc;

import java.io.Serializable;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.engineplugin.spark.datacalc.DataCalcExecution;
import org.apache.linkis.engineplugin.spark.datacalc.DataCalcTempData$;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcSink;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcSource;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcTransform;
import org.apache.linkis.engineplugin.spark.datacalc.exception.ConfigRuntimeException;
import org.apache.linkis.engineplugin.spark.datacalc.model.DataCalcArrayData;
import org.apache.linkis.engineplugin.spark.datacalc.model.DataCalcDataConfig;
import org.apache.linkis.engineplugin.spark.datacalc.model.DataCalcGroupData;
import org.apache.linkis.engineplugin.spark.datacalc.model.DataCalcPluginConfig;
import org.apache.linkis.engineplugin.spark.datacalc.model.ResultTableConfig;
import org.apache.linkis.engineplugin.spark.datacalc.model.SinkConfig;
import org.apache.linkis.engineplugin.spark.datacalc.model.SourceConfig;
import org.apache.linkis.engineplugin.spark.datacalc.model.TransformConfig;
import org.apache.linkis.engineplugin.spark.datacalc.util.PluginUtil;
import org.apache.linkis.engineplugin.spark.errorcode.SparkErrorCodeSummary;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;

public final class DataCalcExecution$ {
    public static DataCalcExecution$ MODULE$;
    private final Logger org$apache$linkis$engineplugin$spark$datacalc$DataCalcExecution$$log;

    static {
        new DataCalcExecution$();
    }

    public Logger org$apache$linkis$engineplugin$spark$datacalc$DataCalcExecution$$log() {
        return this.org$apache$linkis$engineplugin$spark$datacalc$DataCalcExecution$$log;
    }

    public <SR extends SourceConfig, TR extends TransformConfig, SK extends SinkConfig> Tuple3<DataCalcSource<SR>[], DataCalcTransform<TR>[], DataCalcSink<SK>[]> getPlugins(DataCalcGroupData mapleData) {
        DataCalcSource[] sources = (DataCalcSource[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapleData.getSources())).map((Function1 & Serializable & scala.Serializable)source -> PluginUtil.createSource(source.getName(), source.getConfig()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataCalcSource.class)));
        DataCalcTransform[] transformations = mapleData.getTransformations() == null ? (DataCalcTransform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(DataCalcTransform.class)) : (DataCalcTransform[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapleData.getTransformations())).map((Function1 & Serializable & scala.Serializable)sink -> PluginUtil.createTransform(sink.getName(), sink.getConfig()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataCalcTransform.class)));
        DataCalcSink[] sinks = (DataCalcSink[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapleData.getSinks())).map((Function1 & Serializable & scala.Serializable)sink -> PluginUtil.createSink(sink.getName(), sink.getConfig()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataCalcSink.class)));
        DataCalcExecution.CheckResult checkResult = new DataCalcExecution.CheckResult();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sources)).foreach((Function1 & Serializable & scala.Serializable)source -> {
            DataCalcExecution$.$anonfun$getPlugins$4(mapleData, checkResult, source);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])transformations)).foreach((Function1 & Serializable & scala.Serializable)transformation -> {
            DataCalcExecution$.$anonfun$getPlugins$5(mapleData, checkResult, transformation);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sinks)).foreach((Function1 & Serializable & scala.Serializable)sink -> {
            DataCalcExecution$.$anonfun$getPlugins$6(mapleData, checkResult, sink);
            return BoxedUnit.UNIT;
        });
        checkResult.check();
        return new Tuple3((Object)sources, (Object)transformations, (Object)sinks);
    }

    public <SR extends SourceConfig, TR extends TransformConfig, SK extends SinkConfig> void execute(SparkSession spark, DataCalcSource<SR>[] sources, DataCalcTransform<TR>[] transformations, DataCalcSink<SK>[] sinks) {
        if (sources != null && !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sources)).isEmpty()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sources)).foreach((Function1 & Serializable & scala.Serializable)source -> {
                DataCalcExecution$.MODULE$.sourceProcess(spark, source);
                return BoxedUnit.UNIT;
            });
        }
        if (transformations != null && !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])transformations)).isEmpty()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])transformations)).foreach((Function1 & Serializable & scala.Serializable)transformation -> {
                DataCalcExecution$.MODULE$.transformProcess(spark, transformation);
                return BoxedUnit.UNIT;
            });
        }
        if (sinks != null && !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sinks)).isEmpty()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sinks)).foreach((Function1 & Serializable & scala.Serializable)sink -> {
                DataCalcExecution$.MODULE$.sinkProcess(spark, sink);
                return BoxedUnit.UNIT;
            });
        }
        DataCalcTempData$.MODULE$.clean(spark.sqlContext());
    }

    public <SR extends SourceConfig, TR extends TransformConfig, SK extends SinkConfig, T> Object[] getPlugins(DataCalcArrayData mapleData) {
        DataCalcExecution.CheckResult checkResult = new DataCalcExecution.CheckResult();
        Object[] plugins = new Object[mapleData.getPlugins().length];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapleData.getPlugins())).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            DataCalcDataConfig config = mapleData.getPlugins()[i];
            String string = config.getType();
            if ("source".equals(string)) {
                DataCalcSource source = PluginUtil.createSource(config.getName(), config.getConfig());
                ((DataCalcPluginConfig)source.getConfig()).setVariables(mapleData.getVariables());
                checkResult.checkResultTable(source);
                plugins$1[i] = source;
                return;
            }
            if ("transformation".equals(string)) {
                DataCalcTransform transformation = PluginUtil.createTransform(config.getName(), config.getConfig());
                ((DataCalcPluginConfig)transformation.getConfig()).setVariables(mapleData.getVariables());
                checkResult.checkResultTable(transformation);
                plugins$1[i] = transformation;
                return;
            }
            if ("sink".equals(string)) {
                DataCalcSink sink = PluginUtil.createSink(config.getName(), config.getConfig());
                ((DataCalcPluginConfig)sink.getConfig()).setVariables(mapleData.getVariables());
                checkResult.checkPluginConfig(sink);
                plugins$1[i] = sink;
                return;
            }
            if (string != null) {
                String string2 = string;
                throw new ConfigRuntimeException(SparkErrorCodeSummary.DATA_CALC_CONFIG_TYPE_NOT_VALID.getErrorCode(), MessageFormat.format(SparkErrorCodeSummary.DATA_CALC_CONFIG_TYPE_NOT_VALID.getErrorDesc(), string2));
            }
            throw new MatchError((Object)string);
        });
        checkResult.check();
        return plugins;
    }

    public <SR extends SourceConfig, TR extends TransformConfig, SK extends SinkConfig, T> void execute(SparkSession spark, Object[] plugins) {
        if (plugins == null || Predef$.MODULE$.genericArrayOps((Object)plugins).isEmpty()) {
            return;
        }
        Predef$.MODULE$.genericArrayOps((Object)plugins).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DataCalcExecution$.$anonfun$execute$4(spark, x0$1);
            return BoxedUnit.UNIT;
        });
        DataCalcTempData$.MODULE$.clean(spark.sqlContext());
    }

    private <T extends SourceConfig> void sourceProcess(SparkSession spark, DataCalcSource<T> source) {
        source.prepare(spark);
        Dataset<Row> ds = source.getData(spark);
        this.tempSaveResultTable(ds, (ResultTableConfig)source.getConfig());
    }

    private <T extends TransformConfig> void transformProcess(SparkSession spark, DataCalcTransform<T> transform) {
        transform.prepare(spark);
        Dataset fromDs = StringUtils.isNotBlank((CharSequence)((TransformConfig)transform.getConfig()).getSourceTable()) ? spark.read().table(((TransformConfig)transform.getConfig()).getSourceTable()) : null;
        Dataset<Row> ds = transform.process(spark, fromDs);
        this.tempSaveResultTable(ds, (ResultTableConfig)transform.getConfig());
    }

    private <T extends SinkConfig> void sinkProcess(SparkSession spark, DataCalcSink<T> sink) {
        sink.prepare(spark);
        Dataset fromDs = StringUtils.isBlank((CharSequence)((SinkConfig)sink.getConfig()).getSourceQuery()) ? spark.read().table(((SinkConfig)sink.getConfig()).getSourceTable()) : spark.sql(((SinkConfig)sink.getConfig()).getSourceQuery());
        sink.output(spark, (Dataset<Row>)fromDs);
    }

    private void tempSaveResultTable(Dataset<Row> ds, ResultTableConfig resultTableConfig) {
        if (ds != null) {
            ds.createOrReplaceTempView(resultTableConfig.getResultTable());
            DataCalcTempData$.MODULE$.putResultTable(resultTableConfig.getResultTable());
            if (Predef$.MODULE$.Boolean2boolean(resultTableConfig.getPersist())) {
                ds.persist(StorageLevel$.MODULE$.fromString(resultTableConfig.getStorageLevel()));
                DataCalcTempData$.MODULE$.putPersistDataSet(ds);
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$getPlugins$4(DataCalcGroupData mapleData$1, DataCalcExecution.CheckResult checkResult$1, DataCalcSource source) {
        ((DataCalcPluginConfig)source.getConfig()).setVariables(mapleData$1.getVariables());
        checkResult$1.checkResultTable(source);
    }

    public static final /* synthetic */ void $anonfun$getPlugins$5(DataCalcGroupData mapleData$1, DataCalcExecution.CheckResult checkResult$1, DataCalcTransform transformation) {
        ((DataCalcPluginConfig)transformation.getConfig()).setVariables(mapleData$1.getVariables());
        checkResult$1.checkResultTable(transformation);
    }

    public static final /* synthetic */ void $anonfun$getPlugins$6(DataCalcGroupData mapleData$1, DataCalcExecution.CheckResult checkResult$1, DataCalcSink sink) {
        ((DataCalcPluginConfig)sink.getConfig()).setVariables(mapleData$1.getVariables());
        checkResult$1.checkPluginConfig(sink);
    }

    public static final /* synthetic */ void $anonfun$execute$4(SparkSession spark$2, Object x0$1) {
        Object object = x0$1;
        if (object instanceof DataCalcSource) {
            DataCalcSource dataCalcSource = (DataCalcSource)object;
            MODULE$.sourceProcess(spark$2, dataCalcSource);
            return;
        }
        if (object instanceof DataCalcTransform) {
            DataCalcTransform dataCalcTransform = (DataCalcTransform)object;
            MODULE$.transformProcess(spark$2, dataCalcTransform);
            return;
        }
        if (object instanceof DataCalcSink) {
            DataCalcSink dataCalcSink = (DataCalcSink)object;
            MODULE$.sinkProcess(spark$2, dataCalcSink);
            return;
        }
    }

    private DataCalcExecution$() {
        MODULE$ = this;
        this.org$apache$linkis$engineplugin$spark$datacalc$DataCalcExecution$$log = LoggerFactory.getLogger(this.getClass());
    }
}

