/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.comm.ResponseHandler;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.parser.ResponseParseException;
import com.aliyun.oss.common.utils.ExceptionFactory;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.internal.ResponseParsers;
import com.aliyun.oss.internal.model.OSSErrorResult;

public class OSSErrorResponseHandler
implements ResponseHandler {
    private static ResponseParsers.ErrorResponseParser errorResponseParser = new ResponseParsers.ErrorResponseParser();

    @Override
    public void handle(ResponseMessage response) throws OSSException, ClientException {
        if (response.isSuccessful()) {
            return;
        }
        String requestId = response.getRequestId();
        int statusCode = response.getStatusCode();
        if (response.getContent() == null) {
            if (statusCode == 404) {
                throw ExceptionFactory.createOSSException(requestId, "NoSuchKey", "Not Found");
            }
            if (statusCode == 304) {
                throw ExceptionFactory.createOSSException(requestId, "NotModified", "Not Modified");
            }
            if (statusCode == 412) {
                throw ExceptionFactory.createOSSException(requestId, "PreconditionFailed", "Precondition Failed");
            }
            if (statusCode == 403) {
                throw ExceptionFactory.createOSSException(requestId, "AccessForbidden", "AccessForbidden");
            }
            throw ExceptionFactory.createUnknownOSSException(requestId, statusCode);
        }
        try {
            try {
                OSSErrorResult errorResult = errorResponseParser.parse(response);
                throw ExceptionFactory.createOSSException(errorResult, response.getErrorResponseAsString());
            }
            catch (ResponseParseException e) {
                throw ExceptionFactory.createInvalidResponseException(requestId, response.getErrorResponseAsString(), e);
            }
        }
        catch (Throwable throwable) {
            OSSUtils.safeCloseResponse(response);
            throw throwable;
        }
    }
}

