/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.util;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.eureka.EurekaServerContext;
import com.netflix.eureka.cluster.PeerEurekaNode;
import com.netflix.eureka.cluster.PeerEurekaNodes;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.util.StatusInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusUtil {
    private static final Logger logger = LoggerFactory.getLogger(StatusUtil.class);
    private final String myAppName;
    private final PeerAwareInstanceRegistry registry;
    private final PeerEurekaNodes peerEurekaNodes;
    private final InstanceInfo instanceInfo;

    public StatusUtil(EurekaServerContext server) {
        this.myAppName = server.getApplicationInfoManager().getInfo().getAppName();
        this.registry = server.getRegistry();
        this.peerEurekaNodes = server.getPeerEurekaNodes();
        this.instanceInfo = server.getApplicationInfoManager().getInfo();
    }

    public StatusInfo getStatusInfo() {
        StatusInfo.Builder builder = StatusInfo.Builder.newBuilder();
        int upReplicasCount = 0;
        StringBuilder upReplicas = new StringBuilder();
        StringBuilder downReplicas = new StringBuilder();
        StringBuilder replicaHostNames = new StringBuilder();
        for (PeerEurekaNode node : this.peerEurekaNodes.getPeerEurekaNodes()) {
            if (replicaHostNames.length() > 0) {
                replicaHostNames.append(", ");
            }
            replicaHostNames.append(node.getServiceUrl());
            if (this.isReplicaAvailable(node.getServiceUrl())) {
                upReplicas.append(node.getServiceUrl()).append(',');
                ++upReplicasCount;
                continue;
            }
            downReplicas.append(node.getServiceUrl()).append(',');
        }
        builder.add("registered-replicas", replicaHostNames.toString());
        builder.add("available-replicas", upReplicas.toString());
        builder.add("unavailable-replicas", downReplicas.toString());
        if (this.peerEurekaNodes.getMinNumberOfAvailablePeers() > -1) {
            builder.isHealthy(upReplicasCount >= this.peerEurekaNodes.getMinNumberOfAvailablePeers());
        }
        builder.withInstanceInfo(this.instanceInfo);
        return builder.build();
    }

    private boolean isReplicaAvailable(String url) {
        try {
            Application app = this.registry.getApplication(this.myAppName, false);
            if (app == null) {
                return false;
            }
            for (InstanceInfo info : app.getInstances()) {
                if (!this.peerEurekaNodes.isInstanceURL(url, info)) continue;
                return true;
            }
        }
        catch (Throwable e) {
            logger.error("Could not determine if the replica is available ", e);
        }
        return false;
    }
}

