/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.manager.am.conf.AMConfiguration;
import org.apache.linkis.manager.am.converter.MetricsConverter;
import org.apache.linkis.manager.am.service.EngineConnStatusCallbackService;
import org.apache.linkis.manager.am.service.engine.EngineStopService;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.manager.common.entity.metrics.AMNodeMetrics;
import org.apache.linkis.manager.common.entity.metrics.NodeMetrics;
import org.apache.linkis.manager.common.protocol.engine.EngineConnStatusCallback;
import org.apache.linkis.manager.common.protocol.engine.EngineConnStatusCallbackToAM;
import org.apache.linkis.manager.persistence.NodeMetricManagerPersistence;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultEngineConnStatusCallbackService
implements EngineConnStatusCallbackService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEngineConnStatusCallbackService.class);
    @Autowired
    private NodeMetricManagerPersistence nodeMetricManagerPersistence;
    @Autowired
    private MetricsConverter metricsConverter;
    @Autowired
    private EngineStopService engineStopService;
    private static final String[] canRetryLogs = AMConfiguration.AM_CAN_RETRY_LOGS.split(";");

    @Receiver
    public void dealEngineConnStatusCallback(EngineConnStatusCallback protocol) {
        logger.info("EngineConnStatusCallbackServiceImpl handle engineConnStatus callback serviceInstance: [{}] status: [{}]", (Object)protocol.serviceInstance(), (Object)protocol.status());
        if (!NodeStatus.isAvailable((NodeStatus)protocol.status()).booleanValue()) {
            this.dealEngineConnStatusCallbackToAM(new EngineConnStatusCallbackToAM(protocol.serviceInstance(), protocol.status(), protocol.initErrorMsg(), false));
        }
    }

    @Override
    @Receiver
    public void dealEngineConnStatusCallbackToAM(EngineConnStatusCallbackToAM engineConnStatusCallbackToAM) {
        if (engineConnStatusCallbackToAM.serviceInstance() == null) {
            logger.warn("call back service instance is null");
        }
        logger.info("EngineConnStatusCallbackServiceImpl start to deal engineConnStatusCallbackToAM {}", (Object)engineConnStatusCallbackToAM);
        AMNodeMetrics nodeMetrics = new AMNodeMetrics();
        HashMap<String, Object> heartBeatMsg = new HashMap<String, Object>();
        int initErrorMsgMaxByteNum = 60000;
        String initErrorMsg = engineConnStatusCallbackToAM.initErrorMsg();
        try {
            if (StringUtils.isNotBlank((CharSequence)initErrorMsg) && initErrorMsg.getBytes("utf-8").length >= initErrorMsgMaxByteNum) {
                initErrorMsg = initErrorMsg.substring(0, initErrorMsgMaxByteNum);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("dealEngineConnStatusCallbackToAM getBytes failed", (Throwable)e);
        }
        heartBeatMsg.put("start_reason", initErrorMsg);
        if (engineConnStatusCallbackToAM.canRetry()) {
            heartBeatMsg.put("ec_can_try", engineConnStatusCallbackToAM.canRetry());
        } else if (this.matchRetryLog(engineConnStatusCallbackToAM.initErrorMsg())) {
            logger.info("match canRetry log {}", (Object)engineConnStatusCallbackToAM.serviceInstance());
            heartBeatMsg.put("ec_can_try", engineConnStatusCallbackToAM.canRetry());
        }
        try {
            nodeMetrics.setHeartBeatMsg(BDPJettyServerHelper.jacksonJson().writeValueAsString(heartBeatMsg));
        }
        catch (JsonProcessingException e) {
            logger.warn("dealEngineConnStatusCallbackToAM writeValueAsString failed", (Throwable)e);
        }
        nodeMetrics.setServiceInstance(engineConnStatusCallbackToAM.serviceInstance());
        nodeMetrics.setStatus(Integer.valueOf(this.metricsConverter.convertStatus(engineConnStatusCallbackToAM.status())));
        this.nodeMetricManagerPersistence.addOrupdateNodeMetrics((NodeMetrics)nodeMetrics);
        logger.info("Finished to deal engineConnStatusCallbackToAM {}", (Object)engineConnStatusCallbackToAM);
    }

    private boolean matchRetryLog(String errorMsg) {
        boolean flag = false;
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            String errorMsgLowCase = errorMsg.toLowerCase(Locale.getDefault());
            for (String canRetry : canRetryLogs) {
                if (!errorMsgLowCase.contains(canRetry)) continue;
                logger.info("match engineConn log fatal logs, is {}", (Object)canRetry);
                flag = true;
            }
        }
        return flag;
    }
}

