/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.common.utils;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.apache.linkis.common.utils.OverloadUtils$;
import org.apache.linkis.common.utils.Utils$;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class HardwareUtils$ {
    public static HardwareUtils$ MODULE$;
    private final SystemInfo systemInfo;
    private final HardwareAbstractionLayer hardware;
    private final String THREE_DECIMAL;

    static {
        new HardwareUtils$();
    }

    private SystemInfo systemInfo() {
        return this.systemInfo;
    }

    private HardwareAbstractionLayer hardware() {
        return this.hardware;
    }

    private String THREE_DECIMAL() {
        return this.THREE_DECIMAL;
    }

    public long getAvailableMemory() {
        GlobalMemory globalMemory = this.hardware().getMemory();
        return globalMemory.getAvailable();
    }

    public long getMaxMemory() {
        GlobalMemory globalMemory = this.hardware().getMemory();
        return globalMemory.getTotal();
    }

    public int getMaxLogicalCore() {
        CentralProcessor globalProcessor = this.hardware().getProcessor();
        return globalProcessor.getLogicalProcessorCount();
    }

    public Tuple2<Object, Object> getTotalAndAvailableMemory() {
        GlobalMemory globalMemory = this.hardware().getMemory();
        return new Tuple2.mcJJ.sp(globalMemory.getTotal(), globalMemory.getAvailable());
    }

    public double memoryUsage() {
        GlobalMemory memory = this.hardware().getMemory();
        double memoryUsage = (double)(memory.getTotal() - memory.getAvailable()) * 1.0 / (double)memory.getTotal();
        DecimalFormat df = new DecimalFormat(this.THREE_DECIMAL());
        df.setRoundingMode(RoundingMode.HALF_UP);
        return new StringOps(Predef$.MODULE$.augmentString(df.format(memoryUsage))).toDouble();
    }

    public double loadAverageUsage() {
        double loadAverage = BoxesRunTime.unboxToDouble(Utils$.MODULE$.tryCatch((JFunction0.mcD.sp & java.io.Serializable & Serializable)() -> OverloadUtils$.MODULE$.getOSBean().getSystemLoadAverage(), (Function1 & java.io.Serializable & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)HardwareUtils$.$anonfun$loadAverageUsage$2(x0$1))));
        DecimalFormat df = new DecimalFormat(this.THREE_DECIMAL());
        df.setRoundingMode(RoundingMode.HALF_UP);
        if (loadAverage <= 0.0) {
            return 0.0;
        }
        return new StringOps(Predef$.MODULE$.augmentString(df.format(loadAverage / 100.0))).toDouble();
    }

    public static final /* synthetic */ double $anonfun$loadAverageUsage$2(Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            double loadAverage = MODULE$.hardware().getProcessor().getSystemLoadAverage(1)[0];
            if (Double.isNaN(loadAverage)) {
                return -1.0;
            }
            return loadAverage;
        }
        throw new MatchError((Object)throwable);
    }

    private HardwareUtils$() {
        MODULE$ = this;
        this.systemInfo = new SystemInfo();
        this.hardware = this.systemInfo().getHardware();
        this.THREE_DECIMAL = "0.000";
    }
}

