/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.conf;

import org.apache.linkis.entrance.EntranceParser;
import org.apache.linkis.entrance.cli.heartbeat.CliHeartbeatMonitor;
import org.apache.linkis.entrance.cli.heartbeat.KillHandler;
import org.apache.linkis.entrance.conf.EntranceConfiguration;
import org.apache.linkis.entrance.event.EntranceEvent;
import org.apache.linkis.entrance.event.EntranceEventListener;
import org.apache.linkis.entrance.event.EntranceEventListenerBus;
import org.apache.linkis.entrance.execute.impl.EntranceExecutorManagerImpl;
import org.apache.linkis.entrance.interceptor.EntranceInterceptor;
import org.apache.linkis.entrance.interceptor.OnceJobInterceptor;
import org.apache.linkis.entrance.interceptor.impl.CSEntranceInterceptor;
import org.apache.linkis.entrance.interceptor.impl.CommentInterceptor;
import org.apache.linkis.entrance.interceptor.impl.CompatibleInterceptor;
import org.apache.linkis.entrance.interceptor.impl.LabelCheckInterceptor;
import org.apache.linkis.entrance.interceptor.impl.LogPathCreateInterceptor;
import org.apache.linkis.entrance.interceptor.impl.ParserVarLabelInterceptor;
import org.apache.linkis.entrance.interceptor.impl.SQLCodeCheckInterceptor;
import org.apache.linkis.entrance.interceptor.impl.SQLLimitEntranceInterceptor;
import org.apache.linkis.entrance.interceptor.impl.ScalaCodeInterceptor;
import org.apache.linkis.entrance.interceptor.impl.ShellDangerousGrammerInterceptor;
import org.apache.linkis.entrance.interceptor.impl.SparkCodeCheckInterceptor;
import org.apache.linkis.entrance.interceptor.impl.StorePathEntranceInterceptor;
import org.apache.linkis.entrance.interceptor.impl.UserCreatorIPCheckInterceptor;
import org.apache.linkis.entrance.interceptor.impl.VarSubstitutionInterceptor;
import org.apache.linkis.entrance.log.CacheLogManager;
import org.apache.linkis.entrance.log.ErrorCodeListener;
import org.apache.linkis.entrance.log.ErrorCodeManager;
import org.apache.linkis.entrance.log.FlexibleErrorCodeManager$;
import org.apache.linkis.entrance.log.LogManager;
import org.apache.linkis.entrance.log.PersistenceErrorCodeListener;
import org.apache.linkis.entrance.parser.CommonEntranceParser;
import org.apache.linkis.entrance.persistence.EntranceResultSetEngine;
import org.apache.linkis.entrance.persistence.PersistenceEngine;
import org.apache.linkis.entrance.persistence.PersistenceManager;
import org.apache.linkis.entrance.persistence.QueryPersistenceEngine;
import org.apache.linkis.entrance.persistence.QueryPersistenceManager;
import org.apache.linkis.entrance.persistence.ResultSetEngine;
import org.apache.linkis.entrance.scheduler.EntranceGroupFactory;
import org.apache.linkis.entrance.scheduler.EntranceParallelConsumerManager;
import org.apache.linkis.entrance.scheduler.EntranceSchedulerContext;
import org.apache.linkis.scheduler.Scheduler;
import org.apache.linkis.scheduler.SchedulerContext;
import org.apache.linkis.scheduler.executer.ExecutorManager;
import org.apache.linkis.scheduler.queue.ConsumerManager;
import org.apache.linkis.scheduler.queue.GroupFactory;
import org.apache.linkis.scheduler.queue.parallelqueue.ParallelScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class EntranceSpringConfiguration {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public EntranceSpringConfiguration() {
        this.logger.info("load the linkis-cg-entrance spring configuration.");
    }

    @Bean
    @ConditionalOnMissingBean
    public PersistenceEngine persistenceEngine() {
        return new QueryPersistenceEngine();
    }

    @Bean
    @ConditionalOnMissingBean
    public ResultSetEngine resultSetEngine() {
        return new EntranceResultSetEngine();
    }

    @Bean
    @ConditionalOnMissingBean
    public CliHeartbeatMonitor cliHeartbeatMonitor() {
        CliHeartbeatMonitor cliHeartbeatMonitor = new CliHeartbeatMonitor(new KillHandler());
        cliHeartbeatMonitor.start();
        return cliHeartbeatMonitor;
    }

    @Bean
    @ConditionalOnMissingBean
    public PersistenceManager persistenceManager(PersistenceEngine persistenceEngine, ResultSetEngine resultSetEngine, CliHeartbeatMonitor cliHeartbeatMonitor) {
        this.logger.info("init PersistenceManager.");
        QueryPersistenceManager persistenceManager = new QueryPersistenceManager();
        persistenceManager.setPersistenceEngine(persistenceEngine);
        persistenceManager.setResultSetEngine(resultSetEngine);
        persistenceManager.setCliHeartbeatMonitor(cliHeartbeatMonitor);
        return persistenceManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public EntranceParser entranceParser(PersistenceManager persistenceManager) {
        return new CommonEntranceParser(persistenceManager);
    }

    @Bean
    @ConditionalOnMissingBean
    public EntranceEventListenerBus<EntranceEventListener, EntranceEvent> entranceEventListenerBus() {
        EntranceEventListenerBus<EntranceEventListener, EntranceEvent> entranceEventListenerBus = new EntranceEventListenerBus<EntranceEventListener, EntranceEvent>();
        entranceEventListenerBus.start();
        return entranceEventListenerBus;
    }

    @Bean
    @ConditionalOnMissingBean(name={"entranceInterceptors"})
    public EntranceInterceptor[] entranceInterceptors() {
        return new EntranceInterceptor[]{new OnceJobInterceptor(), new CSEntranceInterceptor(), new ShellDangerousGrammerInterceptor(), new CompatibleInterceptor(), new SparkCodeCheckInterceptor(), new SQLCodeCheckInterceptor(), new LabelCheckInterceptor(), new ParserVarLabelInterceptor(), new VarSubstitutionInterceptor(), new LogPathCreateInterceptor(), new StorePathEntranceInterceptor(), new ScalaCodeInterceptor(), new SQLLimitEntranceInterceptor(), new CommentInterceptor(), new UserCreatorIPCheckInterceptor()};
    }

    @Bean
    @ConditionalOnMissingBean
    public ErrorCodeListener errorCodeListener(PersistenceManager persistenceManager, EntranceParser entranceParser) {
        PersistenceErrorCodeListener errorCodeListener = new PersistenceErrorCodeListener();
        errorCodeListener.setEntranceParser(entranceParser);
        errorCodeListener.setPersistenceManager(persistenceManager);
        return errorCodeListener;
    }

    @Bean
    @ConditionalOnMissingBean
    public ErrorCodeManager errorCodeManager() {
        return FlexibleErrorCodeManager$.MODULE$;
    }

    @Bean
    @ConditionalOnMissingBean
    public LogManager logManager(ErrorCodeListener errorCodeListener, ErrorCodeManager errorCodeManager) {
        CacheLogManager logManager = new CacheLogManager();
        logManager.setErrorCodeListener(errorCodeListener);
        logManager.setErrorCodeManager(errorCodeManager);
        return logManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public GroupFactory groupFactory() {
        return new EntranceGroupFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConsumerManager consumerManager() {
        return new EntranceParallelConsumerManager((Integer)EntranceConfiguration.ENTRANCE_SCHEDULER_MAX_PARALLELISM_USERS().getValue(), "EntranceJobScheduler");
    }

    @Bean
    @ConditionalOnMissingBean
    public SchedulerContext schedulerContext(GroupFactory groupFactory, ExecutorManager executorManager, ConsumerManager consumerManager) {
        return new EntranceSchedulerContext(groupFactory, consumerManager, executorManager);
    }

    @Bean
    @ConditionalOnMissingBean
    public ExecutorManager executorManager(GroupFactory groupFactory) {
        return new EntranceExecutorManagerImpl(groupFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public Scheduler scheduler(SchedulerContext schedulerContext) {
        ParallelScheduler scheduler = new ParallelScheduler(schedulerContext);
        scheduler.init();
        scheduler.start();
        return scheduler;
    }
}

