/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.cs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.cs.client.service.CSNodeServiceImpl;
import org.apache.linkis.cs.client.service.CSVariableService;
import org.apache.linkis.cs.client.service.LinkisJobDataServiceImpl;
import org.apache.linkis.cs.client.utils.ContextServiceUtils;
import org.apache.linkis.cs.client.utils.SerializeHelper;
import org.apache.linkis.cs.common.entity.data.LinkisJobData;
import org.apache.linkis.cs.common.entity.enumeration.ContextScope;
import org.apache.linkis.cs.common.entity.enumeration.ContextType;
import org.apache.linkis.cs.common.entity.source.CommonContextKey;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.entity.source.LinkisWorkflowContextID;
import org.apache.linkis.cs.common.utils.CSCommonUtils;
import org.apache.linkis.entrance.conf.EntranceConfiguration$;
import org.apache.linkis.entrance.execute.EntranceJob;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.protocol.utils.TaskUtils$;
import org.apache.linkis.scheduler.queue.Job;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CSEntranceHelper$
implements Logging {
    public static CSEntranceHelper$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new CSEntranceHelper$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        CSEntranceHelper$ cSEntranceHelper$ = this;
        synchronized (cSEntranceHelper$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public Tuple2<String, String> getContextInfo(Map<String, Object> params) {
        Object runtimeMap;
        Object v0;
        Object object = params.get("configuration");
        if (object instanceof Map) {
            Map map = (Map)object;
            v0 = map.get("runtime");
        } else {
            v0 = runtimeMap = null;
        }
        if (runtimeMap != null) {
            Object var7_5 = runtimeMap;
            if (var7_5 instanceof Map) {
                Map map = var7_5;
                String name = ContextServiceUtils.getNodeNameStrByMap((Map)map);
                return new Tuple2((Object)ContextServiceUtils.getContextIDStrByMap((Map)map), (Object)name);
            }
        }
        return new Tuple2(null, null);
    }

    public void setContextInfo(Map<String, Object> params, Map<String, String> copyMap) {
        Tuple2<String, String> tuple2 = this.getContextInfo(params);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String contextIDValueStr = (String)tuple2._1();
        String nodeNameStr = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)contextIDValueStr, (Object)nodeNameStr);
        String contextIDValueStr2 = (String)tuple22._1();
        String nodeNameStr2 = (String)tuple22._2();
        if (StringUtils.isNotBlank((CharSequence)contextIDValueStr2)) {
            copyMap.put("contextID", contextIDValueStr2);
            copyMap.put("nodeName", nodeNameStr2);
            return;
        }
    }

    public void registerCSRSData(Job job) {
        Job job2 = job;
        if (job2 instanceof EntranceJob) {
            EntranceJob entranceJob = (EntranceJob)job2;
            Tuple2<String, String> tuple2 = this.getContextInfo(entranceJob.getParams());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String contextIDValueStr = (String)tuple2._1();
            String nodeNameStr = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)contextIDValueStr, (Object)nodeNameStr);
            String contextIDValueStr2 = (String)tuple22._1();
            String nodeNameStr2 = (String)tuple22._2();
            this.logger().info("registerCSRSData: nodeName: {}", new Object[]{nodeNameStr2});
            if (StringUtils.isBlank((CharSequence)contextIDValueStr2) || StringUtils.isBlank((CharSequence)nodeNameStr2)) {
                return;
            }
            CommonContextKey contextKey = new CommonContextKey();
            contextKey.setContextScope(ContextScope.PUBLIC);
            contextKey.setContextType(ContextType.DATA);
            contextKey.setKey(new StringBuilder(11).append("node.").append(nodeNameStr2).append(".jobID").toString());
            JobRequest jobRequest = entranceJob.getJobRequest();
            if (jobRequest != null) {
                JobRequest jobRequest2 = jobRequest;
                LinkisJobData data = new LinkisJobData();
                data.setJobID(Predef$.MODULE$.Long2long(jobRequest2.getId()));
                LinkisJobDataServiceImpl.getInstance().putLinkisJobData(contextIDValueStr2, SerializeHelper.serializeContextKey((ContextKey)contextKey), data);
                this.logger().info("({} put {} of jobId to cs)", (Object)contextKey.getKey(), (Object)jobRequest2.getId());
            }
            this.logger().info("registerCSRSData end: nodeName: {}", new Object[]{nodeNameStr2});
            return;
        }
    }

    public void initNodeCSInfo(JobRequest requestPersistTask) {
        Tuple2<String, String> tuple2 = this.getContextInfo(requestPersistTask.getParams());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String contextIDValueStr = (String)tuple2._1();
        String nodeNameStr = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)contextIDValueStr, (Object)nodeNameStr);
        String contextIDValueStr2 = (String)tuple22._1();
        String nodeNameStr2 = (String)tuple22._2();
        if (StringUtils.isNotBlank((CharSequence)contextIDValueStr2) && StringUtils.isNotBlank((CharSequence)nodeNameStr2)) {
            this.logger().info("init node({}) cs info", new Object[]{nodeNameStr2});
            CSNodeServiceImpl.getInstance().initNodeCSInfo(contextIDValueStr2, nodeNameStr2);
            return;
        }
    }

    public void resetCreator(JobRequest requestPersistTask) {
        Tuple2<String, String> tuple2 = this.getContextInfo(requestPersistTask.getParams());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String contextIDValueStr = (String)tuple2._1();
        String nodeNameStr = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)contextIDValueStr, (Object)nodeNameStr);
        String contextIDValueStr2 = (String)tuple22._1();
        String nodeNameStr2 = (String)tuple22._2();
        if (StringUtils.isNotBlank((CharSequence)contextIDValueStr2) && StringUtils.isNotBlank((CharSequence)nodeNameStr2)) {
            UserCreatorLabel userCreatorLabel = LabelUtil$.MODULE$.getUserCreatorLabel(requestPersistTask.getLabels());
            ArrayList<UserCreatorLabel> newLabels = new ArrayList<UserCreatorLabel>();
            ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(requestPersistTask.getLabels()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CSEntranceHelper$.$anonfun$resetCreator$1(x$5)))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)newLabels.add(x$1)));
            ContextID contextID = SerializeHelper.deserializeContextID((String)contextIDValueStr2);
            if (contextID instanceof LinkisWorkflowContextID) {
                LinkisWorkflowContextID linkisWorkflowContextID = (LinkisWorkflowContextID)contextID;
                if (CSCommonUtils.CONTEXT_ENV_PROD.equalsIgnoreCase(linkisWorkflowContextID.getEnv())) {
                    this.logger().info("reset creator from {} to {}", (Object)userCreatorLabel.getCreator(), EntranceConfiguration$.MODULE$.SCHEDULER_CREATOR().getHotValue());
                    userCreatorLabel.setCreator((String)EntranceConfiguration$.MODULE$.SCHEDULER_CREATOR().getHotValue());
                } else {
                    this.logger().info("reset creator from {} to {}", (Object)userCreatorLabel.getCreator(), EntranceConfiguration$.MODULE$.FLOW_EXECUTION_CREATOR().getHotValue());
                    userCreatorLabel.setCreator((String)EntranceConfiguration$.MODULE$.FLOW_EXECUTION_CREATOR().getHotValue());
                }
            }
            newLabels.add(userCreatorLabel);
            requestPersistTask.setLabels(newLabels);
            return;
        }
    }

    public void addCSVariable(JobRequest requestPersistTask) {
        HashMap variableMap = new HashMap();
        Tuple2<String, String> tuple2 = this.getContextInfo(requestPersistTask.getParams());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String contextIDValueStr = (String)tuple2._1();
        String nodeNameStr = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)contextIDValueStr, (Object)nodeNameStr);
        String contextIDValueStr2 = (String)tuple22._1();
        String nodeNameStr2 = (String)tuple22._2();
        if (StringUtils.isNotBlank((CharSequence)contextIDValueStr2)) {
            this.logger().info("parse variable nodeName: {}", new Object[]{nodeNameStr2});
            List linkisVariableList = CSVariableService.getInstance().getUpstreamVariables(contextIDValueStr2, nodeNameStr2);
            if (linkisVariableList != null) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(linkisVariableList).asScala()).foreach((Function1 & Serializable & scala.Serializable)linkisVariable -> variableMap.put(linkisVariable.getKey(), linkisVariable.getValue()));
            }
            if (!variableMap.isEmpty()) {
                Map varMap = TaskUtils$.MODULE$.getVariableMap(requestPersistTask.getParams());
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(variableMap).asScala()).foreach((Function1 & Serializable & scala.Serializable)keyAndValue -> {
                    if (!varMap.containsKey(keyAndValue._1())) {
                        return varMap.put(keyAndValue._1(), keyAndValue._2());
                    }
                    return BoxedUnit.UNIT;
                });
                TaskUtils$.MODULE$.addVariableMap(requestPersistTask.getParams(), varMap);
            }
            this.logger().info("parse variable end nodeName: {}", new Object[]{nodeNameStr2});
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$resetCreator$1(Label x$5) {
        return x$5 instanceof UserCreatorLabel;
    }

    private CSEntranceHelper$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

