/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.execute;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.linkis.common.exception.WarnException;
import org.apache.linkis.common.log.LogUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.entrance.conf.EntranceConfiguration$;
import org.apache.linkis.entrance.errorcode.EntranceErrorCodeSummary;
import org.apache.linkis.entrance.exception.EntranceErrorException;
import org.apache.linkis.entrance.execute.DefaultEntranceExecutor;
import org.apache.linkis.entrance.execute.EntranceExecutor;
import org.apache.linkis.entrance.execute.EntranceJob;
import org.apache.linkis.entrance.execute.ExecuteRequestInterceptor;
import org.apache.linkis.entrance.execute.simple.SimpleEntranceExecutor;
import org.apache.linkis.entrance.execute.simple.SimpleExecuteBusContext$;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.scheduler.executer.Executor;
import org.apache.linkis.scheduler.executer.ExecutorManager;
import org.apache.linkis.scheduler.queue.GroupFactory;
import org.apache.linkis.scheduler.queue.Job;
import org.apache.linkis.scheduler.queue.SchedulerEvent;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%b!\u0002\b\u0010\u0003\u0003Q\u0002\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\t\u000bI\u0002A\u0011A\u001a\t\u000f]\u0002!\u0019!C\u0005q!1Q\t\u0001Q\u0001\neBQA\u0012\u0001\u0007\u0002\u001dCQ!\u0015\u0001\u0005BICQa\u0017\u0001\u0005BqCQa\u0017\u0001\u0005B\u0015DQ\u0001\u001d\u0001\u0005BEDQa\u001e\u0001\u0005BaDq!a\u0004\u0001\t#\n\t\u0002C\u0004\u0002\u001c\u0001!\t%!\b\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"\t9RI\u001c;sC:\u001cW-\u0012=fGV$xN]'b]\u0006<WM\u001d\u0006\u0003!E\tq!\u001a=fGV$XM\u0003\u0002\u0013'\u0005AQM\u001c;sC:\u001cWM\u0003\u0002\u0015+\u00051A.\u001b8lSNT!AF\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0012aA8sO\u000e\u00011c\u0001\u0001\u001cGA\u0011A$I\u0007\u0002;)\u0011adH\u0001\tKb,7-\u001e;fe*\u0011\u0001eE\u0001\ng\u000eDW\rZ;mKJL!AI\u000f\u0003\u001f\u0015CXmY;u_Jl\u0015M\\1hKJ\u0004\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\u000bU$\u0018\u000e\\:\u000b\u0005!\u001a\u0012AB2p[6|g.\u0003\u0002+K\t9Aj\\4hS:<\u0017\u0001D4s_V\u0004h)Y2u_JL\bCA\u00171\u001b\u0005q#BA\u0018 \u0003\u0015\tX/Z;f\u0013\t\tdF\u0001\u0007He>,\bOR1di>\u0014\u00180\u0001\u0004=S:LGO\u0010\u000b\u0003iY\u0002\"!\u000e\u0001\u000e\u0003=AQa\u000b\u0002A\u00021\n1\"\u001b3HK:,'/\u0019;peV\t\u0011\b\u0005\u0002;\u00076\t1H\u0003\u0002={\u00051\u0011\r^8nS\u000eT!AP \u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002A\u0003\u0006!Q\u000f^5m\u0015\u0005\u0011\u0015\u0001\u00026bm\u0006L!\u0001R\u001e\u0003\u0015\u0005#x.\\5d\u0019>tw-\u0001\u0007jI\u001e+g.\u001a:bi>\u0014\b%A\fhKR|%o\u0011:fCR,\u0017J\u001c;fe\u000e,\u0007\u000f^8sgR\t\u0001\nE\u0002J\u0019:k\u0011A\u0013\u0006\u0002\u0017\u0006)1oY1mC&\u0011QJ\u0013\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003k=K!\u0001U\b\u00033\u0015CXmY;uKJ+\u0017/^3ti&sG/\u001a:dKB$xN]\u0001\u0007I\u0016dW\r^3\u0015\u0005M3\u0006CA%U\u0013\t)&J\u0001\u0003V]&$\b\"B,\u0007\u0001\u0004A\u0016\u0001C3yK\u000e,Ho\u001c:\u0011\u0005qI\u0016B\u0001.\u001e\u0005!)\u00050Z2vi>\u0014\u0018aC1tW\u0016CXmY;u_J$\"!\u00181\u0011\u0007%s\u0006,\u0003\u0002`\u0015\n1q\n\u001d;j_:DQ!Y\u0004A\u0002\t\fab]2iK\u0012,H.\u001a:Fm\u0016tG\u000f\u0005\u0002.G&\u0011AM\f\u0002\u000f'\u000eDW\rZ;mKJ,e/\u001a8u)\rifm\u001a\u0005\u0006C\"\u0001\rA\u0019\u0005\u0006Q\"\u0001\r![\u0001\u0005o\u0006LG\u000f\u0005\u0002k]6\t1N\u0003\u0002m[\u0006AA-\u001e:bi&|gN\u0003\u0002?\u0015&\u0011qn\u001b\u0002\t\tV\u0014\u0018\r^5p]\u00069q-\u001a;Cs&#GCA/s\u0011\u0015\u0019\u0018\u00021\u0001u\u0003\tIG\r\u0005\u0002Jk&\u0011aO\u0013\u0002\u0005\u0019>tw-\u0001\u0006hKR\u0014\u0015p\u0012:pkB$\"!\u001f>\u0011\u0007%c\u0005\fC\u0003|\u0015\u0001\u0007A0A\u0005he>,\bOT1nKB\u0019Q0!\u0003\u000f\u0007y\f)\u0001\u0005\u0002\u0000\u00156\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007I\u0012A\u0002\u001fs_>$h(C\u0002\u0002\b)\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0006\u0003\u001b\u0011aa\u0015;sS:<'bAA\u0004\u0015\u0006q1M]3bi\u0016,\u00050Z2vi>\u0014H\u0003BA\n\u00033\u00012!NA\u000b\u0013\r\t9b\u0004\u0002\u0011\u000b:$(/\u00198dK\u0016CXmY;u_JDQ!Y\u0006A\u0002\t\f\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0002'\u0006ir-\u001a;F]R\u0014\u0018M\\2f\u000bb,7-\u001e;pe\nK\u0018J\\:uC:\u001cW\r\u0006\u0003\u0002$\u0005\u0015\u0002\u0003B%_\u0003'Aa!a\n\u000e\u0001\u0004a\u0018\u0001C5ogR\fgnY3")
public abstract class EntranceExecutorManager
extends ExecutorManager
implements Logging {
    private final AtomicLong idGenerator;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        EntranceExecutorManager entranceExecutorManager = this;
        synchronized (entranceExecutorManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private AtomicLong idGenerator() {
        return this.idGenerator;
    }

    public abstract ExecuteRequestInterceptor[] getOrCreateInterceptors();

    public void delete(Executor executor) {
        if (executor != null) {
            executor.close();
            return;
        }
    }

    public Option<Executor> askExecutor(SchedulerEvent schedulerEvent) {
        SchedulerEvent schedulerEvent2 = schedulerEvent;
        if (schedulerEvent2 instanceof Job) {
            Job job = (Job)schedulerEvent2;
            return Option$.MODULE$.apply((Object)this.createExecutor((SchedulerEvent)job));
        }
        throw new MatchError((Object)schedulerEvent2);
    }

    public Option<Executor> askExecutor(SchedulerEvent schedulerEvent, Duration wait) {
        SchedulerEvent schedulerEvent2 = schedulerEvent;
        if (schedulerEvent2 instanceof Job) {
            Job job = (Job)schedulerEvent2;
            long startTime = System.currentTimeMillis();
            ObjectRef warnException = ObjectRef.create(null);
            ObjectRef executor = ObjectRef.create((Object)None$.MODULE$);
            while (System.currentTimeMillis() - startTime < wait.toMillis() && ((Option)executor.elem).isEmpty()) {
                Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    executor$1.elem = this.askExecutor((SchedulerEvent)job);
                }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
                    EntranceExecutorManager.$anonfun$askExecutor$2(this, warnException, x0$1);
                    return BoxedUnit.UNIT;
                });
            }
            if ((WarnException)warnException.elem != null && ((Option)executor.elem).isEmpty()) {
                throw (WarnException)warnException.elem;
            }
            return (Option)executor.elem;
        }
        throw new MatchError((Object)schedulerEvent2);
    }

    public Option<Executor> getById(long id) {
        return null;
    }

    public Executor[] getByGroup(String groupName) {
        return null;
    }

    public EntranceExecutor createExecutor(SchedulerEvent schedulerEvent) {
        SchedulerEvent schedulerEvent2 = schedulerEvent;
        if (schedulerEvent2 instanceof EntranceJob) {
            EntranceJob entranceJob = (EntranceJob)schedulerEvent2;
            JobRequest jobRequest = entranceJob.getJobRequest();
            if (jobRequest != null) {
                JobRequest jobRequest2 = jobRequest;
                DefaultEntranceExecutor entranceEntranceExecutor = new DefaultEntranceExecutor(Predef$.MODULE$.Long2long(jobRequest2.getId()));
                EntranceExecutor entranceExecutor = EntranceConfiguration$.MODULE$.LINKIS_ENTRANCE_SKIP_ORCHESTRATOR() ? new SimpleEntranceExecutor(Predef$.MODULE$.Long2long(jobRequest2.getId()), SimpleExecuteBusContext$.MODULE$.getOrchestratorListenerBusContext()) : new DefaultEntranceExecutor(Predef$.MODULE$.Long2long(jobRequest2.getId()));
                entranceJob.getLogListener().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.onLogUpdate((Job)entranceJob, LogUtils$.MODULE$.generateInfo("Your job is being scheduled by orchestrator."));
                    return BoxedUnit.UNIT;
                });
                jobRequest2.setUpdatedTime(new Date(System.currentTimeMillis()));
                return entranceEntranceExecutor;
            }
            throw new EntranceErrorException(EntranceErrorCodeSummary.NOT_CREATE_EXECUTOR.getErrorCode(), EntranceErrorCodeSummary.NOT_CREATE_EXECUTOR.getErrorDesc());
        }
        throw new EntranceErrorException(EntranceErrorCodeSummary.ENTRA_NOT_CREATE_EXECUTOR.getErrorCode(), EntranceErrorCodeSummary.ENTRA_NOT_CREATE_EXECUTOR.getErrorDesc());
    }

    public void shutdown() {
    }

    public Option<EntranceExecutor> getEntranceExecutorByInstance(String instance) {
        return null;
    }

    public static final /* synthetic */ void $anonfun$askExecutor$2(EntranceExecutorManager $this, ObjectRef warnException$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof WarnException) {
            WarnException warnException = (WarnException)throwable;
            $this.logger().warn("request engine failed!", (Throwable)warnException);
            warnException$1.elem = warnException;
            return;
        }
        if (throwable != null) {
            Throwable throwable2 = throwable;
            throw throwable2;
        }
        throw new MatchError((Object)throwable);
    }

    public EntranceExecutorManager(GroupFactory groupFactory) {
        Logging.$init$((Logging)this);
        this.idGenerator = new AtomicLong(0L);
    }
}

