/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.restful;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.entrance.EntranceServer;
import org.apache.linkis.entrance.execute.EntranceJob;
import org.apache.linkis.entrance.scheduler.CreatorECTypeDefaultConf;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"entrance metrice manager"})
@RestController
@RequestMapping(path={"/entrance/operation/metrics"})
public class EntranceMetricRestfulApi {
    private EntranceServer entranceServer;
    private static final Logger logger = LoggerFactory.getLogger(EntranceMetricRestfulApi.class);

    @Autowired
    public void setEntranceServer(EntranceServer entranceServer) {
        this.entranceServer = entranceServer;
    }

    @ApiOperation(value="taskinfo", notes="get task info", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="user", dataType="String", value="User"), @ApiImplicitParam(name="creator", dataType="String", value="Creator"), @ApiImplicitParam(name="engineTypeLabel", dataType="String", value="engine type lable")})
    @RequestMapping(path={"/taskinfo"}, method={RequestMethod.GET})
    public Message taskinfo(HttpServletRequest req, @RequestParam(value="user", required=false) String user, @RequestParam(value="creator", required=false) String creator, @RequestParam(value="ecType", required=false) String ecType) {
        String filterWords;
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"taskinfo");
        String queryUser = user;
        if (Configuration.isNotAdmin((String)userName)) {
            if (StringUtils.isBlank((CharSequence)queryUser)) {
                queryUser = userName;
            } else if (!userName.equalsIgnoreCase(queryUser)) {
                return Message.error((String)"Non-administrators cannot view other users' task information");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(filterWords = creator)) && StringUtils.isNotBlank((CharSequence)queryUser)) {
            filterWords = filterWords + "_" + queryUser;
        } else if (StringUtils.isBlank((CharSequence)creator)) {
            filterWords = queryUser;
        }
        EntranceJob[] undoneTasks = this.entranceServer.getAllUndoneTask(filterWords, ecType);
        int runningNumber = 0;
        int queuedNumber = 0;
        if (null != undoneTasks) {
            for (EntranceJob task : undoneTasks) {
                if (task.isRunning()) {
                    ++runningNumber;
                    continue;
                }
                ++queuedNumber;
            }
        }
        Message resp = Message.ok((String)"success").data("taskNumber", (Object)undoneTasks.length).data("runningNumber", (Object)runningNumber).data("queuedNumber", (Object)queuedNumber);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{creator, ecType})) {
            int creatorECTypeMaxRunningJobs = CreatorECTypeDefaultConf.getCreatorECTypeMaxRunningJobs(creator, ecType);
            resp.data("creatorECTypeMaxRunningJobs", (Object)creatorECTypeMaxRunningJobs);
            resp.data("limitExceeded", (Object)(runningNumber > creatorECTypeMaxRunningJobs ? 1 : 0));
        }
        return resp;
    }

    @ApiOperation(value="runningtask", notes="get running task number ", response=Message.class)
    @RequestMapping(path={"/runningtask"}, method={RequestMethod.GET})
    public Message runningtask(HttpServletRequest req) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"runningtask");
        EntranceJob[] undoneTasks = this.entranceServer.getAllUndoneTask("", null);
        Boolean isCompleted = false;
        if (null == undoneTasks || undoneTasks.length < 1) {
            isCompleted = true;
        }
        int runningTaskNumber = 0;
        if (undoneTasks != null) {
            runningTaskNumber = undoneTasks.length;
        }
        return Message.ok((String)"success").data("runningTaskNumber", (Object)runningTaskNumber).data("isCompleted", (Object)isCompleted);
    }
}

