/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.restful;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.common.log.LogUtils;
import org.apache.linkis.entrance.EntranceServer;
import org.apache.linkis.entrance.conf.EntranceConfiguration;
import org.apache.linkis.entrance.execute.EntranceJob;
import org.apache.linkis.entrance.log.LogReader;
import org.apache.linkis.entrance.restful.EntranceRestfulRemote;
import org.apache.linkis.entrance.utils.JobHistoryHelper;
import org.apache.linkis.entrance.utils.RGBUtils;
import org.apache.linkis.entrance.vo.YarnResourceWithStatusVo;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.manager.common.protocol.resource.ResourceWithStatus;
import org.apache.linkis.protocol.engine.JobInstance;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.apache.linkis.protocol.utils.ZuulEntranceUtils;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.scheduler.listener.LogListener;
import org.apache.linkis.scheduler.queue.Job;
import org.apache.linkis.scheduler.queue.SchedulerEventState;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.conf.ServerConfiguration;
import org.apache.linkis.server.security.SecurityFilter;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.apache.linkis.utils.LinkisSpringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import scala.Option;

@Api(tags={"task operation"})
@RestController
@RequestMapping(path={"/entrance"})
public class EntranceRestfulApi
implements EntranceRestfulRemote {
    private EntranceServer entranceServer;
    private static final Logger logger = LoggerFactory.getLogger(EntranceRestfulApi.class);

    @Autowired
    public void setEntranceServer(EntranceServer entranceServer) {
        this.entranceServer = entranceServer;
    }

    @Override
    @ApiOperation(value="execute", notes="execute the submitted task", response=Message.class)
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/execute"}, method={RequestMethod.POST})
    public Message execute(HttpServletRequest req, @RequestBody Map<String, Object> json) {
        Message message = null;
        String operationUser = ModuleUserUtils.getOperationUser((HttpServletRequest)req);
        logger.info("Begin to get execute task for user {}, Client IP {}", (Object)operationUser, (Object)LinkisSpringUtils.getClientIP((HttpServletRequest)req));
        json.put("executeUser", ModuleUserUtils.getOperationUser((HttpServletRequest)req));
        json.put("submitUser", SecurityFilter.getLoginUsername((HttpServletRequest)req));
        HashMap<String, String> map = (HashMap<String, String>)json.get("source");
        if (map == null) {
            map = new HashMap<String, String>();
            json.put("source", map);
        }
        String ip = JobHistoryHelper.getRequestIpAddr(req);
        map.put("requestIP", ip);
        Job job = this.entranceServer.execute(json);
        JobRequest jobReq = ((EntranceJob)job).getJobRequest();
        Long jobReqId = jobReq.getId();
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("execute task,id: " + jobReqId));
        String execID = ZuulEntranceUtils.generateExecID((String)job.getId(), (String)Sender.getThisServiceInstance().getApplicationName(), (String[])new String[]{Sender.getThisInstance()});
        this.pushLog(LogUtils.generateInfo((String)("Your job is accepted,  jobID is " + execID + " and taskID is " + jobReqId + " in " + Sender.getThisServiceInstance().toString() + ". \n Please wait it to be scheduled(\u60a8\u7684\u4efb\u52a1\u5df2\u7ecf\u63d0\u4ea4\uff0c\u8fdb\u5165\u6392\u961f\u4e2d\uff0c\u5982\u679c\u4e00\u76f4\u6ca1\u6709\u66f4\u65b0\u65e5\u5fd7\uff0c\u662f\u4efb\u52a1\u5e76\u53d1\u8fbe\u5230\u4e86\u9650\u5236\uff0c\u53ef\u4ee5\u8fdb\u884c\u53c2\u6570\u4fee\u6539)")), job);
        message = Message.ok();
        message.setMethod("/api/entrance/execute");
        message.data("execID", (Object)execID);
        message.data("taskID", (Object)jobReqId);
        logger.info("End to get an an execID: {}, taskID: {}", (Object)execID, (Object)jobReqId);
        return message;
    }

    @Override
    @ApiOperation(value="submit", notes="submit execute job", response=Message.class)
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/submit"}, method={RequestMethod.POST})
    public Message submit(HttpServletRequest req, @RequestBody Map<String, Object> json) {
        Message message = null;
        String executeUser = ModuleUserUtils.getOperationUser((HttpServletRequest)req);
        logger.info("Begin to get execute task for user {}, Client IP {}", (Object)executeUser, (Object)LinkisSpringUtils.getClientIP((HttpServletRequest)req));
        json.put("submitUser", SecurityFilter.getLoginUsername((HttpServletRequest)req));
        String token = ModuleUserUtils.getToken((HttpServletRequest)req);
        Object tempExecuteUser = json.get("executeUser");
        if (StringUtils.isNotBlank((CharSequence)token) && tempExecuteUser != null && Configuration.isAdminToken((String)token)) {
            logger.warn("ExecuteUser variable will be replaced by system value: {} -> {}", tempExecuteUser, (Object)executeUser);
            executeUser = String.valueOf(tempExecuteUser);
        }
        json.put("executeUser", executeUser);
        HashMap<String, String> map = (HashMap<String, String>)json.get("source");
        if (map == null) {
            map = new HashMap<String, String>();
            json.put("source", map);
        }
        String ip = JobHistoryHelper.getRequestIpAddr(req);
        map.put("requestIP", ip);
        Job job = this.entranceServer.execute(json);
        JobRequest jobRequest = ((EntranceJob)job).getJobRequest();
        Long jobReqId = jobRequest.getId();
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("submit jobReqId: " + jobReqId));
        this.pushLog(LogUtils.generateInfo((String)("Your job is accepted,  jobID is " + job.getId() + " and jobReqId is " + jobReqId + " in " + Sender.getThisServiceInstance().toString() + ". \n Please wait it to be scheduled(\u60a8\u7684\u4efb\u52a1\u5df2\u7ecf\u63d0\u4ea4\uff0c\u8fdb\u5165\u6392\u961f\u4e2d\uff0c\u5982\u679c\u4e00\u76f4\u6ca1\u6709\u66f4\u65b0\u65e5\u5fd7\uff0c\u662f\u4efb\u52a1\u5e76\u53d1\u8fbe\u5230\u4e86\u9650\u5236\uff0c\u53ef\u4ee5\u8fdb\u884c\u53c2\u6570\u4fee\u6539)")), job);
        String execID = ZuulEntranceUtils.generateExecID((String)job.getId(), (String)Sender.getThisServiceInstance().getApplicationName(), (String[])new String[]{Sender.getThisInstance()});
        message = Message.ok();
        message.setMethod("/api/entrance/submit");
        message.data("execID", (Object)execID);
        message.data("taskID", (Object)jobReqId);
        logger.info("End to get an an execID: {}, taskID: {}", (Object)execID, (Object)jobReqId);
        return message;
    }

    private void pushLog(String log, Job job) {
        this.entranceServer.getEntranceContext().getOrCreateLogManager().onLogUpdate(job, log);
    }

    private JobInstance parseHeaderToJobInstance(HttpServletRequest req) throws JsonProcessingException {
        String jobStr = req.getHeader((String)ServerConfiguration.LINKIS_SERVER_ENTRANCE_HEADER_KEY().getValue());
        return (JobInstance)BDPJettyServerHelper.gson().fromJson(jobStr, JobInstance.class);
    }

    @Override
    @ApiOperation(value="status", notes="get task stats", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskID", required=false, dataType="String", value=" task id"), @ApiImplicitParam(name="id", required=true, dataType="String", value="execute id ")})
    @RequestMapping(path={"/{id}/status"}, method={RequestMethod.GET})
    public Message status(HttpServletRequest req, @PathVariable(value="id") String id, @RequestParam(value="taskID", required=false) String taskID) {
        String execID;
        String realId;
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"job status");
        Message message = null;
        if (id.startsWith(ZuulEntranceUtils.EXEC_ID())) {
            realId = ZuulEntranceUtils.parseExecID((String)id)[3];
            execID = id;
        } else {
            JobInstance jobInstance;
            try {
                jobInstance = this.parseHeaderToJobInstance(req);
            }
            catch (JsonProcessingException e) {
                logger.error("parse JobInstance json error, id: {}", (Object)id);
                message = Message.error((String)"parse JobInstance json error");
                message.setMethod("/api/entrance/" + id + "/status");
                return message;
            }
            if (SchedulerEventState.isCompletedByStr((String)jobInstance.status())) {
                message = Message.ok();
                message.setMethod("/api/entrance/" + id + "/status");
                message.data("status", (Object)jobInstance.status()).data("execID", (Object)"").data("taskID", (Object)id);
                return message;
            }
            if (jobInstance.instanceRegistryTimestamp() > jobInstance.createTimestamp()) {
                logger.warn("The job {} wait failover, return status is Inited", (Object)id);
                String status = SchedulerEventState.Inited().toString();
                message = Message.ok();
                message.setMethod("/api/entrance/" + id + "/status");
                message.data("status", (Object)status).data("execID", (Object)"").data("taskID", (Object)id);
                return message;
            }
            realId = jobInstance.jobReqId();
            execID = ZuulEntranceUtils.generateExecID((String)realId, (String)Sender.getThisServiceInstance().getApplicationName(), (String[])new String[]{Sender.getThisInstance()});
        }
        Option<Job> job = null;
        try {
            job = this.entranceServer.getJob(realId);
        }
        catch (Exception e) {
            logger.warn("get {} status error", (Object)realId, (Object)e);
            if (StringUtils.isEmpty((CharSequence)taskID)) {
                message = Message.error((String)"Get job by ID error and cannot obtain the corresponding task status.(\u83b7\u53d6job\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u4e0d\u80fd\u83b7\u53d6\u76f8\u5e94\u7684\u4efb\u52a1\u72b6\u6001)");
                return message;
            }
            long realTaskID = Long.parseLong(taskID);
            String status = JobHistoryHelper.getStatusByTaskID(realTaskID);
            message = Message.ok();
            message.setMethod("/api/entrance/" + id + "/status");
            message.data("status", (Object)status).data("execID", (Object)execID);
            return message;
        }
        if (job != null && job.isDefined()) {
            if (job.get() instanceof EntranceJob) {
                ((EntranceJob)((Object)job.get())).updateNewestAccessByClientTimestamp();
            }
            message = Message.ok();
            message.setMethod("/api/entrance/" + id + "/status");
            message.data("status", (Object)((Job)job.get()).getState().toString()).data("execID", (Object)execID);
        } else {
            message = Message.error((String)"ID The corresponding job is empty and cannot obtain the corresponding task status.(ID \u5bf9\u5e94\u7684job\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u83b7\u53d6\u76f8\u5e94\u7684\u4efb\u52a1\u72b6\u6001)");
        }
        return message;
    }

    @Override
    @ApiOperation(value="progress", notes="get task progress info", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", required=true, dataType="String", value="exectue id")})
    @RequestMapping(path={"/{id}/progress"}, method={RequestMethod.GET})
    public Message progress(HttpServletRequest req, @PathVariable(value="id") String id) {
        String execID;
        String realId;
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"job progress");
        Message message = null;
        if (id.startsWith(ZuulEntranceUtils.EXEC_ID())) {
            realId = ZuulEntranceUtils.parseExecID((String)id)[3];
            execID = id;
        } else {
            JobInstance jobInstance;
            try {
                jobInstance = this.parseHeaderToJobInstance(req);
            }
            catch (JsonProcessingException e) {
                logger.error("parse JobInstance json error, id: {}", (Object)id);
                message = Message.error((String)"parse JobInstance json error");
                message.setMethod("/api/entrance/" + id + "/progress");
                return message;
            }
            if (SchedulerEventState.isCompletedByStr((String)jobInstance.status())) {
                message = Message.ok();
                message.setMethod("/api/entrance/" + id + "/progress");
                message.data("progress", (Object)"1.0").data("execID", (Object)"").data("taskID", (Object)id).data("progressInfo", new ArrayList());
                return message;
            }
            if (jobInstance.instanceRegistryTimestamp() > jobInstance.createTimestamp()) {
                logger.warn("The job {} wait failover, return progress is 0", (Object)id);
                message = Message.ok();
                message.setMethod("/api/entrance/" + id + "/progress");
                message.data("progress", (Object)0).data("execID", (Object)"").data("taskID", (Object)id).data("progressInfo", new ArrayList());
                return message;
            }
            realId = jobInstance.jobReqId();
            execID = ZuulEntranceUtils.generateExecID((String)realId, (String)Sender.getThisServiceInstance().getApplicationName(), (String[])new String[]{Sender.getThisInstance()});
        }
        Option<Job> job = null;
        try {
            job = this.entranceServer.getJob(realId);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        if (job != null && job.isDefined()) {
            JobProgressInfo[] jobProgressInfos = ((EntranceJob)((Object)job.get())).getProgressInfo();
            if (jobProgressInfos == null) {
                message = Message.error((String)"Can not get the corresponding progress information, it may be that the corresponding progress information has not been generated(\u4e0d\u80fd\u83b7\u53d6\u76f8\u5e94\u7684\u8fdb\u5ea6\u4fe1\u606f,\u53ef\u80fd\u662f\u76f8\u5e94\u7684\u8fdb\u5ea6\u4fe1\u606f\u8fd8\u672a\u751f\u6210)");
                message.setMethod("/api/entrance/" + id + "/progress");
            } else {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                for (JobProgressInfo jobProgressInfo : jobProgressInfos) {
                    if (!"true".equals(EntranceConfiguration.PROGRESS_PUSH().getValue()) && jobProgressInfo.totalTasks() <= 0) continue;
                    this.setJobProgressInfos(list, jobProgressInfo);
                }
                message = Message.ok();
                message.setMethod("/api/entrance/" + id + "/progress");
                message.data("progress", (Object)Float.valueOf(Math.abs(((Job)job.get()).getProgress()))).data("execID", (Object)execID).data("progressInfo", list);
            }
        } else {
            message = Message.error((String)"The job corresponding to the ID is empty, and the corresponding task progress cannot be obtained.(ID \u5bf9\u5e94\u7684job\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u83b7\u53d6\u76f8\u5e94\u7684\u4efb\u52a1\u8fdb\u5ea6)");
        }
        return message;
    }

    @Override
    @ApiOperation(value="progressWithResource", notes="get progress  and resource info", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", required=true, dataType="String", value="execute id")})
    @RequestMapping(path={"/{id}/progressWithResource"}, method={RequestMethod.GET})
    public Message progressWithResource(HttpServletRequest req, @PathVariable(value="id") String id) {
        String execID;
        String realId;
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"job progressWithResource");
        Message message = null;
        if (id.startsWith(ZuulEntranceUtils.EXEC_ID())) {
            realId = ZuulEntranceUtils.parseExecID((String)id)[3];
            execID = id;
        } else {
            JobInstance jobInstance;
            try {
                jobInstance = this.parseHeaderToJobInstance(req);
            }
            catch (JsonProcessingException e) {
                logger.error("parse JobInstance json error, id: {}", (Object)id);
                message = Message.error((String)"parse JobInstance json error");
                message.setMethod("/api/entrance/" + id + "/progressWithResource");
                return message;
            }
            if (SchedulerEventState.isCompletedByStr((String)jobInstance.status())) {
                long realTaskID = Long.parseLong(id);
                JobRequest jobRequest = JobHistoryHelper.getTaskByTaskID(realTaskID);
                message = Message.ok();
                message.setMethod("/api/entrance/" + id + "/progressWithResource");
                HashMap<String, Object> metricsVo = new HashMap<String, Object>();
                this.buildYarnResource(jobRequest, metricsVo, message);
                message.data("progress", (Object)"1.0").data("execID", (Object)"").data("taskID", (Object)id).data("progressInfo", new ArrayList());
                return message;
            }
            if (jobInstance.instanceRegistryTimestamp() > jobInstance.createTimestamp()) {
                logger.warn("The job {} wait failover, return progress is 0 and resource is null", (Object)id);
                message = Message.ok();
                message.setMethod("/api/entrance/" + id + "/progressWithResource");
                message.data("yarnResource", null).data("progress", (Object)0).data("execID", (Object)"").data("taskID", (Object)id).data("progressInfo", new ArrayList());
                return message;
            }
            realId = jobInstance.jobReqId();
            execID = ZuulEntranceUtils.generateExecID((String)realId, (String)Sender.getThisServiceInstance().getApplicationName(), (String[])new String[]{Sender.getThisInstance()});
        }
        Option<Job> job = null;
        try {
            job = this.entranceServer.getJob(realId);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        if (job != null && job.isDefined()) {
            JobRequest jobProgressInfos = ((EntranceJob)((Object)job.get())).getProgressInfo();
            if (jobProgressInfos == null) {
                message = Message.error((String)"Can not get the corresponding progress information, it may be that the corresponding progress information has not been generated(\u4e0d\u80fd\u83b7\u53d6\u76f8\u5e94\u7684\u8fdb\u5ea6\u4fe1\u606f,\u53ef\u80fd\u662f\u76f8\u5e94\u7684\u8fdb\u5ea6\u4fe1\u606f\u8fd8\u672a\u751f\u6210)");
                message.setMethod("/api/entrance/" + id + "/progressWithResource");
            } else {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                for (JobProgressInfo jobProgressInfo : jobProgressInfos) {
                    if (!"true".equals(EntranceConfiguration.PROGRESS_PUSH().getValue()) && jobProgressInfo.totalTasks() <= 0) continue;
                    this.setJobProgressInfos(list, jobProgressInfo);
                }
                message = Message.ok();
                message.setMethod("/api/entrance/" + id + "/progressWithResource");
                JobRequest jobRequest = ((EntranceJob)((Object)job.get())).getJobRequest();
                HashMap<String, Object> metricsVo = new HashMap<String, Object>();
                this.buildYarnResource(jobRequest, metricsVo, message);
                message.data("progress", (Object)Float.valueOf(Math.abs(((Job)job.get()).getProgress()))).data("execID", (Object)execID).data("progressInfo", list);
            }
        } else {
            message = Message.error((String)"The job corresponding to the ID is empty, and the corresponding task progress cannot be obtained.(ID \u5bf9\u5e94\u7684job\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u83b7\u53d6\u76f8\u5e94\u7684\u4efb\u52a1\u8fdb\u5ea6)");
        }
        return message;
    }

    private void buildYarnResource(JobRequest jobRequest, Map<String, Object> metricsVo, Message message) {
        try {
            Map metrics = jobRequest.getMetrics();
            if (metrics.containsKey("yarnResource")) {
                HashMap resourceMap = (HashMap)metrics.get("yarnResource");
                ArrayList resoureList = new ArrayList(12);
                if (null != resourceMap && !resourceMap.isEmpty()) {
                    resourceMap.forEach((applicationId, resource) -> resoureList.add(new YarnResourceWithStatusVo((String)applicationId, (ResourceWithStatus)resource)));
                    metricsVo.put("yarnResource", resoureList);
                    Optional<Integer> cores = resourceMap.values().stream().map(resource -> resource.queueCores()).reduce((x, y) -> x + y);
                    Optional<Long> memory = resourceMap.values().stream().map(resource -> resource.queueMemory()).reduce((x, y) -> x + y);
                    float corePercent = 0.0f;
                    float memoryPercent = 0.0f;
                    if (cores.isPresent() && memory.isPresent()) {
                        corePercent = cores.get().floatValue() / (float)((Integer)EntranceConfiguration.YARN_QUEUE_CORES_MAX().getValue()).intValue();
                        memoryPercent = memory.get().floatValue() / (float)(((Integer)EntranceConfiguration.YARN_QUEUE_MEMORY_MAX().getValue()).longValue() * 1024L * 1024L * 1024L);
                    }
                    String coreRGB = RGBUtils.getRGB(corePercent);
                    String memoryRGB = RGBUtils.getRGB(memoryPercent);
                    metricsVo.put("corePercent", Float.valueOf(corePercent));
                    metricsVo.put("memoryPercent", Float.valueOf(memoryPercent));
                    metricsVo.put("coreRGB", coreRGB);
                    metricsVo.put("memoryRGB", memoryRGB);
                    message.data("yarnMetrics", metricsVo);
                } else {
                    message.data("yarnResource", null);
                }
            } else {
                message.data("yarnResource", null);
            }
        }
        catch (Exception e) {
            logger.error("build yarnResource error", (Throwable)e);
        }
    }

    private void setJobProgressInfos(List<Map<String, Object>> list, JobProgressInfo jobProgressInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", jobProgressInfo.id());
        map.put("succeedTasks", jobProgressInfo.succeedTasks());
        map.put("failedTasks", jobProgressInfo.failedTasks());
        map.put("runningTasks", jobProgressInfo.runningTasks());
        map.put("totalTasks", jobProgressInfo.totalTasks());
        list.add(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ApiOperation(value="log", notes="get task log", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", required=true, dataType="String", value="execute id")})
    @RequestMapping(path={"/{id}/log"}, method={RequestMethod.GET})
    public Message log(HttpServletRequest req, @PathVariable(value="id") String id) {
        String execID;
        String realId;
        String distinctLevelStr;
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"get job log");
        Message message = null;
        int fromLine = 0;
        int size = 100;
        boolean distinctLevel = true;
        String fromLineStr = req.getParameter("fromLine");
        String sizeStr = req.getParameter("size");
        if (StringUtils.isNotBlank((CharSequence)fromLineStr)) {
            fromLine = Math.max(Integer.parseInt(fromLineStr), 0);
        }
        if (StringUtils.isNotBlank((CharSequence)sizeStr)) {
            int n = size = Integer.parseInt(sizeStr) >= 0 ? Integer.parseInt(sizeStr) : 10000;
        }
        if ("false".equals(distinctLevelStr = req.getParameter("distinctLevel"))) {
            distinctLevel = false;
        }
        if (id.startsWith(ZuulEntranceUtils.EXEC_ID())) {
            realId = ZuulEntranceUtils.parseExecID((String)id)[3];
            execID = id;
        } else {
            JobInstance jobInstance;
            try {
                jobInstance = this.parseHeaderToJobInstance(req);
            }
            catch (JsonProcessingException e) {
                logger.error("parse JobInstance json error, id: {}", (Object)id);
                message = Message.error((String)"parse JobInstance json error");
                message.setMethod("/api/entrance/" + id + "/log");
                return message;
            }
            if (SchedulerEventState.isCompletedByStr((String)jobInstance.status())) {
                message = Message.error((String)"The job you just executed has ended. This interface no longer provides a query. It is recommended that you download the log file for viewing.(\u60a8\u521a\u521a\u6267\u884c\u7684job\u5df2\u7ecf\u7ed3\u675f\uff0c\u672c\u63a5\u53e3\u4e0d\u518d\u63d0\u4f9b\u67e5\u8be2\uff0c\u5efa\u8bae\u60a8\u4e0b\u8f7d\u65e5\u5fd7\u6587\u4ef6\u8fdb\u884c\u67e5\u770b)");
                message.setMethod("/api/entrance/" + id + "/log");
                return message;
            }
            if (jobInstance.instanceRegistryTimestamp() > jobInstance.createTimestamp()) {
                Object retLog;
                logger.warn("The job {} wait failover, return customer log", (Object)id);
                message = Message.ok();
                message.setMethod("/api/entrance/" + id + "/log");
                String log = LogUtils.generateInfo((String)"The job will failover soon, please try again later.(job\u5f88\u5feb\u5c31\u4f1afailover\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5)");
                if (distinctLevel) {
                    String[] array = new String[4];
                    array[2] = log;
                    array[3] = log;
                    retLog = new ArrayList<String>(Arrays.asList(array));
                } else {
                    retLog = log;
                }
                message.data("log", retLog).data("execID", (Object)"").data("taskID", (Object)id).data("fromLine", (Object)0);
                return message;
            }
            realId = jobInstance.jobReqId();
            execID = ZuulEntranceUtils.generateExecID((String)realId, (String)Sender.getThisServiceInstance().getApplicationName(), (String[])new String[]{Sender.getThisInstance()});
        }
        Option<Job> job = null;
        try {
            job = this.entranceServer.getJob(realId);
        }
        catch (Throwable t) {
            message = Message.error((String)"The job you just executed has ended. This interface no longer provides a query. It is recommended that you download the log file for viewing.(\u60a8\u521a\u521a\u6267\u884c\u7684job\u5df2\u7ecf\u7ed3\u675f\uff0c\u672c\u63a5\u53e3\u4e0d\u518d\u63d0\u4f9b\u67e5\u8be2\uff0c\u5efa\u8bae\u60a8\u4e0b\u8f7d\u65e5\u5fd7\u6587\u4ef6\u8fdb\u884c\u67e5\u770b)");
            message.setMethod("/api/entrance/" + id + "/log");
            return message;
        }
        if (job != null && job.isDefined()) {
            logger.debug("begin to get log for {}(\u5f00\u59cb\u83b7\u53d6 {} \u7684\u65e5\u5fd7)", (Object)((Job)job.get()).getId(), (Object)((Job)job.get()).getId());
            LogReader logReader = this.entranceServer.getEntranceContext().getOrCreateLogManager().getLogReader(realId);
            Object retLog = null;
            int retFromLine = 0;
            try {
                if (distinctLevel) {
                    String[] logs = new String[4];
                    retFromLine = logReader.readArray(logs, fromLine, size);
                    retLog = new ArrayList<String>(Arrays.asList(logs));
                } else {
                    StringBuilder sb = new StringBuilder();
                    retFromLine = logReader.read(sb, fromLine, size);
                    retLog = sb.toString();
                }
            }
            catch (IllegalStateException e) {
                logger.debug("Failed to get log information for :{}(\u4e3a {} \u83b7\u53d6\u65e5\u5fd7\u5931\u8d25)", new Object[]{((Job)job.get()).getId(), ((Job)job.get()).getId(), e});
                message = Message.ok();
                message.setMethod("/api/entrance/" + id + "/log");
                message.data("log", (Object)"").data("execID", (Object)execID).data("fromLine", (Object)(retFromLine + fromLine));
            }
            catch (IllegalArgumentException e) {
                logger.debug("Failed to get log information for :{}(\u4e3a {} \u83b7\u53d6\u65e5\u5fd7\u5931\u8d25)", new Object[]{((Job)job.get()).getId(), ((Job)job.get()).getId(), e});
                message = Message.ok();
                message.setMethod("/api/entrance/" + id + "/log");
                message.data("log", (Object)"").data("execID", (Object)execID).data("fromLine", (Object)(retFromLine + fromLine));
                Message message2 = message;
                return message2;
            }
            catch (Exception e1) {
                logger.debug("Failed to get log information for :{}(\u4e3a {} \u83b7\u53d6\u65e5\u5fd7\u5931\u8d25)", new Object[]{((Job)job.get()).getId(), ((Job)job.get()).getId(), e1});
                message = Message.error((String)"Failed to get log information(\u83b7\u53d6\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25)");
                message.setMethod("/api/entrance/" + id + "/log");
                message.data("log", (Object)"").data("execID", (Object)execID).data("fromLine", (Object)(retFromLine + fromLine));
                Message message3 = message;
                return message3;
            }
            finally {
                if (null != logReader && ((Job)job.get()).isCompleted()) {
                    IOUtils.closeQuietly((Closeable)logReader);
                }
            }
            message = Message.ok();
            message.setMethod("/api/entrance/" + id + "/log");
            message.data("log", retLog).data("execID", (Object)execID).data("fromLine", (Object)(retFromLine + fromLine));
            logger.debug("success to get log for {} (\u83b7\u53d6 {} \u65e5\u5fd7\u6210\u529f)", (Object)((Job)job.get()).getId(), (Object)((Job)job.get()).getId());
        } else {
            message = Message.error((String)("Can't find execID(\u4e0d\u80fd\u627e\u5230execID): " + id + "Corresponding job, can not get the corresponding log(\u5bf9\u5e94\u7684job\uff0c\u4e0d\u80fd\u83b7\u5f97\u5bf9\u5e94\u7684\u65e5\u5fd7)"));
            message.setMethod("/api/entrance/" + id + "/log");
        }
        return message;
    }

    @Override
    @ApiOperation(value="killJobs", notes="kill jobs", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="strongExecId", required=true, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"/{id}/killJobs"}, method={RequestMethod.POST})
    public Message killJobs(HttpServletRequest req, @RequestBody JsonNode jsonNode, @PathVariable(value="id") String strongExecId) {
        JsonNode idNode = jsonNode.get("idList");
        JsonNode taskIDNode = jsonNode.get("taskIDList");
        ArrayList<Long> waitToForceKill = new ArrayList<Long>();
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"killJobs");
        if (idNode.size() != taskIDNode.size()) {
            return Message.error((String)"The length of the ID list does not match the length of the TASKID list(id\u5217\u8868\u7684\u957f\u5ea6\u4e0etaskId\u5217\u8868\u7684\u957f\u5ea6\u4e0d\u4e00\u81f4)");
        }
        if (!idNode.isArray() || !taskIDNode.isArray()) {
            return Message.error((String)"Request parameter error, please use array(\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u4f7f\u7528\u6570\u7ec4)");
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        for (int i = 0; i < idNode.size(); ++i) {
            String id = idNode.get(i).asText();
            Long taskID = taskIDNode.get(i).asLong();
            String realId = ZuulEntranceUtils.parseExecID((String)id)[3];
            Option<Job> job = null;
            try {
                job = this.entranceServer.getJob(realId);
            }
            catch (Exception e) {
                logger.warn("can not find a job in entranceServer, will force to kill it", (Object)e.getMessage());
                waitToForceKill.add(taskID);
                Message message = Message.ok((String)"Forced Kill task (\u5f3a\u5236\u6740\u6b7b\u4efb\u52a1)");
                message.setMethod("/api/entrance/" + id + "/kill");
                message.setStatus(0);
                messages.add(message);
                continue;
            }
            Message message = null;
            if (job == null || job.isEmpty()) {
                logger.warn("can not find a job in entranceServer, will force to kill it");
                waitToForceKill.add(taskID);
                message = Message.ok((String)"Forced Kill task (\u5f3a\u5236\u6740\u6b7b\u4efb\u52a1)");
                message.setMethod("/api/entrance/" + id + "/killJobs");
                message.setStatus(0);
                messages.add(message);
            } else {
                try {
                    EntranceJob entranceJob;
                    JobRequest jobReq;
                    logger.info("begin to kill job {} ", (Object)((Job)job.get()).getId());
                    if (job.get() instanceof EntranceJob && !userName.equals((jobReq = (entranceJob = (EntranceJob)((Object)job.get())).getJobRequest()).getExecuteUser()) && Configuration.isNotJobHistoryAdmin((String)userName)) {
                        return Message.error((String)("You have no permission to kill this job, excecute by user:" + jobReq.getExecuteUser()));
                    }
                    ((Job)job.get()).kill();
                    message = Message.ok((String)"Successfully killed the job(\u6210\u529fkill\u4e86job)");
                    message.setMethod("/api/entrance/" + id + "/kill");
                    message.setStatus(0);
                    message.data("execID", (Object)id);
                    if (job.get() instanceof EntranceJob) {
                        entranceJob = (EntranceJob)((Object)job.get());
                        jobReq = entranceJob.getJobRequest();
                        entranceJob.updateJobRequestStatus(SchedulerEventState.Cancelled().toString());
                        jobReq.setProgress("1.0f");
                        LogListener logListener = (LogListener)entranceJob.getLogListener().getOrElse(null);
                        if (null != logListener) {
                            logListener.onLogUpdate((Job)entranceJob, LogUtils.generateInfo((String)("Job " + jobReq.getId() + " was kill by user successfully(\u4efb\u52a1" + jobReq.getId() + "\u5df2\u6210\u529f\u53d6\u6d88)")));
                        }
                        this.entranceServer.getEntranceContext().getOrCreatePersistenceManager().createPersistenceEngine().updateIfNeeded(jobReq);
                    }
                    logger.info("end to kill job {} ", (Object)((Job)job.get()).getId());
                }
                catch (Throwable t) {
                    logger.error("kill job {} failed ", (Object)((Job)job.get()).getId(), (Object)t);
                    message = Message.error((String)"An exception occurred while killing the job, kill failed(kill job\u7684\u65f6\u5019\u51fa\u73b0\u4e86\u5f02\u5e38\uff0ckill\u5931\u8d25)", (Throwable)t);
                    message.setMethod("/api/entrance/" + id + "/kill");
                }
            }
            messages.add(message);
        }
        if (!waitToForceKill.isEmpty()) {
            JobHistoryHelper.forceBatchKill(waitToForceKill);
        }
        return Message.ok((String)"success").data("messages", messages);
    }

    @Override
    @ApiOperation(value="kill", notes="kill", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", required=true, dataType="String", value="exec id"), @ApiImplicitParam(name="taskID", required=false, dataType="String", value="task id")})
    @RequestMapping(path={"/{id}/kill"}, method={RequestMethod.GET})
    public Message kill(HttpServletRequest req, @PathVariable(value="id") String id, @RequestParam(value="taskID", required=false) Long taskID) {
        String execID;
        String realId;
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"kill job");
        Message message = null;
        if (id.startsWith(ZuulEntranceUtils.EXEC_ID())) {
            realId = ZuulEntranceUtils.parseExecID((String)id)[3];
            execID = id;
        } else {
            JobInstance jobInstance;
            try {
                jobInstance = this.parseHeaderToJobInstance(req);
            }
            catch (JsonProcessingException e) {
                logger.error("parse JobInstance json error, id: {}", (Object)id);
                message = Message.error((String)"parse JobInstance json error");
                message.setMethod("/api/entrance/" + id + "/kill");
                return message;
            }
            if (SchedulerEventState.isCompletedByStr((String)jobInstance.status())) {
                message = Message.error((String)"The job already completed. Do not support kill.(\u4efb\u52a1\u5df2\u7ecf\u7ed3\u675f\uff0c\u4e0d\u652f\u6301kill)");
                message.setMethod("/api/entrance/" + id + "/kill");
                return message;
            }
            if (jobInstance.instanceRegistryTimestamp() > jobInstance.createTimestamp()) {
                logger.warn("The job {} wait failover, but now force kill", (Object)id);
                long taskId = Long.parseLong(id);
                JobHistoryHelper.forceKill(taskId);
                message = Message.ok((String)"Forced Kill task (\u5f3a\u5236\u6740\u6b7b\u4efb\u52a1)");
                message.setMethod("/api/entrance/" + id + "/kill");
                message.data("execID", (Object)"").data("taskID", (Object)id);
                return message;
            }
            realId = jobInstance.jobReqId();
            execID = ZuulEntranceUtils.generateExecID((String)realId, (String)Sender.getThisServiceInstance().getApplicationName(), (String[])new String[]{Sender.getThisInstance()});
        }
        Option<Job> job = null;
        try {
            job = this.entranceServer.getJob(realId);
        }
        catch (Exception e) {
            logger.warn("can not find a job in entranceServer, will force to kill it", (Throwable)e);
            if (taskID == null || taskID <= 0L) {
                message = Message.error((String)"Get job by ID error, kill failed.(\u83b7\u53d6job\u65f6\u53d1\u751f\u5f02\u5e38\uff0ckill\u5931\u8d25)");
                return message;
            }
            JobHistoryHelper.forceKill(taskID);
            message = Message.ok((String)"Forced Kill task (\u5f3a\u5236\u6740\u6b7b\u4efb\u52a1)");
            message.setMethod("/api/entrance/" + id + "/kill");
            message.setStatus(0);
            return message;
        }
        if (job == null || job.isEmpty()) {
            logger.warn("can not find a job in entranceServer, will force to kill it");
            JobHistoryHelper.forceKill(taskID);
            message = Message.ok((String)"Forced Kill task (\u5f3a\u5236\u6740\u6b7b\u4efb\u52a1)");
            message.setMethod("/api/entrance/" + id + "/kill");
            message.setStatus(0);
            return message;
        }
        try {
            EntranceJob entranceJob;
            JobRequest jobReq;
            if (job.get() instanceof EntranceJob && !userName.equals((jobReq = (entranceJob = (EntranceJob)((Object)job.get())).getJobRequest()).getExecuteUser()) && Configuration.isNotJobHistoryAdmin((String)userName)) {
                return Message.error((String)("You have no permission to kill this job, excecute by user:" + jobReq.getExecuteUser()));
            }
            logger.info("begin to kill job {} ", (Object)((Job)job.get()).getId());
            ((Job)job.get()).kill();
            message = Message.ok((String)"Successfully killed the job(\u6210\u529fkill\u4e86job)");
            message.setMethod("/api/entrance/" + id + "/kill");
            message.data("execID", (Object)execID);
            if (job.get() instanceof EntranceJob) {
                entranceJob = (EntranceJob)((Object)job.get());
                jobReq = entranceJob.getJobRequest();
                entranceJob.updateJobRequestStatus(SchedulerEventState.Cancelled().toString());
                this.entranceServer.getEntranceContext().getOrCreatePersistenceManager().createPersistenceEngine().updateIfNeeded(jobReq);
            }
            logger.info("end to kill job {} ", (Object)((Job)job.get()).getId());
        }
        catch (Throwable t) {
            logger.error("kill job {} failed ", (Object)((Job)job.get()).getId(), (Object)t);
            message = Message.error((String)("An exception occurred while killing the job, kill failed(kill job\u7684\u65f6\u5019\u51fa\u73b0\u4e86\u5f02\u5e38\uff0ckill\u5931\u8d25) with error:" + t.getMessage()), (Throwable)t);
            message.setMethod("/api/entrance/" + id + "/kill");
            message.setStatus(1);
        }
        return message;
    }

    @Override
    @ApiOperation(value="pause ", notes="puase a task job", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", required=true, dataType="String", value="excete id")})
    @RequestMapping(path={"/{id}/pause"}, method={RequestMethod.GET})
    public Message pause(HttpServletRequest req, @PathVariable(value="id") String id) {
        String realId = ZuulEntranceUtils.parseExecID((String)id)[3];
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("pause realId:" + realId));
        Option<Job> job = this.entranceServer.getJob(realId);
        Message message = null;
        if (job.isEmpty()) {
            message = Message.error((String)("can not find the job of exexID :" + id + " can not pause (\u4e0d\u80fd\u627e\u5230execID: " + id + "\u5bf9\u5e94\u7684job\uff0c\u4e0d\u80fd\u8fdb\u884cpause)"));
            message.setMethod("/api/entrance/" + id + "/pause");
            message.setStatus(1);
        } else {
            try {
                logger.info("begin to pause job {} ", (Object)((Job)job.get()).getId());
                message = Message.ok((String)"success to pause job (\u6210\u529fpause\u4e86job)");
                message.setStatus(0);
                message.data("execID", (Object)id);
                message.setMethod("/api/entrance/" + id + "/pause");
                logger.info("end to pause job {} ", (Object)((Job)job.get()).getId());
            }
            catch (Throwable t) {
                logger.info("pause job {} failed ", (Object)((Job)job.get()).getId());
                message = Message.error((String)"Abnormal when pausing job, pause failed(pause job\u7684\u65f6\u5019\u51fa\u73b0\u4e86\u5f02\u5e38\uff0cpause\u5931\u8d25)");
                message.setMethod("/api/entrance/" + id + "/pause");
                message.setStatus(1);
            }
        }
        return message;
    }
}

