/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.server;

import java.io.Closeable;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.entrance.EntranceContext;
import org.apache.linkis.entrance.EntranceServer;
import org.apache.linkis.entrance.conf.EntranceConfiguration;
import org.apache.linkis.entrance.conf.EntranceConfiguration$;
import org.apache.linkis.entrance.execute.EntranceJob;
import org.apache.linkis.entrance.job.EntranceExecutionJob;
import org.apache.linkis.entrance.log.LogReader;
import org.apache.linkis.governance.common.protocol.conf.EntranceInstanceConfRequest;
import org.apache.linkis.rpc.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component(value="entranceServer")
public class DefaultEntranceServer
extends EntranceServer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEntranceServer.class);
    @Autowired
    private EntranceContext entranceContext;
    private Boolean shutdownFlag = false;

    public DefaultEntranceServer() {
    }

    public DefaultEntranceServer(EntranceContext entranceContext) {
        this.entranceContext = entranceContext;
    }

    @Override
    @PostConstruct
    public void init() {
        this.getEntranceWebSocketService();
        this.addRunningJobEngineStatusMonitor();
        this.cleanUpEntranceDirtyData();
    }

    private void cleanUpEntranceDirtyData() {
        if (((Boolean)EntranceConfiguration$.MODULE$.ENABLE_ENTRANCE_DIRTY_DATA_CLEAR().getValue()).booleanValue()) {
            logger.info("start to clean up entrance dirty data.");
            Sender sender = Sender.getSender((String)((String)EntranceConfiguration$.MODULE$.JOBHISTORY_SPRING_APPLICATION_NAME().getValue()));
            ServiceInstance thisServiceInstance = Sender.getThisServiceInstance();
            sender.ask((Object)new EntranceInstanceConfRequest(thisServiceInstance.getInstance()));
        }
    }

    @Override
    public String getName() {
        return Sender.getThisInstance();
    }

    @Override
    public EntranceContext getEntranceContext() {
        return this.entranceContext;
    }

    @Override
    public LogReader logReader(String execId) {
        return this.getEntranceContext().getOrCreateLogManager().getLogReader(execId);
    }

    private void addRunningJobEngineStatusMonitor() {
    }

    @EventListener
    private void shutdownEntrance(ContextClosedEvent event) {
        if (this.shutdownFlag.booleanValue()) {
            logger.warn("event has been handled");
        } else {
            if (EntranceConfiguration.ENTRANCE_SHUTDOWN_FAILOVER_CONSUME_QUEUE_ENABLED()) {
                logger.warn("Entrance exit to update and clean all ConsumeQueue task instances");
                this.updateAllNotExecutionTaskInstances(false);
            }
            logger.warn("Entrance exit to stop all job");
            EntranceJob[] allUndoneTask = this.getAllUndoneTask(null, null);
            if (null != allUndoneTask) {
                for (EntranceJob job : allUndoneTask) {
                    job.onFailure("Your job will be marked as canceled because the Entrance service restarted(\u56e0\u4e3aEntrance\u670d\u52a1\u91cd\u542f\uff0c\u60a8\u7684\u4efb\u52a1\u5c06\u88ab\u6807\u8bb0\u4e3a\u53d6\u6d88)", null);
                    IOUtils.closeQuietly((Closeable)((Closeable)((EntranceExecutionJob)job).getLogWriter().get()));
                }
            }
        }
    }
}

