/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.timeout;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.entrance.conf.EntranceConfiguration$;
import org.apache.linkis.entrance.execute.EntranceJob;
import org.apache.linkis.entrance.timeout.JobTimeoutManager$;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.entrance.JobQueuingTimeoutLabel;
import org.apache.linkis.manager.label.entity.entrance.JobRunningTimeoutLabel;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\t\u0013\u0001uAQ\u0001\f\u0001\u0005\u00025Ba\u0001\r\u0001!\u0002\u001b\t\u0004b\u0002'\u0001\u0005\u0004%I!\u0014\u0005\u0007#\u0002\u0001\u000b\u0011\u0002(\t\u000fI\u0003!\u0019!C\u0005'\"1q\u000b\u0001Q\u0001\nQCQ\u0001\u0017\u0001\u0005\u0002eCQ!\u0019\u0001\u0005\u0002\tDQ\u0001\u001a\u0001\u0005\u0002\u0015DQa\u001a\u0001\u0005\u0002!DQa\u001b\u0001\u0005\n1<Q!\u001c\n\t\u000294Q!\u0005\n\t\u0002=DQ\u0001L\u0007\u0005\u0002ADQ!]\u0007\u0005\u0002IDq!a\b\u000e\t\u0003\t\tCA\tK_\n$\u0016.\\3pkRl\u0015M\\1hKJT!a\u0005\u000b\u0002\u000fQLW.Z8vi*\u0011QCF\u0001\tK:$(/\u00198dK*\u0011q\u0003G\u0001\u0007Y&t7.[:\u000b\u0005eQ\u0012AB1qC\u000eDWMC\u0001\u001c\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0004\n\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0015RS\"\u0001\u0014\u000b\u0005\u001dB\u0013!B;uS2\u001c(BA\u0015\u0017\u0003\u0019\u0019w.\\7p]&\u00111F\n\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\ta\u0006\u0005\u00020\u00015\t!#\u0001\tuS6,w.\u001e;K_\n\u0014\u0015PT1nKB!!'O\u001eG\u001b\u0005\u0019$B\u0001\u001b6\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003m]\nA!\u001e;jY*\t\u0001(\u0001\u0003kCZ\f\u0017B\u0001\u001e4\u00055\u0019uN\\2veJ,g\u000e^'baB\u0011Ah\u0011\b\u0003{\u0005\u0003\"A\u0010\u0011\u000e\u0003}R!\u0001\u0011\u000f\u0002\rq\u0012xn\u001c;?\u0013\t\u0011\u0005%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\t\u0016\u0013aa\u0015;sS:<'B\u0001\"!!\t9%*D\u0001I\u0015\tIE#A\u0004fq\u0016\u001cW\u000f^3\n\u0005-C%aC#oiJ\fgnY3K_\n\fA\u0002^5nK>,Ho\u00115fG.,\u0012A\u0014\t\u0003?=K!\u0001\u0015\u0011\u0003\u000f\t{w\u000e\\3b]\u0006iA/[7f_V$8\t[3dW\u0002\n1\u0003^5nK>,HoU2b]&sG/\u001a:wC2,\u0012\u0001\u0016\t\u0003?UK!A\u0016\u0011\u0003\u0007%sG/\u0001\u000buS6,w.\u001e;TG\u0006t\u0017J\u001c;feZ\fG\u000eI\u0001\u0004C\u0012$Gc\u0001.^?B\u0011qdW\u0005\u00039\u0002\u0012A!\u00168ji\")al\u0002a\u0001w\u00051!n\u001c2LKfDQ\u0001Y\u0004A\u0002\u0019\u000b1A[8c\u0003\u0019!W\r\\3uKR\u0011!l\u0019\u0005\u0006=\"\u0001\raO\u0001\tU>\u0014W\t_5tiR\u0011aJ\u001a\u0005\u0006=&\u0001\raO\u0001\u0012U>\u00147i\\7qY\u0016$X\rR3mKR,GC\u0001.j\u0011\u0015Q'\u00021\u0001<\u0003\u0019QwNY6fs\u0006\u0001B/[7f_V$H)\u001a;fGRLg/\u001a\u000b\u00025\u0006\t\"j\u001c2US6,w.\u001e;NC:\fw-\u001a:\u0011\u0005=j1CA\u0007\u001f)\u0005q\u0017!E2iK\u000e\\G+[7f_V$H*\u00192fYR\u0011!l\u001d\u0005\u0006i>\u0001\r!^\u0001\u0007Y\u0006\u0014W\r\\:\u0011\tY<8(_\u0007\u0002k%\u0011\u00010\u000e\u0002\u0004\u001b\u0006\u0004\bg\u0001>\u0002\u000eA)10!\u0002\u0002\n5\tAP\u0003\u0002~}\u00061QM\u001c;jifT1a`A\u0001\u0003\u0015a\u0017MY3m\u0015\r\t\u0019AF\u0001\b[\u0006t\u0017mZ3s\u0013\r\t9\u0001 \u0002\u0006\u0019\u0006\u0014W\r\u001c\t\u0005\u0003\u0017\ti\u0001\u0004\u0001\u0005\u0017\u0005=1/!A\u0001\u0002\u000b\u0005\u0011\u0011\u0003\u0002\u0004?\u0012\n\u0014\u0003BA\n\u00033\u00012aHA\u000b\u0013\r\t9\u0002\t\u0002\b\u001d>$\b.\u001b8h!\ry\u00121D\u0005\u0004\u0003;\u0001#aA!os\u0006y\u0001.Y:US6,w.\u001e;MC\n,G\u000eF\u0002O\u0003GAa!!\n\u0011\u0001\u00041\u0015aC3oiJ\fgnY3K_\n\u0004")
public class JobTimeoutManager
implements Logging {
    private final ConcurrentMap<String, EntranceJob> timeoutJobByName;
    private final boolean timeoutCheck;
    private final int timeoutScanInterval;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static boolean hasTimeoutLabel(EntranceJob entranceJob) {
        return JobTimeoutManager$.MODULE$.hasTimeoutLabel(entranceJob);
    }

    public static void checkTimeoutLabel(Map<String, Label<?>> map) {
        JobTimeoutManager$.MODULE$.checkTimeoutLabel(map);
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        JobTimeoutManager jobTimeoutManager = this;
        synchronized (jobTimeoutManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private boolean timeoutCheck() {
        return this.timeoutCheck;
    }

    private int timeoutScanInterval() {
        return this.timeoutScanInterval;
    }

    public void add(String jobKey, EntranceJob job) {
        this.logger().info(new StringBuilder(20).append("Adding timeout job: ").append(job.getId()).toString());
        if (!this.timeoutJobByName.containsKey(jobKey)) {
            JobTimeoutManager jobTimeoutManager = this;
            synchronized (jobTimeoutManager) {
                Object object = !this.timeoutJobByName.containsKey(jobKey) ? this.timeoutJobByName.put(jobKey, job) : BoxedUnit.UNIT;
            }
            return;
        }
        this.logger().warn(new StringBuilder(38).append("Job already exists, invalid addition: ").append(jobKey).toString());
    }

    public void delete(String jobKey) {
        EntranceJob job = (EntranceJob)((Object)this.timeoutJobByName.get(jobKey));
        if (job != null) {
            this.logger().info(new StringBuilder(14).append("Deleting Job: ").append(job.getId()).toString());
            JobTimeoutManager jobTimeoutManager = this;
            synchronized (jobTimeoutManager) {
                EntranceJob cfr_ignored_0 = (EntranceJob)((Object)this.timeoutJobByName.remove(jobKey));
            }
            return;
        }
    }

    public boolean jobExist(String jobKey) {
        return this.timeoutJobByName.containsKey(jobKey);
    }

    public void jobCompleteDelete(String jobkey) {
        EntranceJob job = (EntranceJob)((Object)this.timeoutJobByName.get(jobkey));
        if (job.isCompleted()) {
            this.logger().info(new StringBuilder(32).append("Job is complete, delete it now: ").append(job.getId()).toString());
            this.delete(jobkey);
            return;
        }
    }

    public void org$apache$linkis$entrance$timeout$JobTimeoutManager$$timeoutDetective() {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.timeoutJobByName).asScala()).foreach((Function1 & Serializable & scala.Serializable)item -> {
            JobTimeoutManager.$anonfun$timeoutDetective$2(this, item);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$timeoutDetective$1(JobTimeoutManager $this, EntranceJob job$1, long queuingTimeSeconds$1, long runningTimeSeconds$1, Label x0$1) {
        Label label = x0$1;
        if (label instanceof JobQueuingTimeoutLabel) {
            JobQueuingTimeoutLabel jobQueuingTimeoutLabel = (JobQueuingTimeoutLabel)label;
            if (job$1.isWaiting() && Predef$.MODULE$.Long2long(jobQueuingTimeoutLabel.getQueuingTimeout()) > 0L && queuingTimeSeconds$1 >= Predef$.MODULE$.Long2long(jobQueuingTimeoutLabel.getQueuingTimeout())) {
                $this.logger().warn(new StringBuilder(84).append("Job ").append(job$1.getJobRequest().getId()).append(" queued time : ").append(queuingTimeSeconds$1).append(" seconds, which was over queueTimeOut : ").append(jobQueuingTimeoutLabel.getQueuingTimeout()).append(" seconds, cancel it now! ").toString());
                job$1.onFailure(new StringBuilder(51).append("Job queued ").append(queuingTimeSeconds$1).append(" seconds over max queue time : ").append(jobQueuingTimeoutLabel.getQueuingTimeout()).append(" seconds.").toString(), null);
                return;
            }
            return;
        }
        if (label instanceof JobRunningTimeoutLabel) {
            JobRunningTimeoutLabel jobRunningTimeoutLabel = (JobRunningTimeoutLabel)label;
            if (job$1.isRunning() && Predef$.MODULE$.Long2long(jobRunningTimeoutLabel.getRunningTimeout()) > 0L && runningTimeSeconds$1 >= Predef$.MODULE$.Long2long(jobRunningTimeoutLabel.getRunningTimeout())) {
                $this.logger().warn(new StringBuilder(80).append("Job ").append(job$1.getJobRequest().getId()).append(" run timeout ").append(runningTimeSeconds$1).append(" seconds, which was over runTimeOut : ").append(jobRunningTimeoutLabel.getRunningTimeout()).append(" seconds, cancel it now! ").toString());
                job$1.onFailure(new StringBuilder(46).append("Job run ").append(runningTimeSeconds$1).append(" seconds over max run time : ").append(jobRunningTimeoutLabel.getRunningTimeout()).append(" seconds.").toString(), null);
                return;
            }
            return;
        }
    }

    private final void checkAndSwitch$1(EntranceJob job) {
        this.logger().info(new StringBuilder(40).append("Checking whether the job id ").append(job.getJobRequest().getId()).append(" timed out. ").toString());
        long currentTimeSeconds = System.currentTimeMillis() / 1000L;
        long jobScheduleStartTimeSeconds = job.isWaiting() ? job.createTime() / 1000L : currentTimeSeconds;
        long queuingTimeSeconds = currentTimeSeconds - jobScheduleStartTimeSeconds;
        long jobRunningStartTimeSeconds = job.getStartTime() > 0L ? job.getStartTime() / 1000L : currentTimeSeconds;
        long runningTimeSeconds = currentTimeSeconds - jobRunningStartTimeSeconds;
        if (!job.isCompleted()) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(job.jobRequest().getLabels()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                JobTimeoutManager.$anonfun$timeoutDetective$1(this, job, queuingTimeSeconds, runningTimeSeconds, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$timeoutDetective$2(JobTimeoutManager $this, Tuple2 item) {
        $this.logger().info("Running timeout detection!");
        JobTimeoutManager jobTimeoutManager = $this;
        synchronized (jobTimeoutManager) {
            $this.jobCompleteDelete((String)item._1());
            if ($this.jobExist((String)item._1())) {
                $this.checkAndSwitch$1((EntranceJob)((Object)item._2()));
            }
        }
    }

    public JobTimeoutManager() {
        block0: {
            Logging.$init$((Logging)this);
            this.timeoutJobByName = new ConcurrentHashMap<String, EntranceJob>();
            this.timeoutCheck = BoxesRunTime.unboxToBoolean((Object)EntranceConfiguration$.MODULE$.ENABLE_JOB_TIMEOUT_CHECK().getValue());
            this.timeoutScanInterval = BoxesRunTime.unboxToInt((Object)EntranceConfiguration$.MODULE$.TIMEOUT_SCAN_INTERVAL().getValue());
            if (!this.timeoutCheck()) break block0;
            ScheduledFuture<?> woker = Utils$.MODULE$.defaultScheduler().scheduleAtFixedRate(new Runnable(this){
                private final /* synthetic */ JobTimeoutManager $outer;

                public void run() {
                    Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.$outer.org$apache$linkis$entrance$timeout$JobTimeoutManager$$timeoutDetective(), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                        $anon$1.$anonfun$run$2(this, x0$1);
                        return BoxedUnit.UNIT;
                    });
                }

                public static final /* synthetic */ void $anonfun$run$2($anon$1 $this, Throwable x0$1) {
                    Throwable throwable = x0$1;
                    if (throwable != null) {
                        Throwable throwable2 = throwable;
                        $this.$outer.logger().warn(new StringBuilder(30).append("TimeoutDetective task failed. ").append(throwable2.getMessage()).toString(), throwable2);
                        return;
                    }
                    throw new MatchError((Object)throwable);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.linkis.entrance.timeout.JobTimeoutManager$$anon$1 ), $anonfun$run$2$adapted(org.apache.linkis.entrance.timeout.JobTimeoutManager$$anon$1 java.lang.Throwable )}, serializedLambda);
                }
            }, 0L, this.timeoutScanInterval(), TimeUnit.SECONDS);
        }
    }
}

