/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.utils;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.entrance.conf.EntranceConfiguration$;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf$;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.utils.FileSystemUtils$;
import org.apache.linkis.storage.utils.StorageConfiguration$;
import org.apache.linkis.storage.utils.StorageUtils$;
import scala.Function0;
import scala.Predef$;
import scala.collection.GenSeq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class CommonLogPathUtils$ {
    public static CommonLogPathUtils$ MODULE$;
    private final String resPrefix;

    static {
        new CommonLogPathUtils$();
    }

    public void buildCommonPath(String commonPath) {
        Object object;
        FileSystem fileSystem = this.getRootFs(commonPath);
        fileSystem.init(null);
        String realPath = commonPath.endsWith("/") ? commonPath.substring(0, commonPath.length() - 1) : commonPath;
        FsPath fsPath = new FsPath(realPath);
        if (!fileSystem.exists(fsPath)) {
            FileSystemUtils$.MODULE$.mkdirs(fileSystem, fsPath, StorageUtils$.MODULE$.getJvmUser());
            object = BoxesRunTime.boxToBoolean((boolean)fileSystem.setPermission(fsPath, "770"));
        } else {
            object = BoxedUnit.UNIT;
        }
        Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fileSystem.close());
    }

    public FileSystem getRootFs(String commonPath) {
        FsPath fsPath = new FsPath(commonPath);
        if (StorageUtils$.MODULE$.HDFS().equals(fsPath.getFsType())) {
            return (FileSystem)FSFactory$.MODULE$.getFs(StorageUtils$.MODULE$.HDFS());
        }
        if (StorageUtils$.MODULE$.S3().equals(fsPath.getFsType())) {
            return (FileSystem)FSFactory$.MODULE$.getFs(StorageUtils$.MODULE$.S3());
        }
        return (FileSystem)FSFactory$.MODULE$.getFs(StorageUtils$.MODULE$.FILE(), (String)StorageConfiguration$.MODULE$.LOCAL_ROOT_USER().getValue());
    }

    private String resPrefix() {
        return this.resPrefix;
    }

    public String getResultParentPath(JobRequest jobRequest) {
        scala.collection.mutable.StringBuilder resStb = new scala.collection.mutable.StringBuilder();
        scala.collection.mutable.StringBuilder stringBuilder = resStb.endsWith((GenSeq)Predef$.MODULE$.wrapString("/")) ? resStb.append(this.resPrefix()) : resStb.append(this.resPrefix()).append("/");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date(System.currentTimeMillis());
        String dateString = dateFormat.format(date);
        UserCreatorLabel userCreator = LabelUtil$.MODULE$.getUserCreatorLabel(jobRequest.getLabels());
        Object creator = userCreator == null ? EntranceConfiguration$.MODULE$.DEFAULT_CREATE_SERVICE() : userCreator.getCreator();
        resStb.append("result").append("/").append(dateString).append("/").append(creator);
        return resStb.toString();
    }

    public String getResultPath(JobRequest jobRequest) {
        String parentPath = this.getResultParentPath(jobRequest);
        return new StringBuilder(2).append(parentPath).append("/").append(jobRequest.getExecuteUser()).append("/").append(jobRequest.getId()).toString();
    }

    private CommonLogPathUtils$() {
        MODULE$ = this;
        this.resPrefix = (String)GovernanceCommonConf$.MODULE$.RESULT_SET_STORE_PATH().getValue();
    }
}

