/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.monitor.jobhistory.jobtime;

import com.google.common.cache.Cache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.linkis.monitor.constants.Constants$;
import org.apache.linkis.monitor.core.ob.Observer;
import org.apache.linkis.monitor.core.pac.AbstractScanRule;
import org.apache.linkis.monitor.core.pac.AbstractScanRule$;
import org.apache.linkis.monitor.core.pac.ScannedData;
import org.apache.linkis.monitor.jobhistory.entity.JobHistory;
import org.apache.linkis.monitor.jobhistory.exception.AnomalyScannerException;
import org.apache.linkis.monitor.jobhistory.jobtime.JobTimeExceedHitEvent;
import org.apache.linkis.monitor.until.CacheUtils;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0003\u0006\u0001/!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u001dY\u0005A1A\u0005\n1Ca!\u0015\u0001!\u0002\u0013i\u0005b\u0002*\u0001\u0005\u0004%Ia\u0015\u0005\u0007M\u0002\u0001\u000b\u0011\u0002+\t\u000b\u001d\u0004A\u0011\t5\u0003#){'\rV5nK\u0016C8-Z3e%VdWM\u0003\u0002\f\u0019\u00059!n\u001c2uS6,'BA\u0007\u000f\u0003)QwN\u00195jgR|'/\u001f\u0006\u0003\u001fA\tq!\\8oSR|'O\u0003\u0002\u0012%\u00051A.\u001b8lSNT!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sO\u000e\u00011c\u0001\u0001\u0019AA\u0011\u0011DH\u0007\u00025)\u00111\u0004H\u0001\u0004a\u0006\u001c'BA\u000f\u000f\u0003\u0011\u0019wN]3\n\u0005}Q\"\u0001E!cgR\u0014\u0018m\u0019;TG\u0006t'+\u001e7f!\t\tc%D\u0001#\u0015\t\u0019C%A\u0003vi&d7O\u0003\u0002&!\u000511m\\7n_:L!a\n\u0012\u0003\u000f1{wmZ5oO\u0006QA\u000f\u001b:fg\"|G\u000eZ:\u0011\u0007)z\u0013'D\u0001,\u0015\taS&\u0001\u0003vi&d'\"\u0001\u0018\u0002\t)\fg/Y\u0005\u0003a-\u00121aU3u!\t\u00114H\u0004\u00024sA\u0011AgN\u0007\u0002k)\u0011aGF\u0001\u0007yI|w\u000e\u001e \u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0002\rA\u0013X\rZ3g\u0013\taTH\u0001\u0004TiJLgn\u001a\u0006\u0003u]\n1\u0002[5u\u001f\n\u001cXM\u001d<feB\u0011\u0001iQ\u0007\u0002\u0003*\u0011!\tH\u0001\u0003_\nL!\u0001R!\u0003\u0011=\u00137/\u001a:wKJ\fa\u0001P5oSRtDcA$J\u0015B\u0011\u0001\nA\u0007\u0002\u0015!)\u0001f\u0001a\u0001S!)ah\u0001a\u0001\u007f\u0005IA\u000f\u001b:fg\"|G\u000eZ\u000b\u0002\u001bB\u0011ajT\u0007\u0002o%\u0011\u0001k\u000e\u0002\u0005\u0019>tw-\u0001\u0006uQJ,7\u000f[8mI\u0002\nAb]2b]J+H.\u001a'jgR,\u0012\u0001\u0016\t\u0005+v{F-D\u0001W\u0015\t9\u0006,A\u0003dC\u000eDWM\u0003\u0002&3*\u0011!lW\u0001\u0007O>|w\r\\3\u000b\u0003q\u000b1aY8n\u0013\tqfKA\u0003DC\u000eDW\r\u0005\u0002aG6\t\u0011M\u0003\u0002c[\u0005!A.\u00198h\u0013\ta\u0014\r\u0005\u0002aK&\u0011\u0001+Y\u0001\u000eg\u000e\fgNU;mK2K7\u000f\u001e\u0011\u0002!Q\u0014\u0018nZ4fe&3W*\u0019;dQ\u0016$GCA5m!\tq%.\u0003\u0002lo\t9!i\\8mK\u0006t\u0007\"B7\t\u0001\u0004q\u0017\u0001\u00023bi\u0006\u00042AK8r\u0013\t\u00018F\u0001\u0003MSN$\bCA\rs\u0013\t\u0019(DA\u0006TG\u0006tg.\u001a3ECR\f\u0007")
public class JobTimeExceedRule
extends AbstractScanRule {
    private final long threshold;
    private final Cache<String, Long> scanRuleList;

    private long threshold() {
        return this.threshold;
    }

    private Cache<String, Long> scanRuleList() {
        return this.scanRuleList;
    }

    @Override
    public boolean triggerIfMatched(List<ScannedData> data) {
        if (!this.getHitEvent().isRegistered() || data == null) {
            this.logger().error("ScanRule is not bind with an observer. Will not be triggered");
            return false;
        }
        ArrayList alertData = new ArrayList();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(data).asScala()).foreach((Function1 & Serializable & scala.Serializable)sd -> {
            JobTimeExceedRule.$anonfun$triggerIfMatched$1(this, alertData, sd);
            return BoxedUnit.UNIT;
        });
        this.logger().info(new StringBuilder(26).append("hit ").append(alertData.size()).append(" data in one iteration").toString());
        if (alertData.size() > 0) {
            this.getHitEvent().notifyObserver(this.getHitEvent(), alertData);
            return true;
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$threshold$1(JobTimeExceedRule $this, LongRef t$1, String k) {
        if (k != null) {
            if (t$1.elem > new StringOps(Predef$.MODULE$.augmentString(k)).toLong()) {
                t$1.elem = new StringOps(Predef$.MODULE$.augmentString(k)).toLong();
                return;
            }
            return;
        }
        $this.logger().warn("ignored null input");
    }

    public static final /* synthetic */ void $anonfun$triggerIfMatched$2(JobTimeExceedRule $this, List alertData$1, Object d) {
        if (d instanceof JobHistory) {
            long elapse;
            JobHistory jobHistory = (JobHistory)d;
            String status = jobHistory.getStatus().toUpperCase(Locale.getDefault());
            Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Constants$.MODULE$.UNFINISHED_JOB_STATUS())).contains((Object)status) ? ((elapse = System.currentTimeMillis() - jobHistory.getCreatedTime().getTime()) / 1000L >= $this.threshold() ? BoxesRunTime.boxToBoolean((boolean)alertData$1.add((JobHistory)d)) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
            $this.scanRuleList().put((Object)"jobhistoryScan", (Object)jobHistory.getId());
            return;
        }
        $this.logger().warn(new StringBuilder(34).append("Ignored wrong input data Type : ").append(d).append(", ").append(d.getClass().getCanonicalName()).toString());
    }

    public static final /* synthetic */ void $anonfun$triggerIfMatched$1(JobTimeExceedRule $this, List alertData$1, ScannedData sd) {
        if (sd != null && sd.getData() != null) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sd.getData()).asScala()).foreach((Function1 & Serializable & scala.Serializable)d -> {
                JobTimeExceedRule.$anonfun$triggerIfMatched$2($this, alertData$1, d);
                return BoxedUnit.UNIT;
            });
            return;
        }
        $this.logger().warn("Ignored null scanned data");
    }

    public JobTimeExceedRule(Set<String> thresholds, Observer hitObserver) {
        JobTimeExceedHitEvent x$1 = new JobTimeExceedHitEvent();
        Observer x$2 = hitObserver;
        String x$3 = AbstractScanRule$.MODULE$.$lessinit$greater$default$1();
        super(x$3, x$1, x$2);
        if (thresholds == null) {
            throw new AnomalyScannerException(21304, "thresholds should not be null");
        }
        LongRef t = LongRef.create((long)Long.MAX_VALUE);
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(thresholds).asScala()).foreach((Function1 & Serializable & scala.Serializable)k -> {
            JobTimeExceedRule.$anonfun$threshold$1(this, t, k);
            return BoxedUnit.UNIT;
        });
        this.threshold = t.elem;
        this.scanRuleList = CacheUtils.cacheBuilder;
    }
}

