/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.monitor.scheduled;

import com.google.gson.internal.LinkedTreeMap;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.common.utils.Utils;
import org.apache.linkis.governance.common.entity.task.RequestPersistTask;
import org.apache.linkis.httpclient.dws.config.DWSClientConfig;
import org.apache.linkis.monitor.config.MonitorConfig;
import org.apache.linkis.monitor.constants.Constants;
import org.apache.linkis.monitor.until.HttpsUntils;
import org.apache.linkis.monitor.utils.alert.AlertDesc;
import org.apache.linkis.monitor.utils.alert.ims.MonitorAlertUtils;
import org.apache.linkis.monitor.utils.alert.ims.PooledImsAlertUtils;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.apache.linkis.ujes.client.UJESClient;
import org.apache.linkis.ujes.client.UJESClientImpl;
import org.apache.linkis.ujes.client.request.GetTableStatisticInfoAction;
import org.apache.linkis.ujes.client.request.JobSubmitAction;
import org.apache.linkis.ujes.client.response.GetTableStatisticInfoResult;
import org.apache.linkis.ujes.client.response.JobExecuteResult;
import org.apache.linkis.ujes.client.response.JobInfoResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class UserModeMonitor {
    private static final Logger logger = LoggerFactory.getLogger(UserModeMonitor.class);
    private static final DWSClientConfig clientConfig = HttpsUntils.dwsClientConfig;
    private static final UJESClient client = new UJESClientImpl(clientConfig);

    @Scheduled(cron="${linkis.monitor.user.mode.cron}")
    public void job() {
        Optional.ofNullable(MonitorConfig.USER_MODE_ENGINE.getValue()).ifPresent(configStr -> {
            ArrayList userModeStr = (ArrayList)BDPJettyServerHelper.gson().fromJson(configStr, ArrayList.class);
            userModeStr.forEach(engine -> {
                JobExecuteResult jobExecuteResult = UserModeMonitor.toSubmit((LinkedTreeMap<String, String>)engine);
                logger.info("start run engineType: {},job id : {}", engine.get((Object)"engineType"), (Object)jobExecuteResult.taskID());
                HashMap<String, String> parms = new HashMap<String, String>();
                parms.put("$engineType", (String)engine.get((Object)"engineType"));
                parms.put("$url", (String)Configuration.GATEWAY_URL().getValue());
                parms.put("$jobId", jobExecuteResult.taskID());
                Utils.sleepQuietly((long)((Integer)MonitorConfig.USER_MODE_TIMEOUT.getValue() * 1000));
                JobInfoResult jobInfo = client.getJobInfo(jobExecuteResult);
                if (jobInfo.isCompleted()) {
                    if (jobInfo.getJobStatus().equals("Failed")) {
                        logger.info("run fail engineType: {},job id : {}", engine.get((Object)"engineType"), (Object)jobExecuteResult.taskID());
                        RequestPersistTask requestPersistTask = jobInfo.getRequestPersistTask();
                        parms.put("$errorCode", String.valueOf(requestPersistTask.getErrCode()));
                        parms.put("$errorMsg", requestPersistTask.getErrDesc());
                        Map<String, AlertDesc> failedAlerts = MonitorAlertUtils.getAlerts(Constants.USER_RESOURCE_MONITOR(), parms);
                        PooledImsAlertUtils.addAlert(failedAlerts.get("12012"));
                    }
                } else {
                    logger.info("run timeout engineType: {},job id : {}", engine.get((Object)"engineType"), (Object)jobExecuteResult.taskID());
                    Map<String, AlertDesc> alerts = MonitorAlertUtils.getAlerts(Constants.USER_RESOURCE_MONITOR(), parms);
                    PooledImsAlertUtils.addAlert(alerts.get("12011"));
                }
            });
        });
    }

    private static JobExecuteResult toSubmit(LinkedTreeMap<String, String> engine) {
        HashMap<String, Object> labels = new HashMap<String, Object>();
        labels.put("engineType", engine.get((Object)"engineType"));
        labels.put("userCreator", (String)engine.get((Object)"executeUser") + "-IDE");
        labels.put("codeType", engine.get((Object)"runType"));
        HashMap startupMap = new HashMap(16);
        JobSubmitAction jobSubmitAction = JobSubmitAction.builder().addExecuteCode((String)engine.get((Object)"code")).setStartupParams(startupMap).setUser((String)engine.get((Object)"executeUser")).addExecuteUser((String)engine.get((Object)"executeUser")).setLabels(labels).build();
        return client.submit(jobSubmitAction);
    }

    @Scheduled(cron="${linkis.monitor.user.db.cron:0 0/10 * * * ?}")
    public void dbJob() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("readTimeout", MonitorConfig.USER_MODE_INTERFACE_TIMEOUT.getValue());
        DWSClientConfig clientConfig = HttpsUntils.createClientConfig(null, properties);
        UJESClientImpl ujesClient = new UJESClientImpl(clientConfig);
        GetTableStatisticInfoAction builder = GetTableStatisticInfoAction.builder().setUser("hadoop").setDatabase("default").setTable("dual").builder();
        HashMap parms = new HashMap();
        try {
            GetTableStatisticInfoResult tableStatisticInfo = ujesClient.getTableStatisticInfo(builder);
            if (tableStatisticInfo.getStatus() != 0) {
                logger.info("\u5143\u6570\u636e\u67e5\u8be2\u670d\u52a1\u7528\u6237\u6001\uff0c\u6267\u884c\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + tableStatisticInfo.getMessage());
            }
        }
        catch (Exception e) {
            if (e instanceof SocketTimeoutException) {
                Integer timeoutValue = (Integer)MonitorConfig.USER_MODE_INTERFACE_TIMEOUT.getValue();
                long timeout = TimeUnit.MILLISECONDS.toSeconds(timeoutValue.intValue());
                logger.info("\u5143\u6570\u636e\u67e5\u8be2\u670d\u52a1\u7528\u6237\u6001\uff0c\u6267\u884c\u8d85\u65f6\uff1a" + timeout + "\u79d2");
            }
            logger.error("\u5143\u6570\u636e\u67e5\u8be2\u670d\u52a1\u7528\u6237\u6001\uff0c\u6267\u884c\u5f02\u5e38\uff1a" + e);
        }
    }
}

