/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.encoding;

import feign.RequestTemplate;
import java.util.Collection;
import java.util.Map;
import org.springframework.cloud.openfeign.encoding.BaseRequestInterceptor;
import org.springframework.cloud.openfeign.encoding.FeignClientEncodingProperties;

public class FeignContentGzipEncodingInterceptor
extends BaseRequestInterceptor {
    protected FeignContentGzipEncodingInterceptor(FeignClientEncodingProperties properties) {
        super(properties);
    }

    public void apply(RequestTemplate template) {
        if (this.requiresCompression(template)) {
            this.addHeader(template, "Content-Encoding", "gzip", "deflate");
        }
    }

    private boolean requiresCompression(RequestTemplate template) {
        Map headers = template.headers();
        return this.matchesMimeType((Collection)headers.get("Content-Type")) && this.contentLengthExceedThreshold((Collection)headers.get("Content-Length"));
    }

    private boolean contentLengthExceedThreshold(Collection<String> contentLength) {
        try {
            if (contentLength == null || contentLength.size() != 1) {
                return false;
            }
            String strLen = contentLength.iterator().next();
            long length = Long.parseLong(strLen);
            return length > (long)this.getProperties().getMinRequestSize();
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private boolean matchesMimeType(Collection<String> contentTypes) {
        if (contentTypes == null || contentTypes.size() == 0) {
            return false;
        }
        if (this.getProperties().getMimeTypes() == null || this.getProperties().getMimeTypes().length == 0) {
            return true;
        }
        for (String mimeType : this.getProperties().getMimeTypes()) {
            if (!contentTypes.contains(mimeType)) continue;
            return true;
        }
        return false;
    }
}

