/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.computation.executor.bml;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.bml.client.BmlClient;
import org.apache.linkis.bml.client.BmlClientFactory;
import org.apache.linkis.bml.protocol.BmlDownloadResponse;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.common.creation.EngineCreationContext;
import org.apache.linkis.engineconn.computation.executor.bml.BmlHookDownloadException;
import org.apache.linkis.engineconn.computation.executor.entity.EngineConnTask;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineconn.computation.executor.hook.ComputationExecutorHook;
import org.apache.linkis.engineconn.computation.executor.utlis.ComputationEngineConstant$;
import org.apache.linkis.engineconn.core.util.EngineConnUtils$;
import org.apache.linkis.governance.common.utils.GovernanceConstant$;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.storage.utils.StorageUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001I4Aa\u0004\t\u0001?!)A\u0007\u0001C\u0001k!)\u0001\b\u0001C!s!)Q\t\u0001C!\r\"9!\n\u0001b\u0001\n\u0013Y\u0005B\u0002'\u0001A\u0003%!\bC\u0004N\u0001\t\u0007I\u0011B&\t\r9\u0003\u0001\u0015!\u0003;\u0011\u001dy\u0005A1A\u0005\nACa\u0001\u0017\u0001!\u0002\u0013\t\u0006bB-\u0001\u0005\u0004%Ia\u0013\u0005\u00075\u0002\u0001\u000b\u0011\u0002\u001e\t\u000fm\u0003!\u0019!C\u0005\u0017\"1A\f\u0001Q\u0001\niBQ!\u0018\u0001\u0005By\u0013qCQ7m\u000b:<\u0017N\\3Qe\u0016,\u00050Z2vi\u0016Dun\\6\u000b\u0005E\u0011\u0012a\u00012nY*\u00111\u0003F\u0001\tKb,7-\u001e;pe*\u0011QCF\u0001\fG>l\u0007/\u001e;bi&|gN\u0003\u0002\u00181\u0005QQM\\4j]\u0016\u001cwN\u001c8\u000b\u0005eQ\u0012A\u00027j].L7O\u0003\u0002\u001c9\u00051\u0011\r]1dQ\u0016T\u0011!H\u0001\u0004_J<7\u0001A\n\u0005\u0001\u00012C\u0006\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VM\u001a\t\u0003O)j\u0011\u0001\u000b\u0006\u0003SI\tA\u0001[8pW&\u00111\u0006\u000b\u0002\u0018\u0007>l\u0007/\u001e;bi&|g.\u0012=fGV$xN\u001d%p_.\u0004\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\u000bU$\u0018\u000e\\:\u000b\u0005EB\u0012AB2p[6|g.\u0003\u00024]\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u00017!\t9\u0004!D\u0001\u0011\u0003-9W\r\u001e%p_.t\u0015-\\3\u0015\u0003i\u0002\"a\u000f\"\u000f\u0005q\u0002\u0005CA\u001f#\u001b\u0005q$BA \u001f\u0003\u0019a$o\\8u}%\u0011\u0011II\u0001\u0007!J,G-\u001a4\n\u0005\r#%AB*ue&twM\u0003\u0002BE\u0005Aq-\u001a;Pe\u0012,'\u000fF\u0001H!\t\t\u0003*\u0003\u0002JE\t\u0019\u0011J\u001c;\u0002\u0017A\u0014xnY3tgV\u001bXM]\u000b\u0002u\u0005a\u0001O]8dKN\u001cXk]3sA\u0005YA-\u001a4bk2$Xk]3s\u00031!WMZ1vYR,6/\u001a:!\u0003%\u0011W\u000e\\\"mS\u0016tG/F\u0001R!\t\u0011f+D\u0001T\u0015\t!V+\u0001\u0004dY&,g\u000e\u001e\u0006\u0003#aI!aV*\u0003\u0013\tkGn\u00117jK:$\u0018A\u00032nY\u000ec\u0017.\u001a8uA\u0005I1/\u001a9fe\u0006$xN]\u0001\u000bg\u0016\u0004XM]1u_J\u0004\u0013\u0001\u00039bi\"$\u0016\u0010]3\u0002\u0013A\fG\u000f\u001b+za\u0016\u0004\u0013!\u00062fM>\u0014X-\u0012=fGV$xN]#yK\u000e,H/\u001a\u000b\u0005u};\u0007\u000fC\u0003a\u001d\u0001\u0007\u0011-\u0001\ff]\u001eLg.Z#yK\u000e,H/[8o\u0007>tG/\u001a=u!\t\u0011W-D\u0001d\u0015\t!'#A\u0004fq\u0016\u001cW\u000f^3\n\u0005\u0019\u001c'AF#oO&tW-\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\u000b!t\u0001\u0019A5\u0002+\u0015tw-\u001b8f\u0007J,\u0017\r^5p]\u000e{g\u000e^3yiB\u0011!N\\\u0007\u0002W*\u0011A.\\\u0001\tGJ,\u0017\r^5p]*\u0011\u0011GF\u0005\u0003_.\u0014Q#\u00128hS:,7I]3bi&|gnQ8oi\u0016DH\u000fC\u0003r\u001d\u0001\u0007!(\u0001\u0003d_\u0012,\u0007")
public class BmlEnginePreExecuteHook
implements ComputationExecutorHook,
Logging {
    private final String processUser;
    private final String defaultUser;
    private final BmlClient bmlClient;
    private final String seperator;
    private final String pathType;
    private Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    @Override
    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    @Override
    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    @Override
    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    @Override
    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    @Override
    public void afterExecutorExecute(EngineConnTask engineConnTask, ExecuteResponse executeResponse) {
        ComputationExecutorHook.afterExecutorExecute$(this, engineConnTask, executeResponse);
    }

    private Logger logger$lzycompute() {
        BmlEnginePreExecuteHook bmlEnginePreExecuteHook = this;
        synchronized (bmlEnginePreExecuteHook) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String getHookName() {
        return "BmlEnginePreExecuteHook";
    }

    @Override
    public int getOrder() {
        return ComputationEngineConstant$.MODULE$.CS_HOOK_ORDER() + 1;
    }

    private String processUser() {
        return this.processUser;
    }

    private String defaultUser() {
        return this.defaultUser;
    }

    private BmlClient bmlClient() {
        return this.bmlClient;
    }

    private String seperator() {
        return this.seperator;
    }

    private String pathType() {
        return this.pathType;
    }

    @Override
    public String beforeExecutorExecute(EngineExecutionContext engineExecutionContext, EngineCreationContext engineCreationContext, String code) {
        block2: {
            Map<String, Object> props = engineExecutionContext.getProperties();
            if (props == null || !props.containsKey(GovernanceConstant$.MODULE$.TASK_RESOURCES_STR())) break block2;
            Option<String> jobId = engineExecutionContext.getJobId();
            Object object = props.get(GovernanceConstant$.MODULE$.TASK_RESOURCES_STR());
            if (object instanceof List) {
                List list = (List)object;
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    BmlEnginePreExecuteHook.$anonfun$beforeExecutorExecute$1(this, jobId, x0$1);
                    return BoxedUnit.UNIT;
                });
            } else {
                this.logger().info(new StringBuilder(20).append("Invalid resources : ").append(EngineConnUtils$.MODULE$.GSON().toJson(object)).toString());
            }
        }
        return code;
    }

    public static final /* synthetic */ BmlDownloadResponse $anonfun$beforeExecutorExecute$2(BmlEnginePreExecuteHook $this, String resourceId$1, String version$1, String fullPath$1) {
        return $this.bmlClient().downloadShareResource($this.processUser(), resourceId$1, version$1, fullPath$1, true);
    }

    public static final /* synthetic */ void $anonfun$beforeExecutorExecute$1(BmlEnginePreExecuteHook $this, Option jobId$1, Object x0$1) {
        Object object = x0$1;
        if (object instanceof Map) {
            String fullPath;
            String version;
            Map map = (Map)object;
            String fileName = map.get(GovernanceConstant$.MODULE$.TASK_RESOURCE_FILE_NAME_STR()).toString();
            String resourceId = map.get(GovernanceConstant$.MODULE$.TASK_RESOURCE_ID_STR()).toString();
            BmlDownloadResponse response = (BmlDownloadResponse)Utils$.MODULE$.tryCatch(() -> BmlEnginePreExecuteHook.$anonfun$beforeExecutorExecute$2($this, resourceId, version = map.get(GovernanceConstant$.MODULE$.TASK_RESOURCE_VERSION_STR()).toString(), fullPath = fileName), (Function1 & Serializable & scala.Serializable)x0$2 -> {
                Throwable throwable = x0$2;
                if (throwable instanceof ErrorException) {
                    ErrorException errorException = (ErrorException)throwable;
                    $this.logger().error(new StringBuilder(29).append("download resource for ").append(jobId$1).append(" failed").toString(), (Throwable)errorException);
                    throw errorException;
                }
                if (throwable != null) {
                    Throwable throwable2 = throwable;
                    $this.logger().error(new StringBuilder(29).append("download resource for ").append(jobId$1).append(" failed").toString(), throwable2);
                    BmlHookDownloadException e1 = new BmlHookDownloadException(throwable2.getMessage());
                    e1.initCause(throwable2);
                    throw throwable2;
                }
                throw new MatchError((Object)throwable);
            });
            if (response.isSuccess()) {
                $this.logger().info(new StringBuilder(50).append("for job ").append(jobId$1).append(" resourceId ").append(resourceId).append(" version ").append(version).append(" download to path ").append(fullPath).append(" ok").toString());
                return;
            }
            $this.logger().warn(new StringBuilder(54).append("for job ").append(jobId$1).append(" resourceId ").append(resourceId).append(" version ").append(version).append(" download to path ").append(fullPath).append(" Failed").toString());
            return;
        }
        $this.logger().warn("job resource cannot download");
    }

    public BmlEnginePreExecuteHook() {
        ComputationExecutorHook.$init$(this);
        Logging.$init$((Logging)this);
        this.processUser = System.getProperty("user.name");
        this.defaultUser = "hadoop";
        this.bmlClient = StringUtils.isNotEmpty((CharSequence)this.processUser()) ? BmlClientFactory.createBmlClient((String)this.processUser()) : BmlClientFactory.createBmlClient((String)this.defaultUser());
        this.seperator = File.separator;
        this.pathType = StorageUtils$.MODULE$.FILE_SCHEMA();
    }
}

