/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.basedatamanager.server.restful;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.linkis.basedatamanager.server.domain.UdfManagerEntity;
import org.apache.linkis.basedatamanager.server.service.UdfManagerService;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"UdfManagerRestfulApi"})
@RestController
@RequestMapping(path={"/basedata-manager/udf-manager"})
public class UdfManagerRestfulApi {
    @Autowired
    UdfManagerService udfManagerService;

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="string", name="searchName"), @ApiImplicitParam(paramType="query", dataType="int", name="currentPage"), @ApiImplicitParam(paramType="query", dataType="int", name="pageSize")})
    @ApiOperation(value="list", notes="Query list data of UDF Manager", httpMethod="GET")
    @RequestMapping(path={""}, method={RequestMethod.GET})
    public Message list(HttpServletRequest request, String searchName, Integer currentPage, Integer pageSize) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Query list data of UDF Manager,search name:" + searchName));
        PageInfo pageList = this.udfManagerService.getListByPage(searchName, currentPage, pageSize);
        return Message.ok((String)"").data("list", (Object)pageList);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", dataType="long", name="id")})
    @ApiOperation(value="Get a Datasource UDF Manager", notes="get data by id", httpMethod="GET")
    @RequestMapping(path={"/{id}"}, method={RequestMethod.GET})
    public Message get(HttpServletRequest request, @PathVariable(value="id") Long id) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Get a Datasource UDF Manager,id:" + id.toString()));
        UdfManagerEntity errorCode = (UdfManagerEntity)this.udfManagerService.getById(id);
        return Message.ok((String)"").data("item", (Object)errorCode);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="body", dataType="UdfManagerEntity", name="udfManagerEntity")})
    @ApiOperation(value="add", notes="Add a UDF Manager Record", httpMethod="POST")
    @RequestMapping(path={""}, method={RequestMethod.POST})
    public Message add(HttpServletRequest request, @RequestBody UdfManagerEntity udfManagerEntity) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Add a UDF Manager Record," + udfManagerEntity.toString()));
        if (!Configuration.isAdmin((String)username)) {
            return Message.error((String)("User '" + username + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper((Object)udfManagerEntity).eq((Object)"user_name", (Object)udfManagerEntity.getUserName());
        UdfManagerEntity udfManager = (UdfManagerEntity)this.udfManagerService.getOne((Wrapper)queryWrapper);
        if (udfManager == null) {
            udfManagerEntity.setCreateTime(new Date());
            udfManagerEntity.setUpdateTime(new Date());
            boolean result = this.udfManagerService.save(udfManagerEntity);
            return Message.ok((String)"").data("result", (Object)result);
        }
        return Message.error((String)("The " + udfManager.getUserName() + " already exists,Please add again!"));
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", dataType="long", name="id")})
    @ApiOperation(value="remove", notes="Remove a UDF Manager Record by id", httpMethod="DELETE")
    @RequestMapping(path={"/{id}"}, method={RequestMethod.DELETE})
    public Message remove(HttpServletRequest request, @PathVariable(value="id") Long id) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Remove a UDF Manager Record,id:" + id.toString()));
        if (!Configuration.isAdmin((String)username)) {
            return Message.error((String)("User '" + username + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        boolean result = this.udfManagerService.removeById(id);
        return Message.ok((String)"").data("result", (Object)result);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="body", dataType="UdfManagerEntity", name="udfManagerEntity")})
    @ApiOperation(value="update", notes="Update a Datasource Access Record", httpMethod="PUT")
    @RequestMapping(path={""}, method={RequestMethod.PUT})
    public Message update(HttpServletRequest request, @RequestBody UdfManagerEntity udfManagerEntity) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Update a Datasource Access Record,id:" + udfManagerEntity.getId().toString()));
        if (!Configuration.isAdmin((String)username)) {
            return Message.error((String)("User '" + username + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_name", (Object)udfManagerEntity.getUserName());
        UdfManagerEntity udfManager = (UdfManagerEntity)this.udfManagerService.getOne((Wrapper)queryWrapper);
        if (udfManager == null) {
            udfManagerEntity.setUpdateTime(new Date());
            boolean result = this.udfManagerService.updateById(udfManagerEntity);
            return Message.ok((String)"").data("result", (Object)result);
        }
        return Message.error((String)("The " + udfManager.getUserName() + " already exists,Please update again!"));
    }
}

