/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.common.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.common.exception.VariableOperationFailedException;
import org.apache.linkis.common.utils.CodeAndRunTypeUtils;

public class VariableOperationUtils {
    private static final String DOLLAR = "&";
    private static final String PLACEHOLDER_SPLIT = "%";
    private static final String PLACEHOLDER_LEFT = "{";
    private static final String LEFT = "&{";
    private static final String PLACEHOLDER_RIGHT = "}";
    private static final String CYCLE_YEAR = "y";
    private static final String CYCLE_MONTH = "M";
    private static final String CYCLE_DAY = "d";
    private static final String CYCLE_HOUR = "H";
    private static final String CYCLE_MINUTE = "m";
    private static final String CYCLE_SECOND = "s";
    private static final String[] CYCLES = new String[]{"y", "M", "d", "H", "m", "s"};
    private static final ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().enable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_TRAILING_TOKENS})).build();

    public static ZonedDateTime toZonedDateTime(Date date, ZoneId zoneId) {
        if (Configuration.VARIABLE_OPERATION_USE_NOW()) {
            LocalTime currentTime = LocalTime.now();
            LocalDate localDate = date.toInstant().atZone(zoneId).toLocalDate();
            LocalDateTime localDateTime = LocalDateTime.of(localDate, currentTime);
            return ZonedDateTime.of(localDateTime, zoneId);
        }
        Instant instant = date.toInstant();
        LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
        return ZonedDateTime.of(localDateTime, zoneId);
    }

    public static ZonedDateTime toZonedDateTime(Date date) {
        return VariableOperationUtils.toZonedDateTime(date, ZoneId.systemDefault());
    }

    @Deprecated
    public static String replaces(ZonedDateTime dateTime, String str) throws VariableOperationFailedException {
        try {
            JsonNode rootNode = mapper.readTree(str);
            if (rootNode.isArray() || rootNode.isObject()) {
                VariableOperationUtils.replaceJson(dateTime, rootNode);
                return rootNode.toString();
            }
        }
        catch (Exception e) {
            return VariableOperationUtils.replace(dateTime, str);
        }
        return VariableOperationUtils.replace(dateTime, str);
    }

    public static String replaces(String codeType, ZonedDateTime dateTime, String str) throws VariableOperationFailedException {
        String languageType = CodeAndRunTypeUtils.getLanguageTypeByCodeType(codeType, "");
        if (languageType.equals(CodeAndRunTypeUtils.LANGUAGE_TYPE_JSON())) {
            try {
                JsonNode rootNode = mapper.readTree(str);
                if (rootNode.isArray() || rootNode.isObject()) {
                    VariableOperationUtils.replaceJson(dateTime, rootNode);
                    return rootNode.toString();
                }
            }
            catch (Exception e) {
                return VariableOperationUtils.replace(dateTime, str);
            }
        }
        return VariableOperationUtils.replace(dateTime, str);
    }

    private static String replace(ZonedDateTime dateTime, String str) throws VariableOperationFailedException {
        StringBuilder buffer = new StringBuilder(str);
        int startIndex = str.indexOf(LEFT);
        while (startIndex != -1) {
            int endIndex = buffer.indexOf(PLACEHOLDER_RIGHT, startIndex);
            if (endIndex != -1) {
                String placeHolder = buffer.substring(startIndex, endIndex + 1);
                String content = placeHolder.replace(LEFT, "").replace(PLACEHOLDER_RIGHT, "").trim();
                String[] parts = content.split(PLACEHOLDER_SPLIT);
                try {
                    ZonedDateTime ndt = dateTime;
                    for (int i = 1; i < parts.length; ++i) {
                        ndt = VariableOperationUtils.changeDateTime(ndt, parts[i]);
                    }
                    String newContent = ndt.format(DateTimeFormatter.ofPattern(parts[0]));
                    if (buffer.substring(startIndex, endIndex + 1).contains(DOLLAR)) {
                        buffer.replace(startIndex, endIndex + 1, newContent);
                    }
                    startIndex = buffer.indexOf(LEFT, startIndex + newContent.length());
                    continue;
                }
                catch (IllegalArgumentException e1) {
                    startIndex = buffer.indexOf(LEFT, endIndex);
                    continue;
                }
                catch (Exception e2) {
                    throw new VariableOperationFailedException(20050, "variable operation expression" + e2.getMessage(), e2);
                }
            }
            startIndex = -1;
        }
        return buffer.toString();
    }

    private static ZonedDateTime changeDateTime(ZonedDateTime dateTime, String str) {
        if (str == null || str.isEmpty()) {
            return dateTime;
        }
        for (String cycle : CYCLES) {
            if (!str.contains(cycle)) continue;
            switch (cycle) {
                case "d": {
                    return dateTime.plusDays(Integer.parseInt(str.replace(CYCLE_DAY, "")));
                }
                case "H": {
                    return dateTime.plusHours(Integer.parseInt(str.replace(CYCLE_HOUR, "")));
                }
                case "m": {
                    return dateTime.plusMinutes(Integer.parseInt(str.replace(CYCLE_MINUTE, "")));
                }
                case "M": {
                    return dateTime.plusMonths(Integer.parseInt(str.replace(CYCLE_MONTH, "")));
                }
                case "s": {
                    return dateTime.plusSeconds(Integer.parseInt(str.replace(CYCLE_SECOND, "")));
                }
                case "y": {
                    return dateTime.plusYears(Integer.parseInt(str.replace(CYCLE_YEAR, "")));
                }
            }
        }
        return dateTime;
    }

    private static void replaceJson(ZonedDateTime dateTime, JsonNode object) throws VariableOperationFailedException {
        block7: {
            block6: {
                if (!object.isArray()) break block6;
                ArrayNode arrayNode = (ArrayNode)object;
                for (int i = 0; i < arrayNode.size(); ++i) {
                    JsonNode temp = arrayNode.get(i);
                    if (temp.isArray()) {
                        VariableOperationUtils.replaceJson(dateTime, temp);
                        continue;
                    }
                    if (temp.isObject()) {
                        VariableOperationUtils.replaceJson(dateTime, temp);
                        continue;
                    }
                    arrayNode.set(i, VariableOperationUtils.replace(dateTime, temp.toString()));
                }
                break block7;
            }
            if (!object.isObject()) break block7;
            ObjectNode objectNode = (ObjectNode)object;
            Iterator fields = object.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                JsonNode temp = (JsonNode)field.getValue();
                if (temp.isArray()) {
                    VariableOperationUtils.replaceJson(dateTime, temp);
                    continue;
                }
                if (temp.isObject()) {
                    VariableOperationUtils.replaceJson(dateTime, temp);
                    continue;
                }
                objectNode.put((String)field.getKey(), VariableOperationUtils.replace(dateTime, temp.toString()));
            }
        }
    }
}

