/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.ddl;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.metadata.conf.MdqConfiguration$;
import org.apache.linkis.metadata.ddl.DDLCreator;
import org.apache.linkis.metadata.ddl.SQLConst;
import org.apache.linkis.metadata.domain.mdq.bo.MdqTableBO;
import org.apache.linkis.metadata.domain.mdq.bo.MdqTableFieldsInfoBO;
import org.apache.linkis.metadata.errorcode.LinkisMetadataErrorCodeSummary;
import org.apache.linkis.metadata.exception.MdqIllegalParamException;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ScalaDDLCreator$
implements DDLCreator,
SQLConst,
Logging {
    public static ScalaDDLCreator$ MODULE$;
    private Logger logger;
    private final String SPARK_SQL;
    private final String LEFT_PARENTHESES;
    private final String RIGHT_PARENTHESES;
    private final String COMMA;
    private final String SPACE;
    private final String COMMENT;
    private final String CREATE_TABLE;
    private final String PARTITIONED_BY;
    private final String LINE_BREAK;
    private final String MARKS;
    private final String SINGLE_MARK;
    private final String STORED_AS;
    private final String SEMICOLON;
    private final String CODE;
    private final String USER;
    private volatile boolean bitmap$0;

    static {
        new ScalaDDLCreator$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        ScalaDDLCreator$ scalaDDLCreator$ = this;
        synchronized (scalaDDLCreator$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String SPARK_SQL() {
        return this.SPARK_SQL;
    }

    @Override
    public String LEFT_PARENTHESES() {
        return this.LEFT_PARENTHESES;
    }

    @Override
    public String RIGHT_PARENTHESES() {
        return this.RIGHT_PARENTHESES;
    }

    @Override
    public String COMMA() {
        return this.COMMA;
    }

    @Override
    public String SPACE() {
        return this.SPACE;
    }

    @Override
    public String COMMENT() {
        return this.COMMENT;
    }

    @Override
    public String CREATE_TABLE() {
        return this.CREATE_TABLE;
    }

    @Override
    public String PARTITIONED_BY() {
        return this.PARTITIONED_BY;
    }

    @Override
    public String LINE_BREAK() {
        return this.LINE_BREAK;
    }

    @Override
    public String MARKS() {
        return this.MARKS;
    }

    @Override
    public String SINGLE_MARK() {
        return this.SINGLE_MARK;
    }

    @Override
    public String STORED_AS() {
        return this.STORED_AS;
    }

    @Override
    public String SEMICOLON() {
        return this.SEMICOLON;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$SPARK_SQL_$eq(String x$1) {
        this.SPARK_SQL = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$LEFT_PARENTHESES_$eq(String x$1) {
        this.LEFT_PARENTHESES = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$RIGHT_PARENTHESES_$eq(String x$1) {
        this.RIGHT_PARENTHESES = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$COMMA_$eq(String x$1) {
        this.COMMA = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$SPACE_$eq(String x$1) {
        this.SPACE = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$COMMENT_$eq(String x$1) {
        this.COMMENT = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$CREATE_TABLE_$eq(String x$1) {
        this.CREATE_TABLE = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$PARTITIONED_BY_$eq(String x$1) {
        this.PARTITIONED_BY = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$LINE_BREAK_$eq(String x$1) {
        this.LINE_BREAK = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$MARKS_$eq(String x$1) {
        this.MARKS = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$SINGLE_MARK_$eq(String x$1) {
        this.SINGLE_MARK = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$STORED_AS_$eq(String x$1) {
        this.STORED_AS = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$SQLConst$_setter_$SEMICOLON_$eq(String x$1) {
        this.SEMICOLON = x$1;
    }

    @Override
    public String CODE() {
        return this.CODE;
    }

    @Override
    public String USER() {
        return this.USER;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$DDLCreator$_setter_$CODE_$eq(String x$1) {
        this.CODE = x$1;
    }

    @Override
    public void org$apache$linkis$metadata$ddl$DDLCreator$_setter_$USER_$eq(String x$1) {
        this.USER = x$1;
    }

    @Override
    public String createDDL(MdqTableBO tableInfo, String user) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        this.logger().info(new StringBuilder(53).append("begin to generate ddl for user ").append(user).append(" using ScalaDDLCreator").toString());
        String dbName = tableInfo.getTableBaseInfo().getBase().getDatabase();
        String tableName = tableInfo.getTableBaseInfo().getBase().getName();
        List<MdqTableFieldsInfoBO> fields = tableInfo.getTableFieldsInfo();
        scala.collection.mutable.StringBuilder createTableCode = new scala.collection.mutable.StringBuilder();
        createTableCode.append(this.SPARK_SQL()).append(this.LEFT_PARENTHESES()).append(this.MARKS()).append(this.CREATE_TABLE());
        createTableCode.append(dbName).append(".").append(tableName);
        createTableCode.append(this.LEFT_PARENTHESES());
        ArrayBuffer partitions = new ArrayBuffer();
        ArrayBuffer fieldsArray = new ArrayBuffer();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fields).asScala()).foreach((Function1 & Serializable & scala.Serializable)field -> {
            if (field.getPartitionField() != null && BoxesRunTime.equals((Object)field.getPartitionField(), (Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                return partitions.$plus$eq(field);
            }
            String name = field.getName();
            String _type = field.getType();
            String desc = field.getComment();
            if (StringUtils.isNotEmpty((CharSequence)desc)) {
                return fieldsArray.$plus$eq((Object)new StringBuilder(0).append(name).append(MODULE$.SPACE()).append(_type).append(MODULE$.SPACE()).append(MODULE$.COMMENT()).append(MODULE$.SPACE()).append(MODULE$.SINGLE_MARK()).append(desc).append(MODULE$.SINGLE_MARK()).toString());
            }
            return fieldsArray.$plus$eq((Object)new StringBuilder(0).append(name).append(MODULE$.SPACE()).append(_type).toString());
        });
        createTableCode.append(fieldsArray.mkString(this.COMMA())).append(this.RIGHT_PARENTHESES()).append(this.SPACE());
        if (partitions.nonEmpty()) {
            ArrayBuffer partitionArr = new ArrayBuffer();
            partitions.foreach((Function1 & Serializable & scala.Serializable)p -> {
                String name = p.getName();
                String _type = p.getType();
                if (StringUtils.isEmpty((CharSequence)name) || StringUtils.isEmpty((CharSequence)_type)) {
                    throw new MdqIllegalParamException(LinkisMetadataErrorCodeSummary.PARTITION_IS_NULL.getErrorDesc());
                }
                return partitionArr.$plus$eq((Object)new StringBuilder(0).append(name).append(MODULE$.SPACE()).append(_type).toString());
            });
            boxedUnit2 = createTableCode.append(this.PARTITIONED_BY()).append(this.LEFT_PARENTHESES()).append(partitionArr.mkString(this.COMMA())).append(this.RIGHT_PARENTHESES()).append(this.SPACE());
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (partitions.isEmpty() && Predef$.MODULE$.Boolean2boolean(tableInfo.getTableBaseInfo().getBase().getPartitionTable())) {
            String partition = (String)MdqConfiguration$.MODULE$.DEFAULT_PARTITION_NAME().getValue();
            String _type = "string";
            boxedUnit = createTableCode.append(this.PARTITIONED_BY()).append(this.LEFT_PARENTHESES()).append(partition).append(this.SPACE()).append(_type).append(this.RIGHT_PARENTHESES()).append(this.SPACE());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        createTableCode.append(this.STORED_AS()).append(this.SPACE()).append((String)MdqConfiguration$.MODULE$.DEFAULT_STORED_TYPE().getValue()).append(this.SPACE());
        Object object = StringUtils.isNotBlank((CharSequence)tableInfo.getTableBaseInfo().getBase().getComment()) ? createTableCode.append(this.COMMENT()).append(this.SPACE()).append(this.SINGLE_MARK()).append(tableInfo.getTableBaseInfo().getBase().getComment()).append(this.SINGLE_MARK()).append(this.SPACE()) : BoxedUnit.UNIT;
        createTableCode.append(this.MARKS());
        createTableCode.append(this.RIGHT_PARENTHESES());
        String finalCode = createTableCode.toString();
        this.logger().info(new StringBuilder(32).append("End to create ddl code, code is ").append(finalCode).toString());
        return finalCode;
    }

    private ScalaDDLCreator$() {
        MODULE$ = this;
        DDLCreator.$init$(this);
        SQLConst.$init$(this);
        Logging.$init$((Logging)this);
    }
}

