/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.service;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.linkis.datasourcemanager.common.util.json.Json;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public class ElasticConnection
implements Closeable {
    public static final String DEFAULT_TYPE_NAME = "type";
    private static final String DEFAULT_MAPPING_NAME = "mappings";
    private static final String DEFAULT_INDEX_NAME = "index";
    private static final String FIELD_PROPS = "properties";
    private RestClient restClient;

    public ElasticConnection(String[] endPoints, String username, String password) throws IOException {
        HttpHost[] httpHosts = new HttpHost[endPoints.length];
        for (int i = 0; i < endPoints.length; ++i) {
            httpHosts[i] = HttpHost.create((String)endPoints[i]);
        }
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])httpHosts);
        BasicCredentialsProvider credentialsProvider = null;
        if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
            credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        }
        BasicCredentialsProvider finalCredentialsProvider = credentialsProvider;
        restClientBuilder.setHttpClientConfigCallback(httpClientBuilder -> {
            if (null != finalCredentialsProvider) {
                httpClientBuilder.setDefaultCredentialsProvider(finalCredentialsProvider);
            }
            return httpClientBuilder.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(1).build());
        });
        this.restClient = restClientBuilder.build();
        this.ping();
    }

    public List<String> getAllIndices() throws Exception {
        ArrayList<String> indices = new ArrayList<String>();
        Request request = new Request("GET", "_cat/indices");
        request.addParameter("format", "JSON");
        Response response = this.restClient.performRequest(request);
        List list = (List)Json.fromJson((InputStream)response.getEntity().getContent(), Map.class, (Class[])new Class[0]);
        list.forEach(v -> {
            String index = String.valueOf(v.getOrDefault(DEFAULT_INDEX_NAME, ""));
            if (StringUtils.isNotBlank((CharSequence)index) && !index.startsWith(".")) {
                indices.add(index);
            }
        });
        return indices;
    }

    public List<String> getTypes(String index) throws Exception {
        ArrayList<String> types = new ArrayList<String>();
        Request request = new Request("GET", index + "/_mappings");
        Response response = this.restClient.performRequest(request);
        Map result = (Map)Json.fromJson((InputStream)response.getEntity().getContent(), Map.class, (Class[])new Class[0]);
        Map indexMap = (Map)result.get(index);
        Object props = indexMap.get(DEFAULT_MAPPING_NAME);
        if (props instanceof Map) {
            Set keySet = ((Map)props).keySet();
            for (Object v : keySet) {
                types.add(String.valueOf(v));
            }
        }
        return types;
    }

    public Map<Object, Object> getProps(String index, String type) throws Exception {
        Object props;
        Object typeMap;
        Map mappings;
        Request request = new Request("GET", index + "/_mappings");
        Response response = this.restClient.performRequest(request);
        Map result = (Map)Json.fromJson((InputStream)response.getEntity().getContent(), Map.class, (Class[])new Class[0]);
        Map propsMap = mappings = (Map)((Map)result.get(index)).get(DEFAULT_MAPPING_NAME);
        if (mappings.containsKey(type) && (typeMap = mappings.get(type)) instanceof Map) {
            propsMap = (Map)typeMap;
        }
        if (null != (props = propsMap.get(FIELD_PROPS)) && props instanceof Map) {
            return (Map)props;
        }
        return propsMap;
    }

    public void ping() throws IOException {
        int successCode;
        Response response = this.restClient.performRequest(new Request("GET", "/"));
        int code = response.getStatusLine().getStatusCode();
        if (code != (successCode = 200)) {
            throw new RuntimeException("Ping to ElasticSearch ERROR, response code: " + code);
        }
    }

    @Override
    public void close() throws IOException {
        this.restClient.close();
    }
}

