/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.label.builder;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.ClassUtils;
import org.apache.linkis.manager.label.builder.AbstractGenericLabelBuilder;
import org.apache.linkis.manager.label.entity.InheritableLabel;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.SerializableLabel;
import org.apache.linkis.manager.label.entity.annon.KeyMethod;
import org.apache.linkis.manager.label.errorcode.LabelCommonErrorCodeSummary;
import org.apache.linkis.manager.label.exception.LabelErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGlobalLabelBuilder
extends AbstractGenericLabelBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultGlobalLabelBuilder.class);
    private static final Function<String, Object> DEFAULT_STRING_DESERIALIZER = stringValue -> stringValue;
    private static final Map<String, Class<? extends Label<?>>> LABEL_KEY_TYPE_MAP = new HashMap();

    @Override
    public boolean canBuild(String labelKey, Class<?> labelClass) {
        return null == labelClass || Label.class.isAssignableFrom(labelClass);
    }

    @Override
    public <T extends Label<?>> T build(String labelKey, Object valueObj, Class<?> labelClass, Type ... valueTypes) throws LabelErrorException {
        Type suitableValueType;
        Class<? extends Label> suitableLabelClass = this.getSuitableLabelClass(labelKey, labelClass);
        if (null != suitableLabelClass && null != (suitableValueType = this.getSuitableValueType(suitableLabelClass, valueTypes))) {
            return this.buildInner(labelKey, valueObj, suitableLabelClass, suitableValueType);
        }
        return null;
    }

    @Override
    public <T extends Label<?>> T build(String labelKey, Object valueObj, Class<T> labelType) throws LabelErrorException {
        return this.build(labelKey, valueObj, labelType, new Type[0]);
    }

    @Override
    public <T extends Label<?>> T build(String labelKey, InputStream valueInput, Class<?> labelClass, Type ... valueTypes) throws LabelErrorException {
        try {
            return this.build(labelKey, null == valueInput ? "" : IOUtils.toString((InputStream)valueInput), labelClass, valueTypes);
        }
        catch (IOException e) {
            throw new LabelErrorException(LabelCommonErrorCodeSummary.FAILED_READ_INPUT_STREAM.getErrorCode(), LabelCommonErrorCodeSummary.FAILED_READ_INPUT_STREAM.getErrorDesc(), e);
        }
    }

    @Override
    public <T extends Label<?>> T build(String labelKey, InputStream valueInput, Class<T> labelClass) throws LabelErrorException {
        try {
            return this.build(labelKey, null == valueInput ? "" : IOUtils.toString((InputStream)valueInput), labelClass, new Type[0]);
        }
        catch (IOException e) {
            throw new LabelErrorException(LabelCommonErrorCodeSummary.FAILED_READ_INPUT_STREAM.getErrorCode(), LabelCommonErrorCodeSummary.FAILED_READ_INPUT_STREAM.getErrorDesc(), e);
        }
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    protected <T extends Label<?>> T buildInner(String labelKey, Object valueObj, Class<? extends Label> suitableLabelClass, Type suitableValueType) throws LabelErrorException {
        if (suitableValueType instanceof AbstractGenericLabelBuilder.CombineType) {
            AbstractGenericLabelBuilder.CombineType suitableCombineValueType = (AbstractGenericLabelBuilder.CombineType)suitableValueType;
            return (T)this.newInstance(suitableLabelClass, labelKey, suitableCombineValueType.actual, this.transformValueToConcreteType(valueObj, suitableCombineValueType.actual, suitableCombineValueType.childTypes.toArray(new Type[0]), DEFAULT_STRING_DESERIALIZER));
        }
        return (T)this.newInstance(suitableLabelClass, labelKey, suitableValueType, this.transformValueToConcreteType(valueObj, suitableValueType, new Type[0], null));
    }

    protected Class<? extends Label> getSuitableLabelClass(String labelKey, Class<?> labelClass) {
        if (null != labelClass) {
            if (Modifier.isInterface(labelClass.getModifiers()) || Modifier.isAbstract(labelClass.getModifiers())) {
                if (labelClass.equals(Label.class)) {
                    return InheritableLabel.class;
                }
                Set setLabel = ClassUtils.reflections().getSubTypesOf(labelClass);
                for (Class suitableFound : setLabel) {
                    if (Modifier.isInterface(suitableFound.getModifiers())) continue;
                    return suitableFound;
                }
                return null;
            }
            return labelClass;
        }
        return LABEL_KEY_TYPE_MAP.getOrDefault(labelKey, null);
    }

    protected Type getSuitableValueType(Class<? extends Label> labelClass, Type ... valueTypes) {
        Type[] actualValueType = this.findActualLabelValueType(labelClass);
        if (null == actualValueType) {
            actualValueType = valueTypes;
        }
        if (null == actualValueType) {
            AbstractGenericLabelBuilder.CombineType defaultType = new AbstractGenericLabelBuilder.CombineType((Type)((Object)Map.class));
            defaultType.childTypes.add((Type)((Object)String.class));
            defaultType.childTypes.add((Type)((Object)Object.class));
            actualValueType = new Type[]{defaultType};
        }
        return actualValueType[0];
    }

    private Label<?> newInstance(Class<? extends Label> labelType, String labelKey, Type labelValueType, Object labelValue) throws LabelErrorException {
        try {
            Label newLabel = labelType.newInstance();
            if (newLabel instanceof InheritableLabel) {
                InheritableLabel inheritableNewLabel = (InheritableLabel)newLabel;
                if (null != labelKey && null == newLabel.getLabelKey()) {
                    inheritableNewLabel.setLabelKey(labelKey);
                }
                boolean setString = false;
                if (null != labelValue && labelValue.getClass().equals(String.class)) {
                    String SET_STRING_VALUE_METHOD = "setStringValue";
                    try {
                        Method method;
                        try {
                            method = SerializableLabel.class.getDeclaredMethod(SET_STRING_VALUE_METHOD, String.class);
                        }
                        catch (NoSuchMethodException e) {
                            method = labelType.getDeclaredMethod(SET_STRING_VALUE_METHOD, String.class);
                        }
                        method.setAccessible(true);
                        method.invoke((Object)newLabel, String.valueOf(labelValue));
                        setString = true;
                    }
                    catch (NoSuchMethodException method) {
                        // empty catch block
                    }
                }
                Class labelValueClass = (Class)labelValueType;
                if (null != labelValue && labelValueClass.isAssignableFrom(labelValue.getClass()) && (!setString || null == newLabel.getValue())) {
                    String SET_VALUE_METHOD = "setValue";
                    try {
                        Method method = InheritableLabel.class.getDeclaredMethod(SET_VALUE_METHOD, Object.class);
                        method.setAccessible(true);
                        method.invoke((Object)newLabel, labelValue);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            return newLabel;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new LabelErrorException(LabelCommonErrorCodeSummary.FAILED_CONSTRUCT_INSTANCE.getErrorCode(), MessageFormat.format(LabelCommonErrorCodeSummary.FAILED_CONSTRUCT_INSTANCE.getErrorDesc(), labelType.getSimpleName()), e);
        }
    }

    static {
        Method[] methods = Label.class.getMethods();
        Method getKeyMethod = null;
        for (Method method : methods) {
            if (!method.isAnnotationPresent(KeyMethod.class)) continue;
            getKeyMethod = method;
        }
        if (null != getKeyMethod) {
            Set labelEntities = ClassUtils.reflections().getSubTypesOf(Label.class);
            Method finalGetKeyMethod = getKeyMethod;
            labelEntities.forEach(labelEntity -> {
                if (!Modifier.isInterface(labelEntity.getModifiers()) && !Modifier.isAbstract(labelEntity.getModifiers())) {
                    try {
                        Label label = (Label)labelEntity.newInstance();
                        String labelKey = (String)finalGetKeyMethod.invoke((Object)label, new Object[0]);
                        if (StringUtils.isNotBlank((CharSequence)labelKey)) {
                            LABEL_KEY_TYPE_MAP.put(labelKey, (Class<Label<?>>)labelEntity);
                        }
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        LOG.info("Fail to reflect to new a label instance: [" + labelEntity.getSimpleName() + "]", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        LOG.info("Fail to invoke method: [" + finalGetKeyMethod.getName() + "] of label instance: [" + labelEntity.getSimpleName() + "]", (Throwable)e);
                    }
                }
            });
        }
    }
}

