/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.sparkmeasure;

import ch.cern.sparkmeasure.IOUtils$;
import ch.cern.sparkmeasure.TaskInfoRecorderListener;
import ch.cern.sparkmeasure.Utils$;
import org.apache.spark.SparkConf;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U3Aa\u0003\u0007\u0001'!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004C\u0003$\u0001\u0011\u0005A\u0005\u0003\u0005(\u0001!\u0015\r\u0011\"\u0001)\u0011\u001dy\u0003A1A\u0005\u0002ABaA\u0010\u0001!\u0002\u0013\t\u0004bB \u0001\u0005\u0004%\t\u0001\r\u0005\u0007\u0001\u0002\u0001\u000b\u0011B\u0019\t\u000f\u0005\u0003!\u0019!C\u0001\u0005\"1q\t\u0001Q\u0001\n\rCQ\u0001\u0013\u0001\u0005B%\u0013\u0011D\u00127jO\"$(+Z2pe\u0012,'\u000fV1tW6+GO]5dg*\u0011QBD\u0001\rgB\f'o[7fCN,(/\u001a\u0006\u0003\u001fA\tAaY3s]*\t\u0011#\u0001\u0002dQ\u000e\u00011C\u0001\u0001\u0015!\t)b#D\u0001\r\u0013\t9BB\u0001\rUCN\\\u0017J\u001c4p%\u0016\u001cwN\u001d3fe2K7\u000f^3oKJ\fAaY8oMB\u0011!$I\u0007\u00027)\u0011A$H\u0001\u0006gB\f'o\u001b\u0006\u0003=}\ta!\u00199bG\",'\"\u0001\u0011\u0002\u0007=\u0014x-\u0003\u0002#7\tI1\u000b]1sW\u000e{gNZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u00152\u0003CA\u000b\u0001\u0011\u0015A\"\u00011\u0001\u001a\u0003\u0019awnZ4feV\t\u0011\u0006\u0005\u0002+[5\t1F\u0003\u0002-?\u0005)1\u000f\u001c45U&\u0011af\u000b\u0002\u0007\u0019><w-\u001a:\u0002\u001b5,GO]5dg\u001a{'/\\1u+\u0005\t\u0004C\u0001\u001a<\u001d\t\u0019\u0014\b\u0005\u00025o5\tQG\u0003\u00027%\u00051AH]8pizR\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\na\u0001\u0015:fI\u00164\u0017B\u0001\u001f>\u0005\u0019\u0019FO]5oO*\u0011!hN\u0001\u000f[\u0016$(/[2t\r>\u0014X.\u0019;!\u0003=iW\r\u001e:jGN4\u0015\u000e\\3oC6,\u0017\u0001E7fiJL7m\u001d$jY\u0016t\u0017-\\3!\u00035\u0001(/\u001b8u)>\u001cF\u000fZ8viV\t1\t\u0005\u0002E\u000b6\tq'\u0003\u0002Go\t9!i\\8mK\u0006t\u0017A\u00049sS:$Hk\\*uI>,H\u000fI\u0001\u0011_:\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8F]\u0012$\"AS'\u0011\u0005\u0011[\u0015B\u0001'8\u0005\u0011)f.\u001b;\t\u000b9S\u0001\u0019A(\u0002\u001d\u0005\u0004\b\u000f\\5dCRLwN\\#oIB\u0011\u0001kU\u0007\u0002#*\u0011!kG\u0001\ng\u000eDW\rZ;mKJL!\u0001V)\u00037M\u0003\u0018M]6MSN$XM\\3s\u0003B\u0004H.[2bi&|g.\u00128e\u0001")
public class FlightRecorderTaskMetrics
extends TaskInfoRecorderListener {
    private Logger logger;
    private final SparkConf conf;
    private final String metricsFormat;
    private final String metricsFilename;
    private final boolean printToStdout;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        FlightRecorderTaskMetrics flightRecorderTaskMetrics = this;
        synchronized (flightRecorderTaskMetrics) {
            if (!this.bitmap$0) {
                this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String metricsFormat() {
        return this.metricsFormat;
    }

    public String metricsFilename() {
        return this.metricsFilename;
    }

    public boolean printToStdout() {
        return this.printToStdout;
    }

    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        this.logger().info(new StringBuilder(37).append("Spark application ended, timestamp = ").append(applicationEnd.time()).toString());
        if (this.printToStdout()) {
            this.logger().info("Printing Task metrics values serialized to JSON to stdout");
            String stringMetrics = IOUtils$.MODULE$.writeToStringSerializedJSON(new Tuple2((Object)this.metricsFilename(), this.taskMetricsData()));
            Predef$.MODULE$.print((Object)"Task metrics values serialized to JSON:");
            Predef$.MODULE$.print((Object)stringMetrics);
        }
        if (this.metricsFilename().isEmpty()) {
            this.logger().warn("No Task Metrics output file written.");
            return;
        }
        String string = this.metricsFormat();
        if ("json".equals(string)) {
            this.logger().info(new StringBuilder(48).append("Writing Task Metrics data serialized as json to ").append(this.metricsFilename()).toString());
            IOUtils$.MODULE$.writeSerializedJSON(this.metricsFilename(), this.taskMetricsData());
            return;
        }
        if ("java".equals(string)) {
            this.logger().info(new StringBuilder(64).append("Writing Task Metrics data serialized with java serialization to ").append(this.metricsFilename()).toString());
            IOUtils$.MODULE$.writeSerialized(this.metricsFilename(), this.taskMetricsData());
            return;
        }
        if ("json_to_hadoop".equals(string)) {
            this.logger().warn(new StringBuilder(74).append("Writing Task Metrics data with json serialization to Hadoop filesystem to ").append(this.metricsFilename()).toString());
            IOUtils$.MODULE$.writeSerializedJSONToHadoop(this.metricsFilename(), this.taskMetricsData(), this.conf);
            return;
        }
        this.logger().warn("StageMetrics data could not be written");
    }

    public FlightRecorderTaskMetrics(SparkConf conf) {
        this.conf = conf;
        this.metricsFormat = Utils$.MODULE$.parseMetricsFormat(conf, this.logger(), "json");
        this.metricsFilename = Utils$.MODULE$.parseMetricsFilename(conf, this.logger(), "/tmp/taskMetrics_flightRecorder");
        this.printToStdout = Utils$.MODULE$.parsePrintToStdout(conf, this.logger(), false);
    }
}

