/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.reflection.wrapper;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectionException;
import org.apache.ibatis.reflection.property.PropertyTokenizer;
import org.apache.ibatis.reflection.wrapper.ObjectWrapper;

public abstract class BaseWrapper
implements ObjectWrapper {
    protected static final Object[] NO_ARGUMENTS = new Object[0];
    protected final MetaObject metaObject;

    protected BaseWrapper(MetaObject metaObject) {
        this.metaObject = metaObject;
    }

    protected Object resolveCollection(PropertyTokenizer prop, Object object) {
        if ("".equals(prop.getName())) {
            return object;
        }
        return this.metaObject.getValue(prop.getName());
    }

    protected Object getCollectionValue(PropertyTokenizer prop, Object collection) {
        if (collection instanceof Map) {
            return ((Map)collection).get(prop.getIndex());
        }
        int i = Integer.parseInt(prop.getIndex());
        if (collection instanceof List) {
            return ((List)collection).get(i);
        }
        if (collection instanceof Object[]) {
            return ((Object[])collection)[i];
        }
        if (collection instanceof char[]) {
            return Character.valueOf(((char[])collection)[i]);
        }
        if (collection instanceof boolean[]) {
            return ((boolean[])collection)[i];
        }
        if (collection instanceof byte[]) {
            return ((byte[])collection)[i];
        }
        if (collection instanceof double[]) {
            return ((double[])collection)[i];
        }
        if (collection instanceof float[]) {
            return Float.valueOf(((float[])collection)[i]);
        }
        if (collection instanceof int[]) {
            return ((int[])collection)[i];
        }
        if (collection instanceof long[]) {
            return ((long[])collection)[i];
        }
        if (collection instanceof short[]) {
            return ((short[])collection)[i];
        }
        throw new ReflectionException("The '" + prop.getName() + "' property of " + collection + " is not a List or Array.");
    }

    protected void setCollectionValue(PropertyTokenizer prop, Object collection, Object value) {
        if (collection instanceof Map) {
            ((Map)collection).put(prop.getIndex(), value);
        } else {
            int i = Integer.parseInt(prop.getIndex());
            if (collection instanceof List) {
                ((List)collection).set(i, value);
            } else if (collection instanceof Object[]) {
                ((Object[])collection)[i] = value;
            } else if (collection instanceof char[]) {
                ((char[])collection)[i] = ((Character)value).charValue();
            } else if (collection instanceof boolean[]) {
                ((boolean[])collection)[i] = (Boolean)value;
            } else if (collection instanceof byte[]) {
                ((byte[])collection)[i] = (Byte)value;
            } else if (collection instanceof double[]) {
                ((double[])collection)[i] = (Double)value;
            } else if (collection instanceof float[]) {
                ((float[])collection)[i] = ((Float)value).floatValue();
            } else if (collection instanceof int[]) {
                ((int[])collection)[i] = (Integer)value;
            } else if (collection instanceof long[]) {
                ((long[])collection)[i] = (Long)value;
            } else if (collection instanceof short[]) {
                ((short[])collection)[i] = (Short)value;
            } else {
                throw new ReflectionException("The '" + prop.getName() + "' property of " + collection + " is not a List or Array.");
            }
        }
    }
}

