/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.client.service;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.cs.client.service.DefaultSearchService;
import org.apache.linkis.cs.client.service.MetaDataService;
import org.apache.linkis.cs.client.utils.SerializeHelper;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSMetaDataService
implements MetaDataService {
    private static final Logger logger = LoggerFactory.getLogger(CSMetaDataService.class);
    private static CSMetaDataService csMetaDataService;

    private CSMetaDataService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CSMetaDataService getInstance() {
        if (null != csMetaDataService) return csMetaDataService;
        Class<CSMetaDataService> clazz = CSMetaDataService.class;
        synchronized (CSMetaDataService.class) {
            if (null != csMetaDataService) return csMetaDataService;
            csMetaDataService = new CSMetaDataService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return csMetaDataService;
        }
    }

    @Override
    public Map<ContextKey, MetaData> getAllUpstreamMetaData(String contextIDStr, String nodeName) throws CSErrorException {
        if (StringUtils.isBlank((CharSequence)contextIDStr) || StringUtils.isBlank((CharSequence)nodeName)) {
            logger.warn("contextIDStr or nodeName cannot null");
            return null;
        }
        try {
            ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
            return DefaultSearchService.getInstance().searchUpstreamContextMap(contextID, nodeName, Integer.MAX_VALUE, MetaData.class);
        }
        catch (ErrorException e) {
            logger.error("Deserialize contextid error. contextID : " + contextIDStr + ", e ", (Throwable)e);
            throw new CSErrorException(70112, "Deserialize contextid error. contextID : " + contextIDStr + ", e " + e.getDesc());
        }
    }
}

