/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLDbTypedObject;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.SQLWindow;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExprGroup;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBase;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsUDTFSQLSelectItem;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.druid.util.FnvHash;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

public class SQLSelectQueryBlock
extends SQLSelectQueryBase
implements SQLReplaceable,
SQLDbTypedObject {
    protected int distionOption;
    protected final List<SQLSelectItem> selectList = new ArrayList<SQLSelectItem>();
    protected SQLTableSource from;
    protected List<String> commentsAfaterFrom;
    protected SQLExprTableSource into;
    protected SQLExpr where;
    protected SQLExpr startWith;
    protected SQLExpr connectBy;
    protected boolean prior;
    protected boolean noCycle;
    protected SQLOrderBy orderBySiblings;
    protected SQLSelectGroupByClause groupBy;
    protected List<SQLWindow> windows;
    protected SQLExpr qualify;
    protected SQLOrderBy orderBy;
    protected boolean forUpdate;
    protected boolean noWait;
    protected boolean skipLocked;
    protected boolean forShare;
    protected SQLExpr waitTime;
    protected SQLLimit limit;
    protected List<SQLExpr> forUpdateOf;
    protected List<SQLSelectOrderByItem> distributeBy;
    protected List<SQLSelectOrderByItem> sortBy;
    protected List<SQLSelectOrderByItem> clusterBy;
    protected String cachedSelectList;
    protected long cachedSelectListHash;
    protected DbType dbType;
    protected List<SQLCommentHint> hints;

    public SQLSelectQueryBlock() {
    }

    public SQLSelectQueryBlock(DbType dbType) {
        this.dbType = dbType;
    }

    public SQLExprTableSource getInto() {
        return this.into;
    }

    public void setInto(SQLExpr into) {
        this.setInto(new SQLExprTableSource(into));
    }

    public void setInto(SQLExprTableSource into) {
        if (into != null) {
            into.setParent(this);
        }
        this.into = into;
    }

    public SQLSelectGroupByClause getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(SQLSelectGroupByClause x) {
        if (x != null) {
            x.setParent(this);
        }
        this.groupBy = x;
    }

    public List<SQLWindow> getWindows() {
        return this.windows;
    }

    public void addWindow(SQLWindow x) {
        if (x != null) {
            x.setParent(this);
        }
        if (this.windows == null) {
            this.windows = new ArrayList<SQLWindow>(4);
        }
        this.windows.add(x);
    }

    public SQLExpr getQualify() {
        return this.qualify;
    }

    public void setQualify(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.qualify = x;
    }

    public SQLExpr getWhere() {
        return this.where;
    }

    public void setWhere(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.where = x;
    }

    public void addWhere(SQLExpr condition) {
        if (condition == null) {
            return;
        }
        if (this.where == null) {
            condition.setParent(this);
            this.where = condition;
            return;
        }
        List<SQLExpr> items = SQLBinaryOpExpr.split(this.where, SQLBinaryOperator.BooleanAnd);
        for (SQLExpr item : items) {
            if (condition.equals(item)) {
                return;
            }
            if (!(condition instanceof SQLInListExpr)) continue;
            SQLInListExpr inListExpr = (SQLInListExpr)condition;
            if (item instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr binaryOpItem = (SQLBinaryOpExpr)item;
                SQLExpr left = binaryOpItem.getLeft();
                SQLExpr right = binaryOpItem.getRight();
                if (!inListExpr.getExpr().equals(left) || binaryOpItem.getOperator() != SQLBinaryOperator.Equality || right instanceof SQLNullExpr) continue;
                if (inListExpr.getTargetList().contains(right)) {
                    return;
                }
                SQLUtils.replaceInParent(item, new SQLBooleanExpr(false));
                return;
            }
            if (!(item instanceof SQLInListExpr)) continue;
            SQLInListExpr inListItem = (SQLInListExpr)item;
            if (!inListExpr.getExpr().equals(inListItem.getExpr())) continue;
            TreeSet<SQLExpr> set = new TreeSet<SQLExpr>();
            for (SQLExpr itemItem : inListItem.getTargetList()) {
                set.add(itemItem);
            }
            ArrayList<SQLExpr> andList = new ArrayList<SQLExpr>();
            for (SQLExpr exprItem : inListExpr.getTargetList()) {
                if (!set.contains(exprItem)) continue;
                andList.add(exprItem.clone());
            }
            if (andList.isEmpty()) {
                SQLUtils.replaceInParent(item, new SQLBooleanExpr(false));
                return;
            }
            inListItem.getTargetList().clear();
            for (SQLExpr val : andList) {
                inListItem.addTarget(val);
            }
            return;
        }
        this.where = SQLBinaryOpExpr.and(this.where, condition);
        this.where.setParent(this);
    }

    public void addWhereForDynamicFilter(SQLExpr condition) {
        if (condition == null) {
            return;
        }
        if (this.where == null) {
            condition.setParent(this);
            this.where = condition;
            return;
        }
        if (this.where instanceof SQLBinaryOpExpr || this.where instanceof SQLBinaryOpExprGroup) {
            List<SQLExpr> items = SQLBinaryOpExpr.split(this.where, SQLBinaryOperator.BooleanAnd);
            for (SQLExpr item : items) {
                if (condition.equals(item)) {
                    return;
                }
                if (!(condition instanceof SQLInListExpr)) continue;
                SQLInListExpr inListExpr = (SQLInListExpr)condition;
                if (item instanceof SQLBinaryOpExpr) {
                    SQLBinaryOpExpr binaryOpItem = (SQLBinaryOpExpr)item;
                    SQLExpr left = binaryOpItem.getLeft();
                    SQLExpr right = binaryOpItem.getRight();
                    if (!inListExpr.getExpr().equals(left)) continue;
                    if (inListExpr.getTargetList().contains(right)) {
                        this.replace(item, inListExpr);
                    } else {
                        SQLInListExpr inListExpr2 = inListExpr.clone();
                        inListExpr2.addTarget(right.clone());
                        this.replace(item, inListExpr2);
                    }
                    return;
                }
                if (!(item instanceof SQLInListExpr)) continue;
                SQLInListExpr inListItem = (SQLInListExpr)item;
                if (!inListExpr.getExpr().equals(inListItem.getExpr())) continue;
                TreeSet<SQLExpr> set = new TreeSet<SQLExpr>();
                for (SQLExpr itemItem : inListItem.getTargetList()) {
                    set.add(itemItem);
                }
                for (SQLExpr exprItem : inListExpr.getTargetList()) {
                    if (set.contains(exprItem)) continue;
                    inListItem.addTarget(exprItem.clone());
                }
                return;
            }
        }
        this.where = SQLBinaryOpExpr.and(this.where, condition);
        this.where.setParent(this);
    }

    public void whereOr(SQLExpr condition) {
        if (condition == null) {
            return;
        }
        if (this.where == null) {
            condition.setParent(this);
            this.where = condition;
        } else if (SQLBinaryOpExpr.isOr(this.where) || SQLBinaryOpExpr.isOr(condition)) {
            SQLBinaryOpExprGroup group = new SQLBinaryOpExprGroup(SQLBinaryOperator.BooleanOr, this.dbType);
            group.add(this.where);
            group.add(condition);
            group.setParent(this);
            this.where = group;
        } else {
            this.where = SQLBinaryOpExpr.or(this.where, condition);
            this.where.setParent(this);
        }
    }

    public void addHaving(SQLExpr condition) {
        if (condition == null) {
            return;
        }
        if (this.groupBy == null) {
            this.groupBy = new SQLSelectGroupByClause();
        }
        this.groupBy.addHaving(condition);
    }

    public SQLOrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(SQLOrderBy orderBy) {
        if (orderBy != null) {
            orderBy.setParent(this);
        }
        this.orderBy = orderBy;
    }

    public void addOrderBy(SQLOrderBy orderBy) {
        if (orderBy == null) {
            return;
        }
        if (this.orderBy == null) {
            this.setOrderBy(orderBy);
            return;
        }
        for (SQLSelectOrderByItem item : orderBy.getItems()) {
            this.orderBy.addItem(item.clone());
        }
    }

    public void addOrderBy(SQLSelectOrderByItem orderByItem) {
        if (orderByItem == null) {
            return;
        }
        if (this.orderBy == null) {
            this.orderBy = new SQLOrderBy();
            this.orderBy.setParent(this);
        }
        this.orderBy.addItem(orderByItem);
    }

    public boolean containsOrderBy(SQLSelectOrderByItem orderByItem) {
        if (orderByItem == null || this.orderBy == null) {
            return false;
        }
        if (this.orderBy.getItems().contains(orderByItem)) {
            return true;
        }
        SQLExpr expr = orderByItem.getExpr();
        int index = 0;
        for (int i = 0; i < this.selectList.size(); ++i) {
            SQLSelectItem selectItem = this.selectList.get(i);
            if (!selectItem.getExpr().equals(expr)) continue;
            index = i + 1;
            break;
        }
        if (index > 0) {
            for (SQLSelectOrderByItem selectOrderByItem : this.orderBy.getItems()) {
                SQLExpr orderByItemExpr = selectOrderByItem.getExpr();
                if (!(orderByItemExpr instanceof SQLIntegerExpr) || ((SQLIntegerExpr)orderByItemExpr).getNumber().intValue() != index) continue;
                return true;
            }
        }
        return false;
    }

    public void addOrderBy(SQLExpr orderBy, SQLOrderingSpecification type) {
        if (orderBy == null) {
            return;
        }
        if (this.orderBy == null) {
            this.setOrderBy(new SQLOrderBy(orderBy, type));
            return;
        }
        this.orderBy.addItem(orderBy, type);
    }

    public void addOrderBy(SQLExpr orderBy) {
        if (orderBy == null) {
            return;
        }
        if (this.orderBy == null) {
            this.setOrderBy(new SQLOrderBy(orderBy));
            return;
        }
        this.orderBy.addItem(orderBy);
    }

    public SQLOrderBy getOrderBySiblings() {
        return this.orderBySiblings;
    }

    public void setOrderBySiblings(SQLOrderBy orderBySiblings) {
        if (orderBySiblings != null) {
            orderBySiblings.setParent(this);
        }
        this.orderBySiblings = orderBySiblings;
    }

    public int getDistionOption() {
        return this.distionOption;
    }

    public void setDistionOption(int distionOption) {
        this.distionOption = distionOption;
    }

    public void setDistinct() {
        this.distionOption = 2;
    }

    public boolean isDistinct() {
        return this.distionOption == 2;
    }

    public List<SQLSelectItem> getSelectList() {
        return this.selectList;
    }

    public SQLSelectItem getSelectItem(int i) {
        return this.selectList.get(i);
    }

    public void addSelectItem(SQLSelectItem item) {
        this.selectList.add(item);
        item.setParent(this);
    }

    public SQLSelectItem addSelectItem(SQLExpr expr) {
        SQLSelectItem item = new SQLSelectItem(expr);
        this.addSelectItem(item);
        return item;
    }

    public void addSelectItem(String selectItemExpr, String alias) {
        SQLExpr expr = SQLUtils.toSQLExpr(selectItemExpr, this.dbType);
        this.addSelectItem(new SQLSelectItem(expr, alias));
    }

    public void addSelectItem(SQLExpr expr, String alias) {
        this.addSelectItem(new SQLSelectItem(expr, alias));
    }

    public boolean hasSelectAggregation() {
        AggregationStatVisitor v = new AggregationStatVisitor();
        for (SQLSelectItem item : this.selectList) {
            SQLExpr expr = item.getExpr();
            expr.accept(v);
        }
        return v.aggregation;
    }

    public SQLTableSource getFrom() {
        return this.from;
    }

    public void setFrom(SQLExpr from) {
        this.setFrom(new SQLExprTableSource(from));
    }

    public void setFrom(SQLTableSource from) {
        if (from != null) {
            from.setParent(this);
        }
        this.from = from;
    }

    public void setFrom(SQLSelectQueryBlock queryBlock, String alias) {
        if (queryBlock == null) {
            this.from = null;
            return;
        }
        this.setFrom(new SQLSelect(queryBlock), alias);
    }

    public List<String> getCommentsAfaterFrom() {
        return this.commentsAfaterFrom;
    }

    public void setCommentsAfaterFrom(List<String> commentsAfaterFrom) {
        this.commentsAfaterFrom = commentsAfaterFrom;
    }

    public void setFrom(SQLSelect select, String alias) {
        if (select == null) {
            this.from = null;
            return;
        }
        SQLSubqueryTableSource from = new SQLSubqueryTableSource(select);
        from.setAlias(alias);
        this.setFrom(from);
    }

    public void setFrom(String tableName, String alias) {
        SQLExprTableSource from;
        if (tableName == null || tableName.length() == 0) {
            from = null;
        } else {
            SQLExpr expr = SQLUtils.toSQLExpr(tableName);
            from = new SQLExprTableSource(expr, alias);
        }
        this.setFrom(from);
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public void setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
    }

    public boolean isNoWait() {
        return this.noWait;
    }

    public void setNoWait(boolean noWait) {
        this.noWait = noWait;
    }

    public boolean isSkipLocked() {
        return this.skipLocked;
    }

    public void setSkipLocked(boolean skipLocked) {
        this.skipLocked = skipLocked;
    }

    public boolean isForShare() {
        return this.forShare;
    }

    public void setForShare(boolean forShare) {
        this.forShare = forShare;
    }

    public SQLExpr getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(SQLExpr waitTime) {
        if (waitTime != null) {
            waitTime.setParent(this);
        }
        this.waitTime = waitTime;
    }

    public SQLLimit getLimit() {
        return this.limit;
    }

    public void setLimit(SQLLimit limit) {
        if (limit != null) {
            limit.setParent(this);
        }
        this.limit = limit;
    }

    public void mergeLimit(SQLLimit limit) {
        if (this.limit == null) {
            this.limit = limit.clone();
            return;
        }
        this.limit.merge(limit);
    }

    public SQLExpr getFirst() {
        if (this.limit == null) {
            return null;
        }
        return this.limit.getRowCount();
    }

    public void setFirst(SQLExpr first) {
        if (this.limit == null) {
            this.limit = new SQLLimit();
        }
        this.limit.setRowCount(first);
    }

    public SQLExpr getOffset() {
        if (this.limit == null) {
            return null;
        }
        return this.limit.getOffset();
    }

    public void setOffset(SQLExpr offset) {
        if (this.limit == null) {
            this.limit = new SQLLimit();
        }
        this.limit.setOffset(offset);
    }

    public boolean isPrior() {
        return this.prior;
    }

    public void setPrior(boolean prior) {
        this.prior = prior;
    }

    public SQLExpr getStartWith() {
        return this.startWith;
    }

    public void setStartWith(SQLExpr startWith) {
        if (startWith != null) {
            startWith.setParent(this);
        }
        this.startWith = startWith;
    }

    public SQLExpr getConnectBy() {
        return this.connectBy;
    }

    public void setConnectBy(SQLExpr connectBy) {
        if (connectBy != null) {
            connectBy.setParent(this);
        }
        this.connectBy = connectBy;
    }

    public boolean isNoCycle() {
        return this.noCycle;
    }

    public void setNoCycle(boolean noCycle) {
        this.noCycle = noCycle;
    }

    public List<SQLSelectOrderByItem> getDistributeBy() {
        if (this.distributeBy == null) {
            this.distributeBy = new ArrayList<SQLSelectOrderByItem>();
        }
        return this.distributeBy;
    }

    public List<SQLSelectOrderByItem> getDistributeByDirect() {
        return this.distributeBy;
    }

    public void addDistributeBy(SQLExpr x) {
        if (x == null) {
            return;
        }
        x.setParent(this);
        if (this.distributeBy == null) {
            this.distributeBy = new ArrayList<SQLSelectOrderByItem>();
        }
        this.distributeBy.add(new SQLSelectOrderByItem(x));
    }

    public void addDistributeBy(SQLSelectOrderByItem item) {
        if (this.distributeBy == null) {
            this.distributeBy = new ArrayList<SQLSelectOrderByItem>();
        }
        if (item != null) {
            item.setParent(this);
        }
        this.distributeBy.add(item);
    }

    public List<SQLSelectOrderByItem> getSortBy() {
        if (this.sortBy == null) {
            this.sortBy = new ArrayList<SQLSelectOrderByItem>();
        }
        return this.sortBy;
    }

    public List<SQLSelectOrderByItem> getSortByDirect() {
        return this.sortBy;
    }

    public void addSortBy(SQLSelectOrderByItem item) {
        if (this.sortBy == null) {
            this.sortBy = new ArrayList<SQLSelectOrderByItem>();
        }
        if (item != null) {
            item.setParent(this);
        }
        this.sortBy.add(item);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            SQLObjectImpl item;
            int i;
            for (i = 0; i < this.selectList.size(); ++i) {
                item = this.selectList.get(i);
                if (item == null) continue;
                item.accept(visitor);
            }
            if (this.from != null) {
                this.from.accept(visitor);
            }
            if (this.windows != null) {
                for (i = 0; i < this.windows.size(); ++i) {
                    item = this.windows.get(i);
                    item.accept(visitor);
                }
            }
            if (this.into != null) {
                this.into.accept(visitor);
            }
            if (this.where != null) {
                this.where.accept(visitor);
            }
            if (this.startWith != null) {
                this.startWith.accept(visitor);
            }
            if (this.connectBy != null) {
                this.connectBy.accept(visitor);
            }
            if (this.groupBy != null) {
                this.groupBy.accept(visitor);
            }
            if (this.orderBy != null) {
                this.orderBy.accept(visitor);
            }
            if (this.distributeBy != null) {
                for (i = 0; i < this.distributeBy.size(); ++i) {
                    item = this.distributeBy.get(i);
                    item.accept(visitor);
                }
            }
            if (this.sortBy != null) {
                for (i = 0; i < this.sortBy.size(); ++i) {
                    item = this.sortBy.get(i);
                    item.accept(visitor);
                }
            }
            if (this.waitTime != null) {
                this.waitTime.accept(visitor);
            }
            if (this.limit != null) {
                this.limit.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLSelectQueryBlock that = (SQLSelectQueryBlock)o;
        if (this.distionOption != that.distionOption) {
            return false;
        }
        if (this.prior != that.prior) {
            return false;
        }
        if (this.noCycle != that.noCycle) {
            return false;
        }
        if (this.parenthesized != that.parenthesized) {
            return false;
        }
        if (this.forUpdate != that.forUpdate) {
            return false;
        }
        if (this.noWait != that.noWait) {
            return false;
        }
        if (this.cachedSelectListHash != that.cachedSelectListHash) {
            return false;
        }
        if (this.selectList != null ? !this.selectList.equals(that.selectList) : that.selectList != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.into != null ? !this.into.equals(that.into) : that.into != null) {
            return false;
        }
        if (this.where != null ? !this.where.equals(that.where) : that.where != null) {
            return false;
        }
        if (this.startWith != null ? !this.startWith.equals(that.startWith) : that.startWith != null) {
            return false;
        }
        if (this.connectBy != null ? !this.connectBy.equals(that.connectBy) : that.connectBy != null) {
            return false;
        }
        if (this.orderBySiblings != null ? !this.orderBySiblings.equals(that.orderBySiblings) : that.orderBySiblings != null) {
            return false;
        }
        if (this.groupBy != null ? !this.groupBy.equals(that.groupBy) : that.groupBy != null) {
            return false;
        }
        if (this.orderBy != null ? !this.orderBy.equals(that.orderBy) : that.orderBy != null) {
            return false;
        }
        if (this.waitTime != null ? !this.waitTime.equals(that.waitTime) : that.waitTime != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        if (this.forUpdateOf != null ? !this.forUpdateOf.equals(that.forUpdateOf) : that.forUpdateOf != null) {
            return false;
        }
        if (this.distributeBy != null ? !this.distributeBy.equals(that.distributeBy) : that.distributeBy != null) {
            return false;
        }
        if (this.sortBy != null ? !this.sortBy.equals(that.sortBy) : that.sortBy != null) {
            return false;
        }
        if (this.cachedSelectList != null ? !this.cachedSelectList.equals(that.cachedSelectList) : that.cachedSelectList != null) {
            return false;
        }
        if (this.dbType != that.dbType) {
            return false;
        }
        return this.hints != null ? this.hints.equals(that.hints) : that.hints == null;
    }

    public int hashCode() {
        int result = this.distionOption;
        result = 31 * result + (this.selectList != null ? this.selectList.hashCode() : 0);
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        result = 31 * result + (this.into != null ? this.into.hashCode() : 0);
        result = 31 * result + (this.where != null ? this.where.hashCode() : 0);
        result = 31 * result + (this.startWith != null ? this.startWith.hashCode() : 0);
        result = 31 * result + (this.connectBy != null ? this.connectBy.hashCode() : 0);
        result = 31 * result + (this.prior ? 1 : 0);
        result = 31 * result + (this.noCycle ? 1 : 0);
        result = 31 * result + (this.orderBySiblings != null ? this.orderBySiblings.hashCode() : 0);
        result = 31 * result + (this.groupBy != null ? this.groupBy.hashCode() : 0);
        result = 31 * result + (this.orderBy != null ? this.orderBy.hashCode() : 0);
        result = 31 * result + (this.parenthesized ? 1 : 0);
        result = 31 * result + (this.forUpdate ? 1 : 0);
        result = 31 * result + (this.noWait ? 1 : 0);
        result = 31 * result + (this.waitTime != null ? this.waitTime.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.forUpdateOf != null ? this.forUpdateOf.hashCode() : 0);
        result = 31 * result + (this.distributeBy != null ? this.distributeBy.hashCode() : 0);
        result = 31 * result + (this.sortBy != null ? this.sortBy.hashCode() : 0);
        result = 31 * result + (this.cachedSelectList != null ? this.cachedSelectList.hashCode() : 0);
        result = 31 * result + (int)(this.cachedSelectListHash ^ this.cachedSelectListHash >>> 32);
        result = 31 * result + (this.dbType != null ? this.dbType.hashCode() : 0);
        result = 31 * result + (this.hints != null ? this.hints.hashCode() : 0);
        return result;
    }

    public boolean equalsForMergeJoin(SQLSelectQueryBlock that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.into != null || this.limit != null || this.groupBy != null) {
            return false;
        }
        if (this.distionOption != that.distionOption) {
            return false;
        }
        if (this.prior != that.prior) {
            return false;
        }
        if (this.noCycle != that.noCycle) {
            return false;
        }
        if (this.parenthesized != that.parenthesized) {
            return false;
        }
        if (this.forUpdate != that.forUpdate) {
            return false;
        }
        if (this.noWait != that.noWait) {
            return false;
        }
        if (this.cachedSelectListHash != that.cachedSelectListHash) {
            return false;
        }
        if (this.selectList != null ? !this.selectList.equals(that.selectList) : that.selectList != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.into != null ? !this.into.equals(that.into) : that.into != null) {
            return false;
        }
        if (this.startWith != null ? !this.startWith.equals(that.startWith) : that.startWith != null) {
            return false;
        }
        if (this.connectBy != null ? !this.connectBy.equals(that.connectBy) : that.connectBy != null) {
            return false;
        }
        if (this.orderBySiblings != null ? !this.orderBySiblings.equals(that.orderBySiblings) : that.orderBySiblings != null) {
            return false;
        }
        if (this.groupBy != null ? !this.groupBy.equals(that.groupBy) : that.groupBy != null) {
            return false;
        }
        if (this.orderBy != null ? !this.orderBy.equals(that.orderBy) : that.orderBy != null) {
            return false;
        }
        if (this.waitTime != null ? !this.waitTime.equals(that.waitTime) : that.waitTime != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        if (this.forUpdateOf != null ? !this.forUpdateOf.equals(that.forUpdateOf) : that.forUpdateOf != null) {
            return false;
        }
        if (this.distributeBy != null ? !this.distributeBy.equals(that.distributeBy) : that.distributeBy != null) {
            return false;
        }
        if (this.sortBy != null ? !this.sortBy.equals(that.sortBy) : that.sortBy != null) {
            return false;
        }
        if (this.cachedSelectList != null ? !this.cachedSelectList.equals(that.cachedSelectList) : that.cachedSelectList != null) {
            return false;
        }
        return this.dbType == that.dbType;
    }

    @Override
    public SQLSelectQueryBlock clone() {
        SQLSelectQueryBlock x = new SQLSelectQueryBlock(this.dbType);
        this.cloneTo(x);
        return x;
    }

    public List<SQLExpr> getForUpdateOf() {
        if (this.forUpdateOf == null) {
            this.forUpdateOf = new ArrayList<SQLExpr>(1);
        }
        return this.forUpdateOf;
    }

    public int getForUpdateOfSize() {
        if (this.forUpdateOf == null) {
            return 0;
        }
        return this.forUpdateOf.size();
    }

    public void cloneSelectListTo(SQLSelectQueryBlock x) {
        x.distionOption = this.distionOption;
        for (SQLSelectItem item : this.selectList) {
            SQLSelectItem item2 = item.clone();
            item2.setParent(x);
            x.selectList.add(item2);
        }
    }

    public void cloneTo(SQLSelectQueryBlock x) {
        x.parenthesized = this.parenthesized;
        x.distionOption = this.distionOption;
        if (x.selectList.size() > 0) {
            x.selectList.clear();
        }
        if (this.hints != null) {
            for (SQLCommentHint sQLCommentHint : this.hints) {
                SQLCommentHint hint1 = sQLCommentHint.clone();
                hint1.setParent(x);
                x.getHints().add(hint1);
            }
        }
        for (SQLSelectItem sQLSelectItem : this.selectList) {
            x.addSelectItem(sQLSelectItem.clone());
        }
        if (this.from != null) {
            x.setFrom(this.from.clone());
        }
        if (this.into != null) {
            x.setInto(this.into.clone());
        }
        if (this.where != null) {
            x.setWhere(this.where.clone());
        }
        if (this.startWith != null) {
            x.setStartWith(this.startWith.clone());
        }
        if (this.connectBy != null) {
            x.setConnectBy(this.connectBy.clone());
        }
        x.prior = this.prior;
        x.noCycle = this.noCycle;
        if (this.orderBySiblings != null) {
            x.setOrderBySiblings(this.orderBySiblings.clone());
        }
        if (this.groupBy != null) {
            x.setGroupBy(this.groupBy.clone());
        }
        if (this.orderBy != null) {
            x.setOrderBy(this.orderBy.clone());
        }
        if (this.distributeBy != null) {
            if (x.distributeBy == null) {
                x.distributeBy = new ArrayList<SQLSelectOrderByItem>();
            }
            for (int i = 0; i < this.distributeBy.size(); ++i) {
                SQLSelectOrderByItem sQLSelectOrderByItem = this.distributeBy.get(i).clone();
                sQLSelectOrderByItem.setParent(x);
                x.distributeBy.add(sQLSelectOrderByItem);
            }
        }
        if (this.sortBy != null) {
            if (x.sortBy == null) {
                x.sortBy = new ArrayList<SQLSelectOrderByItem>();
            }
            for (int i = 0; i < this.sortBy.size(); ++i) {
                SQLSelectOrderByItem sQLSelectOrderByItem = this.sortBy.get(i).clone();
                sQLSelectOrderByItem.setParent(x);
                x.sortBy.add(sQLSelectOrderByItem);
            }
        }
        if (this.clusterBy != null) {
            if (x.clusterBy == null) {
                x.clusterBy = new ArrayList<SQLSelectOrderByItem>();
            }
            for (int i = 0; i < this.clusterBy.size(); ++i) {
                SQLSelectOrderByItem sQLSelectOrderByItem = this.clusterBy.get(i).clone();
                sQLSelectOrderByItem.setParent(x);
                x.clusterBy.add(sQLSelectOrderByItem);
            }
        }
        x.parenthesized = this.parenthesized;
        x.forUpdate = this.forUpdate;
        x.noWait = this.noWait;
        x.skipLocked = this.skipLocked;
        x.forShare = this.forShare;
        if (this.waitTime != null) {
            x.setWaitTime(this.waitTime.clone());
        }
        if (this.limit != null) {
            x.setLimit(this.limit.clone());
        }
    }

    public SQLTableSource findTableSource(String alias) {
        if (this.from == null) {
            return null;
        }
        return this.from.findTableSource(alias);
    }

    public SQLTableSource findTableSourceWithColumn(String column) {
        if (this.from == null) {
            return null;
        }
        return this.from.findTableSourceWithColumn(column);
    }

    public SQLTableSource findTableSourceWithColumn(long columnHash) {
        SQLSelectItem selectItem;
        if (this.from == null) {
            return null;
        }
        SQLTableSource tableSource = this.from.findTableSourceWithColumn(columnHash);
        if (tableSource == null && this.from instanceof SQLExprTableSource && (selectItem = this.findSelectItem(columnHash)) != null && selectItem.getExpr() instanceof SQLName && ((SQLName)selectItem.getExpr()).nameHashCode64() == columnHash) {
            tableSource = this.from;
        }
        return tableSource;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (this.where == expr) {
            this.setWhere(target);
            return true;
        }
        if (this.startWith == expr) {
            this.setStartWith(target);
            return true;
        }
        if (this.connectBy == expr) {
            this.setConnectBy(target);
            return true;
        }
        return false;
    }

    public SQLSelectItem findSelectItem(String ident) {
        if (ident == null) {
            return null;
        }
        long hash = FnvHash.hashCode64(ident);
        return this.findSelectItem(hash);
    }

    public SQLSelectItem findSelectItem(long identHash) {
        SQLTableSource matchedTableSource;
        for (SQLSelectItem item : this.selectList) {
            if (!item.match(identHash)) continue;
            return item;
        }
        if (this.from == null) {
            return null;
        }
        if (this.selectList.size() == 1 && this.selectList.get(0).getExpr() instanceof SQLAllColumnExpr && (matchedTableSource = this.from.findTableSourceWithColumn(identHash)) != null) {
            return this.selectList.get(0);
        }
        SQLSelectItem ownerAllItem = null;
        for (SQLSelectItem item : this.selectList) {
            SQLExpr itemExpr = item.getExpr();
            if (!(itemExpr instanceof SQLPropertyExpr) || !((SQLPropertyExpr)itemExpr).getName().equals("*")) continue;
            if (ownerAllItem != null) {
                return null;
            }
            ownerAllItem = item;
        }
        if (ownerAllItem != null) {
            return ownerAllItem;
        }
        return null;
    }

    public boolean selectItemHasAllColumn() {
        return this.selectItemHasAllColumn(true);
    }

    public boolean selectItemHasAllColumn(boolean recursive) {
        for (SQLSelectItem item : this.selectList) {
            SQLSelect subSelect;
            SQLSelectQueryBlock queryBlock;
            SQLExpr expr = item.getExpr();
            boolean allColumn = expr instanceof SQLAllColumnExpr || expr instanceof SQLPropertyExpr && ((SQLPropertyExpr)expr).getName().equals("*");
            if (!allColumn) continue;
            if (recursive && this.from instanceof SQLSubqueryTableSource && (queryBlock = (subSelect = ((SQLSubqueryTableSource)this.from).select).getQueryBlock()) != null) {
                return queryBlock.selectItemHasAllColumn();
            }
            return true;
        }
        return false;
    }

    public SQLSelectItem findAllColumnSelectItem() {
        SQLSelectItem allColumnItem = null;
        for (SQLSelectItem item : this.selectList) {
            boolean allColumn;
            SQLExpr expr = item.getExpr();
            boolean bl = allColumn = expr instanceof SQLAllColumnExpr || expr instanceof SQLPropertyExpr && ((SQLPropertyExpr)expr).getName().equals("*");
            if (allColumnItem != null) {
                return null;
            }
            allColumnItem = item;
        }
        return allColumnItem;
    }

    public SQLColumnDefinition findColumn(String columnName) {
        if (this.from == null) {
            return null;
        }
        long hash = FnvHash.hashCode64(columnName);
        return this.from.findColumn(hash);
    }

    public SQLColumnDefinition findColumn(long columnNameHash) {
        SQLExpr expr;
        SQLObject object = this.resolveColum(columnNameHash);
        if (object instanceof SQLColumnDefinition) {
            return (SQLColumnDefinition)object;
        }
        if (object instanceof SQLSelectItem && (expr = ((SQLSelectItem)object).getExpr()) instanceof SQLName) {
            return ((SQLName)expr).getResolvedColumn();
        }
        return null;
    }

    public SQLObject resolveColum(long columnNameHash) {
        SQLSelectItem selectItem = this.findSelectItem(columnNameHash);
        if (selectItem != null) {
            SQLTableSource resolvedTableSource;
            SQLExpr selectItemExpr = selectItem.getExpr();
            if (selectItemExpr instanceof SQLAllColumnExpr) {
                SQLObject resolveColumn = this.from.resolveColum(columnNameHash);
                if (resolveColumn != null) {
                    return resolveColumn;
                }
            } else if (selectItemExpr instanceof SQLPropertyExpr && ((SQLPropertyExpr)selectItemExpr).getName().equals("*") && (resolvedTableSource = ((SQLPropertyExpr)selectItemExpr).getResolvedTableSource()) instanceof SQLSubqueryTableSource) {
                boolean isParentTableSource = false;
                for (SQLObject parent = this.getParent(); parent != null; parent = parent.getParent()) {
                    if (parent != resolvedTableSource) continue;
                    isParentTableSource = true;
                    break;
                }
                if (isParentTableSource) {
                    return null;
                }
                SQLObject resolveColumn = resolvedTableSource.resolveColum(columnNameHash);
                if (resolveColumn != null) {
                    return resolveColumn;
                }
            }
            return selectItem;
        }
        if (this.from != null) {
            return this.from.resolveColum(columnNameHash);
        }
        return null;
    }

    public void addCondition(String conditionSql) {
        if (conditionSql == null || conditionSql.length() == 0) {
            return;
        }
        SQLExpr condition = SQLUtils.toSQLExpr(conditionSql, this.dbType);
        this.addCondition(condition);
    }

    public void addCondition(SQLExpr expr) {
        if (expr == null) {
            return;
        }
        this.setWhere(SQLBinaryOpExpr.and(this.where, expr));
    }

    public boolean removeCondition(String conditionSql) {
        if (conditionSql == null || conditionSql.length() == 0) {
            return false;
        }
        SQLExpr condition = SQLUtils.toSQLExpr(conditionSql, this.dbType);
        return this.removeCondition(condition);
    }

    public boolean removeCondition(SQLExpr condition) {
        SQLBinaryOpExpr binaryOpWhere;
        SQLBinaryOperator operator;
        if (condition == null) {
            return false;
        }
        if (this.where instanceof SQLBinaryOpExprGroup) {
            SQLBinaryOpExprGroup group = (SQLBinaryOpExprGroup)this.where;
            int removedCount = 0;
            List<SQLExpr> items = group.getItems();
            for (int i = items.size() - 1; i >= 0; --i) {
                SQLExpr item = items.get(i);
                if (!item.equals(condition)) continue;
                items.remove(i);
                ++removedCount;
            }
            if (items.isEmpty()) {
                this.where = null;
            }
            return removedCount > 0;
        }
        if (this.where instanceof SQLBinaryOpExpr && ((operator = (binaryOpWhere = (SQLBinaryOpExpr)this.where).getOperator()) == SQLBinaryOperator.BooleanAnd || operator == SQLBinaryOperator.BooleanOr)) {
            List<SQLExpr> items = SQLBinaryOpExpr.split(binaryOpWhere);
            int removedCount = 0;
            for (int i = items.size() - 1; i >= 0; --i) {
                SQLExpr item = items.get(i);
                if (!item.equals(condition) || !SQLUtils.replaceInParent(item, null)) continue;
                ++removedCount;
            }
            return removedCount > 0;
        }
        if (condition.equals(this.where)) {
            this.where = null;
            return true;
        }
        return false;
    }

    public void limit(int rowCount, int offset) {
        SQLLimit limit = new SQLLimit();
        limit.setRowCount(new SQLIntegerExpr(rowCount));
        if (offset > 0) {
            limit.setOffset(new SQLIntegerExpr(offset));
        }
        this.setLimit(limit);
    }

    public String getCachedSelectList() {
        return this.cachedSelectList;
    }

    public void setCachedSelectList(String cachedSelectList, long cachedSelectListHash) {
        this.cachedSelectList = cachedSelectList;
        this.cachedSelectListHash = cachedSelectListHash;
    }

    public long getCachedSelectListHash() {
        return this.cachedSelectListHash;
    }

    @Override
    public DbType getDbType() {
        return this.dbType;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    public List<SQLCommentHint> getHintsDirect() {
        return this.hints;
    }

    public List<SQLCommentHint> getHints() {
        if (this.hints == null) {
            this.hints = new ArrayList<SQLCommentHint>(2);
        }
        return this.hints;
    }

    public void setHints(List<SQLCommentHint> hints) {
        this.hints = hints;
    }

    public int getHintsSize() {
        if (this.hints == null) {
            return 0;
        }
        return this.hints.size();
    }

    public boolean replaceInParent(SQLSelectQuery x) {
        if (this.parent instanceof SQLSelect) {
            ((SQLSelect)this.parent).setQuery(x);
            return true;
        }
        if (this.parent instanceof SQLUnionQuery) {
            SQLUnionQuery union = (SQLUnionQuery)this.parent;
            return union.replace(this, x);
        }
        return false;
    }

    public List<SQLSelectOrderByItem> getClusterBy() {
        if (this.clusterBy == null) {
            this.clusterBy = new ArrayList<SQLSelectOrderByItem>();
        }
        return this.clusterBy;
    }

    public List<SQLSelectOrderByItem> getClusterByDirect() {
        return this.clusterBy;
    }

    public void addClusterBy(SQLSelectOrderByItem item) {
        if (this.clusterBy == null) {
            this.clusterBy = new ArrayList<SQLSelectOrderByItem>();
        }
        if (item != null) {
            item.setParent(this);
        }
        this.clusterBy.add(item);
    }

    public List<String> computeSelecteListAlias() {
        ArrayList<String> aliasList = new ArrayList<String>();
        for (SQLSelectItem item : this.selectList) {
            if (item instanceof OdpsUDTFSQLSelectItem) {
                aliasList.addAll(((OdpsUDTFSQLSelectItem)item).getAliasList());
                continue;
            }
            SQLExpr expr = item.getExpr();
            if (expr instanceof SQLAllColumnExpr || expr instanceof SQLPropertyExpr && ((SQLPropertyExpr)expr).getName().equals("*")) continue;
            aliasList.add(item.computeAlias());
        }
        return aliasList;
    }

    public List<SQLTableSource> getMappJoinTableSources() {
        if (this.hints == null) {
            return Collections.emptyList();
        }
        ArrayList<SQLTableSource> tableSources = null;
        for (SQLCommentHint hint : this.hints) {
            SQLMethodInvokeExpr func;
            SQLExpr hintExpr;
            String text = hint.getText();
            if (!text.startsWith("+") || !((hintExpr = SQLUtils.toSQLExpr(text.substring(1), this.dbType)) instanceof SQLMethodInvokeExpr) || (func = (SQLMethodInvokeExpr)hintExpr).methodNameHashCode64() != FnvHash.Constants.MAPJOIN) continue;
            for (SQLExpr arg : func.getArguments()) {
                SQLIdentifierExpr tablename = (SQLIdentifierExpr)arg;
                SQLTableSource tableSource = this.findTableSource(tablename.getName());
                if (tableSources == null) {
                    tableSources = new ArrayList<SQLTableSource>(2);
                }
                tableSources.add(tableSource);
            }
        }
        if (tableSources == null) {
            return Collections.emptyList();
        }
        return tableSources;
    }

    public boolean clearMapJoinHint() {
        if (this.hints == null) {
            return false;
        }
        int removeCount = 0;
        for (int i = this.hints.size() - 1; i >= 0; --i) {
            SQLMethodInvokeExpr func;
            SQLExpr hintExpr;
            SQLCommentHint hint = this.hints.get(i);
            String text = hint.getText();
            if (!text.startsWith("+") || !((hintExpr = SQLUtils.toSQLExpr(text.substring(1), this.dbType)) instanceof SQLMethodInvokeExpr) || (func = (SQLMethodInvokeExpr)hintExpr).methodNameHashCode64() != FnvHash.Constants.MAPJOIN) continue;
            this.hints.remove(i);
            ++removeCount;
        }
        return removeCount > 0;
    }

    private static class AggregationStatVisitor
    extends SQLASTVisitorAdapter {
        private boolean aggregation;

        private AggregationStatVisitor() {
        }

        @Override
        public boolean visit(SQLAggregateExpr x) {
            this.aggregation = true;
            return false;
        }
    }
}

