/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.starrocks.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLIndexDefinition;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLArrayExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.dialect.starrocks.ast.statement.StarRocksCreateResourceStatement;
import com.alibaba.druid.sql.dialect.starrocks.ast.statement.StarRocksCreateTableStatement;
import com.alibaba.druid.sql.dialect.starrocks.visitor.StarRocksASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.util.FnvHash;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class StarRocksOutputVisitor
extends SQLASTOutputVisitor
implements StarRocksASTVisitor {
    public StarRocksOutputVisitor(StringBuilder appender) {
        super(appender);
        this.dbType = DbType.starrocks;
        this.shardingSupport = true;
        this.quote = (char)96;
    }

    public StarRocksOutputVisitor(StringBuilder appender, DbType dbType) {
        super(appender, dbType);
        this.dbType = DbType.starrocks;
        this.shardingSupport = true;
        this.quote = (char)96;
    }

    public StarRocksOutputVisitor(StringBuilder appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = DbType.starrocks;
        this.shardingSupport = true;
        this.quote = (char)96;
    }

    @Override
    public boolean visit(StarRocksCreateTableStatement x) {
        SQLExpr partitionBy;
        super.visit(x);
        SQLIndexDefinition model = x.getModelKey();
        if (model != null) {
            this.println();
            model.accept(this);
        }
        if (x.getComment() != null) {
            this.println();
            this.print0(this.ucase ? "COMMENT " : "comment ");
            x.getComment().accept(this);
        }
        if ((partitionBy = x.getPartitionBy()) != null) {
            this.println();
            this.print0(this.ucase ? "PARTITION BY " : "partition by ");
            partitionBy.accept(this);
            this.println();
            this.print0("(");
            this.println();
            if (x.isLessThan()) {
                Map<SQLExpr, SQLExpr> lessThanMap = x.getLessThanMap();
                Set<SQLExpr> keySet = lessThanMap.keySet();
                int size = keySet.size();
                if (size > 0) {
                    int i = 0;
                    for (SQLExpr key : keySet) {
                        if (i != 0) {
                            this.println(", ");
                        }
                        SQLObject value = lessThanMap.get(key);
                        this.print0(this.ucase ? "  PARTITION " : "  partition ");
                        key.accept(this);
                        this.print0(this.ucase ? " VALUES LESS THAN " : " values less than ");
                        String s = value.toString();
                        if (s.startsWith("MAXVALUE")) {
                            value.accept(this);
                        } else {
                            this.print0("(");
                            value.accept(this);
                            this.print0(")");
                        }
                        ++i;
                    }
                }
            } else if (x.isFixedRange()) {
                Map<SQLExpr, List<SQLExpr>> fixedRangeMap = x.getFixedRangeMap();
                Set<SQLExpr> keySet = fixedRangeMap.keySet();
                int size = keySet.size();
                if (size > 0) {
                    int i = 0;
                    for (SQLExpr key : keySet) {
                        List<SQLExpr> valueList = fixedRangeMap.get(key);
                        int listSize = valueList.size();
                        this.print0(this.ucase ? "  PARTITION " : "  partition ");
                        key.accept(this);
                        this.print0(this.ucase ? " VALUES " : " values ");
                        this.print0("[");
                        for (int j = 0; j < listSize; ++j) {
                            SQLExpr sqlExpr = valueList.get(j);
                            String[] split = sqlExpr.toString().split(",");
                            if (split.length <= 1) {
                                this.print0("(");
                                sqlExpr.accept(this);
                                this.print0(")");
                            } else {
                                sqlExpr.accept(this);
                            }
                            if (j == listSize - 1) continue;
                            this.print0(",");
                        }
                        this.print0(")");
                        if (i != size - 1) {
                            this.print0(",");
                            this.println();
                        }
                        ++i;
                    }
                }
            } else if (x.isStartEnd()) {
                if (x.getStart() != null) {
                    this.print0(this.ucase ? "  START " : "  start ");
                    this.print0("(");
                    x.getStart().accept(this);
                    this.print0(")");
                }
                if (x.getEnd() != null) {
                    this.print0(this.ucase ? "  END " : "  end ");
                    this.print0("(");
                    x.getEnd().accept(this);
                    this.print0(")");
                }
                if (x.getEvery() != null) {
                    this.print0(this.ucase ? "  EVERY " : "  every ");
                    this.print0("(");
                    x.getEvery().accept(this);
                    this.print0(")");
                }
            }
            this.println();
            this.print0(")");
        }
        this.println();
        if (x.getDistributedBy() != null) {
            this.print0(this.ucase ? "DISTRIBUTED BY " : "distributed by ");
            x.getDistributedBy().accept(this);
            int buckets = x.getBuckets();
            if (buckets > 0) {
                this.print0(this.ucase ? " BUCKETS " : "buckets ");
                this.print0(String.valueOf(buckets));
            }
        }
        this.println();
        List<SQLSelectOrderByItem> sortedBy = x.getSortedBy();
        if (sortedBy.size() > 0) {
            this.println();
            this.print0(this.ucase ? "ORDER BY (" : "order by (");
            this.printAndAccept(sortedBy, ", ");
            this.print(')');
            this.println();
        }
        if (x.getStarRocksProperties().size() > 0) {
            this.print0(this.ucase ? "PROPERTIES" : "properties");
            this.print(x.getStarRocksProperties());
        }
        return false;
    }

    protected void print(List<? extends SQLExpr> exprList) {
        int size = exprList.size();
        if (size == 0) {
            return;
        }
        this.print0(" (");
        ++this.indentCount;
        this.println();
        for (int i = 0; i < size; ++i) {
            SQLExpr element = exprList.get(i);
            if (element instanceof SQLArrayExpr) {
                SQLArrayExpr array = (SQLArrayExpr)element;
                SQLExpr expr = array.getExpr();
                if (expr instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)expr).nameHashCode64() == FnvHash.Constants.ARRAY && this.printNameQuote) {
                    this.print0(((SQLIdentifierExpr)expr).getName());
                } else if (expr != null) {
                    expr.accept(this);
                }
                this.print('[');
                this.printAndAccept(array.getValues(), ", ");
                if (i != size - 1) {
                    this.print0(",");
                }
                this.print(']');
            } else {
                element.accept(this);
            }
            if (i != size - 1 && !(element instanceof SQLArrayExpr)) {
                this.print(',');
            }
            if (i == size - 1) continue;
            this.println();
        }
        --this.indentCount;
        this.println();
        this.print(')');
    }

    @Override
    public boolean visit(SQLColumnDefinition x) {
        super.visit(x);
        if (x.getAggType() != null) {
            this.print(' ');
            this.print0(this.ucase ? x.getAggType().getText().toUpperCase(Locale.ROOT) : x.getAggType().getText().toLowerCase(Locale.ROOT));
        }
        if (x.getBitmap() != null) {
            this.print(' ');
            this.print0(this.ucase ? "USING " : "using ");
            this.print0(this.ucase ? x.getBitmap().getText().toUpperCase(Locale.ROOT) : x.getBitmap().getText().toLowerCase(Locale.ROOT));
        }
        if (x.getIndexComment() != null) {
            this.print(' ');
            this.print0(this.ucase ? "COMMENT " : "comment ");
            x.getIndexComment().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksCreateResourceStatement x) {
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.isExternal()) {
            this.print0(this.ucase ? "EXTERNAL " : "external ");
        }
        this.print0(this.ucase ? "RESOURCE " : "resource ");
        x.getName().accept(this);
        this.println();
        this.print0(this.ucase ? "PROPERTIES" : "properties");
        this.print(x.getProperties());
        return false;
    }
}

