/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.governance.common.utils;

import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenSeq;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class GovernanceUtils$
implements Logging {
    public static GovernanceUtils$ MODULE$;
    private final String LINKIS_DEFAULT_RES_CREATOR;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new GovernanceUtils$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        GovernanceUtils$ governanceUtils$ = this;
        synchronized (governanceUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String LINKIS_DEFAULT_RES_CREATOR() {
        return this.LINKIS_DEFAULT_RES_CREATOR;
    }

    public void killProcess(String pid, String desc, boolean isSudo) {
        String subProcessKillScriptPath = new StringBuilder(28).append(Configuration$.MODULE$.getLinkisHome()).append("/sbin/kill-process-by-pid.sh").toString();
        if (StringUtils.isBlank((CharSequence)subProcessKillScriptPath) || !new File(subProcessKillScriptPath).exists()) {
            this.logger().error(new StringBuilder(40).append("Failed to locate kill-script, ").append(subProcessKillScriptPath).append(" not exist").toString());
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)pid)) {
            String[] cmd = isSudo ? (String[])((Object[])new String[]{"sudo", "sh", subProcessKillScriptPath, String.valueOf(pid)}) : (String[])((Object[])new String[]{"sh", subProcessKillScriptPath, String.valueOf(pid)});
            this.logger().info(new StringBuilder(54).append("Starting to kill sub-processes. desc: ").append(desc).append("  Kill Command: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)).mkString(" ")).toString());
            Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String output = Utils$.MODULE$.exec(cmd, 600000L);
                MODULE$.logger().info(new StringBuilder(28).append("Kill Success! desc: ").append(desc).append(". msg:\n ").append(output).toString());
            }, (Function1 & Serializable & scala.Serializable)t -> {
                GovernanceUtils$.$anonfun$killProcess$2(desc, t);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void killYarnJobApp(List<String> appIds) {
        if (appIds == null || appIds.isEmpty()) {
            return;
        }
        String[] cmdArr = new String[appIds.size() + 2];
        cmdArr[0] = "sh";
        cmdArr[1] = (String)GovernanceCommonConf$.MODULE$.ENGINE_CONN_YARN_APP_KILL_SCRIPTS_PATH().getValue();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), appIds.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            cmdArr$1[i + 2] = (String)appIds.get(i);
        });
        this.logger().info(new StringBuilder(50).append("Starting to kill yarn applications. Kill Command: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArr)).mkString(" ")).toString());
        Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String output = Utils$.MODULE$.exec(cmdArr, 600000L);
            MODULE$.logger().error(new StringBuilder(43).append("Kill yarn applications successfully! msg: ").append(output).append(".").toString());
        }, (Function1 & Serializable & scala.Serializable)t -> {
            GovernanceUtils$.$anonfun$killYarnJobApp$3(t);
            return BoxedUnit.UNIT;
        });
    }

    public void killECProcessByPort(String port, String desc, boolean isSudo) {
        String subProcessKillScriptPath = new StringBuilder(32).append(Configuration$.MODULE$.getLinkisHome()).append("/sbin/kill-ec-process-by-port.sh").toString();
        if (StringUtils.isBlank((CharSequence)subProcessKillScriptPath) || !new File(subProcessKillScriptPath).exists()) {
            this.logger().error(new StringBuilder(40).append("Failed to locate kill-script, ").append(subProcessKillScriptPath).append(" not exist").toString());
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)port)) {
            String[] cmd = isSudo ? (String[])((Object[])new String[]{"sudo", "sh", subProcessKillScriptPath, port}) : (String[])((Object[])new String[]{"sh", subProcessKillScriptPath, port});
            this.logger().info(new StringBuilder(66).append("Starting to kill process and sub-processes. desc: ").append(desc).append("  Kill Command: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)).mkString(" ")).toString());
            Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String output = Utils$.MODULE$.exec(cmd, 600000L);
                MODULE$.logger().info(new StringBuilder(28).append("Kill Success! desc: ").append(desc).append(". msg:\n ").append(output).toString());
            }, (Function1 & Serializable & scala.Serializable)t -> {
                GovernanceUtils$.$anonfun$killECProcessByPort$2(desc, t);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public String findProcessIdentifier(String processPort) {
        String string;
        String findCmd = new StringBuilder(70).append("sudo netstat -tunlp | grep :").append(processPort).append(" | awk '{print $7}' | awk -F/ '{print $1}'").toString();
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add("bash");
        cmdList.add("-c");
        cmdList.add(findCmd);
        try {
            string = Utils$.MODULE$.exec((String[])cmdList.toArray((Object[])new String[0]), 5000L);
        }
        catch (Exception e) {
            this.logger().warn(new StringBuilder(23).append("Method findPid failed, ").append(e.getMessage()).toString());
            string = null;
        }
        return string;
    }

    public String getResultParentPath(String creator) {
        String resPrefix = (String)GovernanceCommonConf$.MODULE$.RESULT_SET_STORE_PATH().getValue();
        scala.collection.mutable.StringBuilder resStb = new scala.collection.mutable.StringBuilder();
        scala.collection.mutable.StringBuilder stringBuilder = resStb.endsWith((GenSeq)Predef$.MODULE$.wrapString("/")) ? resStb.append(resPrefix) : resStb.append(resPrefix).append("/");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date(System.currentTimeMillis());
        String dateString = dateFormat.format(date);
        resStb.append("result").append("/").append(dateString).append("/").append(creator);
        return resStb.toString();
    }

    public static final /* synthetic */ void $anonfun$killProcess$2(String desc$1, Throwable t) {
        MODULE$.logger().error(new StringBuilder(19).append("Kill error! desc: ").append(desc$1).append(".").toString(), t);
    }

    public static final /* synthetic */ void $anonfun$killYarnJobApp$3(Throwable t) {
        MODULE$.logger().error("Kill yarn applications failed!", t);
    }

    public static final /* synthetic */ void $anonfun$killECProcessByPort$2(String desc$2, Throwable t) {
        MODULE$.logger().error(new StringBuilder(19).append("Kill error! desc: ").append(desc$2).append(".").toString(), t);
    }

    private GovernanceUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.LINKIS_DEFAULT_RES_CREATOR = "linkis_default";
    }
}

