/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.acessible.executor.log;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.linkis.engineconn.acessible.executor.conf.AccessibleExecutorConfiguration;
import org.apache.linkis.engineconn.acessible.executor.log.LogCache;
import org.apache.linkis.engineconn.acessible.executor.log.LogHelper;
import org.apache.linkis.engineconn.common.conf.EngineConnConf;
import org.apache.linkis.engineconn.common.conf.EngineConnConstant;
import org.apache.linkis.engineconn.common.creation.EngineCreationContext;
import org.apache.linkis.engineconn.core.EngineConnObject;
import org.apache.linkis.engineconn.executor.listener.EngineConnSyncListenerBus;
import org.apache.linkis.engineconn.executor.listener.ExecutorListenerBusContext;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(name="Send", category="Core", elementType="appender", printObject=true)
public class SendAppender
extends AbstractAppender {
    private static final long serialVersionUID = -830237775522429777L;
    private static EngineConnSyncListenerBus engineConnSyncListenerBus = ExecutorListenerBusContext.getExecutorListenerBusContext().getEngineConnSyncListenerBus();
    private LogCache logCache = LogHelper.logCache();
    private static final Logger logger = LoggerFactory.getLogger(SendAppender.class);
    private static final String IGNORE_WORDS = (String)AccessibleExecutorConfiguration.ENGINECONN_IGNORE_WORDS().getValue();
    private static final String[] IGNORE_WORD_ARR = IGNORE_WORDS.split(",");
    private static final String PASS_WORDS = (String)AccessibleExecutorConfiguration.ENGINECONN_PASS_WORDS().getValue();
    private static final String[] PASS_WORDS_ARR = PASS_WORDS.split(",");

    public SendAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
        logger.info("SendAppender init success");
    }

    public void append(LogEvent event) {
        if (engineConnSyncListenerBus == null) {
            return;
        }
        String logStr = new String(this.getLayout().toByteArray(event));
        if (event.getLevel().intLevel() == Level.INFO.intLevel()) {
            boolean flag = false;
            for (String ignoreLog : IGNORE_WORD_ARR) {
                if (!logStr.contains(ignoreLog)) continue;
                flag = true;
                break;
            }
            for (String word : PASS_WORDS_ARR) {
                if (!logStr.contains(word)) continue;
                flag = false;
                break;
            }
            if (!flag) {
                this.logCache.cacheLog(logStr);
            }
        } else {
            this.logCache.cacheLog(logStr);
        }
    }

    @PluginFactory
    public static SendAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions) {
        if (name == null) {
            LOGGER.error("No name provided for SendAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new SendAppender(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions);
    }

    public String matchLog(String logLine) {
        Matcher hiveMatcher = Pattern.compile(EngineConnConstant.hiveLogReg()).matcher(logLine);
        if (hiveMatcher.find()) {
            String yarnUrl = (String)EngineConnConf.JOB_YARN_TASK_URL().getValue();
            EngineCreationContext engineContext = EngineConnObject.getEngineCreationContext();
            if (null != engineContext) {
                for (Label label : engineContext.getLabels()) {
                    if (!label.getLabelKey().equals("yarnCluster")) continue;
                    yarnUrl = (String)EngineConnConf.JOB_YARN_CLUSTER_TASK_URL().getValue();
                }
            }
            logLine = hiveMatcher.replaceAll(EngineConnConstant.YARN_LOG_URL() + yarnUrl + hiveMatcher.group(1));
        }
        return logLine;
    }
}

