/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.computation.executor.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.common.listener.EventListener;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.acessible.executor.listener.LogListener;
import org.apache.linkis.engineconn.acessible.executor.listener.event.TaskLogUpdateEvent;
import org.apache.linkis.engineconn.acessible.executor.listener.event.TaskProgressUpdateEvent;
import org.apache.linkis.engineconn.acessible.executor.listener.event.TaskResponseErrorEvent;
import org.apache.linkis.engineconn.acessible.executor.listener.event.TaskResultCreateEvent;
import org.apache.linkis.engineconn.acessible.executor.listener.event.TaskResultSizeCreatedEvent;
import org.apache.linkis.engineconn.acessible.executor.listener.event.TaskStatusChangedEvent;
import org.apache.linkis.engineconn.acessible.executor.log.LogHelper$;
import org.apache.linkis.engineconn.acessible.executor.service.LockService;
import org.apache.linkis.engineconn.common.conf.EngineConnConf$;
import org.apache.linkis.engineconn.common.conf.EngineConnConstant$;
import org.apache.linkis.engineconn.computation.executor.async.AsyncConcurrentComputationExecutor;
import org.apache.linkis.engineconn.computation.executor.conf.ComputationExecutorConf$;
import org.apache.linkis.engineconn.computation.executor.entity.CommonEngineConnTask;
import org.apache.linkis.engineconn.computation.executor.entity.EngineConnTask;
import org.apache.linkis.engineconn.computation.executor.execute.ComputationExecutor;
import org.apache.linkis.engineconn.computation.executor.execute.ConcurrentComputationExecutor;
import org.apache.linkis.engineconn.computation.executor.listener.ResultSetListener;
import org.apache.linkis.engineconn.computation.executor.listener.TaskProgressListener;
import org.apache.linkis.engineconn.computation.executor.listener.TaskStatusListener;
import org.apache.linkis.engineconn.computation.executor.service.TaskExecutionService;
import org.apache.linkis.engineconn.computation.executor.service.TaskExecutionServiceImpl$;
import org.apache.linkis.engineconn.computation.executor.upstream.event.TaskStatusChangedForUpstreamMonitorEvent;
import org.apache.linkis.engineconn.computation.executor.utlis.ComputationEngineConstant$;
import org.apache.linkis.engineconn.computation.executor.utlis.ComputationEngineUtils$;
import org.apache.linkis.engineconn.core.EngineConnObject$;
import org.apache.linkis.engineconn.core.executor.ExecutorManager$;
import org.apache.linkis.engineconn.core.executor.LabelExecutorManager;
import org.apache.linkis.engineconn.executor.entity.Executor;
import org.apache.linkis.engineconn.executor.entity.LabelExecutor;
import org.apache.linkis.engineconn.executor.entity.ResourceFetchExecutor;
import org.apache.linkis.engineconn.executor.listener.EngineConnSyncListenerBus;
import org.apache.linkis.engineconn.executor.listener.ExecutorListenerBusContext$;
import org.apache.linkis.engineconn.executor.listener.event.EngineConnSyncEvent;
import org.apache.linkis.governance.common.constant.ec.ECConstants$;
import org.apache.linkis.governance.common.entity.ExecutionNodeStatus;
import org.apache.linkis.governance.common.exception.engineconn.EngineConnExecutorErrorException;
import org.apache.linkis.governance.common.protocol.task.RequestTask;
import org.apache.linkis.governance.common.protocol.task.RequestTaskKill;
import org.apache.linkis.governance.common.protocol.task.RequestTaskPause;
import org.apache.linkis.governance.common.protocol.task.RequestTaskResume;
import org.apache.linkis.governance.common.protocol.task.RequestTaskStatus;
import org.apache.linkis.governance.common.protocol.task.ResponseTaskError;
import org.apache.linkis.governance.common.protocol.task.ResponseTaskLog;
import org.apache.linkis.governance.common.protocol.task.ResponseTaskProgress;
import org.apache.linkis.governance.common.protocol.task.ResponseTaskResultSet;
import org.apache.linkis.governance.common.protocol.task.ResponseTaskResultSize;
import org.apache.linkis.governance.common.protocol.task.ResponseTaskStatus;
import org.apache.linkis.governance.common.utils.JobUtils$;
import org.apache.linkis.governance.common.utils.LoggerUtils;
import org.apache.linkis.hadoop.common.utils.KerberosUtils;
import org.apache.linkis.manager.common.protocol.resource.ResponseTaskRunningInfo;
import org.apache.linkis.manager.common.protocol.resource.ResponseTaskYarnResource;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.protocol.message.RequestProtocol;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.apache.linkis.rpc.utils.RPCUtils$;
import org.apache.linkis.scheduler.executer.ErrorExecuteResponse;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.IncompleteExecuteResponse;
import org.apache.linkis.scheduler.executer.SubmitResponse;
import org.apache.linkis.server.BDPJettyServerHelper$;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContextExecutorService;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0011\u001dc\u0001\u0002\u001c8\u0001\u0019CQ!\u001c\u0001\u0005\u00029D\u0001\u0002\u001d\u0001\t\u0006\u0004%I!\u001d\u0005\bs\u0002\u0011\r\u0011\"\u0003{\u0011\u001d\ty\u0001\u0001Q\u0001\nmD1\"!\u0005\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0014!Y\u0011\u0011\u0005\u0001A\u0002\u0003\u0007I\u0011BA\u0012\u0011-\ty\u0003\u0001a\u0001\u0002\u0003\u0006K!!\u0006\t\u0017\u0005E\u0002\u00011AA\u0002\u0013%\u00111\u0007\u0005\f\u0003\u0003\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019\u0005C\u0006\u0002H\u0001\u0001\r\u0011!Q!\n\u0005U\u0002bCA%\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0017B1\"a\u001c\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002r!Y\u0011q\f\u0001A\u0002\u0003\u0005\u000b\u0015BA'\u0011-\ti\b\u0001a\u0001\u0002\u0004%I!a \t\u0017\u0005-\u0005\u00011AA\u0002\u0013%\u0011Q\u0012\u0005\f\u0003#\u0003\u0001\u0019!A!B\u0013\t\t\tC\u0005\u0002.\u0002\u0011\r\u0011\"\u0003\u00020\"A\u0011Q\u0018\u0001!\u0002\u0013\t\t\fC\u0005\u0002@\u0002\u0011\r\u0011\"\u0003\u0002B\"A\u00111 \u0001!\u0002\u0013\t\u0019\r\u0003\u0006\u0002~\u0002A)\u0019!C\u0005\u0003\u007fD\u0011Ba\u0002\u0001\u0005\u0004%IA!\u0003\t\u0011\tU\u0001\u0001)A\u0005\u0005\u0017AqAa\u0006\u0001\t\u0003\u0011I\u0002C\u0004\u0003,\u0001!IA!\f\t\u000f\u0005U\b\u0001\"\u0011\u0003H!9!Q\u0012\u0001\u0005\n\t=\u0005b\u0002B_\u0001\u0011%!q\u0018\u0005\b\u0005\u000f\u0004A\u0011\u0002Be\u0011\u001d\u0011y\r\u0001C\u0005\u0005#DqAa6\u0001\t\u0013\u0011I\u000eC\u0004\u0003f\u0002!IAa:\t\u000f\t5\b\u0001\"\u0003\u0003p\"91Q\u0001\u0001\u0005\n\r\u001d\u0001bBB\r\u0001\u0011%11\u0004\u0005\b\u0007_\u0001A\u0011BB\u0019\u0011\u001d\u00199\u0004\u0001C!\u0007sAqaa\u0011\u0001\t\u0003\u001a)\u0005C\u0004\u0004P\u0001!\te!\u0015\t\u000f\rU\u0003\u0001\"\u0011\u0004X!911\u000e\u0001\u0005B\r5\u0004bBB>\u0001\u0011\u00053Q\u0010\u0005\b\u0007\u0017\u0003A\u0011IBG\u0011\u001d\u0019Y\n\u0001C!\u0007;Cqa!,\u0001\t\u0003\u001ay\u000bC\u0004\u0004@\u0002!\te!1\t\u000f\r5\u0007\u0001\"\u0011\u0004P\"911\u001c\u0001\u0005B\ru\u0007bBBu\u0001\u0011%11\u001e\u0005\b\u0007c\u0004A\u0011IBz\u0011\u001d\u0019y\u0010\u0001C!\t\u0003Aq\u0001\"\n\u0001\t\u0003\"9\u0003C\u0004\u0005,\u0001!\t\u0005\"\f\u00031Q\u000b7o[#yK\u000e,H/[8o'\u0016\u0014h/[2f\u00136\u0004HN\u0003\u00029s\u000591/\u001a:wS\u000e,'B\u0001\u001e<\u0003!)\u00070Z2vi>\u0014(B\u0001\u001f>\u0003-\u0019w.\u001c9vi\u0006$\u0018n\u001c8\u000b\u0005yz\u0014AC3oO&tWmY8o]*\u0011\u0001)Q\u0001\u0007Y&t7.[:\u000b\u0005\t\u001b\u0015AB1qC\u000eDWMC\u0001E\u0003\ry'oZ\u0002\u0001'!\u0001q)T)Z?\u001eT\u0007C\u0001%L\u001b\u0005I%\"\u0001&\u0002\u000bM\u001c\u0017\r\\1\n\u00051K%AB!osJ+g\r\u0005\u0002O\u001f6\tq'\u0003\u0002Qo\t!B+Y:l\u000bb,7-\u001e;j_:\u001cVM\u001d<jG\u0016\u0004\"AU,\u000e\u0003MS!\u0001V+\u0002\u000bU$\u0018\u000e\\:\u000b\u0005Y{\u0014AB2p[6|g.\u0003\u0002Y'\n9Aj\\4hS:<\u0007C\u0001.^\u001b\u0005Y&B\u0001/:\u0003!a\u0017n\u001d;f]\u0016\u0014\u0018B\u00010\\\u0005E\u0011Vm];miN+G\u000fT5ti\u0016tWM\u001d\t\u0003A\u0016l\u0011!\u0019\u0006\u00039\nT!AO2\u000b\u0005\u0011l\u0014!C1dKN\u001c\u0018N\u00197f\u0013\t1\u0017MA\u0006M_\u001ed\u0015n\u001d;f]\u0016\u0014\bC\u0001.i\u0013\tI7L\u0001\u000bUCN\\\u0007K]8he\u0016\u001c8\u000fT5ti\u0016tWM\u001d\t\u00035.L!\u0001\\.\u0003%Q\u000b7o[*uCR,8\u000fT5ti\u0016tWM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0004\"A\u0014\u0001\u0002\u001f\u0015DXmY;u_Jl\u0015M\\1hKJ,\u0012A\u001d\t\u0003g^l\u0011\u0001\u001e\u0006\u0003uUT!A^\u001f\u0002\t\r|'/Z\u0005\u0003qR\u0014A\u0003T1cK2,\u00050Z2vi>\u0014X*\u00198bO\u0016\u0014\u0018a\u0004;bg.,\u00050Z2vi\u0016$g*^7\u0016\u0003m\u00042\u0001`A\u0006\u001b\u0005i(B\u0001@\u0000\u0003\u0019\tGo\\7jG*!\u0011\u0011AA\u0002\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003\u000b\t9!\u0001\u0003vi&d'BAA\u0005\u0003\u0011Q\u0017M^1\n\u0007\u00055QPA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\u0011i\u0006\u001c8.\u0012=fGV$X\r\u001a(v[\u0002\n\u0001\u0002\\1tiR\u000b7o[\u000b\u0003\u0003+\u0001B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037I\u0014AB3oi&$\u00180\u0003\u0003\u0002 \u0005e!AD#oO&tWmQ8o]R\u000b7o[\u0001\rY\u0006\u001cH\u000fV1tW~#S-\u001d\u000b\u0005\u0003K\tY\u0003E\u0002I\u0003OI1!!\u000bJ\u0005\u0011)f.\u001b;\t\u0013\u00055b!!AA\u0002\u0005U\u0011a\u0001=%c\u0005IA.Y:u)\u0006\u001c8\u000eI\u0001\u0013gft7\rT1tiR\u000b7o\u001b+ie\u0016\fG-\u0006\u0002\u00026A!\u0011qGA\u001f\u001b\t\tID\u0003\u0003\u0002<\u0005\u001d\u0011\u0001\u00027b]\u001eLA!a\u0010\u0002:\t1A\u000b\u001b:fC\u0012\fac]=oG2\u000b7\u000f\u001e+bg.$\u0006N]3bI~#S-\u001d\u000b\u0005\u0003K\t)\u0005C\u0005\u0002.%\t\t\u00111\u0001\u00026\u0005\u00192/\u001f8d\u0019\u0006\u001cH\u000fV1tWRC'/Z1eA\u0005!B.Y:u)\u0006\u001c8\u000eR1f[>tg)\u001e;ve\u0016,\"!!\u00141\t\u0005=\u00131\f\t\u0007\u0003#\n\u0019&a\u0016\u000e\u0003}L1!!\u0016\u0000\u0005\u00191U\u000f^;sKB!\u0011\u0011LA.\u0019\u0001!1\"!\u0018\u000e\u0003\u0003\u0005\tQ!\u0001\u0002b\t\u0019q\fJ\u0019\u0002+1\f7\u000f\u001e+bg.$\u0015-Z7p]\u001a+H/\u001e:fAE!\u00111MA5!\rA\u0015QM\u0005\u0004\u0003OJ%a\u0002(pi\"Lgn\u001a\t\u0004\u0011\u0006-\u0014bAA7\u0013\n\u0019\u0011I\\=\u000211\f7\u000f\u001e+bg.$\u0015-Z7p]\u001a+H/\u001e:f?\u0012*\u0017\u000f\u0006\u0003\u0002&\u0005M\u0004\"CA\u0017\u0019\u0005\u0005\t\u0019AA;a\u0011\t9(a\u001f\u0011\r\u0005E\u00131KA=!\u0011\tI&a\u001f\u0005\u0019\u0005u\u00131OA\u0001\u0002\u0003\u0015\t!!\u0019\u0002\u00171|7m[*feZL7-Z\u000b\u0003\u0003\u0003\u0003B!a!\u0002\b6\u0011\u0011Q\u0011\u0006\u0003q\tLA!!#\u0002\u0006\nYAj\\2l'\u0016\u0014h/[2f\u0003=awnY6TKJ4\u0018nY3`I\u0015\fH\u0003BA\u0013\u0003\u001fC\u0011\"!\f\u0010\u0003\u0003\u0005\r!!!\u0002\u00191|7m[*feZL7-\u001a\u0011)\u0007A\t)\n\u0005\u0003\u0002\u0018\u0006%VBAAM\u0015\u0011\tY*!(\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002 \u0006\u0005\u0016a\u00024bGR|'/\u001f\u0006\u0005\u0003G\u000b)+A\u0003cK\u0006t7OC\u0002\u0002(\u000e\u000bqb\u001d9sS:<gM]1nK^|'o[\u0005\u0005\u0003W\u000bIJA\u0005BkR|w/\u001b:fI\u0006y1/\u001f8d\u0019&\u001cH/\u001a8fe\n+8/\u0006\u0002\u00022B!\u00111WA]\u001b\t\t)LC\u0002]\u0003oS!AO\u001f\n\t\u0005m\u0016Q\u0017\u0002\u001a\u000b:<\u0017N\\3D_:t7+\u001f8d\u0019&\u001cH/\u001a8fe\n+8/\u0001\tts:\u001cG*[:uK:,'OQ;tA\u0005YA/Y:l\u0013\u0012\u001c\u0015m\u00195f+\t\t\u0019\r\u0005\u0005\u0002F\u0006U\u0017\u0011\\Ax\u001b\t\t9M\u0003\u0003\u0002J\u0006-\u0017!B2bG\",'b\u0001,\u0002N*!\u0011qZAi\u0003\u00199wn\\4mK*\u0011\u00111[\u0001\u0004G>l\u0017\u0002BAl\u0003\u000f\u0014QaQ1dQ\u0016\u0004B!a7\u0002j:!\u0011Q\\As!\r\ty.S\u0007\u0003\u0003CT1!a9F\u0003\u0019a$o\\8u}%\u0019\u0011q]%\u0002\rA\u0013X\rZ3g\u0013\u0011\tY/!<\u0003\rM#(/\u001b8h\u0015\r\t9/\u0013\t\u0005\u0003c\f90\u0004\u0002\u0002t*\u0019\u0011Q_\u001d\u0002\u000f\u0015DXmY;uK&!\u0011\u0011`Az\u0005M\u0019u.\u001c9vi\u0006$\u0018n\u001c8Fq\u0016\u001cW\u000f^8s\u00031!\u0018m]6JI\u000e\u000b7\r[3!\u0003A\u0019\u0017m\u00195fIRC'/Z1e!>|G.\u0006\u0002\u0003\u0002A!\u0011\u0011\u000bB\u0002\u0013\r\u0011)a \u0002\u0013)\"\u0014X-\u00193Q_>dW\t_3dkR|'/A\fuCN\\\u0017i]=oGN+(-\\5u\u000bb,7-\u001e;peV\u0011!1\u0002\t\u0005\u0005\u001b\u0011\t\"\u0004\u0002\u0003\u0010)\u0019\u0011\u0011A%\n\t\tM!q\u0002\u0002 \u000bb,7-\u001e;j_:\u001cuN\u001c;fqR,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017\u0001\u0007;bg.\f5/\u001f8d'V\u0014W.\u001b;Fq\u0016\u001cW\u000f^8sA\u0005!\u0011N\\5u)\t\t)\u0003K\u0002\u0019\u0005;\u0001BAa\b\u0003(5\u0011!\u0011\u0005\u0006\u0005\u00037\u0013\u0019C\u0003\u0002\u0003&\u0005)!.\u0019<bq&!!\u0011\u0006B\u0011\u00055\u0001vn\u001d;D_:\u001cHO];di\u0006q1/\u001a8e)>,e\u000e\u001e:b]\u000e,GCBA\u0013\u0005_\u0011\u0019\u0004C\u0004\u00032e\u0001\r!!\u0006\u0002\tQ\f7o\u001b\u0005\b\u0005kI\u0002\u0019\u0001B\u001c\u0003\ri7o\u001a\t\u0005\u0005s\u0011\u0019%\u0004\u0002\u0003<)!!Q\bB \u0003\u001diWm]:bO\u0016T1A!\u0011@\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002B#\u0005w\u0011qBU3rk\u0016\u001cH\u000f\u0015:pi>\u001cw\u000e\u001c\u000b\u0007\u0005\u0013\u0012IFa\u001c\u0011\t\t-#QK\u0007\u0003\u0005\u001bRAAa\u0014\u0003R\u0005AQ\r_3dkR,'OC\u0002\u0003T}\n\u0011b]2iK\u0012,H.\u001a:\n\t\t]#Q\n\u0002\u0010\u000bb,7-\u001e;f%\u0016\u001c\bo\u001c8tK\"9!1\f\u000eA\u0002\tu\u0013a\u0003:fcV,7\u000f\u001e+bg.\u0004BAa\u0018\u0003l5\u0011!\u0011\r\u0006\u0005\u0005c\u0011\u0019G\u0003\u0003\u0003B\t\u0015$b\u0001,\u0003h)\u0019!\u0011N \u0002\u0015\u001d|g/\u001a:oC:\u001cW-\u0003\u0003\u0003n\t\u0005$a\u0003*fcV,7\u000f\u001e+bg.DqA!\u001d\u001b\u0001\u0004\u0011\u0019(\u0001\u0004tK:$WM\u001d\t\u0005\u0005k\u0012Y(\u0004\u0002\u0003x)\u0019!\u0011P \u0002\u0007I\u00048-\u0003\u0003\u0003~\t]$AB*f]\u0012,'\u000fK\u0002\u001b\u0005\u0003\u0003BAa!\u0003\n6\u0011!Q\u0011\u0006\u0005\u00037\u00139I\u0003\u0003\u0003>\t]\u0014\u0002\u0002BF\u0005\u000b\u0013\u0001BU3dK&4XM]\u0001\u0015gV\u0014W.\u001b;UCN\\Gk\\#yK\u000e,Ho\u001c:\u0015\r\t%#\u0011\u0013BM\u0011\u001d\u0011\td\u0007a\u0001\u0005'\u0003B!a\u0006\u0003\u0016&!!qSA\r\u0005Q\u0019u.\\7p]\u0016sw-\u001b8f\u0007>tg\u000eV1tW\"9!1T\u000eA\u0002\tu\u0015A\u00027bE\u0016d7\u000fE\u0003I\u0005?\u0013\u0019+C\u0002\u0003\"&\u0013Q!\u0011:sCf\u0004DA!*\u0003:B1!q\u0015BZ\u0005ok!A!+\u000b\t\u0005m!1\u0016\u0006\u0005\u0005[\u0013y+A\u0003mC\n,GNC\u0002\u00032~\nq!\\1oC\u001e,'/\u0003\u0003\u00036\n%&!\u0002'bE\u0016d\u0007\u0003BA-\u0005s#ABa/\u0003\u001a\u0006\u0005\t\u0011!B\u0001\u0003C\u00121a\u0018\u00133\u0003)\u0019XOY7jiR\u000b7o\u001b\u000b\u0007\u0005\u0013\u0012\tMa1\t\u000f\tEB\u00041\u0001\u0003\u0014\"9!Q\u0019\u000fA\u0002\u0005=\u0018aE2p[B,H/\u0019;j_:,\u00050Z2vi>\u0014\u0018aD:vE6LG/Q*z]\u000e$\u0016m]6\u0015\r\t%#1\u001aBg\u0011\u001d\u0011\t$\ba\u0001\u0005'CqA!2\u001e\u0001\u0004\ty/\u0001\btk\nl\u0017\u000e^*z]\u000e$\u0016m]6\u0015\r\t%#1\u001bBk\u0011\u001d\u0011\tD\ba\u0001\u0005'CqA!2\u001f\u0001\u0004\ty/\u0001\u000btk\nl\u0017\u000e^\"p]\u000e,(O]3oiR\u000b7o\u001b\u000b\u0007\u0005\u0013\u0012YN!8\t\u000f\tEr\u00041\u0001\u0003\u0014\"1!h\ba\u0001\u0005?\u0004B!!=\u0003b&!!1]Az\u0005u\u0019uN\\2veJ,g\u000e^\"p[B,H/\u0019;j_:,\u00050Z2vi>\u0014\u0018aC3yK\u000e,H/\u001a+bg.$bA!\u0013\u0003j\n-\bb\u0002B\u0019A\u0001\u0007\u0011Q\u0003\u0005\u0007u\u0001\u0002\r!a<\u0002#=\u0004XM\u001c#bK6|gNR8s)\u0006\u001c8\u000e\u0006\u0004\u0003r\nm(Q \u0019\u0005\u0005g\u00149\u0010\u0005\u0004\u0002R\u0005M#Q\u001f\t\u0005\u00033\u00129\u0010B\u0006\u0003z\u0006\n\t\u0011!A\u0003\u0002\u0005\u0005$aA0%g!9!\u0011G\u0011A\u0002\u0005U\u0001b\u0002B*C\u0001\u0007!q \t\u0005\u0003#\u001a\t!C\u0002\u0004\u0004}\u0014q\"\u0012=fGV$xN]*feZL7-Z\u0001\u0012EVLG\u000eZ#yiJ\f\u0017J\u001c4p\u001b\u0006\u0004H\u0003BB\u0005\u0007/\u0001\u0002ba\u0003\u0004\u000e\u0005e7\u0011C\u0007\u0003\u0003\u0007IAaa\u0004\u0002\u0004\t9\u0001*Y:i\u001b\u0006\u0004\b\u0003BA\u001c\u0007'IAa!\u0006\u0002:\t1qJ\u00196fGRDqA!\r#\u0001\u0004\t)\"\u0001\tck&dGMU3t_V\u00148-Z'baR!1QDB\u0017!\u0011\u0019yb!\u000b\u000e\u0005\r\u0005\"\u0002BB\u0012\u0007K\t\u0001B]3t_V\u00148-\u001a\u0006\u0005\u0005\u0003\u001a9CC\u0002W\u0005_KAaa\u000b\u0004\"\tA\"+Z:q_:\u001cX\rV1tWf\u000b'O\u001c*fg>,(oY3\t\u000f\tE2\u00051\u0001\u0002\u0016\u0005\u0001B/Y:l3\u0006\u0014hNU3t_V\u00148-\u001a\u000b\u0005\u0007;\u0019\u0019\u0004C\u0004\u00046\u0011\u0002\r!!7\u0002\rQ\f7o[%E\u00031!\u0018m]6Qe><'/Z:t)\u0011\u0019Yd!\u0011\u0011\t\t}3QH\u0005\u0005\u0007\u007f\u0011\tG\u0001\u000bSKN\u0004xN\\:f)\u0006\u001c8\u000e\u0015:pOJ,7o\u001d\u0005\b\u0007k)\u0003\u0019AAm\u0003\u001d!\u0018m]6M_\u001e$Baa\u0012\u0004NA!!qLB%\u0013\u0011\u0019YE!\u0019\u0003\u001fI+7\u000f]8og\u0016$\u0016m]6M_\u001eDqa!\u000e'\u0001\u0004\tI.\u0001\u0005lS2dG+Y:l)\u0011\t)ca\u0015\t\u000f\rUr\u00051\u0001\u0002Z\u0006)B-Z1m%\u0016\fX/Z:u)\u0006\u001c8n\u0015;biV\u001cH\u0003BB-\u0007?\u0002BAa\u0018\u0004\\%!1Q\fB1\u0005I\u0011Vm\u001d9p]N,G+Y:l'R\fG/^:\t\u000f\r\u0005\u0004\u00061\u0001\u0004d\u0005\t\"/Z9vKN$H+Y:l'R\fG/^:\u0011\t\t}3QM\u0005\u0005\u0007O\u0012\tGA\tSKF,Xm\u001d;UCN\\7\u000b^1ukND3\u0001\u000bBA\u0003Q!W-\u00197SKF,Xm\u001d;UCN\\\u0007+Y;tKR!\u0011QEB8\u0011\u001d\u0019\t(\u000ba\u0001\u0007g\n\u0001C]3rk\u0016\u001cH\u000fV1tWB\u000bWo]3\u0011\t\t}3QO\u0005\u0005\u0007o\u0012\tG\u0001\tSKF,Xm\u001d;UCN\\\u0007+Y;tK\"\u001a\u0011F!!\u0002'\u0011,\u0017\r\u001c*fcV,7\u000f\u001e+bg.\\\u0015\u000e\u001c7\u0015\t\u0005\u00152q\u0010\u0005\b\u0007\u0003S\u0003\u0019ABB\u0003=\u0011X-];fgR$\u0016m]6LS2d\u0007\u0003\u0002B0\u0007\u000bKAaa\"\u0003b\ty!+Z9vKN$H+Y:l\u0017&dG\u000eK\u0002+\u0005\u0003\u000bQ\u0003Z3bYJ+\u0017/^3tiR\u000b7o\u001b*fgVlW\r\u0006\u0003\u0002&\r=\u0005bBBIW\u0001\u000711S\u0001\u0012e\u0016\fX/Z:u)\u0006\u001c8NU3tk6,\u0007\u0003\u0002B0\u0007+KAaa&\u0003b\t\t\"+Z9vKN$H+Y:l%\u0016\u001cX/\\3)\u0007-\u0012\t)A\u0004p]\u00163XM\u001c;\u0015\t\u0005\u00152q\u0014\u0005\b\u0007Cc\u0003\u0019ABR\u0003\u0015)g/\u001a8u!\u0011\u0019)k!+\u000e\u0005\r\u001d&\u0002BBQ\u0003kKAaa+\u0004(\n\u0019RI\\4j]\u0016\u001cuN\u001c8Ts:\u001cWI^3oi\u0006YqN\u001c'pOV\u0003H-\u0019;f)\u0011\t)c!-\t\u000f\rMV\u00061\u0001\u00046\u0006qAn\\4Va\u0012\fG/Z#wK:$\b\u0003BB\\\u0007wk!a!/\u000b\u0007\r\u0005\u0016-\u0003\u0003\u0004>\u000ee&A\u0005+bg.dunZ+qI\u0006$X-\u0012<f]R\f1c\u001c8UCN\\7\u000b^1ukN\u001c\u0005.\u00198hK\u0012$B!!\n\u0004D\"91Q\u0019\u0018A\u0002\r\u001d\u0017A\u0006;bg.\u001cF/\u0019;vg\u000eC\u0017M\\4fI\u00163XM\u001c;\u0011\t\r]6\u0011Z\u0005\u0005\u0007\u0017\u001cIL\u0001\fUCN\\7\u000b^1ukN\u001c\u0005.\u00198hK\u0012,e/\u001a8u\u0003Ayg\u000e\u0015:pOJ,7o]+qI\u0006$X\r\u0006\u0003\u0002&\rE\u0007bBBj_\u0001\u00071Q[\u0001\u0018i\u0006\u001c8\u000e\u0015:pOJ,7o]+qI\u0006$X-\u0012<f]R\u0004Baa.\u0004X&!1\u0011\\B]\u0005]!\u0016m]6Qe><'/Z:t+B$\u0017\r^3Fm\u0016tG/\u0001\np]J+7/\u001e7u'\u0016$8I]3bi\u0016$G\u0003BA\u0013\u0007?Dqa!91\u0001\u0004\u0019\u0019/A\u000buCN\\'+Z:vYR\u001c%/Z1uK\u00163XM\u001c;\u0011\t\r]6Q]\u0005\u0005\u0007O\u001cILA\u000bUCN\\'+Z:vYR\u001c%/Z1uK\u00163XM\u001c;\u0002\u001f\u001d,G\u000fV1tW\nKH+Y:l\u0013\u0012$B!!\u0006\u0004n\"91q^\u0019A\u0002\u0005e\u0017A\u0002;bg.LE-A\np]J+7/\u001e7u'&TXm\u0011:fCR,G\r\u0006\u0003\u0002&\rU\bbBB|e\u0001\u00071\u0011`\u0001\u001bi\u0006\u001c8NU3tk2$8+\u001b>f\u0007J,\u0017\r^3e\u000bZ,g\u000e\u001e\t\u0005\u0007o\u001bY0\u0003\u0003\u0004~\u000ee&A\u0007+bg.\u0014Vm];miNK'0Z\"sK\u0006$X\rZ#wK:$\u0018\u0001D8o\u000bZ,g\u000e^#se>\u0014HCBA\u0013\t\u0007!y\u0001C\u0004\u0004\"N\u0002\r\u0001\"\u0002\u0011\t\u0011\u001dA1B\u0007\u0003\t\u0013Q!\u0001X+\n\t\u00115A\u0011\u0002\u0002\u0006\u000bZ,g\u000e\u001e\u0005\b\t#\u0019\u0004\u0019\u0001C\n\u0003\u0005!\b\u0003\u0002C\u000b\t?qA\u0001b\u0006\u0005\u001c9!\u0011q\u001cC\r\u0013\u0005Q\u0015b\u0001C\u000f\u0013\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002C\u0011\tG\u0011\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0011u\u0011*\u0001\u0006dY\u0016\f'oQ1dQ\u0016$B!!\n\u0005*!91q\u001e\u001bA\u0002\u0005e\u0017\u0001G8o)\u0006\u001c8NU3ta>t7/Z#se>\u0014XI^3oiR!\u0011Q\u0005C\u0018\u0011\u001d!\t$\u000ea\u0001\tg\ta\u0003^1tWJ+7\u000f]8og\u0016,%O]8s\u000bZ,g\u000e\u001e\t\u0005\u0007o#)$\u0003\u0003\u00058\re&A\u0006+bg.\u0014Vm\u001d9p]N,WI\u001d:pe\u00163XM\u001c;)\u0007\u0001!Y\u0004\u0005\u0003\u0005>\u0011\rSB\u0001C \u0015\u0011!\t%!*\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0005F\u0011}\"!C\"p[B|g.\u001a8u\u0001")
public class TaskExecutionServiceImpl
implements TaskExecutionService,
Logging,
ResultSetListener,
LogListener,
TaskProgressListener,
TaskStatusListener {
    private LabelExecutorManager executorManager;
    private ThreadPoolExecutor cachedThreadPool;
    private final AtomicInteger taskExecutedNum;
    private EngineConnTask lastTask;
    private Thread syncLastTaskThread;
    private Future<?> lastTaskDaemonFuture;
    @Autowired
    private LockService lockService;
    private final EngineConnSyncListenerBus syncListenerBus;
    private final Cache<String, ComputationExecutor> taskIdCache;
    private final ExecutionContextExecutorService taskAsyncSubmitExecutor;
    private Logger logger;
    private volatile byte bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        TaskExecutionServiceImpl taskExecutionServiceImpl = this;
        synchronized (taskExecutionServiceImpl) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private LabelExecutorManager executorManager$lzycompute() {
        TaskExecutionServiceImpl taskExecutionServiceImpl = this;
        synchronized (taskExecutionServiceImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.executorManager = ExecutorManager$.MODULE$.getInstance();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.executorManager;
    }

    private LabelExecutorManager executorManager() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.executorManager$lzycompute();
        }
        return this.executorManager;
    }

    private AtomicInteger taskExecutedNum() {
        return this.taskExecutedNum;
    }

    private EngineConnTask lastTask() {
        return this.lastTask;
    }

    private void lastTask_$eq(EngineConnTask x$1) {
        this.lastTask = x$1;
    }

    private Thread syncLastTaskThread() {
        return this.syncLastTaskThread;
    }

    private void syncLastTaskThread_$eq(Thread x$1) {
        this.syncLastTaskThread = x$1;
    }

    private Future<?> lastTaskDaemonFuture() {
        return this.lastTaskDaemonFuture;
    }

    private void lastTaskDaemonFuture_$eq(Future<?> x$1) {
        this.lastTaskDaemonFuture = x$1;
    }

    private LockService lockService() {
        return this.lockService;
    }

    private void lockService_$eq(LockService x$1) {
        this.lockService = x$1;
    }

    private EngineConnSyncListenerBus syncListenerBus() {
        return this.syncListenerBus;
    }

    private Cache<String, ComputationExecutor> taskIdCache() {
        return this.taskIdCache;
    }

    private ThreadPoolExecutor cachedThreadPool$lzycompute() {
        TaskExecutionServiceImpl taskExecutionServiceImpl = this;
        synchronized (taskExecutionServiceImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.cachedThreadPool = Utils$.MODULE$.newCachedThreadPool(BoxesRunTime.unboxToInt((Object)ComputationExecutorConf$.MODULE$.ENGINE_CONCURRENT_THREAD_NUM().getValue()), "ConcurrentEngineConnThreadPool", Utils$.MODULE$.newCachedThreadPool$default$3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.cachedThreadPool;
    }

    private ThreadPoolExecutor cachedThreadPool() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.cachedThreadPool$lzycompute();
        }
        return this.cachedThreadPool;
    }

    private ExecutionContextExecutorService taskAsyncSubmitExecutor() {
        return this.taskAsyncSubmitExecutor;
    }

    @PostConstruct
    public void init() {
        LogHelper$.MODULE$.setLogListener((LogListener)this);
        this.syncListenerBus().addListener((EventListener)this);
        if (ComputationExecutorConf$.MODULE$.ENGINE_KERBEROS_AUTO_REFRESH_ENABLED()) {
            KerberosUtils.startKerberosRefreshThread();
            return;
        }
    }

    public void org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$sendToEntrance(EngineConnTask task, RequestProtocol msg) {
        Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Sender sender = null;
            if (task != null && task.getCallbackServiceInstance() != null && msg != null) {
                sender = Sender$.MODULE$.getSender(task.getCallbackServiceInstance());
                sender.send((Object)msg);
                return;
            }
            this.logger().debug("SendtoEntrance error, cannot find entrance instance.");
        }, (Function1 & Serializable & scala.Serializable)t -> {
            String errorMsg = new StringBuilder(22).append("SendToEntrance error. ").append(msg).append(t.getCause()).toString();
            this.logger().error(errorMsg, t);
            throw new EngineConnExecutorErrorException(40105, errorMsg);
        });
    }

    @Override
    @Receiver
    public ExecuteResponse execute(RequestTask requestTask, Sender sender) {
        ExecuteResponse executeResponse;
        Object object = new Object();
        try {
            executeResponse = (ExecuteResponse)Utils$.MODULE$.tryFinally((Function0 & Serializable & scala.Serializable)() -> {
                boolean retryAble;
                String jobId = JobUtils$.MODULE$.getJobIdFromMap(requestTask.getProperties());
                LoggerUtils.setJobIdMDC((String)jobId);
                this.logger().info(new StringBuilder(37).append("Received a new task, task content is ").append(requestTask).toString());
                if (StringUtils.isBlank((CharSequence)requestTask.getLock())) {
                    this.logger().error(new StringBuilder(32).append("Invalid lock : ").append(requestTask.getLock()).append(" , requestTask : ").append(requestTask).toString());
                    throw new NonLocalReturnControl(object, (Object)new ErrorExecuteResponse(new StringBuilder(16).append("Invalid lock : ").append(requestTask.getLock()).append(".").toString(), (Throwable)new EngineConnExecutorErrorException(40102, "Invalid lock or code(\u8bf7\u83b7\u53d6\u5230\u9501\u540e\u518d\u63d0\u4ea4\u4efb\u52a1.)")));
                }
                if (!this.lockService().isLockExist(requestTask.getLock())) {
                    this.logger().error(new StringBuilder(32).append("Lock ").append(requestTask.getLock()).append(" not exist, cannot execute.").toString());
                    throw new NonLocalReturnControl(object, (Object)new ErrorExecuteResponse("Lock not exixt", (Throwable)new EngineConnExecutorErrorException(40103, new StringBuilder(35).append("Lock : ").append(requestTask.getLock()).append(" not exist(\u60a8\u7684\u9501\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u540e\u518d\u63d0\u4ea4).").toString())));
                }
                if (StringUtils.isBlank((CharSequence)requestTask.getCode())) {
                    throw new NonLocalReturnControl(object, (Object)new IncompleteExecuteResponse("Your code is incomplete, it may be that only comments are selected for execution(\u60a8\u7684\u4ee3\u7801\u4e0d\u5b8c\u6574\uff0c\u53ef\u80fd\u662f\u4ec5\u4ec5\u9009\u4e2d\u4e86\u6ce8\u91ca\u8fdb\u884c\u6267\u884c)"));
                }
                String taskId = StringUtils.isNotBlank((CharSequence)jobId) ? jobId : String.valueOf(this.taskExecutedNum().incrementAndGet());
                Object retry = requestTask.getProperties().getOrDefault(ComputationEngineConstant$.MODULE$.RETRYABLE_TYPE_NAME(), null);
                boolean bl = retryAble = retry != null ? BoxesRunTime.unboxToBoolean(retry) : false;
                if (StringUtils.isNotBlank((CharSequence)jobId)) {
                    System.getProperties().put(ComputationExecutorConf$.MODULE$.JOB_ID_TO_ENV_KEY(), jobId);
                    this.logger().info(new StringBuilder(22).append("Received job with id ").append(jobId).append(".").toString());
                }
                CommonEngineConnTask task = new CommonEngineConnTask(taskId, retryAble);
                task.setCode(requestTask.getCode());
                task.setProperties(requestTask.getProperties());
                task.data(ComputationEngineConstant$.MODULE$.LOCK_TYPE_NAME(), requestTask.getLock());
                task.setStatus(ExecutionNodeStatus.Scheduled);
                Label[] labels = (Label[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(requestTask.getLabels()).asScala()).toArray(ClassTag$.MODULE$.apply(Label.class));
                task.setLabels(labels);
                ServiceInstance entranceServerInstance = RPCUtils$.MODULE$.getServiceInstanceFromSender(sender);
                task.setCallbackServiceInstance(entranceServerInstance);
                this.logger().info(new StringBuilder(32).append("task ").append(taskId).append(" submit executor to execute").toString());
                Runnable runnable = new Runnable(this, jobId, task, labels){
                    private final /* synthetic */ TaskExecutionServiceImpl $outer;
                    private final String jobId$1;
                    private final CommonEngineConnTask task$2;
                    private final Label[] labels$1;

                    public void run() {
                        Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            Thread.sleep(ComputationExecutorConf$.MODULE$.TASK_SUBMIT_WAIT_TIME_MS());
                            LoggerUtils.setJobIdMDC((String)$this.jobId$1);
                            ExecuteResponse executeResponse = $this.$outer.org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$submitTaskToExecutor($this.task$2, $this.labels$1);
                            if (executeResponse instanceof ErrorExecuteResponse) {
                                ErrorExecuteResponse errorExecuteResponse = (ErrorExecuteResponse)executeResponse;
                                String message = errorExecuteResponse.message();
                                Throwable throwable = errorExecuteResponse.t();
                                $this.$outer.org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$sendToEntrance($this.task$2, (RequestProtocol)new ResponseTaskError($this.task$2.getTaskId(), message));
                                $this.$outer.logger().error(message, throwable);
                                $this.$outer.org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$sendToEntrance($this.task$2, (RequestProtocol)new ResponseTaskStatus($this.task$2.getTaskId(), ExecutionNodeStatus.Failed));
                            }
                            LoggerUtils.removeJobIdMDC();
                        }, (Function1 & Serializable & scala.Serializable)t -> {
                            $anon$1.$anonfun$run$2(this, t);
                            return BoxedUnit.UNIT;
                        });
                    }

                    public static final /* synthetic */ void $anonfun$run$2($anon$1 $this, Throwable t) {
                        $this.$outer.logger().warn("Failed to submit task ", t);
                        LoggerUtils.removeJobIdMDC();
                        $this.$outer.org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$sendToEntrance($this.task$2, (RequestProtocol)new ResponseTaskError($this.task$2.getTaskId(), ExceptionUtils.getRootCauseMessage((Throwable)t)));
                        $this.$outer.org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$sendToEntrance($this.task$2, (RequestProtocol)new ResponseTaskStatus($this.task$2.getTaskId(), ExecutionNodeStatus.Failed));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.jobId$1 = jobId$1;
                        this.task$2 = task$2;
                        this.labels$1 = labels$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.linkis.engineconn.computation.executor.service.TaskExecutionServiceImpl$$anon$1 ), $anonfun$run$2$adapted(org.apache.linkis.engineconn.computation.executor.service.TaskExecutionServiceImpl$$anon$1 java.lang.Throwable )}, serializedLambda);
                    }
                };
                Future submitTaskToExecutorFuture = this.taskAsyncSubmitExecutor().submit(runnable);
                return new SubmitResponse(task.getTaskId());
            }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> LoggerUtils.removeJobIdMDC());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                executeResponse = (ExecuteResponse)ex.value();
            }
            throw ex;
        }
        return executeResponse;
    }

    public ExecuteResponse org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$submitTaskToExecutor(CommonEngineConnTask task, Label<?>[] labels) {
        LabelExecutor executor = this.executorManager().getExecutorByLabels(labels);
        LabelExecutor labelExecutor = executor;
        if (labelExecutor instanceof ComputationExecutor) {
            ComputationExecutor computationExecutor = (ComputationExecutor)labelExecutor;
            this.taskIdCache().put((Object)task.getTaskId(), (Object)computationExecutor);
            return this.submitTask(task, computationExecutor);
        }
        String labelsStr = labels != null ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])labels)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TaskExecutionServiceImpl.$anonfun$submitTaskToExecutor$1(x$1))))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getStringValue(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",") : "";
        String msg = new StringBuilder(57).append("Invalid computationExecutor : ").append(executor.getClass().getName()).append(", labels : ").append(labelsStr).append(", requestTask : ").append(task.getTaskId()).toString();
        this.logger().error(msg);
        return new ErrorExecuteResponse("Invalid computationExecutor(\u751f\u6210\u65e0\u6548\u7684\u8ba1\u7b97\u5f15\u64ce\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458).", (Throwable)new EngineConnExecutorErrorException(40100, msg));
    }

    private ExecuteResponse submitTask(CommonEngineConnTask task, ComputationExecutor computationExecutor) {
        this.logger().info(new StringBuilder(19).append("Task ").append(task.getTaskId()).append(" was submited.").toString());
        ComputationExecutor computationExecutor2 = computationExecutor;
        if (computationExecutor2 instanceof AsyncConcurrentComputationExecutor) {
            AsyncConcurrentComputationExecutor asyncConcurrentComputationExecutor = (AsyncConcurrentComputationExecutor)computationExecutor2;
            return this.submitASyncTask(task, asyncConcurrentComputationExecutor);
        }
        if (computationExecutor2 instanceof ConcurrentComputationExecutor) {
            ConcurrentComputationExecutor concurrentComputationExecutor = (ConcurrentComputationExecutor)computationExecutor2;
            return this.submitConcurrentTask(task, concurrentComputationExecutor);
        }
        return this.submitSyncTask(task, computationExecutor);
    }

    private ExecuteResponse submitASyncTask(CommonEngineConnTask task, ComputationExecutor computationExecutor) {
        return computationExecutor.execute(task);
    }

    private ExecuteResponse submitSyncTask(CommonEngineConnTask task, ComputationExecutor computationExecutor) {
        LogHelper$.MODULE$.dropAllRemainLogs();
        this.lastTask_$eq(task);
        this.syncLastTaskThread_$eq(Thread.currentThread());
        this.lastTaskDaemonFuture_$eq(this.openDaemonForTask(task, Utils$.MODULE$.defaultScheduler()));
        ExecuteResponse res = this.org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$executeTask(task, computationExecutor);
        return res;
    }

    private ExecuteResponse submitConcurrentTask(CommonEngineConnTask task, ConcurrentComputationExecutor executor) {
        Runnable concurrentJob = new Runnable(this, task, executor){
            private final /* synthetic */ TaskExecutionServiceImpl $outer;
            private final CommonEngineConnTask task$3;
            private final ConcurrentComputationExecutor executor$1;

            public void run() {
                Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
                    String jobId = JobUtils$.MODULE$.getJobIdFromMap($this.task$3.getProperties());
                    LoggerUtils.setJobIdMDC((String)jobId);
                    $this.$outer.logger().info(new StringBuilder(18).append("Start to run task ").append($this.task$3.getTaskId()).toString());
                    return $this.$outer.org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$executeTask($this.task$3, $this.executor$1);
                }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Throwable throwable = x0$1;
                    if (throwable != null) {
                        Throwable throwable2 = throwable;
                        $this.$outer.logger().warn("Failed to execute task ", throwable2);
                        $this.$outer.org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$sendToEntrance($this.task$3, (RequestProtocol)new ResponseTaskError($this.task$3.getTaskId(), ExceptionUtils.getRootCauseMessage((Throwable)throwable2)));
                        $this.$outer.org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$sendToEntrance($this.task$3, (RequestProtocol)new ResponseTaskStatus($this.task$3.getTaskId(), ExecutionNodeStatus.Failed));
                        LoggerUtils.removeJobIdMDC();
                        return null;
                    }
                    throw new MatchError((Object)throwable);
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.task$3 = task$3;
                this.executor$1 = executor$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$3(org.apache.linkis.engineconn.computation.executor.service.TaskExecutionServiceImpl$$anon$2 ), $anonfun$run$4(org.apache.linkis.engineconn.computation.executor.service.TaskExecutionServiceImpl$$anon$2 java.lang.Throwable )}, serializedLambda);
            }
        };
        Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> this.cachedThreadPool().submit(concurrentJob), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof Exception) {
                Exception exception = (Exception)throwable;
                this.logger().error(new StringBuilder(22).append("Failed to submit task ").append(task.getTaskId()).toString(), (Throwable)exception);
                throw exception;
            }
            throw new MatchError((Object)throwable);
        });
        return new SubmitResponse(task.getTaskId());
    }

    public ExecuteResponse org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$executeTask(EngineConnTask task, ComputationExecutor executor) {
        return (ExecuteResponse)Utils$.MODULE$.tryFinally((Function0 & Serializable & scala.Serializable)() -> {
            String jobId = JobUtils$.MODULE$.getJobIdFromMap(task.getProperties());
            LoggerUtils.setJobIdMDC((String)jobId);
            return executor.execute(task);
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.clearCache(task.getTaskId());
            LoggerUtils.removeJobIdMDC();
        });
    }

    private Future<?> openDaemonForTask(EngineConnTask task, ExecutorService scheduler) {
        int sleepInterval = BoxesRunTime.unboxToInt((Object)ComputationExecutorConf$.MODULE$.ENGINE_PROGRESS_FETCH_INTERVAL().getValue());
        return scheduler.submit(new Runnable(this, task, sleepInterval){
            private final /* synthetic */ TaskExecutionServiceImpl $outer;
            private final EngineConnTask task$5;
            private final int sleepInterval$1;

            public void run() {
                this.$outer.logger().info(new StringBuilder(22).append("start daemon thread ").append(this.task$5.getTaskId()).append(", ").append(this.task$5.getStatus()).toString());
                Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Thread.sleep(TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS)));
                while (!ExecutionNodeStatus.isCompleted((ExecutionNodeStatus)this.task$5.getStatus())) {
                    Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        HashMap resourceMap;
                        ResponseTaskProgress progressResponse = (ResponseTaskProgress)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> $this.$outer.taskProgress($this.task$5.getTaskId()), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                            Throwable throwable = x0$1;
                            if (throwable instanceof Exception) {
                                Exception exception = (Exception)throwable;
                                $this.$outer.logger().info("Failed to get progress", (Throwable)exception);
                                return null;
                            }
                            throw new MatchError((Object)throwable);
                        });
                        ResponseTaskYarnResource resourceResponse = (ResponseTaskYarnResource)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> $this.$outer.org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$buildResourceMap($this.task$5), (Function1 & Serializable & scala.Serializable)x0$2 -> {
                            Throwable throwable = x0$2;
                            if (throwable instanceof Exception) {
                                Exception exception = (Exception)throwable;
                                $this.$outer.logger().info("Failed to get resource", (Throwable)exception);
                                return null;
                            }
                            throw new MatchError((Object)throwable);
                        });
                        HashMap extraInfoMap = (HashMap)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> $this.$outer.org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$buildExtraInfoMap($this.task$5), (Function1 & Serializable & scala.Serializable)x0$3 -> {
                            Throwable throwable = x0$3;
                            if (throwable instanceof Exception) {
                                Exception exception = (Exception)throwable;
                                $this.$outer.logger().info("Failed to get extra info ", (Throwable)exception);
                                return null;
                            }
                            throw new MatchError((Object)throwable);
                        });
                        HashMap hashMap = resourceMap = resourceResponse != null ? resourceResponse.resourceMap() : null;
                        ResponseTaskProgress newProgressResponse = progressResponse == null ? new ResponseTaskProgress($this.task$5.getTaskId(), 0.1f, null) : (progressResponse.progress() < 0.1f ? new ResponseTaskProgress($this.task$5.getTaskId(), 0.1f, progressResponse.progressInfo()) : progressResponse);
                        ResponseTaskRunningInfo respRunningInfo = new ResponseTaskRunningInfo(newProgressResponse.execId(), newProgressResponse.progress(), newProgressResponse.progressInfo(), resourceMap, extraInfoMap);
                        $this.$outer.org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$sendToEntrance($this.task$5, (RequestProtocol)respRunningInfo);
                    }, this.$outer.logger());
                    Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Thread.sleep(TimeUnit.MILLISECONDS.convert($this.sleepInterval$1, TimeUnit.SECONDS)));
                }
                this.$outer.logger().info(new StringBuilder(21).append("daemon thread exit ").append(this.task$5.getTaskId()).append(", ").append(this.task$5.getStatus()).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.task$5 = task$5;
                this.sleepInterval$1 = sleepInterval$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$5(), $anonfun$run$6(org.apache.linkis.engineconn.computation.executor.service.TaskExecutionServiceImpl$$anon$3 ), $anonfun$run$13(org.apache.linkis.engineconn.computation.executor.service.TaskExecutionServiceImpl$$anon$3 ), $anonfun$run$7(org.apache.linkis.engineconn.computation.executor.service.TaskExecutionServiceImpl$$anon$3 ), $anonfun$run$8(org.apache.linkis.engineconn.computation.executor.service.TaskExecutionServiceImpl$$anon$3 java.lang.Throwable ), $anonfun$run$9(org.apache.linkis.engineconn.computation.executor.service.TaskExecutionServiceImpl$$anon$3 ), $anonfun$run$10(org.apache.linkis.engineconn.computation.executor.service.TaskExecutionServiceImpl$$anon$3 java.lang.Throwable ), $anonfun$run$11(org.apache.linkis.engineconn.computation.executor.service.TaskExecutionServiceImpl$$anon$3 ), $anonfun$run$12(org.apache.linkis.engineconn.computation.executor.service.TaskExecutionServiceImpl$$anon$3 java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    public HashMap<String, Object> org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$buildExtraInfoMap(EngineConnTask task) {
        HashMap<String, Object> extraInfoMap = new HashMap<String, Object>();
        extraInfoMap.put("engineInstance", Sender$.MODULE$.getThisInstance());
        extraInfoMap.put(ECConstants$.MODULE$.EC_TICKET_ID_KEY(), EngineConnObject$.MODULE$.getEngineCreationContext().getTicketId());
        Map ecParams = EngineConnObject$.MODULE$.getEngineCreationContext().getOptions();
        Object object = ecParams.containsKey(ECConstants$.MODULE$.YARN_QUEUE_NAME_CONFIG_KEY()) ? extraInfoMap.put(ECConstants$.MODULE$.YARN_QUEUE_NAME_KEY(), ecParams.get(ECConstants$.MODULE$.YARN_QUEUE_NAME_CONFIG_KEY())) : BoxedUnit.UNIT;
        extraInfoMap.put("engineConnTaskId", task.getTaskId());
        extraInfoMap.put("engineConnSubmitTime", Long.toString(System.currentTimeMillis()));
        return extraInfoMap;
    }

    public ResponseTaskYarnResource org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$buildResourceMap(EngineConnTask task) {
        ResponseTaskYarnResource responseTaskYarnResource;
        ResponseTaskYarnResource responseTaskYarnResource2 = this.taskYarnResource(task.getTaskId());
        ResponseTaskYarnResource resourceResponse = responseTaskYarnResource2 != null ? ((responseTaskYarnResource = responseTaskYarnResource2).resourceMap() != null && !responseTaskYarnResource.resourceMap().isEmpty() ? responseTaskYarnResource : null) : null;
        return resourceResponse;
    }

    private ResponseTaskYarnResource taskYarnResource(String taskID) {
        ComputationExecutor executor = (ComputationExecutor)((Object)this.taskIdCache().getIfPresent((Object)taskID));
        ComputationExecutor computationExecutor = executor;
        if (computationExecutor instanceof ResourceFetchExecutor) {
            ComputationExecutor computationExecutor2 = computationExecutor;
            HashMap resourceWithApplicationId = ((ResourceFetchExecutor)computationExecutor2).FetchResource();
            return new ResponseTaskYarnResource(taskID, resourceWithApplicationId);
        }
        return null;
    }

    @Override
    public ResponseTaskProgress taskProgress(String taskID) {
        ResponseTaskProgress response = new ResponseTaskProgress(taskID, 0.01f, null);
        if (StringUtils.isBlank((CharSequence)taskID)) {
            return response;
        }
        ComputationExecutor executor = (ComputationExecutor)((Object)this.taskIdCache().getIfPresent((Object)taskID));
        if (executor != null) {
            EngineConnTask task = this.getTaskByTaskId(taskID);
            if (task != null) {
                if (ExecutionNodeStatus.isCompleted((ExecutionNodeStatus)task.getStatus())) {
                    response = new ResponseTaskProgress(taskID, 1.0f, null);
                } else {
                    float progress = executor.progress(taskID);
                    this.logger().info("The latest progress {} of the task id {} is:", (Object)BoxesRunTime.boxToFloat((float)progress), (Object)taskID);
                    response = (ResponseTaskProgress)Utils$.MODULE$.tryQuietly((Function0 & Serializable & scala.Serializable)() -> new ResponseTaskProgress(taskID, progress, executor.getProgressInfo(taskID)));
                }
            }
        } else {
            this.logger().info(new StringBuilder(36).append("Executor of taskId : ").append(taskID).append(" is not cached.").toString());
        }
        return response;
    }

    @Override
    public ResponseTaskLog taskLog(String taskID) {
        return null;
    }

    @Override
    public void killTask(String taskID) {
        ComputationExecutor executor = (ComputationExecutor)((Object)this.taskIdCache().getIfPresent((Object)taskID));
        if (executor != null) {
            Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> executor.killTask(taskID), this.logger());
            this.logger().info(new StringBuilder(29).append("TaskId : ").append(taskID).append(" was killed by user.").toString());
        } else {
            this.logger().error(new StringBuilder(54).append("Kill failed, got invalid executor : null for taskId : ").append(taskID).toString());
        }
        if (this.lastTask() != null && this.lastTask().getTaskId().equalsIgnoreCase(taskID)) {
            if (this.syncLastTaskThread() != null) {
                this.logger().info(new StringBuilder(24).append("try to interrupt thread:").append(taskID).toString());
                Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.syncLastTaskThread().interrupt(), this.logger());
                this.logger().info(new StringBuilder(21).append("thread isInterrupted:").append(taskID).toString());
            } else {
                this.logger().info(new StringBuilder(26).append("skip to force stop thread:").append(taskID).toString());
            }
            if (this.lastTaskDaemonFuture() != null && !this.lastTaskDaemonFuture().isDone()) {
                Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.lastTaskDaemonFuture().cancel(true), this.logger());
                return;
            }
            return;
        }
    }

    @Override
    @Receiver
    public ResponseTaskStatus dealRequestTaskStatus(RequestTaskStatus requestTaskStatus) {
        EngineConnTask task = this.getTaskByTaskId(requestTaskStatus.execId());
        if (task != null) {
            return new ResponseTaskStatus(task.getTaskId(), task.getStatus());
        }
        String msg = new StringBuilder(30).append("Task null! requestTaskStatus: ").append(ComputationEngineUtils$.MODULE$.GSON().toJson((Object)requestTaskStatus)).toString();
        this.logger().error(msg);
        return new ResponseTaskStatus(requestTaskStatus.execId(), ExecutionNodeStatus.Cancelled);
    }

    @Override
    @Receiver
    public void dealRequestTaskPause(RequestTaskPause requestTaskPause) {
        this.logger().info(new StringBuilder(34).append("Pause is Not supported for task : ").append(requestTaskPause.execId()).toString());
    }

    @Override
    @Receiver
    public void dealRequestTaskKill(RequestTaskKill requestTaskKill) {
        this.logger().warn(new StringBuilder(25).append("Requested to kill task : ").append(requestTaskKill.execId()).toString());
        this.killTask(requestTaskKill.execId());
    }

    @Override
    @Receiver
    public void dealRequestTaskResume(RequestTaskResume requestTaskResume) {
        this.logger().info(new StringBuilder(33).append("Resume is Not support for task : ").append(requestTaskResume.execId()).toString());
    }

    public void onEvent(EngineConnSyncEvent event) {
        EngineConnSyncEvent engineConnSyncEvent = event;
        if (engineConnSyncEvent instanceof TaskStatusChangedEvent) {
            TaskStatusChangedEvent taskStatusChangedEvent = (TaskStatusChangedEvent)engineConnSyncEvent;
            this.onTaskStatusChanged(taskStatusChangedEvent);
            return;
        }
        if (engineConnSyncEvent instanceof TaskProgressUpdateEvent) {
            TaskProgressUpdateEvent taskProgressUpdateEvent = (TaskProgressUpdateEvent)engineConnSyncEvent;
            this.onProgressUpdate(taskProgressUpdateEvent);
            return;
        }
        if (engineConnSyncEvent instanceof TaskLogUpdateEvent) {
            TaskLogUpdateEvent taskLogUpdateEvent = (TaskLogUpdateEvent)engineConnSyncEvent;
            this.onLogUpdate(taskLogUpdateEvent);
            return;
        }
        if (engineConnSyncEvent instanceof TaskResultCreateEvent) {
            TaskResultCreateEvent taskResultCreateEvent = (TaskResultCreateEvent)engineConnSyncEvent;
            this.onResultSetCreated(taskResultCreateEvent);
            return;
        }
        if (engineConnSyncEvent instanceof TaskResultSizeCreatedEvent) {
            TaskResultSizeCreatedEvent taskResultSizeCreatedEvent = (TaskResultSizeCreatedEvent)engineConnSyncEvent;
            this.onResultSizeCreated(taskResultSizeCreatedEvent);
            return;
        }
        if (engineConnSyncEvent instanceof TaskResponseErrorEvent) {
            TaskResponseErrorEvent taskResponseErrorEvent = (TaskResponseErrorEvent)engineConnSyncEvent;
            this.onTaskResponseErrorEvent(taskResponseErrorEvent);
            return;
        }
        if (engineConnSyncEvent instanceof TaskStatusChangedForUpstreamMonitorEvent) {
            TaskStatusChangedForUpstreamMonitorEvent taskStatusChangedForUpstreamMonitorEvent = (TaskStatusChangedForUpstreamMonitorEvent)engineConnSyncEvent;
            this.logger().info(new StringBuilder(63).append("ignored TaskStatusChangedEvent2 for entrance monitoring, task: ").append(taskStatusChangedForUpstreamMonitorEvent.taskId()).toString());
            return;
        }
        this.logger().warn(new StringBuilder(16).append("Unknown event : ").append(BDPJettyServerHelper$.MODULE$.gson().toJson((Object)event)).toString());
    }

    public void onLogUpdate(TaskLogUpdateEvent logUpdateEvent) {
        Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (BoxesRunTime.unboxToBoolean((Object)EngineConnConf$.MODULE$.ENGINE_PUSH_LOG_TO_ENTRANCE().getValue())) {
                if (logUpdateEvent != null && StringUtils.isNotBlank((CharSequence)logUpdateEvent.taskId())) {
                    EngineConnTask task = this.getTaskByTaskId(logUpdateEvent.taskId());
                    if (task != null) {
                        this.org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$sendToEntrance(task, (RequestProtocol)new ResponseTaskLog(logUpdateEvent.taskId(), logUpdateEvent.log()));
                        return;
                    }
                    this.logger().error(new StringBuilder(34).append("Task cannot null! logupdateEvent: ").append(logUpdateEvent.taskId()).toString());
                    return;
                }
                if (this.lastTask() != null) {
                    Executor executor = this.executorManager().getReportExecutor();
                    Executor executor2 = executor;
                    if (executor2 instanceof ComputationExecutor) {
                        ComputationExecutor computationExecutor = (ComputationExecutor)executor2;
                        if (computationExecutor.isBusy()) {
                            this.org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$sendToEntrance(this.lastTask(), (RequestProtocol)new ResponseTaskLog(this.lastTask().getTaskId(), logUpdateEvent.log()));
                            return;
                        }
                        return;
                    }
                    this.logger().error(new StringBuilder(49).append("OnLogUpdate error. Invalid ComputationExecutor : ").append(ComputationEngineUtils$.MODULE$.GSON().toJson((Object)executor)).toString());
                    return;
                }
                this.logger().info(new StringBuilder(38).append("Task not ready, log will be dropped : ").append(logUpdateEvent.taskId()).toString());
                return;
            }
        }, this.logger());
    }

    @Override
    public void onTaskStatusChanged(TaskStatusChangedEvent taskStatusChangedEvent) {
        EngineConnTask task = this.getTaskByTaskId(taskStatusChangedEvent.taskId());
        if (task != null) {
            if (ExecutionNodeStatus.isCompleted((ExecutionNodeStatus)taskStatusChangedEvent.toStatus())) {
                LogHelper$.MODULE$.pushAllRemainLogs();
            }
            ExecutionNodeStatus toStatus = taskStatusChangedEvent.toStatus();
            if (!ComputationExecutorConf$.MODULE$.TASK_IGNORE_UNCOMPLETED_STATUS() || ExecutionNodeStatus.isCompleted((ExecutionNodeStatus)toStatus)) {
                this.logger().info(new StringBuilder(30).append("send task ").append(task.getTaskId()).append(" status ").append(toStatus).append(" to entrance").toString());
                this.org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$sendToEntrance(task, (RequestProtocol)new ResponseTaskStatus(taskStatusChangedEvent.taskId(), taskStatusChangedEvent.toStatus()));
                return;
            }
            this.logger().info(new StringBuilder(42).append("task ").append(task.getTaskId()).append(" status ").append(toStatus).append(" will not be send to entrance").toString());
            return;
        }
        this.logger().error(new StringBuilder(42).append("Task cannot null! taskStatusChangedEvent: ").append(ComputationEngineUtils$.MODULE$.GSON().toJson((Object)taskStatusChangedEvent)).toString());
    }

    @Override
    public void onProgressUpdate(TaskProgressUpdateEvent taskProgressUpdateEvent) {
        Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (BoxesRunTime.unboxToBoolean((Object)EngineConnConf$.MODULE$.ENGINE_PUSH_LOG_TO_ENTRANCE().getValue())) {
                EngineConnTask task = this.getTaskByTaskId(taskProgressUpdateEvent.taskId());
                if (task != null) {
                    ResponseTaskYarnResource resourceResponse = this.org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$buildResourceMap(task);
                    HashMap<String, Object> extraInfoMap = this.org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$buildExtraInfoMap(task);
                    HashMap resourceMap = resourceResponse != null ? resourceResponse.resourceMap() : null;
                    ResponseTaskRunningInfo respRunningInfo = new ResponseTaskRunningInfo(taskProgressUpdateEvent.taskId(), taskProgressUpdateEvent.progress(), taskProgressUpdateEvent.progressInfo(), resourceMap, extraInfoMap);
                    this.org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$sendToEntrance(task, (RequestProtocol)respRunningInfo);
                    return;
                }
                this.logger().error(new StringBuilder(44).append("Task cannot null! taskProgressUpdateEvent : ").append(ComputationEngineUtils$.MODULE$.GSON().toJson((Object)taskProgressUpdateEvent)).toString());
                return;
            }
        }, this.logger());
    }

    @Override
    public void onResultSetCreated(TaskResultCreateEvent taskResultCreateEvent) {
        this.logger().info(new StringBuilder(27).append("start to deal result event ").append(taskResultCreateEvent.taskId()).toString());
        EngineConnTask task = this.getTaskByTaskId(taskResultCreateEvent.taskId());
        if (task != null) {
            this.org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$sendToEntrance(task, (RequestProtocol)new ResponseTaskResultSet(taskResultCreateEvent.taskId(), taskResultCreateEvent.resStr(), taskResultCreateEvent.alias()));
        } else {
            this.logger().error(new StringBuilder(41).append("Task cannot null! taskResultCreateEvent: ").append(taskResultCreateEvent.taskId()).toString());
        }
        this.logger().info(new StringBuilder(31).append("Finished  to deal result event ").append(taskResultCreateEvent.taskId()).toString());
    }

    private EngineConnTask getTaskByTaskId(String taskId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return null;
        }
        ComputationExecutor executor = (ComputationExecutor)((Object)this.taskIdCache().getIfPresent((Object)taskId));
        if (executor != null) {
            return executor.getTaskById(taskId);
        }
        this.logger().error(new StringBuilder(36).append("Executor of taskId : ").append(taskId).append(" is not cached.").toString());
        return null;
    }

    @Override
    public void onResultSizeCreated(TaskResultSizeCreatedEvent taskResultSizeCreatedEvent) {
        EngineConnTask task = this.getTaskByTaskId(taskResultSizeCreatedEvent.taskId());
        if (task != null) {
            this.org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$sendToEntrance(task, (RequestProtocol)new ResponseTaskResultSize(taskResultSizeCreatedEvent.taskId(), taskResultSizeCreatedEvent.resultSize()));
            return;
        }
        this.logger().error(new StringBuilder(46).append("Task cannot null! taskResultSizeCreatedEvent: ").append(ComputationEngineUtils$.MODULE$.GSON().toJson((Object)taskResultSizeCreatedEvent)).toString());
    }

    public void onEventError(Event event, Throwable t) {
    }

    @Override
    public void clearCache(String taskId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        Utils$.MODULE$.tryAndError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ComputationExecutor executor = (ComputationExecutor)((Object)((Object)this.taskIdCache().getIfPresent((Object)taskId)));
            if (executor != null) {
                executor.clearTaskCache(taskId);
                this.taskIdCache().invalidate((Object)taskId);
                return;
            }
        }, this.logger());
    }

    @Override
    public void onTaskResponseErrorEvent(TaskResponseErrorEvent taskResponseErrorEvent) {
        EngineConnTask task = this.getTaskByTaskId(taskResponseErrorEvent.taskId());
        if (task != null) {
            this.org$apache$linkis$engineconn$computation$executor$service$TaskExecutionServiceImpl$$sendToEntrance(task, (RequestProtocol)new ResponseTaskError(task.getTaskId(), taskResponseErrorEvent.errorMsg()));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$submitTaskToExecutor$1(Label x$1) {
        return x$1 != null;
    }

    public TaskExecutionServiceImpl() {
        Logging.$init$((Logging)this);
        this.taskExecutedNum = new AtomicInteger(0);
        this.syncListenerBus = ExecutorListenerBusContext$.MODULE$.getExecutorListenerBusContext().getEngineConnSyncListenerBus();
        this.taskIdCache = CacheBuilder.newBuilder().expireAfterAccess((long)BoxesRunTime.unboxToInt((Object)EngineConnConf$.MODULE$.ENGINE_TASK_EXPIRE_TIME().getValue()), TimeUnit.MILLISECONDS).maximumSize((long)EngineConnConstant$.MODULE$.MAX_TASK_NUM()).build();
        this.taskAsyncSubmitExecutor = Utils$.MODULE$.newCachedExecutionContext(ComputationExecutorConf$.MODULE$.TASK_ASYNC_MAX_THREAD_SIZE(), ComputationEngineConstant$.MODULE$.TASK_EXECUTION_THREAD(), Utils$.MODULE$.newCachedExecutionContext$default$3());
    }
}

