/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.linkis.bml.vo;

import java.util.Date;

/** Description: 给用户查看的资源基本信息的VO类 */
public class ResourceBasicVO {
  private String resourceId;
  private String owner;
  private String downloadedFileName;
  private String system;
  private String expireTime;
  private Integer numberOfVerions;
  private Date createTime;

  public String getResourceId() {
    return resourceId;
  }

  public void setResourceId(String resourceId) {
    this.resourceId = resourceId;
  }

  public String getOwner() {
    return owner;
  }

  public void setOwner(String owner) {
    this.owner = owner;
  }

  public String getDownloadedFileName() {
    return downloadedFileName;
  }

  public void setDownloadedFileName(String downloadedFileName) {
    this.downloadedFileName = downloadedFileName;
  }

  public String getSystem() {
    return system;
  }

  public void setSystem(String system) {
    this.system = system;
  }

  public String getExpireTime() {
    return expireTime;
  }

  public void setExpireTime(String expireTime) {
    this.expireTime = expireTime;
  }

  public int getNumberOfVerions() {
    return numberOfVerions;
  }

  public void setNumberOfVerions(int numberOfVerions) {
    this.numberOfVerions = numberOfVerions;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
}
