/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.knn;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Arrays;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.demo.knn.KnnVectorDict;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.VectorUtil;

public final class KnnVectorDictFilter
extends TokenFilter {
    private final KnnVectorDict dict;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final float[] scratchFloats;
    private final float[] result;
    private final byte[] scratchBytes;
    private final FloatBuffer scratchBuffer;

    public KnnVectorDictFilter(TokenStream input, KnnVectorDict dict) {
        super(input);
        this.dict = dict;
        this.result = new float[dict.getDimension()];
        this.scratchBytes = new byte[dict.getDimension() * 4];
        this.scratchBuffer = ByteBuffer.wrap(this.scratchBytes).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
        this.scratchFloats = new float[dict.getDimension()];
    }

    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        BytesRef term = new BytesRef((CharSequence)this.termAtt.toString());
        this.dict.get(term, this.scratchBytes);
        this.scratchBuffer.position(0);
        this.scratchBuffer.get(this.scratchFloats);
        VectorUtil.add((float[])this.result, (float[])this.scratchFloats);
        return true;
    }

    public void reset() throws IOException {
        super.reset();
        Arrays.fill(this.result, 0.0f);
    }

    public void end() throws IOException {
        super.end();
        VectorUtil.l2normalize((float[])this.result, (boolean)false);
    }

    public float[] getResult() {
        return this.result;
    }
}

