/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.composition;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.composition.ComponentComposer;
import org.codehaus.plexus.component.composition.CompositionException;
import org.codehaus.plexus.component.composition.Requirement;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.ComponentRequirementList;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public abstract class AbstractComponentComposer
extends AbstractLogEnabled
implements ComponentComposer {
    private String id;

    public void verifyComponentSuitability(Object component) throws CompositionException {
    }

    public Map createCompositionContext(Object component, ComponentDescriptor descriptor) throws CompositionException {
        return Collections.EMPTY_MAP;
    }

    public List gleanAutowiringRequirements(Map compositionContext, PlexusContainer container, ClassRealm classRealm) throws CompositionException {
        return Collections.EMPTY_LIST;
    }

    public final List gleanAutowiringRequirements(Map compositionContext, PlexusContainer container) throws CompositionException {
        return Collections.EMPTY_LIST;
    }

    public void assembleComponent(Object component, ComponentDescriptor componentDescriptor, PlexusContainer container) throws CompositionException {
        this.assembleComponent(component, componentDescriptor, container, container.getLookupRealm(component));
    }

    public void assembleComponent(Object component, ComponentDescriptor componentDescriptor, PlexusContainer container, ClassRealm lookupRealm) throws CompositionException {
        List requirements;
        this.verifyComponentSuitability(component);
        Map compositionContext = this.createCompositionContext(component, componentDescriptor);
        if (componentDescriptor == null) {
            componentDescriptor = new ComponentDescriptor();
            componentDescriptor.setImplementation(component.getClass().getName());
            componentDescriptor.setRole(component.getClass().getName());
            requirements = this.gleanAutowiringRequirements(compositionContext, container, lookupRealm);
            componentDescriptor.addRequirements(requirements);
            try {
                container.addComponentDescriptor(componentDescriptor);
            }
            catch (ComponentRepositoryException e) {}
        } else {
            requirements = componentDescriptor.getRequirements();
        }
        Iterator i = requirements.iterator();
        while (i.hasNext()) {
            ComponentRequirement requirement = (ComponentRequirement)i.next();
            this.assignRequirement(component, componentDescriptor, requirement, container, compositionContext, lookupRealm);
        }
    }

    public final void assignRequirement(Object component, ComponentDescriptor componentDescriptor, ComponentRequirement componentRequirement, PlexusContainer container, Map compositionContext) throws CompositionException {
        this.assignRequirement(component, componentDescriptor, componentRequirement, container, compositionContext, container.getLookupRealm(component));
    }

    public static Requirement findRequirement(Object component, Class clazz, PlexusContainer container, ComponentRequirement requirement, ClassRealm lookupRealm) throws CompositionException {
        try {
            Object assignment;
            ArrayList<ComponentDescriptor> componentDescriptors;
            String role = requirement.getRole();
            List roleHints = null;
            if (requirement instanceof ComponentRequirementList) {
                roleHints = ((ComponentRequirementList)requirement).getRoleHints();
            }
            if (clazz.isArray()) {
                List dependencies = container.lookupList(role, roleHints, lookupRealm);
                Object[] array = (Object[])Array.newInstance(clazz, dependencies.size());
                componentDescriptors = container.getComponentDescriptorList(role, lookupRealm);
                try {
                    assignment = dependencies.toArray(array);
                }
                catch (ArrayStoreException e) {
                    Iterator i = dependencies.iterator();
                    while (i.hasNext()) {
                        Class<?> dependencyClass = i.next().getClass();
                        if (clazz.isAssignableFrom(dependencyClass)) continue;
                        throw new CompositionException("Dependency of class " + dependencyClass.getName() + " in requirement " + requirement + " is not assignable in field of class " + clazz.getComponentType().getName(), e);
                    }
                    throw e;
                }
            } else if (Map.class.equals(clazz)) {
                assignment = container.lookupMap(role, roleHints, lookupRealm);
                componentDescriptors = container.getComponentDescriptorList(role, lookupRealm);
            } else if (List.class.equals(clazz)) {
                assignment = container.lookupList(role, roleHints, lookupRealm);
                componentDescriptors = container.getComponentDescriptorList(role, lookupRealm);
            } else if (Set.class.equals(clazz) || Collection.class.isAssignableFrom(clazz)) {
                assignment = container.lookupMap(role, roleHints, lookupRealm);
                componentDescriptors = container.getComponentDescriptorList(role, lookupRealm);
            } else {
                String roleHint = requirement.getRoleHint();
                assignment = container.lookup(role, roleHint, lookupRealm);
                ComponentDescriptor componentDescriptor = container.getComponentDescriptor(role, roleHint, lookupRealm);
                componentDescriptors = new ArrayList<ComponentDescriptor>(1);
                componentDescriptors.add(componentDescriptor);
            }
            return new Requirement(assignment, componentDescriptors);
        }
        catch (ComponentLookupException e) {
            throw new CompositionException("Composition failed of field " + requirement.getFieldName() + " " + "in object of type " + component.getClass().getName() + " because the requirement " + requirement + " was missing (lookup realm: " + lookupRealm.getId() + ")", e);
        }
    }

    public String getId() {
        return this.id;
    }
}

