/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.putty;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.KeyTypeNamesSupport;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;

public interface PuttyKeyPairResourceParser
extends KeyTypeNamesSupport,
KeyPairResourceParser {
    public static final String KEY_FILE_HEADER_PREFIX = "PuTTY-User-Key-File-";
    public static final String PUBLIC_LINES_HEADER = "Public-Lines";
    public static final String PRIVATE_LINES_HEADER = "Private-Lines";
    public static final String PPK_FILE_SUFFIX = ".ppk";
    public static final List<String> KNOWN_HEADERS = Collections.unmodifiableList(Arrays.asList("PuTTY-User-Key-File-", "Public-Lines", "Private-Lines"));
    public static final String NO_PRIVATE_KEY_ENCRYPTION_VALUE = "none";
    public static final int FORMAT_3_MAC_KEY_LENGTH = 32;

    default public boolean canExtractKeyPairs(NamedResource resourceKey, List<String> lines) throws IOException, GeneralSecurityException {
        if (GenericUtils.isEmpty(lines)) {
            return false;
        }
        for (String l : lines) {
            l = GenericUtils.trimToEmpty((String)l);
            for (String hdr : KNOWN_HEADERS) {
                if (!l.startsWith(hdr)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decodePrivateKeyBytes(int formatVersion, byte[] prvBytes, String algName, int numBits, String algMode, String password, Map<String, String> headers) throws GeneralSecurityException {
        Objects.requireNonNull(prvBytes, "No encrypted key bytes");
        ValidateUtils.checkNotNullAndNotEmpty((String)algName, (String)"No encryption algorithm");
        ValidateUtils.checkTrue((numBits > 0 ? 1 : 0) != 0, (String)"Invalid encryption key size: %d", (long)numBits);
        ValidateUtils.checkNotNullAndNotEmpty((String)algMode, (String)"No encryption mode");
        ValidateUtils.hasContent((String)password, (String)"No encryption password");
        if (!"AES".equalsIgnoreCase(algName)) {
            throw new NoSuchAlgorithmException("decodePrivateKeyBytes(" + algName + "-" + numBits + "-" + algMode + ") N/A");
        }
        if (numBits != 128 && numBits != 192 && numBits != 256) {
            throw new InvalidKeySpecException("Requested key size (" + numBits + ") is not supported");
        }
        byte[] initVector = new byte[16];
        byte[] keyValue = new byte[numBits / 8];
        PuttyKeyPairResourceParser.decodeEncryptionKey(formatVersion, password, initVector, keyValue, headers);
        try {
            byte[] byArray = PuttyKeyPairResourceParser.decodePrivateKeyBytes(prvBytes, algName, algMode, numBits, initVector, keyValue);
            return byArray;
        }
        finally {
            Arrays.fill(initVector, (byte)0);
            Arrays.fill(keyValue, (byte)0);
        }
    }

    public static byte[] decodePrivateKeyBytes(byte[] encBytes, String cipherName, String cipherMode, int numBits, byte[] initVector, byte[] keyValue) throws GeneralSecurityException {
        String xform = cipherName + "/" + cipherMode + "/NoPadding";
        int maxAllowedBits = Cipher.getMaxAllowedKeyLength(xform);
        if (numBits > maxAllowedBits) {
            throw new InvalidKeySpecException("decodePrivateKeyBytes(" + xform + ") required key length (" + numBits + ") exceeds max. available: " + maxAllowedBits);
        }
        SecretKeySpec skeySpec = new SecretKeySpec(keyValue, cipherName);
        IvParameterSpec ivspec = new IvParameterSpec(initVector);
        Cipher cipher = SecurityUtils.getCipher((String)xform);
        cipher.init(2, (Key)skeySpec, ivspec);
        return cipher.doFinal(encBytes);
    }

    public static void decodeEncryptionKey(int formatVersion, String passphrase, byte[] iv, byte[] key, Map<String, String> headers) throws GeneralSecurityException {
        String keyDerivationType = PuttyKeyPairResourceParser.getStringHeaderValue(headers, "Key-Derivation");
        if (GenericUtils.isBlank((CharSequence)keyDerivationType)) {
            PuttyKeyPairResourceParser.deriveFormat2EncryptionKey(passphrase, iv, key);
        } else if ("Argon2id".equalsIgnoreCase(keyDerivationType) || "Argon2i".equalsIgnoreCase(keyDerivationType) || "Argon2d".equalsIgnoreCase(keyDerivationType)) {
            PuttyKeyPairResourceParser.deriveFormat3EncryptionKey(passphrase, keyDerivationType, iv, key, headers);
        } else {
            throw new NoSuchAlgorithmException("Unsupported KDF method: " + keyDerivationType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deriveFormat3EncryptionKey(String passphrase, String keyDerivationType, byte[] iv, byte[] key, Map<String, String> headers) throws GeneralSecurityException {
        ValidateUtils.checkNotNullAndNotEmpty(headers, (String)"Mising file headers for KDF purposes", (Object[])new Object[0]);
        Objects.requireNonNull(passphrase, "No passphrase provded");
        int parallelism = PuttyKeyPairResourceParser.getIntegerHeaderValue(headers, "Argon2-Parallelism");
        int iterations = PuttyKeyPairResourceParser.getIntegerHeaderValue(headers, "Argon2-Passes");
        int memory = PuttyKeyPairResourceParser.getIntegerHeaderValue(headers, "Argon2-Memory");
        byte[] salt = ValidateUtils.checkNotNullAndNotEmpty((byte[])PuttyKeyPairResourceParser.getHexArrayHeaderValue(headers, "Argon2-Salt"), (String)"No Argon2 salt value provided");
        byte[] hashValue = new byte[key.length + iv.length + 32];
        byte[] passBytes = passphrase.getBytes(StandardCharsets.UTF_8);
        try {
            Argon2Parameters.Builder builder;
            if ("Argon2id".equalsIgnoreCase(keyDerivationType)) {
                builder = new Argon2Parameters.Builder(2);
            } else if ("Argon2i".equalsIgnoreCase(keyDerivationType)) {
                builder = new Argon2Parameters.Builder(1);
            } else if ("Argon2d".equalsIgnoreCase(keyDerivationType)) {
                builder = new Argon2Parameters.Builder(1);
            } else {
                throw new NoSuchAlgorithmException("Unsupported key derivation type: " + keyDerivationType);
            }
            Argon2Parameters params = builder.withSalt(salt).withParallelism(parallelism).withMemoryAsKB(memory).withIterations(iterations).build();
            Argon2BytesGenerator generator = new Argon2BytesGenerator();
            generator.init(params);
            generator.generateBytes(passBytes, hashValue);
        }
        finally {
            Arrays.fill(passBytes, (byte)0);
        }
        try {
            System.arraycopy(hashValue, 0, key, 0, key.length);
            System.arraycopy(hashValue, key.length, iv, 0, iv.length);
        }
        finally {
            Arrays.fill(hashValue, (byte)0);
        }
    }

    public static String getStringHeaderValue(Map<String, String> headers, String key) {
        return MapEntryUtils.isEmpty(headers) ? null : headers.get(key);
    }

    public static byte[] getHexArrayHeaderValue(Map<String, String> headers, String key) {
        String value = PuttyKeyPairResourceParser.getStringHeaderValue(headers, key);
        return BufferUtils.decodeHex((char)'\u0000', (CharSequence)value);
    }

    public static int getIntegerHeaderValue(Map<String, String> headers, String key) {
        String value = ValidateUtils.checkNotNullAndNotEmpty((String)PuttyKeyPairResourceParser.getStringHeaderValue(headers, key), (String)"Missing %s header value", (Object)key);
        return Integer.parseInt(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deriveFormat2EncryptionKey(String passphrase, byte[] iv, byte[] key) throws GeneralSecurityException {
        Objects.requireNonNull(passphrase, "No passphrase provded");
        byte[] passBytes = passphrase.getBytes(StandardCharsets.UTF_8);
        try {
            MessageDigest hash = SecurityUtils.getMessageDigest((String)BuiltinDigests.sha1.getAlgorithm());
            byte[] stateValue = new byte[]{0, 0, 0, 0};
            try {
                int i = 0;
                int remLen = key.length;
                while (remLen > 0) {
                    hash.reset();
                    stateValue[3] = (byte)i;
                    hash.update(stateValue);
                    hash.update(passBytes);
                    byte[] digest = hash.digest();
                    try {
                        System.arraycopy(digest, 0, key, i * 20, Math.min(20, remLen));
                    }
                    finally {
                        Arrays.fill(digest, (byte)0);
                    }
                    remLen -= 20;
                    ++i;
                }
            }
            finally {
                Arrays.fill(stateValue, (byte)0);
            }
            Arrays.fill(iv, (byte)0);
        }
        finally {
            Arrays.fill(passBytes, (byte)0);
        }
    }
}

